package software.amazon.awscdk.services.rds;

/**
 * Construction properties for a DatabaseSecret.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // Build a data source for AppSync to access the database.
 * GraphqlApi api;
 * // Create username and password secret for DB Cluster
 * DatabaseSecret secret = DatabaseSecret.Builder.create(this, "AuroraSecret")
 *         .username("clusteradmin")
 *         .build();
 * // The VPC to place the cluster in
 * Vpc vpc = new Vpc(this, "AuroraVpc");
 * // Create the serverless cluster, provide all values needed to customise the database.
 * ServerlessCluster cluster = ServerlessCluster.Builder.create(this, "AuroraCluster")
 *         .engine(DatabaseClusterEngine.AURORA_MYSQL)
 *         .vpc(vpc)
 *         .credentials(Map.of("username", "clusteradmin"))
 *         .clusterIdentifier("db-endpoint-test")
 *         .defaultDatabaseName("demos")
 *         .build();
 * RdsDataSource rdsDS = api.addRdsDataSource("rds", cluster, secret, "demos");
 * // Set up a resolver for an RDS query.
 * rdsDS.createResolver("QueryGetDemosRdsResolver", BaseResolverProps.builder()
 *         .typeName("Query")
 *         .fieldName("getDemosRds")
 *         .requestMappingTemplate(MappingTemplate.fromString("\n  {\n    \"version\": \"2018-05-29\",\n    \"statements\": [\n      \"SELECT * FROM demos\"\n    ]\n  }\n  "))
 *         .responseMappingTemplate(MappingTemplate.fromString("\n    $utils.toJson($utils.rds.toJsonObject($ctx.result)[0])\n  "))
 *         .build());
 * // Set up a resolver for an RDS mutation.
 * rdsDS.createResolver("MutationAddDemoRdsResolver", BaseResolverProps.builder()
 *         .typeName("Mutation")
 *         .fieldName("addDemoRds")
 *         .requestMappingTemplate(MappingTemplate.fromString("\n  {\n    \"version\": \"2018-05-29\",\n    \"statements\": [\n      \"INSERT INTO demos VALUES (:id, :version)\",\n      \"SELECT * WHERE id = :id\"\n    ],\n    \"variableMap\": {\n      \":id\": $util.toJson($util.autoId()),\n      \":version\": $util.toJson($ctx.args.version)\n    }\n  }\n  "))
 *         .responseMappingTemplate(MappingTemplate.fromString("\n    $utils.toJson($utils.rds.toJsonObject($ctx.result)[1][0])\n  "))
 *         .build());
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.106.0 (build e852934)", date = "2025-03-12T01:36:44.417Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_rds.DatabaseSecretProps")
@software.amazon.jsii.Jsii.Proxy(DatabaseSecretProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface DatabaseSecretProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * The username.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getUsername();

    /**
     * The database name, if not using the default one.
     * <p>
     * Default: - whatever the secret generates after the attach method is run
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getDbname() {
        return null;
    }

    /**
     * The KMS key to use to encrypt the secret.
     * <p>
     * Default: default master key
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.kms.IKey getEncryptionKey() {
        return null;
    }

    /**
     * Characters to not include in the generated password.
     * <p>
     * Default: " %+~`#$&*()|[]{}:;<>?!'/@\"\\"
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getExcludeCharacters() {
        return null;
    }

    /**
     * The master secret which will be used to rotate this secret.
     * <p>
     * Default: - no master secret information will be included
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.secretsmanager.ISecret getMasterSecret() {
        return null;
    }

    /**
     * Whether to replace this secret when the criteria for the password change.
     * <p>
     * This is achieved by overriding the logical id of the AWS::SecretsManager::Secret
     * with a hash of the options that influence the password generation. This
     * way a new secret will be created when the password is regenerated and the
     * cluster or instance consuming this secret will have its credentials updated.
     * <p>
     * Default: false
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getReplaceOnPasswordCriteriaChanges() {
        return null;
    }

    /**
     * A list of regions where to replicate this secret.
     * <p>
     * Default: - Secret is not replicated
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.services.secretsmanager.ReplicaRegion> getReplicaRegions() {
        return null;
    }

    /**
     * A name for the secret.
     * <p>
     * Default: - A name is generated by CloudFormation.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getSecretName() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link DatabaseSecretProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link DatabaseSecretProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<DatabaseSecretProps> {
        java.lang.String username;
        java.lang.String dbname;
        software.amazon.awscdk.services.kms.IKey encryptionKey;
        java.lang.String excludeCharacters;
        software.amazon.awscdk.services.secretsmanager.ISecret masterSecret;
        java.lang.Boolean replaceOnPasswordCriteriaChanges;
        java.util.List<software.amazon.awscdk.services.secretsmanager.ReplicaRegion> replicaRegions;
        java.lang.String secretName;

        /**
         * Sets the value of {@link DatabaseSecretProps#getUsername}
         * @param username The username. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder username(java.lang.String username) {
            this.username = username;
            return this;
        }

        /**
         * Sets the value of {@link DatabaseSecretProps#getDbname}
         * @param dbname The database name, if not using the default one.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder dbname(java.lang.String dbname) {
            this.dbname = dbname;
            return this;
        }

        /**
         * Sets the value of {@link DatabaseSecretProps#getEncryptionKey}
         * @param encryptionKey The KMS key to use to encrypt the secret.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder encryptionKey(software.amazon.awscdk.services.kms.IKey encryptionKey) {
            this.encryptionKey = encryptionKey;
            return this;
        }

        /**
         * Sets the value of {@link DatabaseSecretProps#getExcludeCharacters}
         * @param excludeCharacters Characters to not include in the generated password.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder excludeCharacters(java.lang.String excludeCharacters) {
            this.excludeCharacters = excludeCharacters;
            return this;
        }

        /**
         * Sets the value of {@link DatabaseSecretProps#getMasterSecret}
         * @param masterSecret The master secret which will be used to rotate this secret.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder masterSecret(software.amazon.awscdk.services.secretsmanager.ISecret masterSecret) {
            this.masterSecret = masterSecret;
            return this;
        }

        /**
         * Sets the value of {@link DatabaseSecretProps#getReplaceOnPasswordCriteriaChanges}
         * @param replaceOnPasswordCriteriaChanges Whether to replace this secret when the criteria for the password change.
         *                                         This is achieved by overriding the logical id of the AWS::SecretsManager::Secret
         *                                         with a hash of the options that influence the password generation. This
         *                                         way a new secret will be created when the password is regenerated and the
         *                                         cluster or instance consuming this secret will have its credentials updated.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder replaceOnPasswordCriteriaChanges(java.lang.Boolean replaceOnPasswordCriteriaChanges) {
            this.replaceOnPasswordCriteriaChanges = replaceOnPasswordCriteriaChanges;
            return this;
        }

        /**
         * Sets the value of {@link DatabaseSecretProps#getReplicaRegions}
         * @param replicaRegions A list of regions where to replicate this secret.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder replicaRegions(java.util.List<? extends software.amazon.awscdk.services.secretsmanager.ReplicaRegion> replicaRegions) {
            this.replicaRegions = (java.util.List<software.amazon.awscdk.services.secretsmanager.ReplicaRegion>)replicaRegions;
            return this;
        }

        /**
         * Sets the value of {@link DatabaseSecretProps#getSecretName}
         * @param secretName A name for the secret.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder secretName(java.lang.String secretName) {
            this.secretName = secretName;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link DatabaseSecretProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public DatabaseSecretProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link DatabaseSecretProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements DatabaseSecretProps {
        private final java.lang.String username;
        private final java.lang.String dbname;
        private final software.amazon.awscdk.services.kms.IKey encryptionKey;
        private final java.lang.String excludeCharacters;
        private final software.amazon.awscdk.services.secretsmanager.ISecret masterSecret;
        private final java.lang.Boolean replaceOnPasswordCriteriaChanges;
        private final java.util.List<software.amazon.awscdk.services.secretsmanager.ReplicaRegion> replicaRegions;
        private final java.lang.String secretName;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.username = software.amazon.jsii.Kernel.get(this, "username", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.dbname = software.amazon.jsii.Kernel.get(this, "dbname", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.encryptionKey = software.amazon.jsii.Kernel.get(this, "encryptionKey", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.kms.IKey.class));
            this.excludeCharacters = software.amazon.jsii.Kernel.get(this, "excludeCharacters", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.masterSecret = software.amazon.jsii.Kernel.get(this, "masterSecret", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.secretsmanager.ISecret.class));
            this.replaceOnPasswordCriteriaChanges = software.amazon.jsii.Kernel.get(this, "replaceOnPasswordCriteriaChanges", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.replicaRegions = software.amazon.jsii.Kernel.get(this, "replicaRegions", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.secretsmanager.ReplicaRegion.class)));
            this.secretName = software.amazon.jsii.Kernel.get(this, "secretName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.username = java.util.Objects.requireNonNull(builder.username, "username is required");
            this.dbname = builder.dbname;
            this.encryptionKey = builder.encryptionKey;
            this.excludeCharacters = builder.excludeCharacters;
            this.masterSecret = builder.masterSecret;
            this.replaceOnPasswordCriteriaChanges = builder.replaceOnPasswordCriteriaChanges;
            this.replicaRegions = (java.util.List<software.amazon.awscdk.services.secretsmanager.ReplicaRegion>)builder.replicaRegions;
            this.secretName = builder.secretName;
        }

        @Override
        public final java.lang.String getUsername() {
            return this.username;
        }

        @Override
        public final java.lang.String getDbname() {
            return this.dbname;
        }

        @Override
        public final software.amazon.awscdk.services.kms.IKey getEncryptionKey() {
            return this.encryptionKey;
        }

        @Override
        public final java.lang.String getExcludeCharacters() {
            return this.excludeCharacters;
        }

        @Override
        public final software.amazon.awscdk.services.secretsmanager.ISecret getMasterSecret() {
            return this.masterSecret;
        }

        @Override
        public final java.lang.Boolean getReplaceOnPasswordCriteriaChanges() {
            return this.replaceOnPasswordCriteriaChanges;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.services.secretsmanager.ReplicaRegion> getReplicaRegions() {
            return this.replicaRegions;
        }

        @Override
        public final java.lang.String getSecretName() {
            return this.secretName;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("username", om.valueToTree(this.getUsername()));
            if (this.getDbname() != null) {
                data.set("dbname", om.valueToTree(this.getDbname()));
            }
            if (this.getEncryptionKey() != null) {
                data.set("encryptionKey", om.valueToTree(this.getEncryptionKey()));
            }
            if (this.getExcludeCharacters() != null) {
                data.set("excludeCharacters", om.valueToTree(this.getExcludeCharacters()));
            }
            if (this.getMasterSecret() != null) {
                data.set("masterSecret", om.valueToTree(this.getMasterSecret()));
            }
            if (this.getReplaceOnPasswordCriteriaChanges() != null) {
                data.set("replaceOnPasswordCriteriaChanges", om.valueToTree(this.getReplaceOnPasswordCriteriaChanges()));
            }
            if (this.getReplicaRegions() != null) {
                data.set("replicaRegions", om.valueToTree(this.getReplicaRegions()));
            }
            if (this.getSecretName() != null) {
                data.set("secretName", om.valueToTree(this.getSecretName()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_rds.DatabaseSecretProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            DatabaseSecretProps.Jsii$Proxy that = (DatabaseSecretProps.Jsii$Proxy) o;

            if (!username.equals(that.username)) return false;
            if (this.dbname != null ? !this.dbname.equals(that.dbname) : that.dbname != null) return false;
            if (this.encryptionKey != null ? !this.encryptionKey.equals(that.encryptionKey) : that.encryptionKey != null) return false;
            if (this.excludeCharacters != null ? !this.excludeCharacters.equals(that.excludeCharacters) : that.excludeCharacters != null) return false;
            if (this.masterSecret != null ? !this.masterSecret.equals(that.masterSecret) : that.masterSecret != null) return false;
            if (this.replaceOnPasswordCriteriaChanges != null ? !this.replaceOnPasswordCriteriaChanges.equals(that.replaceOnPasswordCriteriaChanges) : that.replaceOnPasswordCriteriaChanges != null) return false;
            if (this.replicaRegions != null ? !this.replicaRegions.equals(that.replicaRegions) : that.replicaRegions != null) return false;
            return this.secretName != null ? this.secretName.equals(that.secretName) : that.secretName == null;
        }

        @Override
        public final int hashCode() {
            int result = this.username.hashCode();
            result = 31 * result + (this.dbname != null ? this.dbname.hashCode() : 0);
            result = 31 * result + (this.encryptionKey != null ? this.encryptionKey.hashCode() : 0);
            result = 31 * result + (this.excludeCharacters != null ? this.excludeCharacters.hashCode() : 0);
            result = 31 * result + (this.masterSecret != null ? this.masterSecret.hashCode() : 0);
            result = 31 * result + (this.replaceOnPasswordCriteriaChanges != null ? this.replaceOnPasswordCriteriaChanges.hashCode() : 0);
            result = 31 * result + (this.replicaRegions != null ? this.replicaRegions.hashCode() : 0);
            result = 31 * result + (this.secretName != null ? this.secretName.hashCode() : 0);
            return result;
        }
    }
}
