package software.amazon.awscdk.services.route53;

/**
 * Amazon Route 53 health checks monitor the health and performance of your web applications, web servers, and other resources.
 * <p>
 * Each health check that you create can monitor one of the following:
 * <p>
 * <ul>
 * <li>The health of a resource, such as a web server,</li>
 * <li>The status of other health checks, and</li>
 * <li>The CloudWatch alarm that you specify,</li>
 * <li>The status of an Amazon Route 53 routing control.</li>
 * </ul>
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * HostedZone myZone;
 * HealthCheck healthCheck = HealthCheck.Builder.create(this, "HealthCheck")
 *         .type(HealthCheckType.HTTP)
 *         .fqdn("example.com")
 *         .port(80)
 *         .resourcePath("/health")
 *         .failureThreshold(3)
 *         .requestInterval(Duration.seconds(30))
 *         .build();
 * ARecord.Builder.create(this, "ARecord")
 *         .zone(myZone)
 *         .target(RecordTarget.fromIpAddresses("1.2.3.4"))
 *         .healthCheck(healthCheck)
 *         .weight(100)
 *         .build();
 * ARecord.Builder.create(this, "ARecord2")
 *         .zone(myZone)
 *         .target(RecordTarget.fromIpAddresses("5.6.7.8"))
 *         .weight(0)
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.106.0 (build e852934)", date = "2025-03-12T01:36:44.758Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_route53.HealthCheck")
public class HealthCheck extends software.amazon.awscdk.Resource implements software.amazon.awscdk.services.route53.IHealthCheck {

    protected HealthCheck(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected HealthCheck(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * Creates a new health check.
     * <p>
     * @return a reference to the newly created health check.
     * @param scope The parent creating construct (usually <code>this</code>). This parameter is required.
     * @param id The construct's name. This parameter is required.
     * @param props the properties of the new health check. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public HealthCheck(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.route53.HealthCheckProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Import an existing health check into this CDK app.
     * <p>
     * @return a reference to the existing health check.
     * @param scope The parent creating construct (usually <code>this</code>). This parameter is required.
     * @param id The construct's name. This parameter is required.
     * @param healthCheckId ID of the health check. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.route53.IHealthCheck fromHealthCheckId(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull java.lang.String healthCheckId) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.route53.HealthCheck.class, "fromHealthCheckId", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.route53.IHealthCheck.class), new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(healthCheckId, "healthCheckId is required") });
    }

    /**
     * The ID of the health check.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getHealthCheckId() {
        return software.amazon.jsii.Kernel.get(this, "healthCheckId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.route53.HealthCheck}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.route53.HealthCheck> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope The parent creating construct (usually <code>this</code>). This parameter is required.
         * @param id The construct's name. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.route53.HealthCheckProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.services.route53.HealthCheckProps.Builder();
        }

        /**
         * The type of health check to be associated with the record.
         * <p>
         * @return {@code this}
         * @param type The type of health check to be associated with the record. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder type(final software.amazon.awscdk.services.route53.HealthCheckType type) {
            this.props.type(type);
            return this;
        }

        /**
         * CloudWatch alarm that you want Amazon Route 53 health checkers to use to determine whether the specified health check is healthy.
         * <p>
         * Default: - if the type is CLOUDWATCH_METRIC, this property is required. Otherwise, it is not configured.
         * <p>
         * @return {@code this}
         * @param alarmIdentifier CloudWatch alarm that you want Amazon Route 53 health checkers to use to determine whether the specified health check is healthy. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder alarmIdentifier(final software.amazon.awscdk.services.route53.AlarmIdentifier alarmIdentifier) {
            this.props.alarmIdentifier(alarmIdentifier);
            return this;
        }

        /**
         * A list of health checks to monitor for this 'CALCULATED' health check.
         * <p>
         * Default: - if the type is CALCULATED, this property is required. Otherwise, it is not configured.
         * <p>
         * @return {@code this}
         * @param childHealthChecks A list of health checks to monitor for this 'CALCULATED' health check. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder childHealthChecks(final java.util.List<? extends software.amazon.awscdk.services.route53.IHealthCheck> childHealthChecks) {
            this.props.childHealthChecks(childHealthChecks);
            return this;
        }

        /**
         * Specify whether you want Amazon Route 53 to send the value of FullyQualifiedDomainName to the endpoint in the client_hello message during TLS negotiation.
         * <p>
         * This allows the endpoint to respond to HTTPS health check requests with the applicable SSL/TLS certificate.
         * <p>
         * Default: - if the type is HTTPS or HTTPS_STR_MATCH, this property default value is true. Otherwise, it is not configured.
         * <p>
         * @return {@code this}
         * @param enableSni Specify whether you want Amazon Route 53 to send the value of FullyQualifiedDomainName to the endpoint in the client_hello message during TLS negotiation. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder enableSni(final java.lang.Boolean enableSni) {
            this.props.enableSni(enableSni);
            return this;
        }

        /**
         * The number of consecutive health checks that an endpoint must pass or fail for Amazon Route 53 to change the current status of the endpoint from unhealthy to healthy or vice versa.
         * <p>
         * Default: - if the type is CALCULATED it's not configured
         * - if the type is CLOUDWATCH_METRIC it's not configured
         * - otherwise, the default value is 3.
         * <p>
         * @return {@code this}
         * @param failureThreshold The number of consecutive health checks that an endpoint must pass or fail for Amazon Route 53 to change the current status of the endpoint from unhealthy to healthy or vice versa. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder failureThreshold(final java.lang.Number failureThreshold) {
            this.props.failureThreshold(failureThreshold);
            return this;
        }

        /**
         * Fully qualified domain name of the endpoint to be checked.
         * <p>
         * Amazon Route 53 behavior depends on whether you specify a value for IPAddress.
         * <p>
         * If you specify a value for IPAddress:
         * <p>
         * Amazon Route 53 sends health check requests to the specified IPv4 or IPv6 address and passes the value of FullyQualifiedDomainName in the Host header for all health checks except TCP health checks. This is typically the fully qualified DNS name of the endpoint on which you want Route 53 to perform health checks.
         * Note: If you specify a value for Port property other than 80 or 443, Route 53 will construct the value for Host header as FullyQualifiedDomainName:Port.
         * <p>
         * If you don't specify a value for IPAddress:
         * <p>
         * Route 53 sends a DNS request to the domain that you specify for FullyQualifiedDomainName at the interval that you specify for RequestInterval. Using an IPv4 address that DNS returns, Route 53 then checks the health of the endpoint.
         * <p>
         * Additionally, if the type of the health check is HTTP, HTTPS, HTTP_STR_MATCH, or HTTPS_STR_MATCH, Route 53 passes the value of FullyQualifiedDomainName in the Host header, as it does when you specify value for IPAddress. If the type is TCP, Route 53 doesn't pass a Host header.
         * <p>
         * Default: - not configured
         * <p>
         * @return {@code this}
         * @param fqdn Fully qualified domain name of the endpoint to be checked. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder fqdn(final java.lang.String fqdn) {
            this.props.fqdn(fqdn);
            return this;
        }

        /**
         * The number of child health checks that are associated with a CALCULATED health that Amazon Route 53 must consider healthy for the CALCULATED health check to be considered healthy.
         * <p>
         * Default: - if the type is CALCULATED, the default value is number of child health checks. Otherwise, it is not configured.
         * <p>
         * @return {@code this}
         * @param healthThreshold The number of child health checks that are associated with a CALCULATED health that Amazon Route 53 must consider healthy for the CALCULATED health check to be considered healthy. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder healthThreshold(final java.lang.Number healthThreshold) {
            this.props.healthThreshold(healthThreshold);
            return this;
        }

        /**
         * The status of the health check when CloudWatch has insufficient data about the state of associated alarm.
         * <p>
         * Default: - if the type is CLOUDWATCH_METRIC, the default value is InsufficientDataHealthStatus.LAST_KNOWN_STATUS. Otherwise, it is not configured.
         * <p>
         * @return {@code this}
         * @param insufficientDataHealthStatus The status of the health check when CloudWatch has insufficient data about the state of associated alarm. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder insufficientDataHealthStatus(final software.amazon.awscdk.services.route53.InsufficientDataHealthStatusEnum insufficientDataHealthStatus) {
            this.props.insufficientDataHealthStatus(insufficientDataHealthStatus);
            return this;
        }

        /**
         * Specify whether you want Amazon Route 53 to invert the status of a health check, so a health check that would normally be considered unhealthy is considered healthy, and vice versa.
         * <p>
         * Default: false
         * <p>
         * @return {@code this}
         * @param inverted Specify whether you want Amazon Route 53 to invert the status of a health check, so a health check that would normally be considered unhealthy is considered healthy, and vice versa. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder inverted(final java.lang.Boolean inverted) {
            this.props.inverted(inverted);
            return this;
        }

        /**
         * The IPv4 or IPv6 IP address for the endpoint that you want Amazon Route 53 to perform health checks on.
         * <p>
         * If you don't specify a value for IPAddress, Route 53 sends a DNS request to resolve the domain name that you specify in FullyQualifiedDomainName at the interval that you specify in RequestInterval. Using an IPv4 address that DNS returns, Route 53 then checks the health of the endpoint.
         * <p>
         * Default: - not configured
         * <p>
         * @return {@code this}
         * @param ipAddress The IPv4 or IPv6 IP address for the endpoint that you want Amazon Route 53 to perform health checks on. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder ipAddress(final java.lang.String ipAddress) {
            this.props.ipAddress(ipAddress);
            return this;
        }

        /**
         * Specify whether you want Amazon Route 53 to measure the latency between health checkers in multiple AWS regions and your endpoint, and to display CloudWatch latency graphs on the Health Checks page in the Route 53 console.
         * <p>
         * Default: - if the type is CALCULATED it's not configured
         * - if the type is CLOUDWATCH_METRIC it's not configured
         * - otherwise, the default value is false.
         * <p>
         * @return {@code this}
         * @param measureLatency Specify whether you want Amazon Route 53 to measure the latency between health checkers in multiple AWS regions and your endpoint, and to display CloudWatch latency graphs on the Health Checks page in the Route 53 console. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder measureLatency(final java.lang.Boolean measureLatency) {
            this.props.measureLatency(measureLatency);
            return this;
        }

        /**
         * The port on the endpoint that you want Amazon Route 53 to perform health checks on.
         * <p>
         * Default: - if the type is HTTP or HTTP_STR_MATCH, the default value is 80.
         * - if the type is HTTPS or HTTPS_STR_MATCH, the default value is 443.
         * - otherwise, it is not configured.
         * <p>
         * @return {@code this}
         * @param port The port on the endpoint that you want Amazon Route 53 to perform health checks on. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder port(final java.lang.Number port) {
            this.props.port(port);
            return this;
        }

        /**
         * An array of region identifiers that you want Amazon Route 53 health checkers to check the health of the endpoint from.
         * <p>
         * Please refer to the CloudFormation documentation for the most up-to-date list of regions.
         * <p>
         * Default: - if the type is CALCULATED, CLOUDWATCH_METRIC, or RECOVERY_CONTROL, this property is not configured.
         * - otherwise, the default value will be set by CloudFormation itself and will include all valid regions. Please refer to the CloudFormation documentation for the most up-to-date list of regions.
         * <p>
         * @return {@code this}
         * @see <a href="https://docs.aws.amazon.com/Route53/latest/APIReference/API_HealthCheckConfig.html">https://docs.aws.amazon.com/Route53/latest/APIReference/API_HealthCheckConfig.html</a>
         * @param regions An array of region identifiers that you want Amazon Route 53 health checkers to check the health of the endpoint from. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder regions(final java.util.List<java.lang.String> regions) {
            this.props.regions(regions);
            return this;
        }

        /**
         * The duration between the time that Amazon Route 53 gets a response from your endpoint and the time that it sends the next health check request.
         * <p>
         * Each Route 53 health checker makes requests at this interval.
         * <p>
         * Default: - if the type is CALCULATED it's not configured
         * - if the type is CLOUDWATCH_METRIC it's not configured
         * - otherwise, the default value is 30 seconds.
         * <p>
         * @return {@code this}
         * @param requestInterval The duration between the time that Amazon Route 53 gets a response from your endpoint and the time that it sends the next health check request. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder requestInterval(final software.amazon.awscdk.Duration requestInterval) {
            this.props.requestInterval(requestInterval);
            return this;
        }

        /**
         * The path that you want Amazon Route 53 to request when performing health checks.
         * <p>
         * The path can be any value for which your endpoint will return an HTTP status code of 2xx or 3xx when the endpoint is healthy, for example the file /docs/route53-health-check.html. Route 53 automatically adds the DNS name for the service and a leading forward slash (/) character.
         * <p>
         * Default: - if the type is HTTP, HTTPS, HTTP_STR_MATCH, or HTTPS_STR_MATCH, the default value is empty string.
         * - otherwise, it is not configured.
         * <p>
         * @return {@code this}
         * @param resourcePath The path that you want Amazon Route 53 to request when performing health checks. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder resourcePath(final java.lang.String resourcePath) {
            this.props.resourcePath(resourcePath);
            return this;
        }

        /**
         * The Amazon Resource Name (ARN) of the Route 53 Application Recovery Controller routing control that you want Amazon Route 53 health checkers to use to determine whether the specified health check is healthy.
         * <p>
         * Default: - if the type is RECOVERY_CONTROL, this property is required. Otherwise, it is not configured.
         * <p>
         * @return {@code this}
         * @param routingControl The Amazon Resource Name (ARN) of the Route 53 Application Recovery Controller routing control that you want Amazon Route 53 health checkers to use to determine whether the specified health check is healthy. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder routingControl(final java.lang.String routingControl) {
            this.props.routingControl(routingControl);
            return this;
        }

        /**
         * The string that you want Amazon Route 53 to search for in the response body from the specified resource.
         * <p>
         * If the string appears in the response body, Route 53 considers the resource healthy.
         * <p>
         * Route 53 considers case when searching for SearchString in the response body.
         * <p>
         * Default: - if the type is HTTP_STR_MATCH or HTTPS_STR_MATCH, this property is required. Otherwise, it is not configured.
         * <p>
         * @return {@code this}
         * @param searchString The string that you want Amazon Route 53 to search for in the response body from the specified resource. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder searchString(final java.lang.String searchString) {
            this.props.searchString(searchString);
            return this;
        }

        /**
         * @return a newly built instance of {@link software.amazon.awscdk.services.route53.HealthCheck}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.route53.HealthCheck build() {
            return new software.amazon.awscdk.services.route53.HealthCheck(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
