package software.amazon.awscdk.services.route53;

/**
 * The attributes of a key signing key.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.route53.*;
 * HostedZone hostedZone;
 * KeySigningKeyAttributes keySigningKeyAttributes = KeySigningKeyAttributes.builder()
 *         .hostedZone(hostedZone)
 *         .keySigningKeyName("keySigningKeyName")
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.106.0 (build e852934)", date = "2025-03-12T01:36:44.768Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_route53.KeySigningKeyAttributes")
@software.amazon.jsii.Jsii.Proxy(KeySigningKeyAttributes.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface KeySigningKeyAttributes extends software.amazon.jsii.JsiiSerializable {

    /**
     * The hosted zone that the key signing key signs.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.route53.IHostedZone getHostedZone();

    /**
     * The name of the key signing key.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getKeySigningKeyName();

    /**
     * @return a {@link Builder} of {@link KeySigningKeyAttributes}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link KeySigningKeyAttributes}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<KeySigningKeyAttributes> {
        software.amazon.awscdk.services.route53.IHostedZone hostedZone;
        java.lang.String keySigningKeyName;

        /**
         * Sets the value of {@link KeySigningKeyAttributes#getHostedZone}
         * @param hostedZone The hosted zone that the key signing key signs. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder hostedZone(software.amazon.awscdk.services.route53.IHostedZone hostedZone) {
            this.hostedZone = hostedZone;
            return this;
        }

        /**
         * Sets the value of {@link KeySigningKeyAttributes#getKeySigningKeyName}
         * @param keySigningKeyName The name of the key signing key. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder keySigningKeyName(java.lang.String keySigningKeyName) {
            this.keySigningKeyName = keySigningKeyName;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link KeySigningKeyAttributes}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public KeySigningKeyAttributes build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link KeySigningKeyAttributes}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements KeySigningKeyAttributes {
        private final software.amazon.awscdk.services.route53.IHostedZone hostedZone;
        private final java.lang.String keySigningKeyName;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.hostedZone = software.amazon.jsii.Kernel.get(this, "hostedZone", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.route53.IHostedZone.class));
            this.keySigningKeyName = software.amazon.jsii.Kernel.get(this, "keySigningKeyName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.hostedZone = java.util.Objects.requireNonNull(builder.hostedZone, "hostedZone is required");
            this.keySigningKeyName = java.util.Objects.requireNonNull(builder.keySigningKeyName, "keySigningKeyName is required");
        }

        @Override
        public final software.amazon.awscdk.services.route53.IHostedZone getHostedZone() {
            return this.hostedZone;
        }

        @Override
        public final java.lang.String getKeySigningKeyName() {
            return this.keySigningKeyName;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("hostedZone", om.valueToTree(this.getHostedZone()));
            data.set("keySigningKeyName", om.valueToTree(this.getKeySigningKeyName()));

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_route53.KeySigningKeyAttributes"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            KeySigningKeyAttributes.Jsii$Proxy that = (KeySigningKeyAttributes.Jsii$Proxy) o;

            if (!hostedZone.equals(that.hostedZone)) return false;
            return this.keySigningKeyName.equals(that.keySigningKeyName);
        }

        @Override
        public final int hashCode() {
            int result = this.hostedZone.hashCode();
            result = 31 * result + (this.keySigningKeyName.hashCode());
            return result;
        }
    }
}
