package software.amazon.awscdk.services.rum;

/**
 * Creates a CloudWatch RUM app monitor, which you can use to collect telemetry data from your application and send it to CloudWatch RUM.
 * <p>
 * The data includes performance and reliability information such as page load time, client-side errors, and user behavior.
 * <p>
 * After you create an app monitor, sign in to the CloudWatch RUM console to get the JavaScript code snippet to add to your web application. For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/CloudWatch-RUM-find-code-snippet.html">How do I find a code snippet that I've already generated?</a>
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.rum.*;
 * CfnAppMonitor cfnAppMonitor = CfnAppMonitor.Builder.create(this, "MyCfnAppMonitor")
 *         .domain("domain")
 *         .name("name")
 *         // the properties below are optional
 *         .appMonitorConfiguration(AppMonitorConfigurationProperty.builder()
 *                 .allowCookies(false)
 *                 .enableXRay(false)
 *                 .excludedPages(List.of("excludedPages"))
 *                 .favoritePages(List.of("favoritePages"))
 *                 .guestRoleArn("guestRoleArn")
 *                 .identityPoolId("identityPoolId")
 *                 .includedPages(List.of("includedPages"))
 *                 .metricDestinations(List.of(MetricDestinationProperty.builder()
 *                         .destination("destination")
 *                         // the properties below are optional
 *                         .destinationArn("destinationArn")
 *                         .iamRoleArn("iamRoleArn")
 *                         .metricDefinitions(List.of(MetricDefinitionProperty.builder()
 *                                 .name("name")
 *                                 // the properties below are optional
 *                                 .dimensionKeys(Map.of(
 *                                         "dimensionKeysKey", "dimensionKeys"))
 *                                 .eventPattern("eventPattern")
 *                                 .namespace("namespace")
 *                                 .unitLabel("unitLabel")
 *                                 .valueKey("valueKey")
 *                                 .build()))
 *                         .build()))
 *                 .sessionSampleRate(123)
 *                 .telemetries(List.of("telemetries"))
 *                 .build())
 *         .customEvents(CustomEventsProperty.builder()
 *                 .status("status")
 *                 .build())
 *         .cwLogEnabled(false)
 *         .tags(List.of(CfnTag.builder()
 *                 .key("key")
 *                 .value("value")
 *                 .build()))
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rum-appmonitor.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rum-appmonitor.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.106.0 (build e852934)", date = "2025-03-12T01:36:44.874Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_rum.CfnAppMonitor")
public class CfnAppMonitor extends software.amazon.awscdk.CfnResource implements software.amazon.awscdk.IInspectable, software.amazon.awscdk.ITaggable {

    protected CfnAppMonitor(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnAppMonitor(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        CFN_RESOURCE_TYPE_NAME = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rum.CfnAppMonitor.class, "CFN_RESOURCE_TYPE_NAME", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * @param scope Scope in which this resource is defined. This parameter is required.
     * @param id Construct identifier for this resource (unique in its scope). This parameter is required.
     * @param props Resource properties. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public CfnAppMonitor(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.rum.CfnAppMonitorProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Examines the CloudFormation resource and discloses attributes.
     * <p>
     * @param inspector tree inspector to collect and process attributes. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public void inspect(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.TreeInspector inspector) {
        software.amazon.jsii.Kernel.call(this, "inspect", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(inspector, "inspector is required") });
    }

    /**
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> renderProperties(final @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> props) {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.call(this, "renderProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class)), new Object[] { java.util.Objects.requireNonNull(props, "props is required") }));
    }

    /**
     * The CloudFormation resource type name for this resource class.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String CFN_RESOURCE_TYPE_NAME;

    /**
     * The ID of the app monitor, such as <code>123456ab-1234-4ca9-9d2f-a1b2c3456789</code> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrId() {
        return software.amazon.jsii.Kernel.get(this, "attrId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> getCfnProperties() {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.get(this, "cfnProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class))));
    }

    /**
     * Tag Manager which manages the tags for this resource.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.TagManager getTags() {
        return software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.TagManager.class));
    }

    /**
     * The top-level internet domain name for which your application has administrative authority.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getDomain() {
        return software.amazon.jsii.Kernel.get(this, "domain", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The top-level internet domain name for which your application has administrative authority.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setDomain(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "domain", java.util.Objects.requireNonNull(value, "domain is required"));
    }

    /**
     * A name for the app monitor.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getName() {
        return software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * A name for the app monitor.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setName(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "name", java.util.Objects.requireNonNull(value, "name is required"));
    }

    /**
     * A structure that contains much of the configuration data for the app monitor.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getAppMonitorConfiguration() {
        return software.amazon.jsii.Kernel.get(this, "appMonitorConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * A structure that contains much of the configuration data for the app monitor.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setAppMonitorConfiguration(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "appMonitorConfiguration", value);
    }

    /**
     * A structure that contains much of the configuration data for the app monitor.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setAppMonitorConfiguration(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.rum.CfnAppMonitor.AppMonitorConfigurationProperty value) {
        software.amazon.jsii.Kernel.set(this, "appMonitorConfiguration", value);
    }

    /**
     * Specifies whether this app monitor allows the web client to define and send custom events.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getCustomEvents() {
        return software.amazon.jsii.Kernel.get(this, "customEvents", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * Specifies whether this app monitor allows the web client to define and send custom events.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setCustomEvents(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "customEvents", value);
    }

    /**
     * Specifies whether this app monitor allows the web client to define and send custom events.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setCustomEvents(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.rum.CfnAppMonitor.CustomEventsProperty value) {
        software.amazon.jsii.Kernel.set(this, "customEvents", value);
    }

    /**
     * Data collected by CloudWatch RUM is kept by RUM for 30 days and then deleted.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getCwLogEnabled() {
        return software.amazon.jsii.Kernel.get(this, "cwLogEnabled", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * Data collected by CloudWatch RUM is kept by RUM for 30 days and then deleted.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setCwLogEnabled(final @org.jetbrains.annotations.Nullable java.lang.Boolean value) {
        software.amazon.jsii.Kernel.set(this, "cwLogEnabled", value);
    }

    /**
     * Data collected by CloudWatch RUM is kept by RUM for 30 days and then deleted.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setCwLogEnabled(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "cwLogEnabled", value);
    }

    /**
     * Assigns one or more tags (key-value pairs) to the app monitor.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.CfnTag> getTagsRaw() {
        return java.util.Optional.ofNullable((java.util.List<software.amazon.awscdk.CfnTag>)(software.amazon.jsii.Kernel.get(this, "tagsRaw", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.CfnTag.class))))).map(java.util.Collections::unmodifiableList).orElse(null);
    }

    /**
     * Assigns one or more tags (key-value pairs) to the app monitor.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setTagsRaw(final @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.CfnTag> value) {
        software.amazon.jsii.Kernel.set(this, "tagsRaw", value);
    }
    /**
     * This structure contains much of the configuration data for the app monitor.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.rum.*;
     * AppMonitorConfigurationProperty appMonitorConfigurationProperty = AppMonitorConfigurationProperty.builder()
     *         .allowCookies(false)
     *         .enableXRay(false)
     *         .excludedPages(List.of("excludedPages"))
     *         .favoritePages(List.of("favoritePages"))
     *         .guestRoleArn("guestRoleArn")
     *         .identityPoolId("identityPoolId")
     *         .includedPages(List.of("includedPages"))
     *         .metricDestinations(List.of(MetricDestinationProperty.builder()
     *                 .destination("destination")
     *                 // the properties below are optional
     *                 .destinationArn("destinationArn")
     *                 .iamRoleArn("iamRoleArn")
     *                 .metricDefinitions(List.of(MetricDefinitionProperty.builder()
     *                         .name("name")
     *                         // the properties below are optional
     *                         .dimensionKeys(Map.of(
     *                                 "dimensionKeysKey", "dimensionKeys"))
     *                         .eventPattern("eventPattern")
     *                         .namespace("namespace")
     *                         .unitLabel("unitLabel")
     *                         .valueKey("valueKey")
     *                         .build()))
     *                 .build()))
     *         .sessionSampleRate(123)
     *         .telemetries(List.of("telemetries"))
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-rum-appmonitor-appmonitorconfiguration.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-rum-appmonitor-appmonitorconfiguration.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_rum.CfnAppMonitor.AppMonitorConfigurationProperty")
    @software.amazon.jsii.Jsii.Proxy(AppMonitorConfigurationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface AppMonitorConfigurationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * If you set this to <code>true</code> , the CloudWatch RUM web client sets two cookies, a session cookie and a user cookie.
         * <p>
         * The cookies allow the CloudWatch RUM web client to collect data relating to the number of users an application has and the behavior of the application across a sequence of events. Cookies are stored in the top-level domain of the current page.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-rum-appmonitor-appmonitorconfiguration.html#cfn-rum-appmonitor-appmonitorconfiguration-allowcookies">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-rum-appmonitor-appmonitorconfiguration.html#cfn-rum-appmonitor-appmonitorconfiguration-allowcookies</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getAllowCookies() {
            return null;
        }

        /**
         * If you set this to <code>true</code> , CloudWatch RUM sends client-side traces to X-Ray for each sampled session.
         * <p>
         * You can then see traces and segments from these user sessions in the RUM dashboard and the CloudWatch ServiceLens console. For more information, see <a href="https://docs.aws.amazon.com/xray/latest/devguide/aws-xray.html">What is AWS X-Ray ?</a>
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-rum-appmonitor-appmonitorconfiguration.html#cfn-rum-appmonitor-appmonitorconfiguration-enablexray">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-rum-appmonitor-appmonitorconfiguration.html#cfn-rum-appmonitor-appmonitorconfiguration-enablexray</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getEnableXRay() {
            return null;
        }

        /**
         * A list of URLs in your website or application to exclude from RUM data collection.
         * <p>
         * You can't include both <code>ExcludedPages</code> and <code>IncludedPages</code> in the same app monitor.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-rum-appmonitor-appmonitorconfiguration.html#cfn-rum-appmonitor-appmonitorconfiguration-excludedpages">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-rum-appmonitor-appmonitorconfiguration.html#cfn-rum-appmonitor-appmonitorconfiguration-excludedpages</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getExcludedPages() {
            return null;
        }

        /**
         * A list of pages in your application that are to be displayed with a "favorite" icon in the CloudWatch RUM console.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-rum-appmonitor-appmonitorconfiguration.html#cfn-rum-appmonitor-appmonitorconfiguration-favoritepages">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-rum-appmonitor-appmonitorconfiguration.html#cfn-rum-appmonitor-appmonitorconfiguration-favoritepages</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getFavoritePages() {
            return null;
        }

        /**
         * The ARN of the guest IAM role that is attached to the Amazon Cognito identity pool that is used to authorize the sending of data to CloudWatch RUM.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-rum-appmonitor-appmonitorconfiguration.html#cfn-rum-appmonitor-appmonitorconfiguration-guestrolearn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-rum-appmonitor-appmonitorconfiguration.html#cfn-rum-appmonitor-appmonitorconfiguration-guestrolearn</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getGuestRoleArn() {
            return null;
        }

        /**
         * The ID of the Amazon Cognito identity pool that is used to authorize the sending of data to CloudWatch RUM.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-rum-appmonitor-appmonitorconfiguration.html#cfn-rum-appmonitor-appmonitorconfiguration-identitypoolid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-rum-appmonitor-appmonitorconfiguration.html#cfn-rum-appmonitor-appmonitorconfiguration-identitypoolid</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getIdentityPoolId() {
            return null;
        }

        /**
         * If this app monitor is to collect data from only certain pages in your application, this structure lists those pages.
         * <p>
         * You can't include both <code>ExcludedPages</code> and <code>IncludedPages</code> in the same app monitor.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-rum-appmonitor-appmonitorconfiguration.html#cfn-rum-appmonitor-appmonitorconfiguration-includedpages">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-rum-appmonitor-appmonitorconfiguration.html#cfn-rum-appmonitor-appmonitorconfiguration-includedpages</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getIncludedPages() {
            return null;
        }

        /**
         * An array of structures that each define a destination that this app monitor will send extended metrics to.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-rum-appmonitor-appmonitorconfiguration.html#cfn-rum-appmonitor-appmonitorconfiguration-metricdestinations">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-rum-appmonitor-appmonitorconfiguration.html#cfn-rum-appmonitor-appmonitorconfiguration-metricdestinations</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getMetricDestinations() {
            return null;
        }

        /**
         * Specifies the portion of user sessions to use for CloudWatch RUM data collection.
         * <p>
         * Choosing a higher portion gives you more data but also incurs more costs.
         * <p>
         * The range for this value is 0 to 1 inclusive. Setting this to 1 means that 100% of user sessions are sampled, and setting it to 0.1 means that 10% of user sessions are sampled.
         * <p>
         * If you omit this parameter, the default of 0.1 is used, and 10% of sessions will be sampled.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-rum-appmonitor-appmonitorconfiguration.html#cfn-rum-appmonitor-appmonitorconfiguration-sessionsamplerate">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-rum-appmonitor-appmonitorconfiguration.html#cfn-rum-appmonitor-appmonitorconfiguration-sessionsamplerate</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getSessionSampleRate() {
            return null;
        }

        /**
         * An array that lists the types of telemetry data that this app monitor is to collect.
         * <p>
         * <ul>
         * <li><code>errors</code> indicates that RUM collects data about unhandled JavaScript errors raised by your application.</li>
         * <li><code>performance</code> indicates that RUM collects performance data about how your application and its resources are loaded and rendered. This includes Core Web Vitals.</li>
         * <li><code>http</code> indicates that RUM collects data about HTTP errors thrown by your application.</li>
         * </ul>
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-rum-appmonitor-appmonitorconfiguration.html#cfn-rum-appmonitor-appmonitorconfiguration-telemetries">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-rum-appmonitor-appmonitorconfiguration.html#cfn-rum-appmonitor-appmonitorconfiguration-telemetries</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getTelemetries() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link AppMonitorConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link AppMonitorConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<AppMonitorConfigurationProperty> {
            java.lang.Object allowCookies;
            java.lang.Object enableXRay;
            java.util.List<java.lang.String> excludedPages;
            java.util.List<java.lang.String> favoritePages;
            java.lang.String guestRoleArn;
            java.lang.String identityPoolId;
            java.util.List<java.lang.String> includedPages;
            java.lang.Object metricDestinations;
            java.lang.Number sessionSampleRate;
            java.util.List<java.lang.String> telemetries;

            /**
             * Sets the value of {@link AppMonitorConfigurationProperty#getAllowCookies}
             * @param allowCookies If you set this to <code>true</code> , the CloudWatch RUM web client sets two cookies, a session cookie and a user cookie.
             *                     The cookies allow the CloudWatch RUM web client to collect data relating to the number of users an application has and the behavior of the application across a sequence of events. Cookies are stored in the top-level domain of the current page.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder allowCookies(java.lang.Boolean allowCookies) {
                this.allowCookies = allowCookies;
                return this;
            }

            /**
             * Sets the value of {@link AppMonitorConfigurationProperty#getAllowCookies}
             * @param allowCookies If you set this to <code>true</code> , the CloudWatch RUM web client sets two cookies, a session cookie and a user cookie.
             *                     The cookies allow the CloudWatch RUM web client to collect data relating to the number of users an application has and the behavior of the application across a sequence of events. Cookies are stored in the top-level domain of the current page.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder allowCookies(software.amazon.awscdk.IResolvable allowCookies) {
                this.allowCookies = allowCookies;
                return this;
            }

            /**
             * Sets the value of {@link AppMonitorConfigurationProperty#getEnableXRay}
             * @param enableXRay If you set this to <code>true</code> , CloudWatch RUM sends client-side traces to X-Ray for each sampled session.
             *                   You can then see traces and segments from these user sessions in the RUM dashboard and the CloudWatch ServiceLens console. For more information, see <a href="https://docs.aws.amazon.com/xray/latest/devguide/aws-xray.html">What is AWS X-Ray ?</a>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder enableXRay(java.lang.Boolean enableXRay) {
                this.enableXRay = enableXRay;
                return this;
            }

            /**
             * Sets the value of {@link AppMonitorConfigurationProperty#getEnableXRay}
             * @param enableXRay If you set this to <code>true</code> , CloudWatch RUM sends client-side traces to X-Ray for each sampled session.
             *                   You can then see traces and segments from these user sessions in the RUM dashboard and the CloudWatch ServiceLens console. For more information, see <a href="https://docs.aws.amazon.com/xray/latest/devguide/aws-xray.html">What is AWS X-Ray ?</a>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder enableXRay(software.amazon.awscdk.IResolvable enableXRay) {
                this.enableXRay = enableXRay;
                return this;
            }

            /**
             * Sets the value of {@link AppMonitorConfigurationProperty#getExcludedPages}
             * @param excludedPages A list of URLs in your website or application to exclude from RUM data collection.
             *                      You can't include both <code>ExcludedPages</code> and <code>IncludedPages</code> in the same app monitor.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder excludedPages(java.util.List<java.lang.String> excludedPages) {
                this.excludedPages = excludedPages;
                return this;
            }

            /**
             * Sets the value of {@link AppMonitorConfigurationProperty#getFavoritePages}
             * @param favoritePages A list of pages in your application that are to be displayed with a "favorite" icon in the CloudWatch RUM console.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder favoritePages(java.util.List<java.lang.String> favoritePages) {
                this.favoritePages = favoritePages;
                return this;
            }

            /**
             * Sets the value of {@link AppMonitorConfigurationProperty#getGuestRoleArn}
             * @param guestRoleArn The ARN of the guest IAM role that is attached to the Amazon Cognito identity pool that is used to authorize the sending of data to CloudWatch RUM.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder guestRoleArn(java.lang.String guestRoleArn) {
                this.guestRoleArn = guestRoleArn;
                return this;
            }

            /**
             * Sets the value of {@link AppMonitorConfigurationProperty#getIdentityPoolId}
             * @param identityPoolId The ID of the Amazon Cognito identity pool that is used to authorize the sending of data to CloudWatch RUM.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder identityPoolId(java.lang.String identityPoolId) {
                this.identityPoolId = identityPoolId;
                return this;
            }

            /**
             * Sets the value of {@link AppMonitorConfigurationProperty#getIncludedPages}
             * @param includedPages If this app monitor is to collect data from only certain pages in your application, this structure lists those pages.
             *                      You can't include both <code>ExcludedPages</code> and <code>IncludedPages</code> in the same app monitor.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder includedPages(java.util.List<java.lang.String> includedPages) {
                this.includedPages = includedPages;
                return this;
            }

            /**
             * Sets the value of {@link AppMonitorConfigurationProperty#getMetricDestinations}
             * @param metricDestinations An array of structures that each define a destination that this app monitor will send extended metrics to.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder metricDestinations(software.amazon.awscdk.IResolvable metricDestinations) {
                this.metricDestinations = metricDestinations;
                return this;
            }

            /**
             * Sets the value of {@link AppMonitorConfigurationProperty#getMetricDestinations}
             * @param metricDestinations An array of structures that each define a destination that this app monitor will send extended metrics to.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder metricDestinations(java.util.List<? extends java.lang.Object> metricDestinations) {
                this.metricDestinations = metricDestinations;
                return this;
            }

            /**
             * Sets the value of {@link AppMonitorConfigurationProperty#getSessionSampleRate}
             * @param sessionSampleRate Specifies the portion of user sessions to use for CloudWatch RUM data collection.
             *                          Choosing a higher portion gives you more data but also incurs more costs.
             *                          <p>
             *                          The range for this value is 0 to 1 inclusive. Setting this to 1 means that 100% of user sessions are sampled, and setting it to 0.1 means that 10% of user sessions are sampled.
             *                          <p>
             *                          If you omit this parameter, the default of 0.1 is used, and 10% of sessions will be sampled.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder sessionSampleRate(java.lang.Number sessionSampleRate) {
                this.sessionSampleRate = sessionSampleRate;
                return this;
            }

            /**
             * Sets the value of {@link AppMonitorConfigurationProperty#getTelemetries}
             * @param telemetries An array that lists the types of telemetry data that this app monitor is to collect.
             *                    <ul>
             *                    <li><code>errors</code> indicates that RUM collects data about unhandled JavaScript errors raised by your application.</li>
             *                    <li><code>performance</code> indicates that RUM collects performance data about how your application and its resources are loaded and rendered. This includes Core Web Vitals.</li>
             *                    <li><code>http</code> indicates that RUM collects data about HTTP errors thrown by your application.</li>
             *                    </ul>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder telemetries(java.util.List<java.lang.String> telemetries) {
                this.telemetries = telemetries;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link AppMonitorConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public AppMonitorConfigurationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link AppMonitorConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements AppMonitorConfigurationProperty {
            private final java.lang.Object allowCookies;
            private final java.lang.Object enableXRay;
            private final java.util.List<java.lang.String> excludedPages;
            private final java.util.List<java.lang.String> favoritePages;
            private final java.lang.String guestRoleArn;
            private final java.lang.String identityPoolId;
            private final java.util.List<java.lang.String> includedPages;
            private final java.lang.Object metricDestinations;
            private final java.lang.Number sessionSampleRate;
            private final java.util.List<java.lang.String> telemetries;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.allowCookies = software.amazon.jsii.Kernel.get(this, "allowCookies", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.enableXRay = software.amazon.jsii.Kernel.get(this, "enableXRay", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.excludedPages = software.amazon.jsii.Kernel.get(this, "excludedPages", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
                this.favoritePages = software.amazon.jsii.Kernel.get(this, "favoritePages", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
                this.guestRoleArn = software.amazon.jsii.Kernel.get(this, "guestRoleArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.identityPoolId = software.amazon.jsii.Kernel.get(this, "identityPoolId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.includedPages = software.amazon.jsii.Kernel.get(this, "includedPages", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
                this.metricDestinations = software.amazon.jsii.Kernel.get(this, "metricDestinations", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.sessionSampleRate = software.amazon.jsii.Kernel.get(this, "sessionSampleRate", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.telemetries = software.amazon.jsii.Kernel.get(this, "telemetries", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.allowCookies = builder.allowCookies;
                this.enableXRay = builder.enableXRay;
                this.excludedPages = builder.excludedPages;
                this.favoritePages = builder.favoritePages;
                this.guestRoleArn = builder.guestRoleArn;
                this.identityPoolId = builder.identityPoolId;
                this.includedPages = builder.includedPages;
                this.metricDestinations = builder.metricDestinations;
                this.sessionSampleRate = builder.sessionSampleRate;
                this.telemetries = builder.telemetries;
            }

            @Override
            public final java.lang.Object getAllowCookies() {
                return this.allowCookies;
            }

            @Override
            public final java.lang.Object getEnableXRay() {
                return this.enableXRay;
            }

            @Override
            public final java.util.List<java.lang.String> getExcludedPages() {
                return this.excludedPages;
            }

            @Override
            public final java.util.List<java.lang.String> getFavoritePages() {
                return this.favoritePages;
            }

            @Override
            public final java.lang.String getGuestRoleArn() {
                return this.guestRoleArn;
            }

            @Override
            public final java.lang.String getIdentityPoolId() {
                return this.identityPoolId;
            }

            @Override
            public final java.util.List<java.lang.String> getIncludedPages() {
                return this.includedPages;
            }

            @Override
            public final java.lang.Object getMetricDestinations() {
                return this.metricDestinations;
            }

            @Override
            public final java.lang.Number getSessionSampleRate() {
                return this.sessionSampleRate;
            }

            @Override
            public final java.util.List<java.lang.String> getTelemetries() {
                return this.telemetries;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getAllowCookies() != null) {
                    data.set("allowCookies", om.valueToTree(this.getAllowCookies()));
                }
                if (this.getEnableXRay() != null) {
                    data.set("enableXRay", om.valueToTree(this.getEnableXRay()));
                }
                if (this.getExcludedPages() != null) {
                    data.set("excludedPages", om.valueToTree(this.getExcludedPages()));
                }
                if (this.getFavoritePages() != null) {
                    data.set("favoritePages", om.valueToTree(this.getFavoritePages()));
                }
                if (this.getGuestRoleArn() != null) {
                    data.set("guestRoleArn", om.valueToTree(this.getGuestRoleArn()));
                }
                if (this.getIdentityPoolId() != null) {
                    data.set("identityPoolId", om.valueToTree(this.getIdentityPoolId()));
                }
                if (this.getIncludedPages() != null) {
                    data.set("includedPages", om.valueToTree(this.getIncludedPages()));
                }
                if (this.getMetricDestinations() != null) {
                    data.set("metricDestinations", om.valueToTree(this.getMetricDestinations()));
                }
                if (this.getSessionSampleRate() != null) {
                    data.set("sessionSampleRate", om.valueToTree(this.getSessionSampleRate()));
                }
                if (this.getTelemetries() != null) {
                    data.set("telemetries", om.valueToTree(this.getTelemetries()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_rum.CfnAppMonitor.AppMonitorConfigurationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                AppMonitorConfigurationProperty.Jsii$Proxy that = (AppMonitorConfigurationProperty.Jsii$Proxy) o;

                if (this.allowCookies != null ? !this.allowCookies.equals(that.allowCookies) : that.allowCookies != null) return false;
                if (this.enableXRay != null ? !this.enableXRay.equals(that.enableXRay) : that.enableXRay != null) return false;
                if (this.excludedPages != null ? !this.excludedPages.equals(that.excludedPages) : that.excludedPages != null) return false;
                if (this.favoritePages != null ? !this.favoritePages.equals(that.favoritePages) : that.favoritePages != null) return false;
                if (this.guestRoleArn != null ? !this.guestRoleArn.equals(that.guestRoleArn) : that.guestRoleArn != null) return false;
                if (this.identityPoolId != null ? !this.identityPoolId.equals(that.identityPoolId) : that.identityPoolId != null) return false;
                if (this.includedPages != null ? !this.includedPages.equals(that.includedPages) : that.includedPages != null) return false;
                if (this.metricDestinations != null ? !this.metricDestinations.equals(that.metricDestinations) : that.metricDestinations != null) return false;
                if (this.sessionSampleRate != null ? !this.sessionSampleRate.equals(that.sessionSampleRate) : that.sessionSampleRate != null) return false;
                return this.telemetries != null ? this.telemetries.equals(that.telemetries) : that.telemetries == null;
            }

            @Override
            public final int hashCode() {
                int result = this.allowCookies != null ? this.allowCookies.hashCode() : 0;
                result = 31 * result + (this.enableXRay != null ? this.enableXRay.hashCode() : 0);
                result = 31 * result + (this.excludedPages != null ? this.excludedPages.hashCode() : 0);
                result = 31 * result + (this.favoritePages != null ? this.favoritePages.hashCode() : 0);
                result = 31 * result + (this.guestRoleArn != null ? this.guestRoleArn.hashCode() : 0);
                result = 31 * result + (this.identityPoolId != null ? this.identityPoolId.hashCode() : 0);
                result = 31 * result + (this.includedPages != null ? this.includedPages.hashCode() : 0);
                result = 31 * result + (this.metricDestinations != null ? this.metricDestinations.hashCode() : 0);
                result = 31 * result + (this.sessionSampleRate != null ? this.sessionSampleRate.hashCode() : 0);
                result = 31 * result + (this.telemetries != null ? this.telemetries.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * This structure specifies whether this app monitor allows the web client to define and send custom events.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.rum.*;
     * CustomEventsProperty customEventsProperty = CustomEventsProperty.builder()
     *         .status("status")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-rum-appmonitor-customevents.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-rum-appmonitor-customevents.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_rum.CfnAppMonitor.CustomEventsProperty")
    @software.amazon.jsii.Jsii.Proxy(CustomEventsProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface CustomEventsProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Set this to <code>ENABLED</code> to allow the web client to send custom events for this app monitor.
         * <p>
         * Valid values are <code>ENABLED</code> and <code>DISABLED</code> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-rum-appmonitor-customevents.html#cfn-rum-appmonitor-customevents-status">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-rum-appmonitor-customevents.html#cfn-rum-appmonitor-customevents-status</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getStatus() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link CustomEventsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link CustomEventsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<CustomEventsProperty> {
            java.lang.String status;

            /**
             * Sets the value of {@link CustomEventsProperty#getStatus}
             * @param status Set this to <code>ENABLED</code> to allow the web client to send custom events for this app monitor.
             *               Valid values are <code>ENABLED</code> and <code>DISABLED</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder status(java.lang.String status) {
                this.status = status;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link CustomEventsProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public CustomEventsProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link CustomEventsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CustomEventsProperty {
            private final java.lang.String status;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.status = software.amazon.jsii.Kernel.get(this, "status", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.status = builder.status;
            }

            @Override
            public final java.lang.String getStatus() {
                return this.status;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getStatus() != null) {
                    data.set("status", om.valueToTree(this.getStatus()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_rum.CfnAppMonitor.CustomEventsProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                CustomEventsProperty.Jsii$Proxy that = (CustomEventsProperty.Jsii$Proxy) o;

                return this.status != null ? this.status.equals(that.status) : that.status == null;
            }

            @Override
            public final int hashCode() {
                int result = this.status != null ? this.status.hashCode() : 0;
                return result;
            }
        }
    }
    /**
     * Specifies one custom metric or extended metric that you want the CloudWatch RUM app monitor to send to a destination.
     * <p>
     * Valid destinations include CloudWatch and Evidently.
     * <p>
     * By default, RUM app monitors send some metrics to CloudWatch . These default metrics are listed in <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/CloudWatch-RUM-metrics.html">CloudWatch metrics that you can collect.</a>
     * <p>
     * In addition to these default metrics, you can choose to send extended metrics or custom metrics or both.
     * <p>
     * <ul>
     * <li>Extended metrics enable you to send metrics with additional dimensions not included in the default metrics. You can also send extended metrics to Evidently as well as CloudWatch . The valid dimension names for the additional dimensions for extended metrics are <code>BrowserName</code> , <code>CountryCode</code> , <code>DeviceType</code> , <code>FileType</code> , <code>OSName</code> , and <code>PageId</code> . For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/CloudWatch-RUM-vended-metrics.html">Extended metrics</a> .</li>
     * <li>Custom metrics are metrics that you define. You can send custom metrics to CloudWatch or to CloudWatch Evidently or to both. With custom metrics, you can use any metric name and namespace, and to derive the metrics you can use any custom events, built-in events, custom attributes, or default attributes.</li>
     * </ul>
     * <p>
     * You can't send custom metrics to the <code>AWS/RUM</code> namespace. You must send custom metrics to a custom namespace that you define. The namespace that you use can't start with <code>AWS/</code> . CloudWatch RUM prepends <code>RUM/CustomMetrics/</code> to the custom namespace that you define, so the final namespace for your metrics in CloudWatch is <code>RUM/CustomMetrics/ *your-custom-namespace*</code> .
     * <p>
     * For information about syntax rules for specifying custom metrics and extended metrics, see <a href="https://docs.aws.amazon.com/cloudwatchrum/latest/APIReference/API_MetricDefinitionRequest.html">MetridDefinitionRequest</a> in the <em>CloudWatch RUM API Reference</em> .
     * <p>
     * The maximum number of metric definitions that one destination can contain is 2000.
     * <p>
     * Extended metrics sent to CloudWatch and RUM custom metrics are charged as CloudWatch custom metrics. Each combination of additional dimension name and dimension value counts as a custom metric.
     * <p>
     * If some metric definitions that you specify are not valid, then the operation will not modify any metric definitions even if other metric definitions specified are valid.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.rum.*;
     * MetricDefinitionProperty metricDefinitionProperty = MetricDefinitionProperty.builder()
     *         .name("name")
     *         // the properties below are optional
     *         .dimensionKeys(Map.of(
     *                 "dimensionKeysKey", "dimensionKeys"))
     *         .eventPattern("eventPattern")
     *         .namespace("namespace")
     *         .unitLabel("unitLabel")
     *         .valueKey("valueKey")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-rum-appmonitor-metricdefinition.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-rum-appmonitor-metricdefinition.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_rum.CfnAppMonitor.MetricDefinitionProperty")
    @software.amazon.jsii.Jsii.Proxy(MetricDefinitionProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface MetricDefinitionProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The name of the metric that is defined in this structure.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-rum-appmonitor-metricdefinition.html#cfn-rum-appmonitor-metricdefinition-name">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-rum-appmonitor-metricdefinition.html#cfn-rum-appmonitor-metricdefinition-name</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getName();

        /**
         * This field is a map of field paths to dimension names.
         * <p>
         * It defines the dimensions to associate with this metric in CloudWatch . The value of this field is used only if the metric destination is <code>CloudWatch</code> . If the metric destination is <code>Evidently</code> , the value of <code>DimensionKeys</code> is ignored.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-rum-appmonitor-metricdefinition.html#cfn-rum-appmonitor-metricdefinition-dimensionkeys">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-rum-appmonitor-metricdefinition.html#cfn-rum-appmonitor-metricdefinition-dimensionkeys</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getDimensionKeys() {
            return null;
        }

        /**
         * The pattern that defines the metric.
         * <p>
         * RUM checks events that happen in a user's session against the pattern, and events that match the pattern are sent to the metric destination.
         * <p>
         * If the metrics destination is <code>CloudWatch</code> and the event also matches a value in <code>DimensionKeys</code> , then the metric is published with the specified dimensions.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-rum-appmonitor-metricdefinition.html#cfn-rum-appmonitor-metricdefinition-eventpattern">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-rum-appmonitor-metricdefinition.html#cfn-rum-appmonitor-metricdefinition-eventpattern</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getEventPattern() {
            return null;
        }

        /**
         * If you are creating a custom metric instead of an extended metrics, use this parameter to define the metric namespace for that custom metric.
         * <p>
         * Do not specify this parameter if you are creating an extended metric.
         * <p>
         * You can't use any string that starts with <code>AWS/</code> for your namespace.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-rum-appmonitor-metricdefinition.html#cfn-rum-appmonitor-metricdefinition-namespace">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-rum-appmonitor-metricdefinition.html#cfn-rum-appmonitor-metricdefinition-namespace</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getNamespace() {
            return null;
        }

        /**
         * Use this field only if you are sending this metric to CloudWatch .
         * <p>
         * It defines the CloudWatch metric unit that this metric is measured in.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-rum-appmonitor-metricdefinition.html#cfn-rum-appmonitor-metricdefinition-unitlabel">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-rum-appmonitor-metricdefinition.html#cfn-rum-appmonitor-metricdefinition-unitlabel</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getUnitLabel() {
            return null;
        }

        /**
         * The field within the event object that the metric value is sourced from.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-rum-appmonitor-metricdefinition.html#cfn-rum-appmonitor-metricdefinition-valuekey">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-rum-appmonitor-metricdefinition.html#cfn-rum-appmonitor-metricdefinition-valuekey</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getValueKey() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link MetricDefinitionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link MetricDefinitionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<MetricDefinitionProperty> {
            java.lang.String name;
            java.lang.Object dimensionKeys;
            java.lang.String eventPattern;
            java.lang.String namespace;
            java.lang.String unitLabel;
            java.lang.String valueKey;

            /**
             * Sets the value of {@link MetricDefinitionProperty#getName}
             * @param name The name of the metric that is defined in this structure. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder name(java.lang.String name) {
                this.name = name;
                return this;
            }

            /**
             * Sets the value of {@link MetricDefinitionProperty#getDimensionKeys}
             * @param dimensionKeys This field is a map of field paths to dimension names.
             *                      It defines the dimensions to associate with this metric in CloudWatch . The value of this field is used only if the metric destination is <code>CloudWatch</code> . If the metric destination is <code>Evidently</code> , the value of <code>DimensionKeys</code> is ignored.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder dimensionKeys(java.util.Map<java.lang.String, java.lang.String> dimensionKeys) {
                this.dimensionKeys = dimensionKeys;
                return this;
            }

            /**
             * Sets the value of {@link MetricDefinitionProperty#getDimensionKeys}
             * @param dimensionKeys This field is a map of field paths to dimension names.
             *                      It defines the dimensions to associate with this metric in CloudWatch . The value of this field is used only if the metric destination is <code>CloudWatch</code> . If the metric destination is <code>Evidently</code> , the value of <code>DimensionKeys</code> is ignored.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder dimensionKeys(software.amazon.awscdk.IResolvable dimensionKeys) {
                this.dimensionKeys = dimensionKeys;
                return this;
            }

            /**
             * Sets the value of {@link MetricDefinitionProperty#getEventPattern}
             * @param eventPattern The pattern that defines the metric.
             *                     RUM checks events that happen in a user's session against the pattern, and events that match the pattern are sent to the metric destination.
             *                     <p>
             *                     If the metrics destination is <code>CloudWatch</code> and the event also matches a value in <code>DimensionKeys</code> , then the metric is published with the specified dimensions.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder eventPattern(java.lang.String eventPattern) {
                this.eventPattern = eventPattern;
                return this;
            }

            /**
             * Sets the value of {@link MetricDefinitionProperty#getNamespace}
             * @param namespace If you are creating a custom metric instead of an extended metrics, use this parameter to define the metric namespace for that custom metric.
             *                  Do not specify this parameter if you are creating an extended metric.
             *                  <p>
             *                  You can't use any string that starts with <code>AWS/</code> for your namespace.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder namespace(java.lang.String namespace) {
                this.namespace = namespace;
                return this;
            }

            /**
             * Sets the value of {@link MetricDefinitionProperty#getUnitLabel}
             * @param unitLabel Use this field only if you are sending this metric to CloudWatch .
             *                  It defines the CloudWatch metric unit that this metric is measured in.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder unitLabel(java.lang.String unitLabel) {
                this.unitLabel = unitLabel;
                return this;
            }

            /**
             * Sets the value of {@link MetricDefinitionProperty#getValueKey}
             * @param valueKey The field within the event object that the metric value is sourced from.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder valueKey(java.lang.String valueKey) {
                this.valueKey = valueKey;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link MetricDefinitionProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public MetricDefinitionProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link MetricDefinitionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements MetricDefinitionProperty {
            private final java.lang.String name;
            private final java.lang.Object dimensionKeys;
            private final java.lang.String eventPattern;
            private final java.lang.String namespace;
            private final java.lang.String unitLabel;
            private final java.lang.String valueKey;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.name = software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.dimensionKeys = software.amazon.jsii.Kernel.get(this, "dimensionKeys", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.eventPattern = software.amazon.jsii.Kernel.get(this, "eventPattern", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.namespace = software.amazon.jsii.Kernel.get(this, "namespace", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.unitLabel = software.amazon.jsii.Kernel.get(this, "unitLabel", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.valueKey = software.amazon.jsii.Kernel.get(this, "valueKey", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.name = java.util.Objects.requireNonNull(builder.name, "name is required");
                this.dimensionKeys = builder.dimensionKeys;
                this.eventPattern = builder.eventPattern;
                this.namespace = builder.namespace;
                this.unitLabel = builder.unitLabel;
                this.valueKey = builder.valueKey;
            }

            @Override
            public final java.lang.String getName() {
                return this.name;
            }

            @Override
            public final java.lang.Object getDimensionKeys() {
                return this.dimensionKeys;
            }

            @Override
            public final java.lang.String getEventPattern() {
                return this.eventPattern;
            }

            @Override
            public final java.lang.String getNamespace() {
                return this.namespace;
            }

            @Override
            public final java.lang.String getUnitLabel() {
                return this.unitLabel;
            }

            @Override
            public final java.lang.String getValueKey() {
                return this.valueKey;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("name", om.valueToTree(this.getName()));
                if (this.getDimensionKeys() != null) {
                    data.set("dimensionKeys", om.valueToTree(this.getDimensionKeys()));
                }
                if (this.getEventPattern() != null) {
                    data.set("eventPattern", om.valueToTree(this.getEventPattern()));
                }
                if (this.getNamespace() != null) {
                    data.set("namespace", om.valueToTree(this.getNamespace()));
                }
                if (this.getUnitLabel() != null) {
                    data.set("unitLabel", om.valueToTree(this.getUnitLabel()));
                }
                if (this.getValueKey() != null) {
                    data.set("valueKey", om.valueToTree(this.getValueKey()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_rum.CfnAppMonitor.MetricDefinitionProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                MetricDefinitionProperty.Jsii$Proxy that = (MetricDefinitionProperty.Jsii$Proxy) o;

                if (!name.equals(that.name)) return false;
                if (this.dimensionKeys != null ? !this.dimensionKeys.equals(that.dimensionKeys) : that.dimensionKeys != null) return false;
                if (this.eventPattern != null ? !this.eventPattern.equals(that.eventPattern) : that.eventPattern != null) return false;
                if (this.namespace != null ? !this.namespace.equals(that.namespace) : that.namespace != null) return false;
                if (this.unitLabel != null ? !this.unitLabel.equals(that.unitLabel) : that.unitLabel != null) return false;
                return this.valueKey != null ? this.valueKey.equals(that.valueKey) : that.valueKey == null;
            }

            @Override
            public final int hashCode() {
                int result = this.name.hashCode();
                result = 31 * result + (this.dimensionKeys != null ? this.dimensionKeys.hashCode() : 0);
                result = 31 * result + (this.eventPattern != null ? this.eventPattern.hashCode() : 0);
                result = 31 * result + (this.namespace != null ? this.namespace.hashCode() : 0);
                result = 31 * result + (this.unitLabel != null ? this.unitLabel.hashCode() : 0);
                result = 31 * result + (this.valueKey != null ? this.valueKey.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Creates or updates a destination to receive extended metrics from CloudWatch RUM.
     * <p>
     * You can send extended metrics to CloudWatch or to a CloudWatch Evidently experiment.
     * <p>
     * For more information about extended metrics, see <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/CloudWatch-RUM-vended-metrics.html">Extended metrics that you can send to CloudWatch and CloudWatch Evidently</a> .
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.rum.*;
     * MetricDestinationProperty metricDestinationProperty = MetricDestinationProperty.builder()
     *         .destination("destination")
     *         // the properties below are optional
     *         .destinationArn("destinationArn")
     *         .iamRoleArn("iamRoleArn")
     *         .metricDefinitions(List.of(MetricDefinitionProperty.builder()
     *                 .name("name")
     *                 // the properties below are optional
     *                 .dimensionKeys(Map.of(
     *                         "dimensionKeysKey", "dimensionKeys"))
     *                 .eventPattern("eventPattern")
     *                 .namespace("namespace")
     *                 .unitLabel("unitLabel")
     *                 .valueKey("valueKey")
     *                 .build()))
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-rum-appmonitor-metricdestination.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-rum-appmonitor-metricdestination.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_rum.CfnAppMonitor.MetricDestinationProperty")
    @software.amazon.jsii.Jsii.Proxy(MetricDestinationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface MetricDestinationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Defines the destination to send the metrics to.
         * <p>
         * Valid values are <code>CloudWatch</code> and <code>Evidently</code> . If you specify <code>Evidently</code> , you must also specify the ARN of the CloudWatch Evidently experiment that is to be the destination and an IAM role that has permission to write to the experiment.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-rum-appmonitor-metricdestination.html#cfn-rum-appmonitor-metricdestination-destination">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-rum-appmonitor-metricdestination.html#cfn-rum-appmonitor-metricdestination-destination</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getDestination();

        /**
         * Use this parameter only if <code>Destination</code> is <code>Evidently</code> .
         * <p>
         * This parameter specifies the ARN of the Evidently experiment that will receive the extended metrics.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-rum-appmonitor-metricdestination.html#cfn-rum-appmonitor-metricdestination-destinationarn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-rum-appmonitor-metricdestination.html#cfn-rum-appmonitor-metricdestination-destinationarn</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getDestinationArn() {
            return null;
        }

        /**
         * This parameter is required if <code>Destination</code> is <code>Evidently</code> . If <code>Destination</code> is <code>CloudWatch</code> , do not use this parameter.
         * <p>
         * This parameter specifies the ARN of an IAM role that RUM will assume to write to the Evidently experiment that you are sending metrics to. This role must have permission to write to that experiment.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-rum-appmonitor-metricdestination.html#cfn-rum-appmonitor-metricdestination-iamrolearn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-rum-appmonitor-metricdestination.html#cfn-rum-appmonitor-metricdestination-iamrolearn</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getIamRoleArn() {
            return null;
        }

        /**
         * An array of structures which define the metrics that you want to send.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-rum-appmonitor-metricdestination.html#cfn-rum-appmonitor-metricdestination-metricdefinitions">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-rum-appmonitor-metricdestination.html#cfn-rum-appmonitor-metricdestination-metricdefinitions</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getMetricDefinitions() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link MetricDestinationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link MetricDestinationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<MetricDestinationProperty> {
            java.lang.String destination;
            java.lang.String destinationArn;
            java.lang.String iamRoleArn;
            java.lang.Object metricDefinitions;

            /**
             * Sets the value of {@link MetricDestinationProperty#getDestination}
             * @param destination Defines the destination to send the metrics to. This parameter is required.
             *                    Valid values are <code>CloudWatch</code> and <code>Evidently</code> . If you specify <code>Evidently</code> , you must also specify the ARN of the CloudWatch Evidently experiment that is to be the destination and an IAM role that has permission to write to the experiment.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder destination(java.lang.String destination) {
                this.destination = destination;
                return this;
            }

            /**
             * Sets the value of {@link MetricDestinationProperty#getDestinationArn}
             * @param destinationArn Use this parameter only if <code>Destination</code> is <code>Evidently</code> .
             *                       This parameter specifies the ARN of the Evidently experiment that will receive the extended metrics.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder destinationArn(java.lang.String destinationArn) {
                this.destinationArn = destinationArn;
                return this;
            }

            /**
             * Sets the value of {@link MetricDestinationProperty#getIamRoleArn}
             * @param iamRoleArn This parameter is required if <code>Destination</code> is <code>Evidently</code> . If <code>Destination</code> is <code>CloudWatch</code> , do not use this parameter.
             *                   This parameter specifies the ARN of an IAM role that RUM will assume to write to the Evidently experiment that you are sending metrics to. This role must have permission to write to that experiment.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder iamRoleArn(java.lang.String iamRoleArn) {
                this.iamRoleArn = iamRoleArn;
                return this;
            }

            /**
             * Sets the value of {@link MetricDestinationProperty#getMetricDefinitions}
             * @param metricDefinitions An array of structures which define the metrics that you want to send.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder metricDefinitions(software.amazon.awscdk.IResolvable metricDefinitions) {
                this.metricDefinitions = metricDefinitions;
                return this;
            }

            /**
             * Sets the value of {@link MetricDestinationProperty#getMetricDefinitions}
             * @param metricDefinitions An array of structures which define the metrics that you want to send.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder metricDefinitions(java.util.List<? extends java.lang.Object> metricDefinitions) {
                this.metricDefinitions = metricDefinitions;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link MetricDestinationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public MetricDestinationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link MetricDestinationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements MetricDestinationProperty {
            private final java.lang.String destination;
            private final java.lang.String destinationArn;
            private final java.lang.String iamRoleArn;
            private final java.lang.Object metricDefinitions;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.destination = software.amazon.jsii.Kernel.get(this, "destination", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.destinationArn = software.amazon.jsii.Kernel.get(this, "destinationArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.iamRoleArn = software.amazon.jsii.Kernel.get(this, "iamRoleArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.metricDefinitions = software.amazon.jsii.Kernel.get(this, "metricDefinitions", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.destination = java.util.Objects.requireNonNull(builder.destination, "destination is required");
                this.destinationArn = builder.destinationArn;
                this.iamRoleArn = builder.iamRoleArn;
                this.metricDefinitions = builder.metricDefinitions;
            }

            @Override
            public final java.lang.String getDestination() {
                return this.destination;
            }

            @Override
            public final java.lang.String getDestinationArn() {
                return this.destinationArn;
            }

            @Override
            public final java.lang.String getIamRoleArn() {
                return this.iamRoleArn;
            }

            @Override
            public final java.lang.Object getMetricDefinitions() {
                return this.metricDefinitions;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("destination", om.valueToTree(this.getDestination()));
                if (this.getDestinationArn() != null) {
                    data.set("destinationArn", om.valueToTree(this.getDestinationArn()));
                }
                if (this.getIamRoleArn() != null) {
                    data.set("iamRoleArn", om.valueToTree(this.getIamRoleArn()));
                }
                if (this.getMetricDefinitions() != null) {
                    data.set("metricDefinitions", om.valueToTree(this.getMetricDefinitions()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_rum.CfnAppMonitor.MetricDestinationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                MetricDestinationProperty.Jsii$Proxy that = (MetricDestinationProperty.Jsii$Proxy) o;

                if (!destination.equals(that.destination)) return false;
                if (this.destinationArn != null ? !this.destinationArn.equals(that.destinationArn) : that.destinationArn != null) return false;
                if (this.iamRoleArn != null ? !this.iamRoleArn.equals(that.iamRoleArn) : that.iamRoleArn != null) return false;
                return this.metricDefinitions != null ? this.metricDefinitions.equals(that.metricDefinitions) : that.metricDefinitions == null;
            }

            @Override
            public final int hashCode() {
                int result = this.destination.hashCode();
                result = 31 * result + (this.destinationArn != null ? this.destinationArn.hashCode() : 0);
                result = 31 * result + (this.iamRoleArn != null ? this.iamRoleArn.hashCode() : 0);
                result = 31 * result + (this.metricDefinitions != null ? this.metricDefinitions.hashCode() : 0);
                return result;
            }
        }
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.rum.CfnAppMonitor}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.rum.CfnAppMonitor> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope Scope in which this resource is defined. This parameter is required.
         * @param id Construct identifier for this resource (unique in its scope). This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.rum.CfnAppMonitorProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.services.rum.CfnAppMonitorProps.Builder();
        }

        /**
         * The top-level internet domain name for which your application has administrative authority.
         * <p>
         * This parameter is required.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rum-appmonitor.html#cfn-rum-appmonitor-domain">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rum-appmonitor.html#cfn-rum-appmonitor-domain</a>
         * @param domain The top-level internet domain name for which your application has administrative authority. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder domain(final java.lang.String domain) {
            this.props.domain(domain);
            return this;
        }

        /**
         * A name for the app monitor.
         * <p>
         * This parameter is required.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rum-appmonitor.html#cfn-rum-appmonitor-name">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rum-appmonitor.html#cfn-rum-appmonitor-name</a>
         * @param name A name for the app monitor. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder name(final java.lang.String name) {
            this.props.name(name);
            return this;
        }

        /**
         * A structure that contains much of the configuration data for the app monitor.
         * <p>
         * If you are using Amazon Cognito for authorization, you must include this structure in your request, and it must include the ID of the Amazon Cognito identity pool to use for authorization. If you don't include <code>AppMonitorConfiguration</code> , you must set up your own authorization method. For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/CloudWatch-RUM-get-started-authorization.html">Authorize your application to send data to AWS</a> .
         * <p>
         * If you omit this argument, the sample rate used for CloudWatch RUM is set to 10% of the user sessions.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rum-appmonitor.html#cfn-rum-appmonitor-appmonitorconfiguration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rum-appmonitor.html#cfn-rum-appmonitor-appmonitorconfiguration</a>
         * @param appMonitorConfiguration A structure that contains much of the configuration data for the app monitor. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder appMonitorConfiguration(final software.amazon.awscdk.IResolvable appMonitorConfiguration) {
            this.props.appMonitorConfiguration(appMonitorConfiguration);
            return this;
        }
        /**
         * A structure that contains much of the configuration data for the app monitor.
         * <p>
         * If you are using Amazon Cognito for authorization, you must include this structure in your request, and it must include the ID of the Amazon Cognito identity pool to use for authorization. If you don't include <code>AppMonitorConfiguration</code> , you must set up your own authorization method. For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/CloudWatch-RUM-get-started-authorization.html">Authorize your application to send data to AWS</a> .
         * <p>
         * If you omit this argument, the sample rate used for CloudWatch RUM is set to 10% of the user sessions.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rum-appmonitor.html#cfn-rum-appmonitor-appmonitorconfiguration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rum-appmonitor.html#cfn-rum-appmonitor-appmonitorconfiguration</a>
         * @param appMonitorConfiguration A structure that contains much of the configuration data for the app monitor. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder appMonitorConfiguration(final software.amazon.awscdk.services.rum.CfnAppMonitor.AppMonitorConfigurationProperty appMonitorConfiguration) {
            this.props.appMonitorConfiguration(appMonitorConfiguration);
            return this;
        }

        /**
         * Specifies whether this app monitor allows the web client to define and send custom events.
         * <p>
         * If you omit this parameter, custom events are <code>DISABLED</code> .
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rum-appmonitor.html#cfn-rum-appmonitor-customevents">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rum-appmonitor.html#cfn-rum-appmonitor-customevents</a>
         * @param customEvents Specifies whether this app monitor allows the web client to define and send custom events. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder customEvents(final software.amazon.awscdk.IResolvable customEvents) {
            this.props.customEvents(customEvents);
            return this;
        }
        /**
         * Specifies whether this app monitor allows the web client to define and send custom events.
         * <p>
         * If you omit this parameter, custom events are <code>DISABLED</code> .
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rum-appmonitor.html#cfn-rum-appmonitor-customevents">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rum-appmonitor.html#cfn-rum-appmonitor-customevents</a>
         * @param customEvents Specifies whether this app monitor allows the web client to define and send custom events. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder customEvents(final software.amazon.awscdk.services.rum.CfnAppMonitor.CustomEventsProperty customEvents) {
            this.props.customEvents(customEvents);
            return this;
        }

        /**
         * Data collected by CloudWatch RUM is kept by RUM for 30 days and then deleted.
         * <p>
         * This parameter specifies whether CloudWatch RUM sends a copy of this telemetry data to Amazon CloudWatch Logs in your account. This enables you to keep the telemetry data for more than 30 days, but it does incur Amazon CloudWatch Logs charges.
         * <p>
         * If you omit this parameter, the default is <code>false</code> .
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rum-appmonitor.html#cfn-rum-appmonitor-cwlogenabled">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rum-appmonitor.html#cfn-rum-appmonitor-cwlogenabled</a>
         * @param cwLogEnabled Data collected by CloudWatch RUM is kept by RUM for 30 days and then deleted. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder cwLogEnabled(final java.lang.Boolean cwLogEnabled) {
            this.props.cwLogEnabled(cwLogEnabled);
            return this;
        }
        /**
         * Data collected by CloudWatch RUM is kept by RUM for 30 days and then deleted.
         * <p>
         * This parameter specifies whether CloudWatch RUM sends a copy of this telemetry data to Amazon CloudWatch Logs in your account. This enables you to keep the telemetry data for more than 30 days, but it does incur Amazon CloudWatch Logs charges.
         * <p>
         * If you omit this parameter, the default is <code>false</code> .
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rum-appmonitor.html#cfn-rum-appmonitor-cwlogenabled">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rum-appmonitor.html#cfn-rum-appmonitor-cwlogenabled</a>
         * @param cwLogEnabled Data collected by CloudWatch RUM is kept by RUM for 30 days and then deleted. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder cwLogEnabled(final software.amazon.awscdk.IResolvable cwLogEnabled) {
            this.props.cwLogEnabled(cwLogEnabled);
            return this;
        }

        /**
         * Assigns one or more tags (key-value pairs) to the app monitor.
         * <p>
         * Tags can help you organize and categorize your resources. You can also use them to scope user permissions by granting a user permission to access or change only resources with certain tag values.
         * <p>
         * Tags don't have any semantic meaning to AWS and are interpreted strictly as strings of characters.
         * <p>
         * You can associate as many as 50 tags with an app monitor.
         * <p>
         * For more information, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html">Tagging AWS resources</a> .
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rum-appmonitor.html#cfn-rum-appmonitor-tags">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rum-appmonitor.html#cfn-rum-appmonitor-tags</a>
         * @param tags Assigns one or more tags (key-value pairs) to the app monitor. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder tags(final java.util.List<? extends software.amazon.awscdk.CfnTag> tags) {
            this.props.tags(tags);
            return this;
        }

        /**
         * @return a newly built instance of {@link software.amazon.awscdk.services.rum.CfnAppMonitor}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.rum.CfnAppMonitor build() {
            return new software.amazon.awscdk.services.rum.CfnAppMonitor(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
