package software.amazon.awscdk.services.secretsmanager;

/**
 * A secret rotation serverless application.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * Secret myUserSecret;
 * Secret myMasterSecret;
 * IConnectable myDatabase;
 * Vpc myVpc;
 * SecretRotation.Builder.create(this, "SecretRotation")
 *         .application(SecretRotationApplication.MYSQL_ROTATION_MULTI_USER)
 *         .secret(myUserSecret) // The secret that will be rotated
 *         .masterSecret(myMasterSecret) // The secret used for the rotation
 *         .target(myDatabase)
 *         .vpc(myVpc)
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.106.0 (build e852934)", date = "2025-03-12T01:36:45.647Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_secretsmanager.SecretRotationApplication")
public class SecretRotationApplication extends software.amazon.jsii.JsiiObject {

    protected SecretRotationApplication(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected SecretRotationApplication(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        MARIADB_ROTATION_MULTI_USER = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.secretsmanager.SecretRotationApplication.class, "MARIADB_ROTATION_MULTI_USER", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.secretsmanager.SecretRotationApplication.class));
        MARIADB_ROTATION_SINGLE_USER = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.secretsmanager.SecretRotationApplication.class, "MARIADB_ROTATION_SINGLE_USER", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.secretsmanager.SecretRotationApplication.class));
        MONGODB_ROTATION_MULTI_USER = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.secretsmanager.SecretRotationApplication.class, "MONGODB_ROTATION_MULTI_USER", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.secretsmanager.SecretRotationApplication.class));
        MONGODB_ROTATION_SINGLE_USER = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.secretsmanager.SecretRotationApplication.class, "MONGODB_ROTATION_SINGLE_USER", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.secretsmanager.SecretRotationApplication.class));
        MYSQL_ROTATION_MULTI_USER = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.secretsmanager.SecretRotationApplication.class, "MYSQL_ROTATION_MULTI_USER", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.secretsmanager.SecretRotationApplication.class));
        MYSQL_ROTATION_SINGLE_USER = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.secretsmanager.SecretRotationApplication.class, "MYSQL_ROTATION_SINGLE_USER", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.secretsmanager.SecretRotationApplication.class));
        ORACLE_ROTATION_MULTI_USER = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.secretsmanager.SecretRotationApplication.class, "ORACLE_ROTATION_MULTI_USER", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.secretsmanager.SecretRotationApplication.class));
        ORACLE_ROTATION_SINGLE_USER = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.secretsmanager.SecretRotationApplication.class, "ORACLE_ROTATION_SINGLE_USER", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.secretsmanager.SecretRotationApplication.class));
        POSTGRES_ROTATION_MULTI_USER = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.secretsmanager.SecretRotationApplication.class, "POSTGRES_ROTATION_MULTI_USER", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.secretsmanager.SecretRotationApplication.class));
        POSTGRES_ROTATION_SINGLE_USER = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.secretsmanager.SecretRotationApplication.class, "POSTGRES_ROTATION_SINGLE_USER", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.secretsmanager.SecretRotationApplication.class));
        REDSHIFT_ROTATION_MULTI_USER = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.secretsmanager.SecretRotationApplication.class, "REDSHIFT_ROTATION_MULTI_USER", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.secretsmanager.SecretRotationApplication.class));
        REDSHIFT_ROTATION_SINGLE_USER = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.secretsmanager.SecretRotationApplication.class, "REDSHIFT_ROTATION_SINGLE_USER", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.secretsmanager.SecretRotationApplication.class));
        SQLSERVER_ROTATION_MULTI_USER = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.secretsmanager.SecretRotationApplication.class, "SQLSERVER_ROTATION_MULTI_USER", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.secretsmanager.SecretRotationApplication.class));
        SQLSERVER_ROTATION_SINGLE_USER = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.secretsmanager.SecretRotationApplication.class, "SQLSERVER_ROTATION_SINGLE_USER", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.secretsmanager.SecretRotationApplication.class));
    }

    /**
     * @param applicationId This parameter is required.
     * @param semanticVersion This parameter is required.
     * @param options
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public SecretRotationApplication(final @org.jetbrains.annotations.NotNull java.lang.String applicationId, final @org.jetbrains.annotations.NotNull java.lang.String semanticVersion, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.secretsmanager.SecretRotationApplicationOptions options) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(applicationId, "applicationId is required"), java.util.Objects.requireNonNull(semanticVersion, "semanticVersion is required"), options });
    }

    /**
     * @param applicationId This parameter is required.
     * @param semanticVersion This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public SecretRotationApplication(final @org.jetbrains.annotations.NotNull java.lang.String applicationId, final @org.jetbrains.annotations.NotNull java.lang.String semanticVersion) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(applicationId, "applicationId is required"), java.util.Objects.requireNonNull(semanticVersion, "semanticVersion is required") });
    }

    /**
     * Returns the application ARN for the current partition.
     * <p>
     * Can be used in combination with a <code>CfnMapping</code> to automatically select the correct ARN based on the current partition.
     * <p>
     * @param partition This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String applicationArnForPartition(final @org.jetbrains.annotations.NotNull java.lang.String partition) {
        return software.amazon.jsii.Kernel.call(this, "applicationArnForPartition", software.amazon.jsii.NativeType.forClass(java.lang.String.class), new Object[] { java.util.Objects.requireNonNull(partition, "partition is required") });
    }

    /**
     * The semantic version of the app for the current partition.
     * <p>
     * Can be used in combination with a <code>CfnMapping</code> to automatically select the correct version based on the current partition.
     * <p>
     * @param partition This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String semanticVersionForPartition(final @org.jetbrains.annotations.NotNull java.lang.String partition) {
        return software.amazon.jsii.Kernel.call(this, "semanticVersionForPartition", software.amazon.jsii.NativeType.forClass(java.lang.String.class), new Object[] { java.util.Objects.requireNonNull(partition, "partition is required") });
    }

    /**
     * Conducts an AWS SecretsManager secret rotation for RDS MariaDB using the multi user rotation scheme.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.secretsmanager.SecretRotationApplication MARIADB_ROTATION_MULTI_USER;

    /**
     * Conducts an AWS SecretsManager secret rotation for RDS MariaDB using the single user rotation scheme.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.secretsmanager.SecretRotationApplication MARIADB_ROTATION_SINGLE_USER;

    /**
     * Conducts an AWS SecretsManager secret rotation for MongoDB using the multi user rotation scheme.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.secretsmanager.SecretRotationApplication MONGODB_ROTATION_MULTI_USER;

    /**
     * Conducts an AWS SecretsManager secret rotation for MongoDB using the single user rotation scheme.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.secretsmanager.SecretRotationApplication MONGODB_ROTATION_SINGLE_USER;

    /**
     * Conducts an AWS SecretsManager secret rotation for RDS MySQL using the multi user rotation scheme.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.secretsmanager.SecretRotationApplication MYSQL_ROTATION_MULTI_USER;

    /**
     * Conducts an AWS SecretsManager secret rotation for RDS MySQL using the single user rotation scheme.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.secretsmanager.SecretRotationApplication MYSQL_ROTATION_SINGLE_USER;

    /**
     * Conducts an AWS SecretsManager secret rotation for RDS Oracle using the multi user rotation scheme.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.secretsmanager.SecretRotationApplication ORACLE_ROTATION_MULTI_USER;

    /**
     * Conducts an AWS SecretsManager secret rotation for RDS Oracle using the single user rotation scheme.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.secretsmanager.SecretRotationApplication ORACLE_ROTATION_SINGLE_USER;

    /**
     * Conducts an AWS SecretsManager secret rotation for RDS PostgreSQL using the multi user rotation scheme.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.secretsmanager.SecretRotationApplication POSTGRES_ROTATION_MULTI_USER;

    /**
     * Conducts an AWS SecretsManager secret rotation for RDS PostgreSQL using the single user rotation scheme.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.secretsmanager.SecretRotationApplication POSTGRES_ROTATION_SINGLE_USER;

    /**
     * Conducts an AWS SecretsManager secret rotation for Amazon Redshift using the multi user rotation scheme.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.secretsmanager.SecretRotationApplication REDSHIFT_ROTATION_MULTI_USER;

    /**
     * Conducts an AWS SecretsManager secret rotation for Amazon Redshift using the single user rotation scheme.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.secretsmanager.SecretRotationApplication REDSHIFT_ROTATION_SINGLE_USER;

    /**
     * Conducts an AWS SecretsManager secret rotation for RDS SQL Server using the multi user rotation scheme.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.secretsmanager.SecretRotationApplication SQLSERVER_ROTATION_MULTI_USER;

    /**
     * Conducts an AWS SecretsManager secret rotation for RDS SQL Server using the single user rotation scheme.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.secretsmanager.SecretRotationApplication SQLSERVER_ROTATION_SINGLE_USER;

    /**
     * Whether the rotation application uses the mutli user scheme.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Boolean getIsMultiUser() {
        return software.amazon.jsii.Kernel.get(this, "isMultiUser", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.secretsmanager.SecretRotationApplication}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.secretsmanager.SecretRotationApplication> {
        /**
         * @return a new instance of {@link Builder}.
         * @param applicationId This parameter is required.
         * @param semanticVersion This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final java.lang.String applicationId, final java.lang.String semanticVersion) {
            return new Builder(applicationId, semanticVersion);
        }

        private final java.lang.String applicationId;
        private final java.lang.String semanticVersion;
        private software.amazon.awscdk.services.secretsmanager.SecretRotationApplicationOptions.Builder options;

        private Builder(final java.lang.String applicationId, final java.lang.String semanticVersion) {
            this.applicationId = applicationId;
            this.semanticVersion = semanticVersion;
        }

        /**
         * Whether the rotation application uses the mutli user scheme.
         * <p>
         * Default: false
         * <p>
         * @return {@code this}
         * @param isMultiUser Whether the rotation application uses the mutli user scheme. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder isMultiUser(final java.lang.Boolean isMultiUser) {
            this.options().isMultiUser(isMultiUser);
            return this;
        }

        /**
         * @return a newly built instance of {@link software.amazon.awscdk.services.secretsmanager.SecretRotationApplication}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.secretsmanager.SecretRotationApplication build() {
            return new software.amazon.awscdk.services.secretsmanager.SecretRotationApplication(
                this.applicationId,
                this.semanticVersion,
                this.options != null ? this.options.build() : null
            );
        }

        private software.amazon.awscdk.services.secretsmanager.SecretRotationApplicationOptions.Builder options() {
            if (this.options == null) {
                this.options = new software.amazon.awscdk.services.secretsmanager.SecretRotationApplicationOptions.Builder();
            }
            return this.options;
        }
    }
}
