package software.amazon.awscdk.services.securityhub;

/**
 * Properties for defining a <code>CfnInsight</code>.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.securityhub.*;
 * CfnInsightProps cfnInsightProps = CfnInsightProps.builder()
 *         .filters(AwsSecurityFindingFiltersProperty.builder()
 *                 .awsAccountId(List.of(StringFilterProperty.builder()
 *                         .comparison("comparison")
 *                         .value("value")
 *                         .build()))
 *                 .awsAccountName(List.of(StringFilterProperty.builder()
 *                         .comparison("comparison")
 *                         .value("value")
 *                         .build()))
 *                 .companyName(List.of(StringFilterProperty.builder()
 *                         .comparison("comparison")
 *                         .value("value")
 *                         .build()))
 *                 .complianceAssociatedStandardsId(List.of(StringFilterProperty.builder()
 *                         .comparison("comparison")
 *                         .value("value")
 *                         .build()))
 *                 .complianceSecurityControlId(List.of(StringFilterProperty.builder()
 *                         .comparison("comparison")
 *                         .value("value")
 *                         .build()))
 *                 .complianceSecurityControlParametersName(List.of(StringFilterProperty.builder()
 *                         .comparison("comparison")
 *                         .value("value")
 *                         .build()))
 *                 .complianceSecurityControlParametersValue(List.of(StringFilterProperty.builder()
 *                         .comparison("comparison")
 *                         .value("value")
 *                         .build()))
 *                 .complianceStatus(List.of(StringFilterProperty.builder()
 *                         .comparison("comparison")
 *                         .value("value")
 *                         .build()))
 *                 .confidence(List.of(NumberFilterProperty.builder()
 *                         .eq(123)
 *                         .gte(123)
 *                         .lte(123)
 *                         .build()))
 *                 .createdAt(List.of(DateFilterProperty.builder()
 *                         .dateRange(DateRangeProperty.builder()
 *                                 .unit("unit")
 *                                 .value(123)
 *                                 .build())
 *                         .end("end")
 *                         .start("start")
 *                         .build()))
 *                 .criticality(List.of(NumberFilterProperty.builder()
 *                         .eq(123)
 *                         .gte(123)
 *                         .lte(123)
 *                         .build()))
 *                 .description(List.of(StringFilterProperty.builder()
 *                         .comparison("comparison")
 *                         .value("value")
 *                         .build()))
 *                 .findingProviderFieldsConfidence(List.of(NumberFilterProperty.builder()
 *                         .eq(123)
 *                         .gte(123)
 *                         .lte(123)
 *                         .build()))
 *                 .findingProviderFieldsCriticality(List.of(NumberFilterProperty.builder()
 *                         .eq(123)
 *                         .gte(123)
 *                         .lte(123)
 *                         .build()))
 *                 .findingProviderFieldsRelatedFindingsId(List.of(StringFilterProperty.builder()
 *                         .comparison("comparison")
 *                         .value("value")
 *                         .build()))
 *                 .findingProviderFieldsRelatedFindingsProductArn(List.of(StringFilterProperty.builder()
 *                         .comparison("comparison")
 *                         .value("value")
 *                         .build()))
 *                 .findingProviderFieldsSeverityLabel(List.of(StringFilterProperty.builder()
 *                         .comparison("comparison")
 *                         .value("value")
 *                         .build()))
 *                 .findingProviderFieldsSeverityOriginal(List.of(StringFilterProperty.builder()
 *                         .comparison("comparison")
 *                         .value("value")
 *                         .build()))
 *                 .findingProviderFieldsTypes(List.of(StringFilterProperty.builder()
 *                         .comparison("comparison")
 *                         .value("value")
 *                         .build()))
 *                 .firstObservedAt(List.of(DateFilterProperty.builder()
 *                         .dateRange(DateRangeProperty.builder()
 *                                 .unit("unit")
 *                                 .value(123)
 *                                 .build())
 *                         .end("end")
 *                         .start("start")
 *                         .build()))
 *                 .generatorId(List.of(StringFilterProperty.builder()
 *                         .comparison("comparison")
 *                         .value("value")
 *                         .build()))
 *                 .id(List.of(StringFilterProperty.builder()
 *                         .comparison("comparison")
 *                         .value("value")
 *                         .build()))
 *                 .keyword(List.of(KeywordFilterProperty.builder()
 *                         .value("value")
 *                         .build()))
 *                 .lastObservedAt(List.of(DateFilterProperty.builder()
 *                         .dateRange(DateRangeProperty.builder()
 *                                 .unit("unit")
 *                                 .value(123)
 *                                 .build())
 *                         .end("end")
 *                         .start("start")
 *                         .build()))
 *                 .malwareName(List.of(StringFilterProperty.builder()
 *                         .comparison("comparison")
 *                         .value("value")
 *                         .build()))
 *                 .malwarePath(List.of(StringFilterProperty.builder()
 *                         .comparison("comparison")
 *                         .value("value")
 *                         .build()))
 *                 .malwareState(List.of(StringFilterProperty.builder()
 *                         .comparison("comparison")
 *                         .value("value")
 *                         .build()))
 *                 .malwareType(List.of(StringFilterProperty.builder()
 *                         .comparison("comparison")
 *                         .value("value")
 *                         .build()))
 *                 .networkDestinationDomain(List.of(StringFilterProperty.builder()
 *                         .comparison("comparison")
 *                         .value("value")
 *                         .build()))
 *                 .networkDestinationIpV4(List.of(IpFilterProperty.builder()
 *                         .cidr("cidr")
 *                         .build()))
 *                 .networkDestinationIpV6(List.of(IpFilterProperty.builder()
 *                         .cidr("cidr")
 *                         .build()))
 *                 .networkDestinationPort(List.of(NumberFilterProperty.builder()
 *                         .eq(123)
 *                         .gte(123)
 *                         .lte(123)
 *                         .build()))
 *                 .networkDirection(List.of(StringFilterProperty.builder()
 *                         .comparison("comparison")
 *                         .value("value")
 *                         .build()))
 *                 .networkProtocol(List.of(StringFilterProperty.builder()
 *                         .comparison("comparison")
 *                         .value("value")
 *                         .build()))
 *                 .networkSourceDomain(List.of(StringFilterProperty.builder()
 *                         .comparison("comparison")
 *                         .value("value")
 *                         .build()))
 *                 .networkSourceIpV4(List.of(IpFilterProperty.builder()
 *                         .cidr("cidr")
 *                         .build()))
 *                 .networkSourceIpV6(List.of(IpFilterProperty.builder()
 *                         .cidr("cidr")
 *                         .build()))
 *                 .networkSourceMac(List.of(StringFilterProperty.builder()
 *                         .comparison("comparison")
 *                         .value("value")
 *                         .build()))
 *                 .networkSourcePort(List.of(NumberFilterProperty.builder()
 *                         .eq(123)
 *                         .gte(123)
 *                         .lte(123)
 *                         .build()))
 *                 .noteText(List.of(StringFilterProperty.builder()
 *                         .comparison("comparison")
 *                         .value("value")
 *                         .build()))
 *                 .noteUpdatedAt(List.of(DateFilterProperty.builder()
 *                         .dateRange(DateRangeProperty.builder()
 *                                 .unit("unit")
 *                                 .value(123)
 *                                 .build())
 *                         .end("end")
 *                         .start("start")
 *                         .build()))
 *                 .noteUpdatedBy(List.of(StringFilterProperty.builder()
 *                         .comparison("comparison")
 *                         .value("value")
 *                         .build()))
 *                 .processLaunchedAt(List.of(DateFilterProperty.builder()
 *                         .dateRange(DateRangeProperty.builder()
 *                                 .unit("unit")
 *                                 .value(123)
 *                                 .build())
 *                         .end("end")
 *                         .start("start")
 *                         .build()))
 *                 .processName(List.of(StringFilterProperty.builder()
 *                         .comparison("comparison")
 *                         .value("value")
 *                         .build()))
 *                 .processParentPid(List.of(NumberFilterProperty.builder()
 *                         .eq(123)
 *                         .gte(123)
 *                         .lte(123)
 *                         .build()))
 *                 .processPath(List.of(StringFilterProperty.builder()
 *                         .comparison("comparison")
 *                         .value("value")
 *                         .build()))
 *                 .processPid(List.of(NumberFilterProperty.builder()
 *                         .eq(123)
 *                         .gte(123)
 *                         .lte(123)
 *                         .build()))
 *                 .processTerminatedAt(List.of(DateFilterProperty.builder()
 *                         .dateRange(DateRangeProperty.builder()
 *                                 .unit("unit")
 *                                 .value(123)
 *                                 .build())
 *                         .end("end")
 *                         .start("start")
 *                         .build()))
 *                 .productArn(List.of(StringFilterProperty.builder()
 *                         .comparison("comparison")
 *                         .value("value")
 *                         .build()))
 *                 .productFields(List.of(MapFilterProperty.builder()
 *                         .comparison("comparison")
 *                         .key("key")
 *                         .value("value")
 *                         .build()))
 *                 .productName(List.of(StringFilterProperty.builder()
 *                         .comparison("comparison")
 *                         .value("value")
 *                         .build()))
 *                 .recommendationText(List.of(StringFilterProperty.builder()
 *                         .comparison("comparison")
 *                         .value("value")
 *                         .build()))
 *                 .recordState(List.of(StringFilterProperty.builder()
 *                         .comparison("comparison")
 *                         .value("value")
 *                         .build()))
 *                 .region(List.of(StringFilterProperty.builder()
 *                         .comparison("comparison")
 *                         .value("value")
 *                         .build()))
 *                 .relatedFindingsId(List.of(StringFilterProperty.builder()
 *                         .comparison("comparison")
 *                         .value("value")
 *                         .build()))
 *                 .relatedFindingsProductArn(List.of(StringFilterProperty.builder()
 *                         .comparison("comparison")
 *                         .value("value")
 *                         .build()))
 *                 .resourceApplicationArn(List.of(StringFilterProperty.builder()
 *                         .comparison("comparison")
 *                         .value("value")
 *                         .build()))
 *                 .resourceApplicationName(List.of(StringFilterProperty.builder()
 *                         .comparison("comparison")
 *                         .value("value")
 *                         .build()))
 *                 .resourceAwsEc2InstanceIamInstanceProfileArn(List.of(StringFilterProperty.builder()
 *                         .comparison("comparison")
 *                         .value("value")
 *                         .build()))
 *                 .resourceAwsEc2InstanceImageId(List.of(StringFilterProperty.builder()
 *                         .comparison("comparison")
 *                         .value("value")
 *                         .build()))
 *                 .resourceAwsEc2InstanceIpV4Addresses(List.of(IpFilterProperty.builder()
 *                         .cidr("cidr")
 *                         .build()))
 *                 .resourceAwsEc2InstanceIpV6Addresses(List.of(IpFilterProperty.builder()
 *                         .cidr("cidr")
 *                         .build()))
 *                 .resourceAwsEc2InstanceKeyName(List.of(StringFilterProperty.builder()
 *                         .comparison("comparison")
 *                         .value("value")
 *                         .build()))
 *                 .resourceAwsEc2InstanceLaunchedAt(List.of(DateFilterProperty.builder()
 *                         .dateRange(DateRangeProperty.builder()
 *                                 .unit("unit")
 *                                 .value(123)
 *                                 .build())
 *                         .end("end")
 *                         .start("start")
 *                         .build()))
 *                 .resourceAwsEc2InstanceSubnetId(List.of(StringFilterProperty.builder()
 *                         .comparison("comparison")
 *                         .value("value")
 *                         .build()))
 *                 .resourceAwsEc2InstanceType(List.of(StringFilterProperty.builder()
 *                         .comparison("comparison")
 *                         .value("value")
 *                         .build()))
 *                 .resourceAwsEc2InstanceVpcId(List.of(StringFilterProperty.builder()
 *                         .comparison("comparison")
 *                         .value("value")
 *                         .build()))
 *                 .resourceAwsIamAccessKeyCreatedAt(List.of(DateFilterProperty.builder()
 *                         .dateRange(DateRangeProperty.builder()
 *                                 .unit("unit")
 *                                 .value(123)
 *                                 .build())
 *                         .end("end")
 *                         .start("start")
 *                         .build()))
 *                 .resourceAwsIamAccessKeyPrincipalName(List.of(StringFilterProperty.builder()
 *                         .comparison("comparison")
 *                         .value("value")
 *                         .build()))
 *                 .resourceAwsIamAccessKeyStatus(List.of(StringFilterProperty.builder()
 *                         .comparison("comparison")
 *                         .value("value")
 *                         .build()))
 *                 .resourceAwsIamAccessKeyUserName(List.of(StringFilterProperty.builder()
 *                         .comparison("comparison")
 *                         .value("value")
 *                         .build()))
 *                 .resourceAwsIamUserUserName(List.of(StringFilterProperty.builder()
 *                         .comparison("comparison")
 *                         .value("value")
 *                         .build()))
 *                 .resourceAwsS3BucketOwnerId(List.of(StringFilterProperty.builder()
 *                         .comparison("comparison")
 *                         .value("value")
 *                         .build()))
 *                 .resourceAwsS3BucketOwnerName(List.of(StringFilterProperty.builder()
 *                         .comparison("comparison")
 *                         .value("value")
 *                         .build()))
 *                 .resourceContainerImageId(List.of(StringFilterProperty.builder()
 *                         .comparison("comparison")
 *                         .value("value")
 *                         .build()))
 *                 .resourceContainerImageName(List.of(StringFilterProperty.builder()
 *                         .comparison("comparison")
 *                         .value("value")
 *                         .build()))
 *                 .resourceContainerLaunchedAt(List.of(DateFilterProperty.builder()
 *                         .dateRange(DateRangeProperty.builder()
 *                                 .unit("unit")
 *                                 .value(123)
 *                                 .build())
 *                         .end("end")
 *                         .start("start")
 *                         .build()))
 *                 .resourceContainerName(List.of(StringFilterProperty.builder()
 *                         .comparison("comparison")
 *                         .value("value")
 *                         .build()))
 *                 .resourceDetailsOther(List.of(MapFilterProperty.builder()
 *                         .comparison("comparison")
 *                         .key("key")
 *                         .value("value")
 *                         .build()))
 *                 .resourceId(List.of(StringFilterProperty.builder()
 *                         .comparison("comparison")
 *                         .value("value")
 *                         .build()))
 *                 .resourcePartition(List.of(StringFilterProperty.builder()
 *                         .comparison("comparison")
 *                         .value("value")
 *                         .build()))
 *                 .resourceRegion(List.of(StringFilterProperty.builder()
 *                         .comparison("comparison")
 *                         .value("value")
 *                         .build()))
 *                 .resourceTags(List.of(MapFilterProperty.builder()
 *                         .comparison("comparison")
 *                         .key("key")
 *                         .value("value")
 *                         .build()))
 *                 .resourceType(List.of(StringFilterProperty.builder()
 *                         .comparison("comparison")
 *                         .value("value")
 *                         .build()))
 *                 .sample(List.of(BooleanFilterProperty.builder()
 *                         .value(false)
 *                         .build()))
 *                 .severityLabel(List.of(StringFilterProperty.builder()
 *                         .comparison("comparison")
 *                         .value("value")
 *                         .build()))
 *                 .severityNormalized(List.of(NumberFilterProperty.builder()
 *                         .eq(123)
 *                         .gte(123)
 *                         .lte(123)
 *                         .build()))
 *                 .severityProduct(List.of(NumberFilterProperty.builder()
 *                         .eq(123)
 *                         .gte(123)
 *                         .lte(123)
 *                         .build()))
 *                 .sourceUrl(List.of(StringFilterProperty.builder()
 *                         .comparison("comparison")
 *                         .value("value")
 *                         .build()))
 *                 .threatIntelIndicatorCategory(List.of(StringFilterProperty.builder()
 *                         .comparison("comparison")
 *                         .value("value")
 *                         .build()))
 *                 .threatIntelIndicatorLastObservedAt(List.of(DateFilterProperty.builder()
 *                         .dateRange(DateRangeProperty.builder()
 *                                 .unit("unit")
 *                                 .value(123)
 *                                 .build())
 *                         .end("end")
 *                         .start("start")
 *                         .build()))
 *                 .threatIntelIndicatorSource(List.of(StringFilterProperty.builder()
 *                         .comparison("comparison")
 *                         .value("value")
 *                         .build()))
 *                 .threatIntelIndicatorSourceUrl(List.of(StringFilterProperty.builder()
 *                         .comparison("comparison")
 *                         .value("value")
 *                         .build()))
 *                 .threatIntelIndicatorType(List.of(StringFilterProperty.builder()
 *                         .comparison("comparison")
 *                         .value("value")
 *                         .build()))
 *                 .threatIntelIndicatorValue(List.of(StringFilterProperty.builder()
 *                         .comparison("comparison")
 *                         .value("value")
 *                         .build()))
 *                 .title(List.of(StringFilterProperty.builder()
 *                         .comparison("comparison")
 *                         .value("value")
 *                         .build()))
 *                 .type(List.of(StringFilterProperty.builder()
 *                         .comparison("comparison")
 *                         .value("value")
 *                         .build()))
 *                 .updatedAt(List.of(DateFilterProperty.builder()
 *                         .dateRange(DateRangeProperty.builder()
 *                                 .unit("unit")
 *                                 .value(123)
 *                                 .build())
 *                         .end("end")
 *                         .start("start")
 *                         .build()))
 *                 .userDefinedFields(List.of(MapFilterProperty.builder()
 *                         .comparison("comparison")
 *                         .key("key")
 *                         .value("value")
 *                         .build()))
 *                 .verificationState(List.of(StringFilterProperty.builder()
 *                         .comparison("comparison")
 *                         .value("value")
 *                         .build()))
 *                 .vulnerabilitiesExploitAvailable(List.of(StringFilterProperty.builder()
 *                         .comparison("comparison")
 *                         .value("value")
 *                         .build()))
 *                 .vulnerabilitiesFixAvailable(List.of(StringFilterProperty.builder()
 *                         .comparison("comparison")
 *                         .value("value")
 *                         .build()))
 *                 .workflowState(List.of(StringFilterProperty.builder()
 *                         .comparison("comparison")
 *                         .value("value")
 *                         .build()))
 *                 .workflowStatus(List.of(StringFilterProperty.builder()
 *                         .comparison("comparison")
 *                         .value("value")
 *                         .build()))
 *                 .build())
 *         .groupByAttribute("groupByAttribute")
 *         .name("name")
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-securityhub-insight.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-securityhub-insight.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.106.0 (build e852934)", date = "2025-03-12T01:36:45.724Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_securityhub.CfnInsightProps")
@software.amazon.jsii.Jsii.Proxy(CfnInsightProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnInsightProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * One or more attributes used to filter the findings included in the insight.
     * <p>
     * The insight only includes findings that match the criteria defined in the filters. You can filter by up to ten finding attributes. For each attribute, you can provide up to 20 filter values.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-securityhub-insight.html#cfn-securityhub-insight-filters">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-securityhub-insight.html#cfn-securityhub-insight-filters</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.Object getFilters();

    /**
     * The grouping attribute for the insight's findings.
     * <p>
     * Indicates how to group the matching findings, and identifies the type of item that the insight applies to. For example, if an insight is grouped by resource identifier, then the insight produces a list of resource identifiers.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-securityhub-insight.html#cfn-securityhub-insight-groupbyattribute">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-securityhub-insight.html#cfn-securityhub-insight-groupbyattribute</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getGroupByAttribute();

    /**
     * The name of a Security Hub insight.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-securityhub-insight.html#cfn-securityhub-insight-name">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-securityhub-insight.html#cfn-securityhub-insight-name</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getName();

    /**
     * @return a {@link Builder} of {@link CfnInsightProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnInsightProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnInsightProps> {
        java.lang.Object filters;
        java.lang.String groupByAttribute;
        java.lang.String name;

        /**
         * Sets the value of {@link CfnInsightProps#getFilters}
         * @param filters One or more attributes used to filter the findings included in the insight. This parameter is required.
         *                The insight only includes findings that match the criteria defined in the filters. You can filter by up to ten finding attributes. For each attribute, you can provide up to 20 filter values.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder filters(software.amazon.awscdk.IResolvable filters) {
            this.filters = filters;
            return this;
        }

        /**
         * Sets the value of {@link CfnInsightProps#getFilters}
         * @param filters One or more attributes used to filter the findings included in the insight. This parameter is required.
         *                The insight only includes findings that match the criteria defined in the filters. You can filter by up to ten finding attributes. For each attribute, you can provide up to 20 filter values.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder filters(software.amazon.awscdk.services.securityhub.CfnInsight.AwsSecurityFindingFiltersProperty filters) {
            this.filters = filters;
            return this;
        }

        /**
         * Sets the value of {@link CfnInsightProps#getGroupByAttribute}
         * @param groupByAttribute The grouping attribute for the insight's findings. This parameter is required.
         *                         Indicates how to group the matching findings, and identifies the type of item that the insight applies to. For example, if an insight is grouped by resource identifier, then the insight produces a list of resource identifiers.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder groupByAttribute(java.lang.String groupByAttribute) {
            this.groupByAttribute = groupByAttribute;
            return this;
        }

        /**
         * Sets the value of {@link CfnInsightProps#getName}
         * @param name The name of a Security Hub insight. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder name(java.lang.String name) {
            this.name = name;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnInsightProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnInsightProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnInsightProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnInsightProps {
        private final java.lang.Object filters;
        private final java.lang.String groupByAttribute;
        private final java.lang.String name;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.filters = software.amazon.jsii.Kernel.get(this, "filters", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.groupByAttribute = software.amazon.jsii.Kernel.get(this, "groupByAttribute", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.name = software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.filters = java.util.Objects.requireNonNull(builder.filters, "filters is required");
            this.groupByAttribute = java.util.Objects.requireNonNull(builder.groupByAttribute, "groupByAttribute is required");
            this.name = java.util.Objects.requireNonNull(builder.name, "name is required");
        }

        @Override
        public final java.lang.Object getFilters() {
            return this.filters;
        }

        @Override
        public final java.lang.String getGroupByAttribute() {
            return this.groupByAttribute;
        }

        @Override
        public final java.lang.String getName() {
            return this.name;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("filters", om.valueToTree(this.getFilters()));
            data.set("groupByAttribute", om.valueToTree(this.getGroupByAttribute()));
            data.set("name", om.valueToTree(this.getName()));

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_securityhub.CfnInsightProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnInsightProps.Jsii$Proxy that = (CfnInsightProps.Jsii$Proxy) o;

            if (!filters.equals(that.filters)) return false;
            if (!groupByAttribute.equals(that.groupByAttribute)) return false;
            return this.name.equals(that.name);
        }

        @Override
        public final int hashCode() {
            int result = this.filters.hashCode();
            result = 31 * result + (this.groupByAttribute.hashCode());
            result = 31 * result + (this.name.hashCode());
            return result;
        }
    }
}
