package software.amazon.awscdk.services.servicediscovery;

/**
 * A complex type that contains information about an instance that AWS Cloud Map creates when you submit a <code>RegisterInstance</code> request.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.servicediscovery.*;
 * Object instanceAttributes;
 * CfnInstance cfnInstance = CfnInstance.Builder.create(this, "MyCfnInstance")
 *         .instanceAttributes(instanceAttributes)
 *         .serviceId("serviceId")
 *         // the properties below are optional
 *         .instanceId("instanceId")
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-servicediscovery-instance.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-servicediscovery-instance.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.106.0 (build e852934)", date = "2025-03-12T01:36:45.842Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_servicediscovery.CfnInstance")
public class CfnInstance extends software.amazon.awscdk.CfnResource implements software.amazon.awscdk.IInspectable {

    protected CfnInstance(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnInstance(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        CFN_RESOURCE_TYPE_NAME = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.servicediscovery.CfnInstance.class, "CFN_RESOURCE_TYPE_NAME", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * @param scope Scope in which this resource is defined. This parameter is required.
     * @param id Construct identifier for this resource (unique in its scope). This parameter is required.
     * @param props Resource properties. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public CfnInstance(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.servicediscovery.CfnInstanceProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Examines the CloudFormation resource and discloses attributes.
     * <p>
     * @param inspector tree inspector to collect and process attributes. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public void inspect(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.TreeInspector inspector) {
        software.amazon.jsii.Kernel.call(this, "inspect", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(inspector, "inspector is required") });
    }

    /**
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> renderProperties(final @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> props) {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.call(this, "renderProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class)), new Object[] { java.util.Objects.requireNonNull(props, "props is required") }));
    }

    /**
     * The CloudFormation resource type name for this resource class.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String CFN_RESOURCE_TYPE_NAME;

    /**
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> getCfnProperties() {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.get(this, "cfnProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class))));
    }

    /**
     * A string map that contains the following information for the service that you specify in <code>ServiceId</code> :.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.Object getInstanceAttributes() {
        return software.amazon.jsii.Kernel.get(this, "instanceAttributes", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * A string map that contains the following information for the service that you specify in <code>ServiceId</code> :.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setInstanceAttributes(final @org.jetbrains.annotations.NotNull java.lang.Object value) {
        software.amazon.jsii.Kernel.set(this, "instanceAttributes", java.util.Objects.requireNonNull(value, "instanceAttributes is required"));
    }

    /**
     * The ID of the service that you want to use for settings for the instance.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getServiceId() {
        return software.amazon.jsii.Kernel.get(this, "serviceId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The ID of the service that you want to use for settings for the instance.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setServiceId(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "serviceId", java.util.Objects.requireNonNull(value, "serviceId is required"));
    }

    /**
     * An identifier that you want to associate with the instance.
     * <p>
     * Note the following:.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getInstanceId() {
        return software.amazon.jsii.Kernel.get(this, "instanceId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * An identifier that you want to associate with the instance.
     * <p>
     * Note the following:.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setInstanceId(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "instanceId", value);
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.servicediscovery.CfnInstance}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.servicediscovery.CfnInstance> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope Scope in which this resource is defined. This parameter is required.
         * @param id Construct identifier for this resource (unique in its scope). This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.servicediscovery.CfnInstanceProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.services.servicediscovery.CfnInstanceProps.Builder();
        }

        /**
         * A string map that contains the following information for the service that you specify in <code>ServiceId</code> :.
         * <p>
         * <ul>
         * <li>The attributes that apply to the records that are defined in the service.</li>
         * <li>For each attribute, the applicable value.</li>
         * </ul>
         * <p>
         * Supported attribute keys include the following:
         * <p>
         * <ul>
         * <li><strong>AWS_ALIAS_DNS_NAME</strong> - If you want AWS Cloud Map to create a Route 53 alias record that routes traffic to an Elastic Load Balancing load balancer, specify the DNS name that is associated with the load balancer. For information about how to get the DNS name, see <a href="https://docs.aws.amazon.com/Route53/latest/APIReference/API_AliasTarget.html#Route53-Type-AliasTarget-DNSName">AliasTarget-&gt;DNSName</a> in the <em>Route 53 API Reference</em> .</li>
         * </ul>
         * <p>
         * Note the following:
         * <p>
         * <ul>
         * <li>The configuration for the service that is specified by <code>ServiceId</code> must include settings for an <code>A</code> record, an <code>AAAA</code> record, or both.</li>
         * <li>In the service that is specified by <code>ServiceId</code> , the value of <code>RoutingPolicy</code> must be <code>WEIGHTED</code> .</li>
         * <li>If the service that is specified by <code>ServiceId</code> includes <code>HealthCheckConfig</code> settings, AWS Cloud Map will create the health check, but it won't associate the health check with the alias record.</li>
         * <li>Auto naming currently doesn't support creating alias records that route traffic to AWS resources other than ELB load balancers.</li>
         * <li>If you specify a value for <code>AWS_ALIAS_DNS_NAME</code> , don't specify values for any of the <code>AWS_INSTANCE</code> attributes.</li>
         * <li><strong>AWS_EC2_INSTANCE_ID</strong> - <em>HTTP namespaces only.</em> The Amazon EC2 instance ID for the instance. The <code>AWS_INSTANCE_IPV4</code> attribute contains the primary private IPv4 address. When creating resources with a type of <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-servicediscovery-instance.html">AWS::ServiceDiscovery::Instance</a> , if the <code>AWS_EC2_INSTANCE_ID</code> attribute is specified, the only other attribute that can be specified is <code>AWS_INIT_HEALTH_STATUS</code> . After the resource has been created, the <code>AWS_INSTANCE_IPV4</code> attribute contains the primary private IPv4 address.</li>
         * <li><strong>AWS_INIT_HEALTH_STATUS</strong> - If the service configuration includes <code>HealthCheckCustomConfig</code> , when creating resources with a type of <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-servicediscovery-instance.html">AWS::ServiceDiscovery::Instance</a> you can optionally use <code>AWS_INIT_HEALTH_STATUS</code> to specify the initial status of the custom health check, <code>HEALTHY</code> or <code>UNHEALTHY</code> . If you don't specify a value for <code>AWS_INIT_HEALTH_STATUS</code> , the initial status is <code>HEALTHY</code> . This attribute can only be used when creating resources and will not be seen on existing resources.</li>
         * <li><strong>AWS_INSTANCE_CNAME</strong> - If the service configuration includes a <code>CNAME</code> record, the domain name that you want Route 53 to return in response to DNS queries, for example, <code>example.com</code> .</li>
         * </ul>
         * <p>
         * This value is required if the service specified by <code>ServiceId</code> includes settings for an <code>CNAME</code> record.
         * <p>
         * <ul>
         * <li><strong>AWS_INSTANCE_IPV4</strong> - If the service configuration includes an <code>A</code> record, the IPv4 address that you want Route 53 to return in response to DNS queries, for example, <code>192.0.2.44</code> .</li>
         * </ul>
         * <p>
         * This value is required if the service specified by <code>ServiceId</code> includes settings for an <code>A</code> record. If the service includes settings for an <code>SRV</code> record, you must specify a value for <code>AWS_INSTANCE_IPV4</code> , <code>AWS_INSTANCE_IPV6</code> , or both.
         * <p>
         * <ul>
         * <li><strong>AWS_INSTANCE_IPV6</strong> - If the service configuration includes an <code>AAAA</code> record, the IPv6 address that you want Route 53 to return in response to DNS queries, for example, <code>2001:0db8:85a3:0000:0000:abcd:0001:2345</code> .</li>
         * </ul>
         * <p>
         * This value is required if the service specified by <code>ServiceId</code> includes settings for an <code>AAAA</code> record. If the service includes settings for an <code>SRV</code> record, you must specify a value for <code>AWS_INSTANCE_IPV4</code> , <code>AWS_INSTANCE_IPV6</code> , or both.
         * <p>
         * <ul>
         * <li><strong>AWS_INSTANCE_PORT</strong> - If the service includes an <code>SRV</code> record, the value that you want Route 53 to return for the port.</li>
         * </ul>
         * <p>
         * If the service includes <code>HealthCheckConfig</code> , the port on the endpoint that you want Route 53 to send requests to.
         * <p>
         * This value is required if you specified settings for an <code>SRV</code> record or a Route 53 health check when you created the service.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-servicediscovery-instance.html#cfn-servicediscovery-instance-instanceattributes">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-servicediscovery-instance.html#cfn-servicediscovery-instance-instanceattributes</a>
         * @param instanceAttributes A string map that contains the following information for the service that you specify in <code>ServiceId</code> :. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder instanceAttributes(final java.lang.Object instanceAttributes) {
            this.props.instanceAttributes(instanceAttributes);
            return this;
        }

        /**
         * The ID of the service that you want to use for settings for the instance.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-servicediscovery-instance.html#cfn-servicediscovery-instance-serviceid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-servicediscovery-instance.html#cfn-servicediscovery-instance-serviceid</a>
         * @param serviceId The ID of the service that you want to use for settings for the instance. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder serviceId(final java.lang.String serviceId) {
            this.props.serviceId(serviceId);
            return this;
        }

        /**
         * An identifier that you want to associate with the instance. Note the following:.
         * <p>
         * <ul>
         * <li>If the service that's specified by <code>ServiceId</code> includes settings for an <code>SRV</code> record, the value of <code>InstanceId</code> is automatically included as part of the value for the <code>SRV</code> record. For more information, see <a href="https://docs.aws.amazon.com/cloud-map/latest/api/API_DnsRecord.html#cloudmap-Type-DnsRecord-Type">DnsRecord &gt; Type</a> .</li>
         * <li>You can use this value to update an existing instance.</li>
         * <li>To register a new instance, you must specify a value that's unique among instances that you register by using the same service.</li>
         * <li>If you specify an existing <code>InstanceId</code> and <code>ServiceId</code> , AWS Cloud Map updates the existing DNS records, if any. If there's also an existing health check, AWS Cloud Map deletes the old health check and creates a new one.</li>
         * </ul>
         * <p>
         * <blockquote>
         * <p>
         * The health check isn't deleted immediately, so it will still appear for a while if you submit a <code>ListHealthChecks</code> request, for example.
         * <p>
         * </blockquote><blockquote>
         * <p>
         * Do not include sensitive information in <code>InstanceId</code> if the namespace is discoverable by public DNS queries and any <code>Type</code> member of <code>DnsRecord</code> for the service contains <code>SRV</code> because the <code>InstanceId</code> is discoverable by public DNS queries.
         * <p>
         * </blockquote>
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-servicediscovery-instance.html#cfn-servicediscovery-instance-instanceid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-servicediscovery-instance.html#cfn-servicediscovery-instance-instanceid</a>
         * @param instanceId An identifier that you want to associate with the instance. Note the following:. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder instanceId(final java.lang.String instanceId) {
            this.props.instanceId(instanceId);
            return this;
        }

        /**
         * @return a newly built instance of {@link software.amazon.awscdk.services.servicediscovery.CfnInstance}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.servicediscovery.CfnInstance build() {
            return new software.amazon.awscdk.services.servicediscovery.CfnInstance(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
