package software.amazon.awscdk.services.servicediscovery;

/**
 * Define a Public DNS Namespace.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * import software.amazon.awscdk.*;
 * import software.amazon.awscdk.*;
 * App app = new App();
 * Stack stack = new Stack(app, "aws-servicediscovery-integ");
 * PublicDnsNamespace namespace = PublicDnsNamespace.Builder.create(stack, "Namespace")
 *         .name("foobar.com")
 *         .build();
 * Service service = namespace.createService("Service", DnsServiceProps.builder()
 *         .name("foo")
 *         .dnsRecordType(DnsRecordType.A)
 *         .dnsTtl(Duration.seconds(30))
 *         .healthCheck(HealthCheckConfig.builder()
 *                 .type(HealthCheckType.HTTPS)
 *                 .resourcePath("/healthcheck")
 *                 .failureThreshold(2)
 *                 .build())
 *         .build());
 * service.registerIpInstance("IpInstance", IpInstanceBaseProps.builder()
 *         .ipv4("54.239.25.192")
 *         .port(443)
 *         .build());
 * app.synth();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.106.0 (build e852934)", date = "2025-03-12T01:36:45.885Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_servicediscovery.PublicDnsNamespace")
public class PublicDnsNamespace extends software.amazon.awscdk.Resource implements software.amazon.awscdk.services.servicediscovery.IPublicDnsNamespace {

    protected PublicDnsNamespace(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected PublicDnsNamespace(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * @param scope This parameter is required.
     * @param id This parameter is required.
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public PublicDnsNamespace(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.servicediscovery.PublicDnsNamespaceProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * @param scope This parameter is required.
     * @param id This parameter is required.
     * @param attrs This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.servicediscovery.IPublicDnsNamespace fromPublicDnsNamespaceAttributes(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.servicediscovery.PublicDnsNamespaceAttributes attrs) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.servicediscovery.PublicDnsNamespace.class, "fromPublicDnsNamespaceAttributes", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.servicediscovery.IPublicDnsNamespace.class), new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(attrs, "attrs is required") });
    }

    /**
     * Creates a service within the namespace.
     * <p>
     * @param id This parameter is required.
     * @param props
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.servicediscovery.Service createService(final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.servicediscovery.DnsServiceProps props) {
        return software.amazon.jsii.Kernel.call(this, "createService", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.servicediscovery.Service.class), new Object[] { java.util.Objects.requireNonNull(id, "id is required"), props });
    }

    /**
     * Creates a service within the namespace.
     * <p>
     * @param id This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.servicediscovery.Service createService(final @org.jetbrains.annotations.NotNull java.lang.String id) {
        return software.amazon.jsii.Kernel.call(this, "createService", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.servicediscovery.Service.class), new Object[] { java.util.Objects.requireNonNull(id, "id is required") });
    }

    /**
     * Namespace Arn for the namespace.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getNamespaceArn() {
        return software.amazon.jsii.Kernel.get(this, "namespaceArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * ID of hosted zone created by namespace.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getNamespaceHostedZoneId() {
        return software.amazon.jsii.Kernel.get(this, "namespaceHostedZoneId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Namespace Id for the namespace.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getNamespaceId() {
        return software.amazon.jsii.Kernel.get(this, "namespaceId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * A name for the namespace.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getNamespaceName() {
        return software.amazon.jsii.Kernel.get(this, "namespaceName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getPublicDnsNamespaceArn() {
        return software.amazon.jsii.Kernel.get(this, "publicDnsNamespaceArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getPublicDnsNamespaceId() {
        return software.amazon.jsii.Kernel.get(this, "publicDnsNamespaceId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getPublicDnsNamespaceName() {
        return software.amazon.jsii.Kernel.get(this, "publicDnsNamespaceName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Type of the namespace.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.servicediscovery.NamespaceType getType() {
        return software.amazon.jsii.Kernel.get(this, "type", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.servicediscovery.NamespaceType.class));
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.servicediscovery.PublicDnsNamespace}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.servicediscovery.PublicDnsNamespace> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope This parameter is required.
         * @param id This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.servicediscovery.PublicDnsNamespaceProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.services.servicediscovery.PublicDnsNamespaceProps.Builder();
        }

        /**
         * A name for the Namespace.
         * <p>
         * @return {@code this}
         * @param name A name for the Namespace. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder name(final java.lang.String name) {
            this.props.name(name);
            return this;
        }

        /**
         * A description of the Namespace.
         * <p>
         * Default: none
         * <p>
         * @return {@code this}
         * @param description A description of the Namespace. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder description(final java.lang.String description) {
            this.props.description(description);
            return this;
        }

        /**
         * @return a newly built instance of {@link software.amazon.awscdk.services.servicediscovery.PublicDnsNamespace}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.servicediscovery.PublicDnsNamespace build() {
            return new software.amazon.awscdk.services.servicediscovery.PublicDnsNamespace(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
