package software.amazon.awscdk.services.ses;

/**
 * Configuration sets let you create groups of rules that you can apply to the emails you send using Amazon SES.
 * <p>
 * For more information about using configuration sets, see <a href="https://docs.aws.amazon.com/ses/latest/dg/using-configuration-sets.html">Using Amazon SES Configuration Sets</a> in the <a href="https://docs.aws.amazon.com/ses/latest/dg/">Amazon SES Developer Guide</a> .
 * <p>
 * <blockquote>
 * <p>
 * <em>Required permissions:</em>
 * <p>
 * To apply any of the resource options, you will need to have the corresponding AWS Identity and Access Management (IAM) SES API v2 permissions:
 * <p>
 * <ul>
 * <li><code>ses:GetConfigurationSet</code></li>
 * <li>(This permission is replacing the v1 <em>ses:DescribeConfigurationSet</em> permission which will not work with these v2 resource options.)</li>
 * <li><code>ses:PutConfigurationSetDeliveryOptions</code></li>
 * <li><code>ses:PutConfigurationSetReputationOptions</code></li>
 * <li><code>ses:PutConfigurationSetSendingOptions</code></li>
 * <li><code>ses:PutConfigurationSetSuppressionOptions</code></li>
 * <li><code>ses:PutConfigurationSetTrackingOptions</code></li>
 * </ul>
 * <p>
 * </blockquote>
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.ses.*;
 * CfnConfigurationSet cfnConfigurationSet = CfnConfigurationSet.Builder.create(this, "MyCfnConfigurationSet")
 *         .deliveryOptions(DeliveryOptionsProperty.builder()
 *                 .maxDeliverySeconds(123)
 *                 .sendingPoolName("sendingPoolName")
 *                 .tlsPolicy("tlsPolicy")
 *                 .build())
 *         .name("name")
 *         .reputationOptions(ReputationOptionsProperty.builder()
 *                 .reputationMetricsEnabled(false)
 *                 .build())
 *         .sendingOptions(SendingOptionsProperty.builder()
 *                 .sendingEnabled(false)
 *                 .build())
 *         .suppressionOptions(SuppressionOptionsProperty.builder()
 *                 .suppressedReasons(List.of("suppressedReasons"))
 *                 .build())
 *         .trackingOptions(TrackingOptionsProperty.builder()
 *                 .customRedirectDomain("customRedirectDomain")
 *                 .httpsPolicy("httpsPolicy")
 *                 .build())
 *         .vdmOptions(VdmOptionsProperty.builder()
 *                 .dashboardOptions(DashboardOptionsProperty.builder()
 *                         .engagementMetrics("engagementMetrics")
 *                         .build())
 *                 .guardianOptions(GuardianOptionsProperty.builder()
 *                         .optimizedSharedDelivery("optimizedSharedDelivery")
 *                         .build())
 *                 .build())
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ses-configurationset.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ses-configurationset.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.106.0 (build e852934)", date = "2025-03-12T01:36:45.909Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_ses.CfnConfigurationSet")
public class CfnConfigurationSet extends software.amazon.awscdk.CfnResource implements software.amazon.awscdk.IInspectable {

    protected CfnConfigurationSet(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnConfigurationSet(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        CFN_RESOURCE_TYPE_NAME = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.ses.CfnConfigurationSet.class, "CFN_RESOURCE_TYPE_NAME", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * @param scope Scope in which this resource is defined. This parameter is required.
     * @param id Construct identifier for this resource (unique in its scope). This parameter is required.
     * @param props Resource properties.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public CfnConfigurationSet(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.ses.CfnConfigurationSetProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), props });
    }

    /**
     * @param scope Scope in which this resource is defined. This parameter is required.
     * @param id Construct identifier for this resource (unique in its scope). This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public CfnConfigurationSet(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required") });
    }

    /**
     * Examines the CloudFormation resource and discloses attributes.
     * <p>
     * @param inspector tree inspector to collect and process attributes. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public void inspect(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.TreeInspector inspector) {
        software.amazon.jsii.Kernel.call(this, "inspect", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(inspector, "inspector is required") });
    }

    /**
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> renderProperties(final @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> props) {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.call(this, "renderProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class)), new Object[] { java.util.Objects.requireNonNull(props, "props is required") }));
    }

    /**
     * The CloudFormation resource type name for this resource class.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String CFN_RESOURCE_TYPE_NAME;

    /**
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> getCfnProperties() {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.get(this, "cfnProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class))));
    }

    /**
     * Specifies the name of the dedicated IP pool to associate with the configuration set and whether messages that use the configuration set are required to use Transport Layer Security (TLS).
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getDeliveryOptions() {
        return software.amazon.jsii.Kernel.get(this, "deliveryOptions", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * Specifies the name of the dedicated IP pool to associate with the configuration set and whether messages that use the configuration set are required to use Transport Layer Security (TLS).
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setDeliveryOptions(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "deliveryOptions", value);
    }

    /**
     * Specifies the name of the dedicated IP pool to associate with the configuration set and whether messages that use the configuration set are required to use Transport Layer Security (TLS).
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setDeliveryOptions(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.ses.CfnConfigurationSet.DeliveryOptionsProperty value) {
        software.amazon.jsii.Kernel.set(this, "deliveryOptions", value);
    }

    /**
     * The name of the configuration set.
     * <p>
     * The name must meet the following requirements:.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getName() {
        return software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The name of the configuration set.
     * <p>
     * The name must meet the following requirements:.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setName(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "name", value);
    }

    /**
     * An object that defines whether or not Amazon SES collects reputation metrics for the emails that you send that use the configuration set.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getReputationOptions() {
        return software.amazon.jsii.Kernel.get(this, "reputationOptions", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * An object that defines whether or not Amazon SES collects reputation metrics for the emails that you send that use the configuration set.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setReputationOptions(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "reputationOptions", value);
    }

    /**
     * An object that defines whether or not Amazon SES collects reputation metrics for the emails that you send that use the configuration set.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setReputationOptions(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.ses.CfnConfigurationSet.ReputationOptionsProperty value) {
        software.amazon.jsii.Kernel.set(this, "reputationOptions", value);
    }

    /**
     * An object that defines whether or not Amazon SES can send email that you send using the configuration set.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getSendingOptions() {
        return software.amazon.jsii.Kernel.get(this, "sendingOptions", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * An object that defines whether or not Amazon SES can send email that you send using the configuration set.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setSendingOptions(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "sendingOptions", value);
    }

    /**
     * An object that defines whether or not Amazon SES can send email that you send using the configuration set.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setSendingOptions(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.ses.CfnConfigurationSet.SendingOptionsProperty value) {
        software.amazon.jsii.Kernel.set(this, "sendingOptions", value);
    }

    /**
     * An object that contains information about the suppression list preferences for your account.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getSuppressionOptions() {
        return software.amazon.jsii.Kernel.get(this, "suppressionOptions", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * An object that contains information about the suppression list preferences for your account.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setSuppressionOptions(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "suppressionOptions", value);
    }

    /**
     * An object that contains information about the suppression list preferences for your account.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setSuppressionOptions(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.ses.CfnConfigurationSet.SuppressionOptionsProperty value) {
        software.amazon.jsii.Kernel.set(this, "suppressionOptions", value);
    }

    /**
     * An object that defines the open and click tracking options for emails that you send using the configuration set.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getTrackingOptions() {
        return software.amazon.jsii.Kernel.get(this, "trackingOptions", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * An object that defines the open and click tracking options for emails that you send using the configuration set.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setTrackingOptions(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "trackingOptions", value);
    }

    /**
     * An object that defines the open and click tracking options for emails that you send using the configuration set.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setTrackingOptions(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.ses.CfnConfigurationSet.TrackingOptionsProperty value) {
        software.amazon.jsii.Kernel.set(this, "trackingOptions", value);
    }

    /**
     * The Virtual Deliverability Manager (VDM) options that apply to the configuration set.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getVdmOptions() {
        return software.amazon.jsii.Kernel.get(this, "vdmOptions", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * The Virtual Deliverability Manager (VDM) options that apply to the configuration set.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setVdmOptions(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "vdmOptions", value);
    }

    /**
     * The Virtual Deliverability Manager (VDM) options that apply to the configuration set.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setVdmOptions(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.ses.CfnConfigurationSet.VdmOptionsProperty value) {
        software.amazon.jsii.Kernel.set(this, "vdmOptions", value);
    }
    /**
     * An object containing additional settings for your VDM configuration as applicable to the Dashboard.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.ses.*;
     * DashboardOptionsProperty dashboardOptionsProperty = DashboardOptionsProperty.builder()
     *         .engagementMetrics("engagementMetrics")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ses-configurationset-dashboardoptions.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ses-configurationset-dashboardoptions.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_ses.CfnConfigurationSet.DashboardOptionsProperty")
    @software.amazon.jsii.Jsii.Proxy(DashboardOptionsProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface DashboardOptionsProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Specifies the status of your VDM engagement metrics collection. Can be one of the following:.
         * <p>
         * <ul>
         * <li><code>ENABLED</code> – Amazon SES enables engagement metrics for the configuration set.</li>
         * <li><code>DISABLED</code> – Amazon SES disables engagement metrics for the configuration set.</li>
         * </ul>
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ses-configurationset-dashboardoptions.html#cfn-ses-configurationset-dashboardoptions-engagementmetrics">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ses-configurationset-dashboardoptions.html#cfn-ses-configurationset-dashboardoptions-engagementmetrics</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getEngagementMetrics();

        /**
         * @return a {@link Builder} of {@link DashboardOptionsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link DashboardOptionsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<DashboardOptionsProperty> {
            java.lang.String engagementMetrics;

            /**
             * Sets the value of {@link DashboardOptionsProperty#getEngagementMetrics}
             * @param engagementMetrics Specifies the status of your VDM engagement metrics collection. Can be one of the following:. This parameter is required.
             *                          <ul>
             *                          <li><code>ENABLED</code> – Amazon SES enables engagement metrics for the configuration set.</li>
             *                          <li><code>DISABLED</code> – Amazon SES disables engagement metrics for the configuration set.</li>
             *                          </ul>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder engagementMetrics(java.lang.String engagementMetrics) {
                this.engagementMetrics = engagementMetrics;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link DashboardOptionsProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public DashboardOptionsProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link DashboardOptionsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements DashboardOptionsProperty {
            private final java.lang.String engagementMetrics;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.engagementMetrics = software.amazon.jsii.Kernel.get(this, "engagementMetrics", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.engagementMetrics = java.util.Objects.requireNonNull(builder.engagementMetrics, "engagementMetrics is required");
            }

            @Override
            public final java.lang.String getEngagementMetrics() {
                return this.engagementMetrics;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("engagementMetrics", om.valueToTree(this.getEngagementMetrics()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_ses.CfnConfigurationSet.DashboardOptionsProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                DashboardOptionsProperty.Jsii$Proxy that = (DashboardOptionsProperty.Jsii$Proxy) o;

                return this.engagementMetrics.equals(that.engagementMetrics);
            }

            @Override
            public final int hashCode() {
                int result = this.engagementMetrics.hashCode();
                return result;
            }
        }
    }
    /**
     * Specifies the name of the dedicated IP pool to associate with the configuration set and whether messages that use the configuration set are required to use Transport Layer Security (TLS).
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.ses.*;
     * DeliveryOptionsProperty deliveryOptionsProperty = DeliveryOptionsProperty.builder()
     *         .maxDeliverySeconds(123)
     *         .sendingPoolName("sendingPoolName")
     *         .tlsPolicy("tlsPolicy")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ses-configurationset-deliveryoptions.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ses-configurationset-deliveryoptions.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_ses.CfnConfigurationSet.DeliveryOptionsProperty")
    @software.amazon.jsii.Jsii.Proxy(DeliveryOptionsProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface DeliveryOptionsProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The maximum amount of time, in seconds, that Amazon SES API v2 will attempt delivery of email.
         * <p>
         * If specified, the value must greater than or equal to 300 seconds (5 minutes) and less than or equal to 50400 seconds (840 minutes).
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ses-configurationset-deliveryoptions.html#cfn-ses-configurationset-deliveryoptions-maxdeliveryseconds">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ses-configurationset-deliveryoptions.html#cfn-ses-configurationset-deliveryoptions-maxdeliveryseconds</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getMaxDeliverySeconds() {
            return null;
        }

        /**
         * The name of the dedicated IP pool to associate with the configuration set.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ses-configurationset-deliveryoptions.html#cfn-ses-configurationset-deliveryoptions-sendingpoolname">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ses-configurationset-deliveryoptions.html#cfn-ses-configurationset-deliveryoptions-sendingpoolname</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getSendingPoolName() {
            return null;
        }

        /**
         * Specifies whether messages that use the configuration set are required to use Transport Layer Security (TLS).
         * <p>
         * If the value is <code>REQUIRE</code> , messages are only delivered if a TLS connection can be established. If the value is <code>OPTIONAL</code> , messages can be delivered in plain text if a TLS connection can't be established.
         * <p>
         * Valid Values: <code>REQUIRE | OPTIONAL</code>
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ses-configurationset-deliveryoptions.html#cfn-ses-configurationset-deliveryoptions-tlspolicy">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ses-configurationset-deliveryoptions.html#cfn-ses-configurationset-deliveryoptions-tlspolicy</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getTlsPolicy() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link DeliveryOptionsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link DeliveryOptionsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<DeliveryOptionsProperty> {
            java.lang.Number maxDeliverySeconds;
            java.lang.String sendingPoolName;
            java.lang.String tlsPolicy;

            /**
             * Sets the value of {@link DeliveryOptionsProperty#getMaxDeliverySeconds}
             * @param maxDeliverySeconds The maximum amount of time, in seconds, that Amazon SES API v2 will attempt delivery of email.
             *                           If specified, the value must greater than or equal to 300 seconds (5 minutes) and less than or equal to 50400 seconds (840 minutes).
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder maxDeliverySeconds(java.lang.Number maxDeliverySeconds) {
                this.maxDeliverySeconds = maxDeliverySeconds;
                return this;
            }

            /**
             * Sets the value of {@link DeliveryOptionsProperty#getSendingPoolName}
             * @param sendingPoolName The name of the dedicated IP pool to associate with the configuration set.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder sendingPoolName(java.lang.String sendingPoolName) {
                this.sendingPoolName = sendingPoolName;
                return this;
            }

            /**
             * Sets the value of {@link DeliveryOptionsProperty#getTlsPolicy}
             * @param tlsPolicy Specifies whether messages that use the configuration set are required to use Transport Layer Security (TLS).
             *                  If the value is <code>REQUIRE</code> , messages are only delivered if a TLS connection can be established. If the value is <code>OPTIONAL</code> , messages can be delivered in plain text if a TLS connection can't be established.
             *                  <p>
             *                  Valid Values: <code>REQUIRE | OPTIONAL</code>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder tlsPolicy(java.lang.String tlsPolicy) {
                this.tlsPolicy = tlsPolicy;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link DeliveryOptionsProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public DeliveryOptionsProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link DeliveryOptionsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements DeliveryOptionsProperty {
            private final java.lang.Number maxDeliverySeconds;
            private final java.lang.String sendingPoolName;
            private final java.lang.String tlsPolicy;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.maxDeliverySeconds = software.amazon.jsii.Kernel.get(this, "maxDeliverySeconds", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.sendingPoolName = software.amazon.jsii.Kernel.get(this, "sendingPoolName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.tlsPolicy = software.amazon.jsii.Kernel.get(this, "tlsPolicy", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.maxDeliverySeconds = builder.maxDeliverySeconds;
                this.sendingPoolName = builder.sendingPoolName;
                this.tlsPolicy = builder.tlsPolicy;
            }

            @Override
            public final java.lang.Number getMaxDeliverySeconds() {
                return this.maxDeliverySeconds;
            }

            @Override
            public final java.lang.String getSendingPoolName() {
                return this.sendingPoolName;
            }

            @Override
            public final java.lang.String getTlsPolicy() {
                return this.tlsPolicy;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getMaxDeliverySeconds() != null) {
                    data.set("maxDeliverySeconds", om.valueToTree(this.getMaxDeliverySeconds()));
                }
                if (this.getSendingPoolName() != null) {
                    data.set("sendingPoolName", om.valueToTree(this.getSendingPoolName()));
                }
                if (this.getTlsPolicy() != null) {
                    data.set("tlsPolicy", om.valueToTree(this.getTlsPolicy()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_ses.CfnConfigurationSet.DeliveryOptionsProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                DeliveryOptionsProperty.Jsii$Proxy that = (DeliveryOptionsProperty.Jsii$Proxy) o;

                if (this.maxDeliverySeconds != null ? !this.maxDeliverySeconds.equals(that.maxDeliverySeconds) : that.maxDeliverySeconds != null) return false;
                if (this.sendingPoolName != null ? !this.sendingPoolName.equals(that.sendingPoolName) : that.sendingPoolName != null) return false;
                return this.tlsPolicy != null ? this.tlsPolicy.equals(that.tlsPolicy) : that.tlsPolicy == null;
            }

            @Override
            public final int hashCode() {
                int result = this.maxDeliverySeconds != null ? this.maxDeliverySeconds.hashCode() : 0;
                result = 31 * result + (this.sendingPoolName != null ? this.sendingPoolName.hashCode() : 0);
                result = 31 * result + (this.tlsPolicy != null ? this.tlsPolicy.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * An object containing additional settings for your VDM configuration as applicable to the Guardian.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.ses.*;
     * GuardianOptionsProperty guardianOptionsProperty = GuardianOptionsProperty.builder()
     *         .optimizedSharedDelivery("optimizedSharedDelivery")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ses-configurationset-guardianoptions.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ses-configurationset-guardianoptions.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_ses.CfnConfigurationSet.GuardianOptionsProperty")
    @software.amazon.jsii.Jsii.Proxy(GuardianOptionsProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface GuardianOptionsProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Specifies the status of your VDM optimized shared delivery. Can be one of the following:.
         * <p>
         * <ul>
         * <li><code>ENABLED</code> – Amazon SES enables optimized shared delivery for the configuration set.</li>
         * <li><code>DISABLED</code> – Amazon SES disables optimized shared delivery for the configuration set.</li>
         * </ul>
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ses-configurationset-guardianoptions.html#cfn-ses-configurationset-guardianoptions-optimizedshareddelivery">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ses-configurationset-guardianoptions.html#cfn-ses-configurationset-guardianoptions-optimizedshareddelivery</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getOptimizedSharedDelivery();

        /**
         * @return a {@link Builder} of {@link GuardianOptionsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link GuardianOptionsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<GuardianOptionsProperty> {
            java.lang.String optimizedSharedDelivery;

            /**
             * Sets the value of {@link GuardianOptionsProperty#getOptimizedSharedDelivery}
             * @param optimizedSharedDelivery Specifies the status of your VDM optimized shared delivery. Can be one of the following:. This parameter is required.
             *                                <ul>
             *                                <li><code>ENABLED</code> – Amazon SES enables optimized shared delivery for the configuration set.</li>
             *                                <li><code>DISABLED</code> – Amazon SES disables optimized shared delivery for the configuration set.</li>
             *                                </ul>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder optimizedSharedDelivery(java.lang.String optimizedSharedDelivery) {
                this.optimizedSharedDelivery = optimizedSharedDelivery;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link GuardianOptionsProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public GuardianOptionsProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link GuardianOptionsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements GuardianOptionsProperty {
            private final java.lang.String optimizedSharedDelivery;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.optimizedSharedDelivery = software.amazon.jsii.Kernel.get(this, "optimizedSharedDelivery", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.optimizedSharedDelivery = java.util.Objects.requireNonNull(builder.optimizedSharedDelivery, "optimizedSharedDelivery is required");
            }

            @Override
            public final java.lang.String getOptimizedSharedDelivery() {
                return this.optimizedSharedDelivery;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("optimizedSharedDelivery", om.valueToTree(this.getOptimizedSharedDelivery()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_ses.CfnConfigurationSet.GuardianOptionsProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                GuardianOptionsProperty.Jsii$Proxy that = (GuardianOptionsProperty.Jsii$Proxy) o;

                return this.optimizedSharedDelivery.equals(that.optimizedSharedDelivery);
            }

            @Override
            public final int hashCode() {
                int result = this.optimizedSharedDelivery.hashCode();
                return result;
            }
        }
    }
    /**
     * Enable or disable collection of reputation metrics for emails that you send using this configuration set in the current AWS Region.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.ses.*;
     * ReputationOptionsProperty reputationOptionsProperty = ReputationOptionsProperty.builder()
     *         .reputationMetricsEnabled(false)
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ses-configurationset-reputationoptions.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ses-configurationset-reputationoptions.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_ses.CfnConfigurationSet.ReputationOptionsProperty")
    @software.amazon.jsii.Jsii.Proxy(ReputationOptionsProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ReputationOptionsProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * If <code>true</code> , tracking of reputation metrics is enabled for the configuration set.
         * <p>
         * If <code>false</code> , tracking of reputation metrics is disabled for the configuration set.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ses-configurationset-reputationoptions.html#cfn-ses-configurationset-reputationoptions-reputationmetricsenabled">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ses-configurationset-reputationoptions.html#cfn-ses-configurationset-reputationoptions-reputationmetricsenabled</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getReputationMetricsEnabled() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link ReputationOptionsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ReputationOptionsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ReputationOptionsProperty> {
            java.lang.Object reputationMetricsEnabled;

            /**
             * Sets the value of {@link ReputationOptionsProperty#getReputationMetricsEnabled}
             * @param reputationMetricsEnabled If <code>true</code> , tracking of reputation metrics is enabled for the configuration set.
             *                                 If <code>false</code> , tracking of reputation metrics is disabled for the configuration set.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder reputationMetricsEnabled(java.lang.Boolean reputationMetricsEnabled) {
                this.reputationMetricsEnabled = reputationMetricsEnabled;
                return this;
            }

            /**
             * Sets the value of {@link ReputationOptionsProperty#getReputationMetricsEnabled}
             * @param reputationMetricsEnabled If <code>true</code> , tracking of reputation metrics is enabled for the configuration set.
             *                                 If <code>false</code> , tracking of reputation metrics is disabled for the configuration set.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder reputationMetricsEnabled(software.amazon.awscdk.IResolvable reputationMetricsEnabled) {
                this.reputationMetricsEnabled = reputationMetricsEnabled;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ReputationOptionsProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ReputationOptionsProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link ReputationOptionsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ReputationOptionsProperty {
            private final java.lang.Object reputationMetricsEnabled;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.reputationMetricsEnabled = software.amazon.jsii.Kernel.get(this, "reputationMetricsEnabled", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.reputationMetricsEnabled = builder.reputationMetricsEnabled;
            }

            @Override
            public final java.lang.Object getReputationMetricsEnabled() {
                return this.reputationMetricsEnabled;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getReputationMetricsEnabled() != null) {
                    data.set("reputationMetricsEnabled", om.valueToTree(this.getReputationMetricsEnabled()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_ses.CfnConfigurationSet.ReputationOptionsProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ReputationOptionsProperty.Jsii$Proxy that = (ReputationOptionsProperty.Jsii$Proxy) o;

                return this.reputationMetricsEnabled != null ? this.reputationMetricsEnabled.equals(that.reputationMetricsEnabled) : that.reputationMetricsEnabled == null;
            }

            @Override
            public final int hashCode() {
                int result = this.reputationMetricsEnabled != null ? this.reputationMetricsEnabled.hashCode() : 0;
                return result;
            }
        }
    }
    /**
     * Used to enable or disable email sending for messages that use this configuration set in the current AWS Region.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.ses.*;
     * SendingOptionsProperty sendingOptionsProperty = SendingOptionsProperty.builder()
     *         .sendingEnabled(false)
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ses-configurationset-sendingoptions.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ses-configurationset-sendingoptions.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_ses.CfnConfigurationSet.SendingOptionsProperty")
    @software.amazon.jsii.Jsii.Proxy(SendingOptionsProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface SendingOptionsProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * If <code>true</code> , email sending is enabled for the configuration set.
         * <p>
         * If <code>false</code> , email sending is disabled for the configuration set.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ses-configurationset-sendingoptions.html#cfn-ses-configurationset-sendingoptions-sendingenabled">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ses-configurationset-sendingoptions.html#cfn-ses-configurationset-sendingoptions-sendingenabled</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getSendingEnabled() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link SendingOptionsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link SendingOptionsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<SendingOptionsProperty> {
            java.lang.Object sendingEnabled;

            /**
             * Sets the value of {@link SendingOptionsProperty#getSendingEnabled}
             * @param sendingEnabled If <code>true</code> , email sending is enabled for the configuration set.
             *                       If <code>false</code> , email sending is disabled for the configuration set.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder sendingEnabled(java.lang.Boolean sendingEnabled) {
                this.sendingEnabled = sendingEnabled;
                return this;
            }

            /**
             * Sets the value of {@link SendingOptionsProperty#getSendingEnabled}
             * @param sendingEnabled If <code>true</code> , email sending is enabled for the configuration set.
             *                       If <code>false</code> , email sending is disabled for the configuration set.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder sendingEnabled(software.amazon.awscdk.IResolvable sendingEnabled) {
                this.sendingEnabled = sendingEnabled;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link SendingOptionsProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public SendingOptionsProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link SendingOptionsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements SendingOptionsProperty {
            private final java.lang.Object sendingEnabled;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.sendingEnabled = software.amazon.jsii.Kernel.get(this, "sendingEnabled", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.sendingEnabled = builder.sendingEnabled;
            }

            @Override
            public final java.lang.Object getSendingEnabled() {
                return this.sendingEnabled;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getSendingEnabled() != null) {
                    data.set("sendingEnabled", om.valueToTree(this.getSendingEnabled()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_ses.CfnConfigurationSet.SendingOptionsProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                SendingOptionsProperty.Jsii$Proxy that = (SendingOptionsProperty.Jsii$Proxy) o;

                return this.sendingEnabled != null ? this.sendingEnabled.equals(that.sendingEnabled) : that.sendingEnabled == null;
            }

            @Override
            public final int hashCode() {
                int result = this.sendingEnabled != null ? this.sendingEnabled.hashCode() : 0;
                return result;
            }
        }
    }
    /**
     * An object that contains information about the suppression list preferences for your account.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.ses.*;
     * SuppressionOptionsProperty suppressionOptionsProperty = SuppressionOptionsProperty.builder()
     *         .suppressedReasons(List.of("suppressedReasons"))
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ses-configurationset-suppressionoptions.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ses-configurationset-suppressionoptions.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_ses.CfnConfigurationSet.SuppressionOptionsProperty")
    @software.amazon.jsii.Jsii.Proxy(SuppressionOptionsProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface SuppressionOptionsProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * A list that contains the reasons that email addresses are automatically added to the suppression list for your account.
         * <p>
         * This list can contain any or all of the following:
         * <p>
         * <ul>
         * <li><code>COMPLAINT</code> – Amazon SES adds an email address to the suppression list for your account when a message sent to that address results in a complaint.</li>
         * <li><code>BOUNCE</code> – Amazon SES adds an email address to the suppression list for your account when a message sent to that address results in a hard bounce.</li>
         * </ul>
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ses-configurationset-suppressionoptions.html#cfn-ses-configurationset-suppressionoptions-suppressedreasons">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ses-configurationset-suppressionoptions.html#cfn-ses-configurationset-suppressionoptions-suppressedreasons</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getSuppressedReasons() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link SuppressionOptionsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link SuppressionOptionsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<SuppressionOptionsProperty> {
            java.util.List<java.lang.String> suppressedReasons;

            /**
             * Sets the value of {@link SuppressionOptionsProperty#getSuppressedReasons}
             * @param suppressedReasons A list that contains the reasons that email addresses are automatically added to the suppression list for your account.
             *                          This list can contain any or all of the following:
             *                          <p>
             *                          <ul>
             *                          <li><code>COMPLAINT</code> – Amazon SES adds an email address to the suppression list for your account when a message sent to that address results in a complaint.</li>
             *                          <li><code>BOUNCE</code> – Amazon SES adds an email address to the suppression list for your account when a message sent to that address results in a hard bounce.</li>
             *                          </ul>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder suppressedReasons(java.util.List<java.lang.String> suppressedReasons) {
                this.suppressedReasons = suppressedReasons;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link SuppressionOptionsProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public SuppressionOptionsProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link SuppressionOptionsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements SuppressionOptionsProperty {
            private final java.util.List<java.lang.String> suppressedReasons;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.suppressedReasons = software.amazon.jsii.Kernel.get(this, "suppressedReasons", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.suppressedReasons = builder.suppressedReasons;
            }

            @Override
            public final java.util.List<java.lang.String> getSuppressedReasons() {
                return this.suppressedReasons;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getSuppressedReasons() != null) {
                    data.set("suppressedReasons", om.valueToTree(this.getSuppressedReasons()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_ses.CfnConfigurationSet.SuppressionOptionsProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                SuppressionOptionsProperty.Jsii$Proxy that = (SuppressionOptionsProperty.Jsii$Proxy) o;

                return this.suppressedReasons != null ? this.suppressedReasons.equals(that.suppressedReasons) : that.suppressedReasons == null;
            }

            @Override
            public final int hashCode() {
                int result = this.suppressedReasons != null ? this.suppressedReasons.hashCode() : 0;
                return result;
            }
        }
    }
    /**
     * An object that defines the tracking options for a configuration set.
     * <p>
     * When you use the Amazon SES API v2 to send an email, it contains an invisible image that's used to track when recipients open your email. If your email contains links, those links are changed slightly in order to track when recipients click them.
     * <p>
     * You can optionally configure a custom subdomain that is used to redirect email recipients to an Amazon SES-operated domain. This domain captures open and click events generated by Amazon SES emails.
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/ses/latest/dg/configure-custom-open-click-domains.html">Configuring Custom Domains to Handle Open and Click Tracking</a> in the <em>Amazon SES Developer Guide</em> .
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.ses.*;
     * TrackingOptionsProperty trackingOptionsProperty = TrackingOptionsProperty.builder()
     *         .customRedirectDomain("customRedirectDomain")
     *         .httpsPolicy("httpsPolicy")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ses-configurationset-trackingoptions.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ses-configurationset-trackingoptions.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_ses.CfnConfigurationSet.TrackingOptionsProperty")
    @software.amazon.jsii.Jsii.Proxy(TrackingOptionsProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface TrackingOptionsProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The custom subdomain that is used to redirect email recipients to the Amazon SES event tracking domain.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ses-configurationset-trackingoptions.html#cfn-ses-configurationset-trackingoptions-customredirectdomain">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ses-configurationset-trackingoptions.html#cfn-ses-configurationset-trackingoptions-customredirectdomain</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getCustomRedirectDomain() {
            return null;
        }

        /**
         * The https policy to use for tracking open and click events.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ses-configurationset-trackingoptions.html#cfn-ses-configurationset-trackingoptions-httpspolicy">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ses-configurationset-trackingoptions.html#cfn-ses-configurationset-trackingoptions-httpspolicy</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getHttpsPolicy() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link TrackingOptionsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link TrackingOptionsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<TrackingOptionsProperty> {
            java.lang.String customRedirectDomain;
            java.lang.String httpsPolicy;

            /**
             * Sets the value of {@link TrackingOptionsProperty#getCustomRedirectDomain}
             * @param customRedirectDomain The custom subdomain that is used to redirect email recipients to the Amazon SES event tracking domain.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder customRedirectDomain(java.lang.String customRedirectDomain) {
                this.customRedirectDomain = customRedirectDomain;
                return this;
            }

            /**
             * Sets the value of {@link TrackingOptionsProperty#getHttpsPolicy}
             * @param httpsPolicy The https policy to use for tracking open and click events.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder httpsPolicy(java.lang.String httpsPolicy) {
                this.httpsPolicy = httpsPolicy;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link TrackingOptionsProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public TrackingOptionsProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link TrackingOptionsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements TrackingOptionsProperty {
            private final java.lang.String customRedirectDomain;
            private final java.lang.String httpsPolicy;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.customRedirectDomain = software.amazon.jsii.Kernel.get(this, "customRedirectDomain", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.httpsPolicy = software.amazon.jsii.Kernel.get(this, "httpsPolicy", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.customRedirectDomain = builder.customRedirectDomain;
                this.httpsPolicy = builder.httpsPolicy;
            }

            @Override
            public final java.lang.String getCustomRedirectDomain() {
                return this.customRedirectDomain;
            }

            @Override
            public final java.lang.String getHttpsPolicy() {
                return this.httpsPolicy;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getCustomRedirectDomain() != null) {
                    data.set("customRedirectDomain", om.valueToTree(this.getCustomRedirectDomain()));
                }
                if (this.getHttpsPolicy() != null) {
                    data.set("httpsPolicy", om.valueToTree(this.getHttpsPolicy()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_ses.CfnConfigurationSet.TrackingOptionsProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                TrackingOptionsProperty.Jsii$Proxy that = (TrackingOptionsProperty.Jsii$Proxy) o;

                if (this.customRedirectDomain != null ? !this.customRedirectDomain.equals(that.customRedirectDomain) : that.customRedirectDomain != null) return false;
                return this.httpsPolicy != null ? this.httpsPolicy.equals(that.httpsPolicy) : that.httpsPolicy == null;
            }

            @Override
            public final int hashCode() {
                int result = this.customRedirectDomain != null ? this.customRedirectDomain.hashCode() : 0;
                result = 31 * result + (this.httpsPolicy != null ? this.httpsPolicy.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * The Virtual Deliverability Manager (VDM) options that apply to a configuration set.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.ses.*;
     * VdmOptionsProperty vdmOptionsProperty = VdmOptionsProperty.builder()
     *         .dashboardOptions(DashboardOptionsProperty.builder()
     *                 .engagementMetrics("engagementMetrics")
     *                 .build())
     *         .guardianOptions(GuardianOptionsProperty.builder()
     *                 .optimizedSharedDelivery("optimizedSharedDelivery")
     *                 .build())
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ses-configurationset-vdmoptions.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ses-configurationset-vdmoptions.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_ses.CfnConfigurationSet.VdmOptionsProperty")
    @software.amazon.jsii.Jsii.Proxy(VdmOptionsProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface VdmOptionsProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Specifies additional settings for your VDM configuration as applicable to the Dashboard.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ses-configurationset-vdmoptions.html#cfn-ses-configurationset-vdmoptions-dashboardoptions">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ses-configurationset-vdmoptions.html#cfn-ses-configurationset-vdmoptions-dashboardoptions</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getDashboardOptions() {
            return null;
        }

        /**
         * Specifies additional settings for your VDM configuration as applicable to the Guardian.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ses-configurationset-vdmoptions.html#cfn-ses-configurationset-vdmoptions-guardianoptions">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ses-configurationset-vdmoptions.html#cfn-ses-configurationset-vdmoptions-guardianoptions</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getGuardianOptions() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link VdmOptionsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link VdmOptionsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<VdmOptionsProperty> {
            java.lang.Object dashboardOptions;
            java.lang.Object guardianOptions;

            /**
             * Sets the value of {@link VdmOptionsProperty#getDashboardOptions}
             * @param dashboardOptions Specifies additional settings for your VDM configuration as applicable to the Dashboard.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder dashboardOptions(software.amazon.awscdk.IResolvable dashboardOptions) {
                this.dashboardOptions = dashboardOptions;
                return this;
            }

            /**
             * Sets the value of {@link VdmOptionsProperty#getDashboardOptions}
             * @param dashboardOptions Specifies additional settings for your VDM configuration as applicable to the Dashboard.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder dashboardOptions(software.amazon.awscdk.services.ses.CfnConfigurationSet.DashboardOptionsProperty dashboardOptions) {
                this.dashboardOptions = dashboardOptions;
                return this;
            }

            /**
             * Sets the value of {@link VdmOptionsProperty#getGuardianOptions}
             * @param guardianOptions Specifies additional settings for your VDM configuration as applicable to the Guardian.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder guardianOptions(software.amazon.awscdk.IResolvable guardianOptions) {
                this.guardianOptions = guardianOptions;
                return this;
            }

            /**
             * Sets the value of {@link VdmOptionsProperty#getGuardianOptions}
             * @param guardianOptions Specifies additional settings for your VDM configuration as applicable to the Guardian.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder guardianOptions(software.amazon.awscdk.services.ses.CfnConfigurationSet.GuardianOptionsProperty guardianOptions) {
                this.guardianOptions = guardianOptions;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link VdmOptionsProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public VdmOptionsProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link VdmOptionsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements VdmOptionsProperty {
            private final java.lang.Object dashboardOptions;
            private final java.lang.Object guardianOptions;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.dashboardOptions = software.amazon.jsii.Kernel.get(this, "dashboardOptions", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.guardianOptions = software.amazon.jsii.Kernel.get(this, "guardianOptions", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.dashboardOptions = builder.dashboardOptions;
                this.guardianOptions = builder.guardianOptions;
            }

            @Override
            public final java.lang.Object getDashboardOptions() {
                return this.dashboardOptions;
            }

            @Override
            public final java.lang.Object getGuardianOptions() {
                return this.guardianOptions;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getDashboardOptions() != null) {
                    data.set("dashboardOptions", om.valueToTree(this.getDashboardOptions()));
                }
                if (this.getGuardianOptions() != null) {
                    data.set("guardianOptions", om.valueToTree(this.getGuardianOptions()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_ses.CfnConfigurationSet.VdmOptionsProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                VdmOptionsProperty.Jsii$Proxy that = (VdmOptionsProperty.Jsii$Proxy) o;

                if (this.dashboardOptions != null ? !this.dashboardOptions.equals(that.dashboardOptions) : that.dashboardOptions != null) return false;
                return this.guardianOptions != null ? this.guardianOptions.equals(that.guardianOptions) : that.guardianOptions == null;
            }

            @Override
            public final int hashCode() {
                int result = this.dashboardOptions != null ? this.dashboardOptions.hashCode() : 0;
                result = 31 * result + (this.guardianOptions != null ? this.guardianOptions.hashCode() : 0);
                return result;
            }
        }
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.ses.CfnConfigurationSet}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.ses.CfnConfigurationSet> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope Scope in which this resource is defined. This parameter is required.
         * @param id Construct identifier for this resource (unique in its scope). This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private software.amazon.awscdk.services.ses.CfnConfigurationSetProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
        }

        /**
         * Specifies the name of the dedicated IP pool to associate with the configuration set and whether messages that use the configuration set are required to use Transport Layer Security (TLS).
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ses-configurationset.html#cfn-ses-configurationset-deliveryoptions">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ses-configurationset.html#cfn-ses-configurationset-deliveryoptions</a>
         * @param deliveryOptions Specifies the name of the dedicated IP pool to associate with the configuration set and whether messages that use the configuration set are required to use Transport Layer Security (TLS). This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder deliveryOptions(final software.amazon.awscdk.IResolvable deliveryOptions) {
            this.props().deliveryOptions(deliveryOptions);
            return this;
        }
        /**
         * Specifies the name of the dedicated IP pool to associate with the configuration set and whether messages that use the configuration set are required to use Transport Layer Security (TLS).
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ses-configurationset.html#cfn-ses-configurationset-deliveryoptions">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ses-configurationset.html#cfn-ses-configurationset-deliveryoptions</a>
         * @param deliveryOptions Specifies the name of the dedicated IP pool to associate with the configuration set and whether messages that use the configuration set are required to use Transport Layer Security (TLS). This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder deliveryOptions(final software.amazon.awscdk.services.ses.CfnConfigurationSet.DeliveryOptionsProperty deliveryOptions) {
            this.props().deliveryOptions(deliveryOptions);
            return this;
        }

        /**
         * The name of the configuration set. The name must meet the following requirements:.
         * <p>
         * <ul>
         * <li>Contain only letters (a-z, A-Z), numbers (0-9), underscores (_), or dashes (-).</li>
         * <li>Contain 64 characters or fewer.</li>
         * </ul>
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ses-configurationset.html#cfn-ses-configurationset-name">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ses-configurationset.html#cfn-ses-configurationset-name</a>
         * @param name The name of the configuration set. The name must meet the following requirements:. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder name(final java.lang.String name) {
            this.props().name(name);
            return this;
        }

        /**
         * An object that defines whether or not Amazon SES collects reputation metrics for the emails that you send that use the configuration set.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ses-configurationset.html#cfn-ses-configurationset-reputationoptions">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ses-configurationset.html#cfn-ses-configurationset-reputationoptions</a>
         * @param reputationOptions An object that defines whether or not Amazon SES collects reputation metrics for the emails that you send that use the configuration set. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder reputationOptions(final software.amazon.awscdk.IResolvable reputationOptions) {
            this.props().reputationOptions(reputationOptions);
            return this;
        }
        /**
         * An object that defines whether or not Amazon SES collects reputation metrics for the emails that you send that use the configuration set.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ses-configurationset.html#cfn-ses-configurationset-reputationoptions">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ses-configurationset.html#cfn-ses-configurationset-reputationoptions</a>
         * @param reputationOptions An object that defines whether or not Amazon SES collects reputation metrics for the emails that you send that use the configuration set. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder reputationOptions(final software.amazon.awscdk.services.ses.CfnConfigurationSet.ReputationOptionsProperty reputationOptions) {
            this.props().reputationOptions(reputationOptions);
            return this;
        }

        /**
         * An object that defines whether or not Amazon SES can send email that you send using the configuration set.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ses-configurationset.html#cfn-ses-configurationset-sendingoptions">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ses-configurationset.html#cfn-ses-configurationset-sendingoptions</a>
         * @param sendingOptions An object that defines whether or not Amazon SES can send email that you send using the configuration set. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder sendingOptions(final software.amazon.awscdk.IResolvable sendingOptions) {
            this.props().sendingOptions(sendingOptions);
            return this;
        }
        /**
         * An object that defines whether or not Amazon SES can send email that you send using the configuration set.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ses-configurationset.html#cfn-ses-configurationset-sendingoptions">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ses-configurationset.html#cfn-ses-configurationset-sendingoptions</a>
         * @param sendingOptions An object that defines whether or not Amazon SES can send email that you send using the configuration set. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder sendingOptions(final software.amazon.awscdk.services.ses.CfnConfigurationSet.SendingOptionsProperty sendingOptions) {
            this.props().sendingOptions(sendingOptions);
            return this;
        }

        /**
         * An object that contains information about the suppression list preferences for your account.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ses-configurationset.html#cfn-ses-configurationset-suppressionoptions">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ses-configurationset.html#cfn-ses-configurationset-suppressionoptions</a>
         * @param suppressionOptions An object that contains information about the suppression list preferences for your account. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder suppressionOptions(final software.amazon.awscdk.IResolvable suppressionOptions) {
            this.props().suppressionOptions(suppressionOptions);
            return this;
        }
        /**
         * An object that contains information about the suppression list preferences for your account.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ses-configurationset.html#cfn-ses-configurationset-suppressionoptions">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ses-configurationset.html#cfn-ses-configurationset-suppressionoptions</a>
         * @param suppressionOptions An object that contains information about the suppression list preferences for your account. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder suppressionOptions(final software.amazon.awscdk.services.ses.CfnConfigurationSet.SuppressionOptionsProperty suppressionOptions) {
            this.props().suppressionOptions(suppressionOptions);
            return this;
        }

        /**
         * An object that defines the open and click tracking options for emails that you send using the configuration set.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ses-configurationset.html#cfn-ses-configurationset-trackingoptions">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ses-configurationset.html#cfn-ses-configurationset-trackingoptions</a>
         * @param trackingOptions An object that defines the open and click tracking options for emails that you send using the configuration set. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder trackingOptions(final software.amazon.awscdk.IResolvable trackingOptions) {
            this.props().trackingOptions(trackingOptions);
            return this;
        }
        /**
         * An object that defines the open and click tracking options for emails that you send using the configuration set.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ses-configurationset.html#cfn-ses-configurationset-trackingoptions">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ses-configurationset.html#cfn-ses-configurationset-trackingoptions</a>
         * @param trackingOptions An object that defines the open and click tracking options for emails that you send using the configuration set. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder trackingOptions(final software.amazon.awscdk.services.ses.CfnConfigurationSet.TrackingOptionsProperty trackingOptions) {
            this.props().trackingOptions(trackingOptions);
            return this;
        }

        /**
         * The Virtual Deliverability Manager (VDM) options that apply to the configuration set.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ses-configurationset.html#cfn-ses-configurationset-vdmoptions">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ses-configurationset.html#cfn-ses-configurationset-vdmoptions</a>
         * @param vdmOptions The Virtual Deliverability Manager (VDM) options that apply to the configuration set. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder vdmOptions(final software.amazon.awscdk.IResolvable vdmOptions) {
            this.props().vdmOptions(vdmOptions);
            return this;
        }
        /**
         * The Virtual Deliverability Manager (VDM) options that apply to the configuration set.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ses-configurationset.html#cfn-ses-configurationset-vdmoptions">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ses-configurationset.html#cfn-ses-configurationset-vdmoptions</a>
         * @param vdmOptions The Virtual Deliverability Manager (VDM) options that apply to the configuration set. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder vdmOptions(final software.amazon.awscdk.services.ses.CfnConfigurationSet.VdmOptionsProperty vdmOptions) {
            this.props().vdmOptions(vdmOptions);
            return this;
        }

        /**
         * @return a newly built instance of {@link software.amazon.awscdk.services.ses.CfnConfigurationSet}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.ses.CfnConfigurationSet build() {
            return new software.amazon.awscdk.services.ses.CfnConfigurationSet(
                this.scope,
                this.id,
                this.props != null ? this.props.build() : null
            );
        }

        private software.amazon.awscdk.services.ses.CfnConfigurationSetProps.Builder props() {
            if (this.props == null) {
                this.props = new software.amazon.awscdk.services.ses.CfnConfigurationSetProps.Builder();
            }
            return this.props;
        }
    }
}
