package software.amazon.awscdk.services.ses;

/**
 * Specifies a configuration set event destination.
 * <p>
 * <em>Events</em> include message sends, deliveries, opens, clicks, bounces, and complaints. <em>Event destinations</em> are places that you can send information about these events to. For example, you can send event data to Amazon SNS to receive notifications when you receive bounces or complaints, or you can use Amazon Kinesis Data Firehose to stream data to Amazon S3 for long-term storage.
 * <p>
 * A single configuration set can include more than one event destination.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.ses.*;
 * CfnConfigurationSetEventDestination cfnConfigurationSetEventDestination = CfnConfigurationSetEventDestination.Builder.create(this, "MyCfnConfigurationSetEventDestination")
 *         .configurationSetName("configurationSetName")
 *         .eventDestination(EventDestinationProperty.builder()
 *                 .matchingEventTypes(List.of("matchingEventTypes"))
 *                 // the properties below are optional
 *                 .cloudWatchDestination(CloudWatchDestinationProperty.builder()
 *                         .dimensionConfigurations(List.of(DimensionConfigurationProperty.builder()
 *                                 .defaultDimensionValue("defaultDimensionValue")
 *                                 .dimensionName("dimensionName")
 *                                 .dimensionValueSource("dimensionValueSource")
 *                                 .build()))
 *                         .build())
 *                 .enabled(false)
 *                 .eventBridgeDestination(EventBridgeDestinationProperty.builder()
 *                         .eventBusArn("eventBusArn")
 *                         .build())
 *                 .kinesisFirehoseDestination(KinesisFirehoseDestinationProperty.builder()
 *                         .deliveryStreamArn("deliveryStreamArn")
 *                         .iamRoleArn("iamRoleArn")
 *                         .build())
 *                 .name("name")
 *                 .snsDestination(SnsDestinationProperty.builder()
 *                         .topicArn("topicArn")
 *                         .build())
 *                 .build())
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ses-configurationseteventdestination.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ses-configurationseteventdestination.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.106.0 (build e852934)", date = "2025-03-12T01:36:45.913Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_ses.CfnConfigurationSetEventDestination")
public class CfnConfigurationSetEventDestination extends software.amazon.awscdk.CfnResource implements software.amazon.awscdk.IInspectable {

    protected CfnConfigurationSetEventDestination(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnConfigurationSetEventDestination(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        CFN_RESOURCE_TYPE_NAME = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.ses.CfnConfigurationSetEventDestination.class, "CFN_RESOURCE_TYPE_NAME", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * @param scope Scope in which this resource is defined. This parameter is required.
     * @param id Construct identifier for this resource (unique in its scope). This parameter is required.
     * @param props Resource properties. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public CfnConfigurationSetEventDestination(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ses.CfnConfigurationSetEventDestinationProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Examines the CloudFormation resource and discloses attributes.
     * <p>
     * @param inspector tree inspector to collect and process attributes. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public void inspect(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.TreeInspector inspector) {
        software.amazon.jsii.Kernel.call(this, "inspect", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(inspector, "inspector is required") });
    }

    /**
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> renderProperties(final @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> props) {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.call(this, "renderProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class)), new Object[] { java.util.Objects.requireNonNull(props, "props is required") }));
    }

    /**
     * The CloudFormation resource type name for this resource class.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String CFN_RESOURCE_TYPE_NAME;

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrId() {
        return software.amazon.jsii.Kernel.get(this, "attrId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> getCfnProperties() {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.get(this, "cfnProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class))));
    }

    /**
     * The name of the configuration set that contains the event destination.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getConfigurationSetName() {
        return software.amazon.jsii.Kernel.get(this, "configurationSetName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The name of the configuration set that contains the event destination.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setConfigurationSetName(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "configurationSetName", java.util.Objects.requireNonNull(value, "configurationSetName is required"));
    }

    /**
     * An object that defines the event destination.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.Object getEventDestination() {
        return software.amazon.jsii.Kernel.get(this, "eventDestination", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * An object that defines the event destination.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setEventDestination(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "eventDestination", java.util.Objects.requireNonNull(value, "eventDestination is required"));
    }

    /**
     * An object that defines the event destination.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setEventDestination(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ses.CfnConfigurationSetEventDestination.EventDestinationProperty value) {
        software.amazon.jsii.Kernel.set(this, "eventDestination", java.util.Objects.requireNonNull(value, "eventDestination is required"));
    }
    /**
     * An object that defines an Amazon CloudWatch destination for email events.
     * <p>
     * You can use Amazon CloudWatch to monitor and gain insights on your email sending metrics.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.ses.*;
     * CloudWatchDestinationProperty cloudWatchDestinationProperty = CloudWatchDestinationProperty.builder()
     *         .dimensionConfigurations(List.of(DimensionConfigurationProperty.builder()
     *                 .defaultDimensionValue("defaultDimensionValue")
     *                 .dimensionName("dimensionName")
     *                 .dimensionValueSource("dimensionValueSource")
     *                 .build()))
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ses-configurationseteventdestination-cloudwatchdestination.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ses-configurationseteventdestination-cloudwatchdestination.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_ses.CfnConfigurationSetEventDestination.CloudWatchDestinationProperty")
    @software.amazon.jsii.Jsii.Proxy(CloudWatchDestinationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface CloudWatchDestinationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * An array of objects that define the dimensions to use when you send email events to Amazon CloudWatch.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ses-configurationseteventdestination-cloudwatchdestination.html#cfn-ses-configurationseteventdestination-cloudwatchdestination-dimensionconfigurations">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ses-configurationseteventdestination-cloudwatchdestination.html#cfn-ses-configurationseteventdestination-cloudwatchdestination-dimensionconfigurations</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getDimensionConfigurations() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link CloudWatchDestinationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link CloudWatchDestinationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<CloudWatchDestinationProperty> {
            java.lang.Object dimensionConfigurations;

            /**
             * Sets the value of {@link CloudWatchDestinationProperty#getDimensionConfigurations}
             * @param dimensionConfigurations An array of objects that define the dimensions to use when you send email events to Amazon CloudWatch.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder dimensionConfigurations(software.amazon.awscdk.IResolvable dimensionConfigurations) {
                this.dimensionConfigurations = dimensionConfigurations;
                return this;
            }

            /**
             * Sets the value of {@link CloudWatchDestinationProperty#getDimensionConfigurations}
             * @param dimensionConfigurations An array of objects that define the dimensions to use when you send email events to Amazon CloudWatch.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder dimensionConfigurations(java.util.List<? extends java.lang.Object> dimensionConfigurations) {
                this.dimensionConfigurations = dimensionConfigurations;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link CloudWatchDestinationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public CloudWatchDestinationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link CloudWatchDestinationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CloudWatchDestinationProperty {
            private final java.lang.Object dimensionConfigurations;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.dimensionConfigurations = software.amazon.jsii.Kernel.get(this, "dimensionConfigurations", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.dimensionConfigurations = builder.dimensionConfigurations;
            }

            @Override
            public final java.lang.Object getDimensionConfigurations() {
                return this.dimensionConfigurations;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getDimensionConfigurations() != null) {
                    data.set("dimensionConfigurations", om.valueToTree(this.getDimensionConfigurations()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_ses.CfnConfigurationSetEventDestination.CloudWatchDestinationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                CloudWatchDestinationProperty.Jsii$Proxy that = (CloudWatchDestinationProperty.Jsii$Proxy) o;

                return this.dimensionConfigurations != null ? this.dimensionConfigurations.equals(that.dimensionConfigurations) : that.dimensionConfigurations == null;
            }

            @Override
            public final int hashCode() {
                int result = this.dimensionConfigurations != null ? this.dimensionConfigurations.hashCode() : 0;
                return result;
            }
        }
    }
    /**
     * An object that defines the dimension configuration to use when you send email events to Amazon CloudWatch.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.ses.*;
     * DimensionConfigurationProperty dimensionConfigurationProperty = DimensionConfigurationProperty.builder()
     *         .defaultDimensionValue("defaultDimensionValue")
     *         .dimensionName("dimensionName")
     *         .dimensionValueSource("dimensionValueSource")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ses-configurationseteventdestination-dimensionconfiguration.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ses-configurationseteventdestination-dimensionconfiguration.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_ses.CfnConfigurationSetEventDestination.DimensionConfigurationProperty")
    @software.amazon.jsii.Jsii.Proxy(DimensionConfigurationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface DimensionConfigurationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The default value of the dimension that is published to Amazon CloudWatch if you don't provide the value of the dimension when you send an email.
         * <p>
         * This value has to meet the following criteria:
         * <p>
         * <ul>
         * <li>Can only contain ASCII letters (a–z, A–Z), numbers (0–9), underscores (_), or dashes (-), at signs (&#64;), and periods (.).</li>
         * <li>It can contain no more than 256 characters.</li>
         * </ul>
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ses-configurationseteventdestination-dimensionconfiguration.html#cfn-ses-configurationseteventdestination-dimensionconfiguration-defaultdimensionvalue">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ses-configurationseteventdestination-dimensionconfiguration.html#cfn-ses-configurationseteventdestination-dimensionconfiguration-defaultdimensionvalue</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getDefaultDimensionValue();

        /**
         * The name of an Amazon CloudWatch dimension associated with an email sending metric.
         * <p>
         * The name has to meet the following criteria:
         * <p>
         * <ul>
         * <li>It can only contain ASCII letters (a–z, A–Z), numbers (0–9), underscores (_), or dashes (-).</li>
         * <li>It can contain no more than 256 characters.</li>
         * </ul>
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ses-configurationseteventdestination-dimensionconfiguration.html#cfn-ses-configurationseteventdestination-dimensionconfiguration-dimensionname">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ses-configurationseteventdestination-dimensionconfiguration.html#cfn-ses-configurationseteventdestination-dimensionconfiguration-dimensionname</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getDimensionName();

        /**
         * The location where the Amazon SES API v2 finds the value of a dimension to publish to Amazon CloudWatch.
         * <p>
         * To use the message tags that you specify using an <code>X-SES-MESSAGE-TAGS</code> header or a parameter to the <code>SendEmail</code> or <code>SendRawEmail</code> API, choose <code>messageTag</code> . To use your own email headers, choose <code>emailHeader</code> . To use link tags, choose <code>linkTag</code> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ses-configurationseteventdestination-dimensionconfiguration.html#cfn-ses-configurationseteventdestination-dimensionconfiguration-dimensionvaluesource">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ses-configurationseteventdestination-dimensionconfiguration.html#cfn-ses-configurationseteventdestination-dimensionconfiguration-dimensionvaluesource</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getDimensionValueSource();

        /**
         * @return a {@link Builder} of {@link DimensionConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link DimensionConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<DimensionConfigurationProperty> {
            java.lang.String defaultDimensionValue;
            java.lang.String dimensionName;
            java.lang.String dimensionValueSource;

            /**
             * Sets the value of {@link DimensionConfigurationProperty#getDefaultDimensionValue}
             * @param defaultDimensionValue The default value of the dimension that is published to Amazon CloudWatch if you don't provide the value of the dimension when you send an email. This parameter is required.
             *                              This value has to meet the following criteria:
             *                              <p>
             *                              <ul>
             *                              <li>Can only contain ASCII letters (a–z, A–Z), numbers (0–9), underscores (_), or dashes (-), at signs (&#64;), and periods (.).</li>
             *                              <li>It can contain no more than 256 characters.</li>
             *                              </ul>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder defaultDimensionValue(java.lang.String defaultDimensionValue) {
                this.defaultDimensionValue = defaultDimensionValue;
                return this;
            }

            /**
             * Sets the value of {@link DimensionConfigurationProperty#getDimensionName}
             * @param dimensionName The name of an Amazon CloudWatch dimension associated with an email sending metric. This parameter is required.
             *                      The name has to meet the following criteria:
             *                      <p>
             *                      <ul>
             *                      <li>It can only contain ASCII letters (a–z, A–Z), numbers (0–9), underscores (_), or dashes (-).</li>
             *                      <li>It can contain no more than 256 characters.</li>
             *                      </ul>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder dimensionName(java.lang.String dimensionName) {
                this.dimensionName = dimensionName;
                return this;
            }

            /**
             * Sets the value of {@link DimensionConfigurationProperty#getDimensionValueSource}
             * @param dimensionValueSource The location where the Amazon SES API v2 finds the value of a dimension to publish to Amazon CloudWatch. This parameter is required.
             *                             To use the message tags that you specify using an <code>X-SES-MESSAGE-TAGS</code> header or a parameter to the <code>SendEmail</code> or <code>SendRawEmail</code> API, choose <code>messageTag</code> . To use your own email headers, choose <code>emailHeader</code> . To use link tags, choose <code>linkTag</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder dimensionValueSource(java.lang.String dimensionValueSource) {
                this.dimensionValueSource = dimensionValueSource;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link DimensionConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public DimensionConfigurationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link DimensionConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements DimensionConfigurationProperty {
            private final java.lang.String defaultDimensionValue;
            private final java.lang.String dimensionName;
            private final java.lang.String dimensionValueSource;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.defaultDimensionValue = software.amazon.jsii.Kernel.get(this, "defaultDimensionValue", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.dimensionName = software.amazon.jsii.Kernel.get(this, "dimensionName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.dimensionValueSource = software.amazon.jsii.Kernel.get(this, "dimensionValueSource", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.defaultDimensionValue = java.util.Objects.requireNonNull(builder.defaultDimensionValue, "defaultDimensionValue is required");
                this.dimensionName = java.util.Objects.requireNonNull(builder.dimensionName, "dimensionName is required");
                this.dimensionValueSource = java.util.Objects.requireNonNull(builder.dimensionValueSource, "dimensionValueSource is required");
            }

            @Override
            public final java.lang.String getDefaultDimensionValue() {
                return this.defaultDimensionValue;
            }

            @Override
            public final java.lang.String getDimensionName() {
                return this.dimensionName;
            }

            @Override
            public final java.lang.String getDimensionValueSource() {
                return this.dimensionValueSource;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("defaultDimensionValue", om.valueToTree(this.getDefaultDimensionValue()));
                data.set("dimensionName", om.valueToTree(this.getDimensionName()));
                data.set("dimensionValueSource", om.valueToTree(this.getDimensionValueSource()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_ses.CfnConfigurationSetEventDestination.DimensionConfigurationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                DimensionConfigurationProperty.Jsii$Proxy that = (DimensionConfigurationProperty.Jsii$Proxy) o;

                if (!defaultDimensionValue.equals(that.defaultDimensionValue)) return false;
                if (!dimensionName.equals(that.dimensionName)) return false;
                return this.dimensionValueSource.equals(that.dimensionValueSource);
            }

            @Override
            public final int hashCode() {
                int result = this.defaultDimensionValue.hashCode();
                result = 31 * result + (this.dimensionName.hashCode());
                result = 31 * result + (this.dimensionValueSource.hashCode());
                return result;
            }
        }
    }
    /**
     * An object that defines an Amazon EventBridge destination for email events.
     * <p>
     * You can use Amazon EventBridge to send notifications when certain email events occur.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.ses.*;
     * EventBridgeDestinationProperty eventBridgeDestinationProperty = EventBridgeDestinationProperty.builder()
     *         .eventBusArn("eventBusArn")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ses-configurationseteventdestination-eventbridgedestination.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ses-configurationseteventdestination-eventbridgedestination.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_ses.CfnConfigurationSetEventDestination.EventBridgeDestinationProperty")
    @software.amazon.jsii.Jsii.Proxy(EventBridgeDestinationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface EventBridgeDestinationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The Amazon Resource Name (ARN) of the Amazon EventBridge bus to publish email events to.
         * <p>
         * Only the default bus is supported.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ses-configurationseteventdestination-eventbridgedestination.html#cfn-ses-configurationseteventdestination-eventbridgedestination-eventbusarn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ses-configurationseteventdestination-eventbridgedestination.html#cfn-ses-configurationseteventdestination-eventbridgedestination-eventbusarn</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getEventBusArn();

        /**
         * @return a {@link Builder} of {@link EventBridgeDestinationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link EventBridgeDestinationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<EventBridgeDestinationProperty> {
            java.lang.String eventBusArn;

            /**
             * Sets the value of {@link EventBridgeDestinationProperty#getEventBusArn}
             * @param eventBusArn The Amazon Resource Name (ARN) of the Amazon EventBridge bus to publish email events to. This parameter is required.
             *                    Only the default bus is supported.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder eventBusArn(java.lang.String eventBusArn) {
                this.eventBusArn = eventBusArn;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link EventBridgeDestinationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public EventBridgeDestinationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link EventBridgeDestinationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements EventBridgeDestinationProperty {
            private final java.lang.String eventBusArn;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.eventBusArn = software.amazon.jsii.Kernel.get(this, "eventBusArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.eventBusArn = java.util.Objects.requireNonNull(builder.eventBusArn, "eventBusArn is required");
            }

            @Override
            public final java.lang.String getEventBusArn() {
                return this.eventBusArn;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("eventBusArn", om.valueToTree(this.getEventBusArn()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_ses.CfnConfigurationSetEventDestination.EventBridgeDestinationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                EventBridgeDestinationProperty.Jsii$Proxy that = (EventBridgeDestinationProperty.Jsii$Proxy) o;

                return this.eventBusArn.equals(that.eventBusArn);
            }

            @Override
            public final int hashCode() {
                int result = this.eventBusArn.hashCode();
                return result;
            }
        }
    }
    /**
     * In the Amazon SES API v2, <em>events</em> include message sends, deliveries, opens, clicks, bounces, complaints and delivery delays.
     * <p>
     * <em>Event destinations</em> are places that you can send information about these events to. For example, you can send event data to Amazon SNS to receive notifications when you receive bounces or complaints, or you can use Amazon Kinesis Data Firehose to stream data to Amazon S3 for long-term storage.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.ses.*;
     * EventDestinationProperty eventDestinationProperty = EventDestinationProperty.builder()
     *         .matchingEventTypes(List.of("matchingEventTypes"))
     *         // the properties below are optional
     *         .cloudWatchDestination(CloudWatchDestinationProperty.builder()
     *                 .dimensionConfigurations(List.of(DimensionConfigurationProperty.builder()
     *                         .defaultDimensionValue("defaultDimensionValue")
     *                         .dimensionName("dimensionName")
     *                         .dimensionValueSource("dimensionValueSource")
     *                         .build()))
     *                 .build())
     *         .enabled(false)
     *         .eventBridgeDestination(EventBridgeDestinationProperty.builder()
     *                 .eventBusArn("eventBusArn")
     *                 .build())
     *         .kinesisFirehoseDestination(KinesisFirehoseDestinationProperty.builder()
     *                 .deliveryStreamArn("deliveryStreamArn")
     *                 .iamRoleArn("iamRoleArn")
     *                 .build())
     *         .name("name")
     *         .snsDestination(SnsDestinationProperty.builder()
     *                 .topicArn("topicArn")
     *                 .build())
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ses-configurationseteventdestination-eventdestination.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ses-configurationseteventdestination-eventdestination.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_ses.CfnConfigurationSetEventDestination.EventDestinationProperty")
    @software.amazon.jsii.Jsii.Proxy(EventDestinationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface EventDestinationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The types of events that Amazon SES sends to the specified event destinations.
         * <p>
         * <ul>
         * <li><code>SEND</code> - The send request was successful and SES will attempt to deliver the message to the recipient’s mail server. (If account-level or global suppression is being used, SES will still count it as a send, but delivery is suppressed.)</li>
         * <li><code>REJECT</code> - SES accepted the email, but determined that it contained a virus and didn’t attempt to deliver it to the recipient’s mail server.</li>
         * <li><code>BOUNCE</code> - ( <em>Hard bounce</em> ) The recipient's mail server permanently rejected the email. ( <em>Soft bounces</em> are only included when SES fails to deliver the email after retrying for a period of time.)</li>
         * <li><code>COMPLAINT</code> - The email was successfully delivered to the recipient’s mail server, but the recipient marked it as spam.</li>
         * <li><code>DELIVERY</code> - SES successfully delivered the email to the recipient's mail server.</li>
         * <li><code>OPEN</code> - The recipient received the message and opened it in their email client.</li>
         * <li><code>CLICK</code> - The recipient clicked one or more links in the email.</li>
         * <li><code>RENDERING_FAILURE</code> - The email wasn't sent because of a template rendering issue. This event type can occur when template data is missing, or when there is a mismatch between template parameters and data. (This event type only occurs when you send email using the <a href="https://docs.aws.amazon.com/ses/latest/APIReference/API_SendTemplatedEmail.html"><code>SendTemplatedEmail</code></a> or <a href="https://docs.aws.amazon.com/ses/latest/APIReference/API_SendBulkTemplatedEmail.html"><code>SendBulkTemplatedEmail</code></a> API operations.)</li>
         * <li><code>DELIVERY_DELAY</code> - The email couldn't be delivered to the recipient’s mail server because a temporary issue occurred. Delivery delays can occur, for example, when the recipient's inbox is full, or when the receiving email server experiences a transient issue.</li>
         * <li><code>SUBSCRIPTION</code> - The email was successfully delivered, but the recipient updated their subscription preferences by clicking on an <em>unsubscribe</em> link as part of your <a href="https://docs.aws.amazon.com/ses/latest/dg/sending-email-subscription-management.html">subscription management</a> .</li>
         * </ul>
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ses-configurationseteventdestination-eventdestination.html#cfn-ses-configurationseteventdestination-eventdestination-matchingeventtypes">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ses-configurationseteventdestination-eventdestination.html#cfn-ses-configurationseteventdestination-eventdestination-matchingeventtypes</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.util.List<java.lang.String> getMatchingEventTypes();

        /**
         * An object that defines an Amazon CloudWatch destination for email events.
         * <p>
         * You can use Amazon CloudWatch to monitor and gain insights on your email sending metrics.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ses-configurationseteventdestination-eventdestination.html#cfn-ses-configurationseteventdestination-eventdestination-cloudwatchdestination">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ses-configurationseteventdestination-eventdestination.html#cfn-ses-configurationseteventdestination-eventdestination-cloudwatchdestination</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getCloudWatchDestination() {
            return null;
        }

        /**
         * If <code>true</code> , the event destination is enabled.
         * <p>
         * When the event destination is enabled, the specified event types are sent to the destinations in this <code>EventDestinationDefinition</code> .
         * <p>
         * If <code>false</code> , the event destination is disabled. When the event destination is disabled, events aren't sent to the specified destinations.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ses-configurationseteventdestination-eventdestination.html#cfn-ses-configurationseteventdestination-eventdestination-enabled">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ses-configurationseteventdestination-eventdestination.html#cfn-ses-configurationseteventdestination-eventdestination-enabled</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getEnabled() {
            return null;
        }

        /**
         * An object that defines an Amazon EventBridge destination for email events.
         * <p>
         * You can use Amazon EventBridge to send notifications when certain email events occur.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ses-configurationseteventdestination-eventdestination.html#cfn-ses-configurationseteventdestination-eventdestination-eventbridgedestination">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ses-configurationseteventdestination-eventdestination.html#cfn-ses-configurationseteventdestination-eventdestination-eventbridgedestination</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getEventBridgeDestination() {
            return null;
        }

        /**
         * An object that contains the delivery stream ARN and the IAM role ARN associated with an Amazon Kinesis Firehose event destination.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ses-configurationseteventdestination-eventdestination.html#cfn-ses-configurationseteventdestination-eventdestination-kinesisfirehosedestination">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ses-configurationseteventdestination-eventdestination.html#cfn-ses-configurationseteventdestination-eventdestination-kinesisfirehosedestination</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getKinesisFirehoseDestination() {
            return null;
        }

        /**
         * The name of the event destination. The name must meet the following requirements:.
         * <p>
         * <ul>
         * <li>Contain only ASCII letters (a-z, A-Z), numbers (0-9), underscores (_), or dashes (-).</li>
         * <li>Contain 64 characters or fewer.</li>
         * </ul>
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ses-configurationseteventdestination-eventdestination.html#cfn-ses-configurationseteventdestination-eventdestination-name">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ses-configurationseteventdestination-eventdestination.html#cfn-ses-configurationseteventdestination-eventdestination-name</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getName() {
            return null;
        }

        /**
         * An object that contains the topic ARN associated with an Amazon Simple Notification Service (Amazon SNS) event destination.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ses-configurationseteventdestination-eventdestination.html#cfn-ses-configurationseteventdestination-eventdestination-snsdestination">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ses-configurationseteventdestination-eventdestination.html#cfn-ses-configurationseteventdestination-eventdestination-snsdestination</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getSnsDestination() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link EventDestinationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link EventDestinationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<EventDestinationProperty> {
            java.util.List<java.lang.String> matchingEventTypes;
            java.lang.Object cloudWatchDestination;
            java.lang.Object enabled;
            java.lang.Object eventBridgeDestination;
            java.lang.Object kinesisFirehoseDestination;
            java.lang.String name;
            java.lang.Object snsDestination;

            /**
             * Sets the value of {@link EventDestinationProperty#getMatchingEventTypes}
             * @param matchingEventTypes The types of events that Amazon SES sends to the specified event destinations. This parameter is required.
             *                           <ul>
             *                           <li><code>SEND</code> - The send request was successful and SES will attempt to deliver the message to the recipient’s mail server. (If account-level or global suppression is being used, SES will still count it as a send, but delivery is suppressed.)</li>
             *                           <li><code>REJECT</code> - SES accepted the email, but determined that it contained a virus and didn’t attempt to deliver it to the recipient’s mail server.</li>
             *                           <li><code>BOUNCE</code> - ( <em>Hard bounce</em> ) The recipient's mail server permanently rejected the email. ( <em>Soft bounces</em> are only included when SES fails to deliver the email after retrying for a period of time.)</li>
             *                           <li><code>COMPLAINT</code> - The email was successfully delivered to the recipient’s mail server, but the recipient marked it as spam.</li>
             *                           <li><code>DELIVERY</code> - SES successfully delivered the email to the recipient's mail server.</li>
             *                           <li><code>OPEN</code> - The recipient received the message and opened it in their email client.</li>
             *                           <li><code>CLICK</code> - The recipient clicked one or more links in the email.</li>
             *                           <li><code>RENDERING_FAILURE</code> - The email wasn't sent because of a template rendering issue. This event type can occur when template data is missing, or when there is a mismatch between template parameters and data. (This event type only occurs when you send email using the <a href="https://docs.aws.amazon.com/ses/latest/APIReference/API_SendTemplatedEmail.html"><code>SendTemplatedEmail</code></a> or <a href="https://docs.aws.amazon.com/ses/latest/APIReference/API_SendBulkTemplatedEmail.html"><code>SendBulkTemplatedEmail</code></a> API operations.)</li>
             *                           <li><code>DELIVERY_DELAY</code> - The email couldn't be delivered to the recipient’s mail server because a temporary issue occurred. Delivery delays can occur, for example, when the recipient's inbox is full, or when the receiving email server experiences a transient issue.</li>
             *                           <li><code>SUBSCRIPTION</code> - The email was successfully delivered, but the recipient updated their subscription preferences by clicking on an <em>unsubscribe</em> link as part of your <a href="https://docs.aws.amazon.com/ses/latest/dg/sending-email-subscription-management.html">subscription management</a> .</li>
             *                           </ul>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder matchingEventTypes(java.util.List<java.lang.String> matchingEventTypes) {
                this.matchingEventTypes = matchingEventTypes;
                return this;
            }

            /**
             * Sets the value of {@link EventDestinationProperty#getCloudWatchDestination}
             * @param cloudWatchDestination An object that defines an Amazon CloudWatch destination for email events.
             *                              You can use Amazon CloudWatch to monitor and gain insights on your email sending metrics.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder cloudWatchDestination(software.amazon.awscdk.IResolvable cloudWatchDestination) {
                this.cloudWatchDestination = cloudWatchDestination;
                return this;
            }

            /**
             * Sets the value of {@link EventDestinationProperty#getCloudWatchDestination}
             * @param cloudWatchDestination An object that defines an Amazon CloudWatch destination for email events.
             *                              You can use Amazon CloudWatch to monitor and gain insights on your email sending metrics.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder cloudWatchDestination(software.amazon.awscdk.services.ses.CfnConfigurationSetEventDestination.CloudWatchDestinationProperty cloudWatchDestination) {
                this.cloudWatchDestination = cloudWatchDestination;
                return this;
            }

            /**
             * Sets the value of {@link EventDestinationProperty#getEnabled}
             * @param enabled If <code>true</code> , the event destination is enabled.
             *                When the event destination is enabled, the specified event types are sent to the destinations in this <code>EventDestinationDefinition</code> .
             *                <p>
             *                If <code>false</code> , the event destination is disabled. When the event destination is disabled, events aren't sent to the specified destinations.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder enabled(java.lang.Boolean enabled) {
                this.enabled = enabled;
                return this;
            }

            /**
             * Sets the value of {@link EventDestinationProperty#getEnabled}
             * @param enabled If <code>true</code> , the event destination is enabled.
             *                When the event destination is enabled, the specified event types are sent to the destinations in this <code>EventDestinationDefinition</code> .
             *                <p>
             *                If <code>false</code> , the event destination is disabled. When the event destination is disabled, events aren't sent to the specified destinations.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder enabled(software.amazon.awscdk.IResolvable enabled) {
                this.enabled = enabled;
                return this;
            }

            /**
             * Sets the value of {@link EventDestinationProperty#getEventBridgeDestination}
             * @param eventBridgeDestination An object that defines an Amazon EventBridge destination for email events.
             *                               You can use Amazon EventBridge to send notifications when certain email events occur.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder eventBridgeDestination(software.amazon.awscdk.IResolvable eventBridgeDestination) {
                this.eventBridgeDestination = eventBridgeDestination;
                return this;
            }

            /**
             * Sets the value of {@link EventDestinationProperty#getEventBridgeDestination}
             * @param eventBridgeDestination An object that defines an Amazon EventBridge destination for email events.
             *                               You can use Amazon EventBridge to send notifications when certain email events occur.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder eventBridgeDestination(software.amazon.awscdk.services.ses.CfnConfigurationSetEventDestination.EventBridgeDestinationProperty eventBridgeDestination) {
                this.eventBridgeDestination = eventBridgeDestination;
                return this;
            }

            /**
             * Sets the value of {@link EventDestinationProperty#getKinesisFirehoseDestination}
             * @param kinesisFirehoseDestination An object that contains the delivery stream ARN and the IAM role ARN associated with an Amazon Kinesis Firehose event destination.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder kinesisFirehoseDestination(software.amazon.awscdk.IResolvable kinesisFirehoseDestination) {
                this.kinesisFirehoseDestination = kinesisFirehoseDestination;
                return this;
            }

            /**
             * Sets the value of {@link EventDestinationProperty#getKinesisFirehoseDestination}
             * @param kinesisFirehoseDestination An object that contains the delivery stream ARN and the IAM role ARN associated with an Amazon Kinesis Firehose event destination.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder kinesisFirehoseDestination(software.amazon.awscdk.services.ses.CfnConfigurationSetEventDestination.KinesisFirehoseDestinationProperty kinesisFirehoseDestination) {
                this.kinesisFirehoseDestination = kinesisFirehoseDestination;
                return this;
            }

            /**
             * Sets the value of {@link EventDestinationProperty#getName}
             * @param name The name of the event destination. The name must meet the following requirements:.
             *             <ul>
             *             <li>Contain only ASCII letters (a-z, A-Z), numbers (0-9), underscores (_), or dashes (-).</li>
             *             <li>Contain 64 characters or fewer.</li>
             *             </ul>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder name(java.lang.String name) {
                this.name = name;
                return this;
            }

            /**
             * Sets the value of {@link EventDestinationProperty#getSnsDestination}
             * @param snsDestination An object that contains the topic ARN associated with an Amazon Simple Notification Service (Amazon SNS) event destination.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder snsDestination(software.amazon.awscdk.IResolvable snsDestination) {
                this.snsDestination = snsDestination;
                return this;
            }

            /**
             * Sets the value of {@link EventDestinationProperty#getSnsDestination}
             * @param snsDestination An object that contains the topic ARN associated with an Amazon Simple Notification Service (Amazon SNS) event destination.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder snsDestination(software.amazon.awscdk.services.ses.CfnConfigurationSetEventDestination.SnsDestinationProperty snsDestination) {
                this.snsDestination = snsDestination;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link EventDestinationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public EventDestinationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link EventDestinationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements EventDestinationProperty {
            private final java.util.List<java.lang.String> matchingEventTypes;
            private final java.lang.Object cloudWatchDestination;
            private final java.lang.Object enabled;
            private final java.lang.Object eventBridgeDestination;
            private final java.lang.Object kinesisFirehoseDestination;
            private final java.lang.String name;
            private final java.lang.Object snsDestination;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.matchingEventTypes = software.amazon.jsii.Kernel.get(this, "matchingEventTypes", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
                this.cloudWatchDestination = software.amazon.jsii.Kernel.get(this, "cloudWatchDestination", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.enabled = software.amazon.jsii.Kernel.get(this, "enabled", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.eventBridgeDestination = software.amazon.jsii.Kernel.get(this, "eventBridgeDestination", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.kinesisFirehoseDestination = software.amazon.jsii.Kernel.get(this, "kinesisFirehoseDestination", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.name = software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.snsDestination = software.amazon.jsii.Kernel.get(this, "snsDestination", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.matchingEventTypes = java.util.Objects.requireNonNull(builder.matchingEventTypes, "matchingEventTypes is required");
                this.cloudWatchDestination = builder.cloudWatchDestination;
                this.enabled = builder.enabled;
                this.eventBridgeDestination = builder.eventBridgeDestination;
                this.kinesisFirehoseDestination = builder.kinesisFirehoseDestination;
                this.name = builder.name;
                this.snsDestination = builder.snsDestination;
            }

            @Override
            public final java.util.List<java.lang.String> getMatchingEventTypes() {
                return this.matchingEventTypes;
            }

            @Override
            public final java.lang.Object getCloudWatchDestination() {
                return this.cloudWatchDestination;
            }

            @Override
            public final java.lang.Object getEnabled() {
                return this.enabled;
            }

            @Override
            public final java.lang.Object getEventBridgeDestination() {
                return this.eventBridgeDestination;
            }

            @Override
            public final java.lang.Object getKinesisFirehoseDestination() {
                return this.kinesisFirehoseDestination;
            }

            @Override
            public final java.lang.String getName() {
                return this.name;
            }

            @Override
            public final java.lang.Object getSnsDestination() {
                return this.snsDestination;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("matchingEventTypes", om.valueToTree(this.getMatchingEventTypes()));
                if (this.getCloudWatchDestination() != null) {
                    data.set("cloudWatchDestination", om.valueToTree(this.getCloudWatchDestination()));
                }
                if (this.getEnabled() != null) {
                    data.set("enabled", om.valueToTree(this.getEnabled()));
                }
                if (this.getEventBridgeDestination() != null) {
                    data.set("eventBridgeDestination", om.valueToTree(this.getEventBridgeDestination()));
                }
                if (this.getKinesisFirehoseDestination() != null) {
                    data.set("kinesisFirehoseDestination", om.valueToTree(this.getKinesisFirehoseDestination()));
                }
                if (this.getName() != null) {
                    data.set("name", om.valueToTree(this.getName()));
                }
                if (this.getSnsDestination() != null) {
                    data.set("snsDestination", om.valueToTree(this.getSnsDestination()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_ses.CfnConfigurationSetEventDestination.EventDestinationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                EventDestinationProperty.Jsii$Proxy that = (EventDestinationProperty.Jsii$Proxy) o;

                if (!matchingEventTypes.equals(that.matchingEventTypes)) return false;
                if (this.cloudWatchDestination != null ? !this.cloudWatchDestination.equals(that.cloudWatchDestination) : that.cloudWatchDestination != null) return false;
                if (this.enabled != null ? !this.enabled.equals(that.enabled) : that.enabled != null) return false;
                if (this.eventBridgeDestination != null ? !this.eventBridgeDestination.equals(that.eventBridgeDestination) : that.eventBridgeDestination != null) return false;
                if (this.kinesisFirehoseDestination != null ? !this.kinesisFirehoseDestination.equals(that.kinesisFirehoseDestination) : that.kinesisFirehoseDestination != null) return false;
                if (this.name != null ? !this.name.equals(that.name) : that.name != null) return false;
                return this.snsDestination != null ? this.snsDestination.equals(that.snsDestination) : that.snsDestination == null;
            }

            @Override
            public final int hashCode() {
                int result = this.matchingEventTypes.hashCode();
                result = 31 * result + (this.cloudWatchDestination != null ? this.cloudWatchDestination.hashCode() : 0);
                result = 31 * result + (this.enabled != null ? this.enabled.hashCode() : 0);
                result = 31 * result + (this.eventBridgeDestination != null ? this.eventBridgeDestination.hashCode() : 0);
                result = 31 * result + (this.kinesisFirehoseDestination != null ? this.kinesisFirehoseDestination.hashCode() : 0);
                result = 31 * result + (this.name != null ? this.name.hashCode() : 0);
                result = 31 * result + (this.snsDestination != null ? this.snsDestination.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * An object that defines an Amazon Kinesis Data Firehose destination for email events.
     * <p>
     * You can use Amazon Kinesis Data Firehose to stream data to other services, such as Amazon S3 and Amazon Redshift.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.ses.*;
     * KinesisFirehoseDestinationProperty kinesisFirehoseDestinationProperty = KinesisFirehoseDestinationProperty.builder()
     *         .deliveryStreamArn("deliveryStreamArn")
     *         .iamRoleArn("iamRoleArn")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ses-configurationseteventdestination-kinesisfirehosedestination.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ses-configurationseteventdestination-kinesisfirehosedestination.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_ses.CfnConfigurationSetEventDestination.KinesisFirehoseDestinationProperty")
    @software.amazon.jsii.Jsii.Proxy(KinesisFirehoseDestinationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface KinesisFirehoseDestinationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The ARN of the Amazon Kinesis Firehose stream that email sending events should be published to.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ses-configurationseteventdestination-kinesisfirehosedestination.html#cfn-ses-configurationseteventdestination-kinesisfirehosedestination-deliverystreamarn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ses-configurationseteventdestination-kinesisfirehosedestination.html#cfn-ses-configurationseteventdestination-kinesisfirehosedestination-deliverystreamarn</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getDeliveryStreamArn();

        /**
         * The Amazon Resource Name (ARN) of the IAM role that the Amazon SES API v2 uses to send email events to the Amazon Kinesis Data Firehose stream.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ses-configurationseteventdestination-kinesisfirehosedestination.html#cfn-ses-configurationseteventdestination-kinesisfirehosedestination-iamrolearn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ses-configurationseteventdestination-kinesisfirehosedestination.html#cfn-ses-configurationseteventdestination-kinesisfirehosedestination-iamrolearn</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getIamRoleArn();

        /**
         * @return a {@link Builder} of {@link KinesisFirehoseDestinationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link KinesisFirehoseDestinationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<KinesisFirehoseDestinationProperty> {
            java.lang.String deliveryStreamArn;
            java.lang.String iamRoleArn;

            /**
             * Sets the value of {@link KinesisFirehoseDestinationProperty#getDeliveryStreamArn}
             * @param deliveryStreamArn The ARN of the Amazon Kinesis Firehose stream that email sending events should be published to. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder deliveryStreamArn(java.lang.String deliveryStreamArn) {
                this.deliveryStreamArn = deliveryStreamArn;
                return this;
            }

            /**
             * Sets the value of {@link KinesisFirehoseDestinationProperty#getIamRoleArn}
             * @param iamRoleArn The Amazon Resource Name (ARN) of the IAM role that the Amazon SES API v2 uses to send email events to the Amazon Kinesis Data Firehose stream. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder iamRoleArn(java.lang.String iamRoleArn) {
                this.iamRoleArn = iamRoleArn;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link KinesisFirehoseDestinationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public KinesisFirehoseDestinationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link KinesisFirehoseDestinationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements KinesisFirehoseDestinationProperty {
            private final java.lang.String deliveryStreamArn;
            private final java.lang.String iamRoleArn;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.deliveryStreamArn = software.amazon.jsii.Kernel.get(this, "deliveryStreamArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.iamRoleArn = software.amazon.jsii.Kernel.get(this, "iamRoleArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.deliveryStreamArn = java.util.Objects.requireNonNull(builder.deliveryStreamArn, "deliveryStreamArn is required");
                this.iamRoleArn = java.util.Objects.requireNonNull(builder.iamRoleArn, "iamRoleArn is required");
            }

            @Override
            public final java.lang.String getDeliveryStreamArn() {
                return this.deliveryStreamArn;
            }

            @Override
            public final java.lang.String getIamRoleArn() {
                return this.iamRoleArn;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("deliveryStreamArn", om.valueToTree(this.getDeliveryStreamArn()));
                data.set("iamRoleArn", om.valueToTree(this.getIamRoleArn()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_ses.CfnConfigurationSetEventDestination.KinesisFirehoseDestinationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                KinesisFirehoseDestinationProperty.Jsii$Proxy that = (KinesisFirehoseDestinationProperty.Jsii$Proxy) o;

                if (!deliveryStreamArn.equals(that.deliveryStreamArn)) return false;
                return this.iamRoleArn.equals(that.iamRoleArn);
            }

            @Override
            public final int hashCode() {
                int result = this.deliveryStreamArn.hashCode();
                result = 31 * result + (this.iamRoleArn.hashCode());
                return result;
            }
        }
    }
    /**
     * Contains the topic ARN associated with an Amazon Simple Notification Service (Amazon SNS) event destination.
     * <p>
     * Event destinations, such as Amazon SNS, are associated with configuration sets, which enable you to publish email sending events. For information about using configuration sets, see the <a href="https://docs.aws.amazon.com/ses/latest/dg/monitor-sending-activity.html">Amazon SES Developer Guide</a> .
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.ses.*;
     * SnsDestinationProperty snsDestinationProperty = SnsDestinationProperty.builder()
     *         .topicArn("topicArn")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ses-configurationseteventdestination-snsdestination.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ses-configurationseteventdestination-snsdestination.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_ses.CfnConfigurationSetEventDestination.SnsDestinationProperty")
    @software.amazon.jsii.Jsii.Proxy(SnsDestinationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface SnsDestinationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The ARN of the Amazon SNS topic for email sending events.
         * <p>
         * You can find the ARN of a topic by using the <a href="https://docs.aws.amazon.com/sns/latest/api/API_ListTopics.html">ListTopics</a> Amazon SNS operation.
         * <p>
         * For more information about Amazon SNS topics, see the <a href="https://docs.aws.amazon.com/sns/latest/dg/CreateTopic.html">Amazon SNS Developer Guide</a> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ses-configurationseteventdestination-snsdestination.html#cfn-ses-configurationseteventdestination-snsdestination-topicarn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ses-configurationseteventdestination-snsdestination.html#cfn-ses-configurationseteventdestination-snsdestination-topicarn</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getTopicArn();

        /**
         * @return a {@link Builder} of {@link SnsDestinationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link SnsDestinationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<SnsDestinationProperty> {
            java.lang.String topicArn;

            /**
             * Sets the value of {@link SnsDestinationProperty#getTopicArn}
             * @param topicArn The ARN of the Amazon SNS topic for email sending events. This parameter is required.
             *                 You can find the ARN of a topic by using the <a href="https://docs.aws.amazon.com/sns/latest/api/API_ListTopics.html">ListTopics</a> Amazon SNS operation.
             *                 <p>
             *                 For more information about Amazon SNS topics, see the <a href="https://docs.aws.amazon.com/sns/latest/dg/CreateTopic.html">Amazon SNS Developer Guide</a> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder topicArn(java.lang.String topicArn) {
                this.topicArn = topicArn;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link SnsDestinationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public SnsDestinationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link SnsDestinationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements SnsDestinationProperty {
            private final java.lang.String topicArn;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.topicArn = software.amazon.jsii.Kernel.get(this, "topicArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.topicArn = java.util.Objects.requireNonNull(builder.topicArn, "topicArn is required");
            }

            @Override
            public final java.lang.String getTopicArn() {
                return this.topicArn;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("topicArn", om.valueToTree(this.getTopicArn()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_ses.CfnConfigurationSetEventDestination.SnsDestinationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                SnsDestinationProperty.Jsii$Proxy that = (SnsDestinationProperty.Jsii$Proxy) o;

                return this.topicArn.equals(that.topicArn);
            }

            @Override
            public final int hashCode() {
                int result = this.topicArn.hashCode();
                return result;
            }
        }
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.ses.CfnConfigurationSetEventDestination}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.ses.CfnConfigurationSetEventDestination> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope Scope in which this resource is defined. This parameter is required.
         * @param id Construct identifier for this resource (unique in its scope). This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.ses.CfnConfigurationSetEventDestinationProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.services.ses.CfnConfigurationSetEventDestinationProps.Builder();
        }

        /**
         * The name of the configuration set that contains the event destination.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ses-configurationseteventdestination.html#cfn-ses-configurationseteventdestination-configurationsetname">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ses-configurationseteventdestination.html#cfn-ses-configurationseteventdestination-configurationsetname</a>
         * @param configurationSetName The name of the configuration set that contains the event destination. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder configurationSetName(final java.lang.String configurationSetName) {
            this.props.configurationSetName(configurationSetName);
            return this;
        }

        /**
         * An object that defines the event destination.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ses-configurationseteventdestination.html#cfn-ses-configurationseteventdestination-eventdestination">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ses-configurationseteventdestination.html#cfn-ses-configurationseteventdestination-eventdestination</a>
         * @param eventDestination An object that defines the event destination. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder eventDestination(final software.amazon.awscdk.IResolvable eventDestination) {
            this.props.eventDestination(eventDestination);
            return this;
        }
        /**
         * An object that defines the event destination.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ses-configurationseteventdestination.html#cfn-ses-configurationseteventdestination-eventdestination">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ses-configurationseteventdestination.html#cfn-ses-configurationseteventdestination-eventdestination</a>
         * @param eventDestination An object that defines the event destination. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder eventDestination(final software.amazon.awscdk.services.ses.CfnConfigurationSetEventDestination.EventDestinationProperty eventDestination) {
            this.props.eventDestination(eventDestination);
            return this;
        }

        /**
         * @return a newly built instance of {@link software.amazon.awscdk.services.ses.CfnConfigurationSetEventDestination}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.ses.CfnConfigurationSetEventDestination build() {
            return new software.amazon.awscdk.services.ses.CfnConfigurationSetEventDestination(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
