package software.amazon.awscdk.services.ssm;

/**
 * Common attributes for string parameters.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.ssm.*;
 * CommonStringParameterAttributes commonStringParameterAttributes = CommonStringParameterAttributes.builder()
 *         .parameterName("parameterName")
 *         // the properties below are optional
 *         .simpleName(false)
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.106.0 (build e852934)", date = "2025-03-12T01:36:46.209Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_ssm.CommonStringParameterAttributes")
@software.amazon.jsii.Jsii.Proxy(CommonStringParameterAttributes.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CommonStringParameterAttributes extends software.amazon.jsii.JsiiSerializable {

    /**
     * The name of the parameter store value.
     * <p>
     * This value can be a token or a concrete string. If it is a concrete string
     * and includes "/" it must also be prefixed with a "/" (fully-qualified).
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getParameterName();

    /**
     * Indicates whether the parameter name is a simple name.
     * <p>
     * A parameter name
     * without any "/" is considered a simple name. If the parameter name includes
     * "/", setting simpleName to true might cause unintended issues such
     * as duplicate "/" in the resulting ARN.
     * <p>
     * This is required only if <code>parameterName</code> is a token, which means we
     * are unable to detect if the name is simple or "path-like" for the purpose
     * of rendering SSM parameter ARNs.
     * <p>
     * If <code>parameterName</code> is not specified, <code>simpleName</code> must be <code>true</code> (or
     * undefined) since the name generated by AWS CloudFormation is always a
     * simple name.
     * <p>
     * Default: - auto-detect based on `parameterName`
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getSimpleName() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CommonStringParameterAttributes}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CommonStringParameterAttributes}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CommonStringParameterAttributes> {
        java.lang.String parameterName;
        java.lang.Boolean simpleName;

        /**
         * Sets the value of {@link CommonStringParameterAttributes#getParameterName}
         * @param parameterName The name of the parameter store value. This parameter is required.
         *                      This value can be a token or a concrete string. If it is a concrete string
         *                      and includes "/" it must also be prefixed with a "/" (fully-qualified).
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder parameterName(java.lang.String parameterName) {
            this.parameterName = parameterName;
            return this;
        }

        /**
         * Sets the value of {@link CommonStringParameterAttributes#getSimpleName}
         * @param simpleName Indicates whether the parameter name is a simple name.
         *                   A parameter name
         *                   without any "/" is considered a simple name. If the parameter name includes
         *                   "/", setting simpleName to true might cause unintended issues such
         *                   as duplicate "/" in the resulting ARN.
         *                   <p>
         *                   This is required only if <code>parameterName</code> is a token, which means we
         *                   are unable to detect if the name is simple or "path-like" for the purpose
         *                   of rendering SSM parameter ARNs.
         *                   <p>
         *                   If <code>parameterName</code> is not specified, <code>simpleName</code> must be <code>true</code> (or
         *                   undefined) since the name generated by AWS CloudFormation is always a
         *                   simple name.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder simpleName(java.lang.Boolean simpleName) {
            this.simpleName = simpleName;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CommonStringParameterAttributes}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CommonStringParameterAttributes build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CommonStringParameterAttributes}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CommonStringParameterAttributes {
        private final java.lang.String parameterName;
        private final java.lang.Boolean simpleName;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.parameterName = software.amazon.jsii.Kernel.get(this, "parameterName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.simpleName = software.amazon.jsii.Kernel.get(this, "simpleName", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.parameterName = java.util.Objects.requireNonNull(builder.parameterName, "parameterName is required");
            this.simpleName = builder.simpleName;
        }

        @Override
        public final java.lang.String getParameterName() {
            return this.parameterName;
        }

        @Override
        public final java.lang.Boolean getSimpleName() {
            return this.simpleName;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("parameterName", om.valueToTree(this.getParameterName()));
            if (this.getSimpleName() != null) {
                data.set("simpleName", om.valueToTree(this.getSimpleName()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_ssm.CommonStringParameterAttributes"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CommonStringParameterAttributes.Jsii$Proxy that = (CommonStringParameterAttributes.Jsii$Proxy) o;

            if (!parameterName.equals(that.parameterName)) return false;
            return this.simpleName != null ? this.simpleName.equals(that.simpleName) : that.simpleName == null;
        }

        @Override
        public final int hashCode() {
            int result = this.parameterName.hashCode();
            result = 31 * result + (this.simpleName != null ? this.simpleName.hashCode() : 0);
            return result;
        }
    }
}
