package software.amazon.awscdk.services.stepfunctions;

/**
 * Properties for configuring a Distribute Map state that using JSONPath.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.stepfunctions.*;
 * Object assign;
 * ItemBatcher itemBatcher;
 * IItemReader itemReader;
 * Object itemSelector;
 * Object resultSelector;
 * ResultWriter resultWriter;
 * DistributedMapJsonPathProps distributedMapJsonPathProps = DistributedMapJsonPathProps.builder()
 *         .assign(Map.of(
 *                 "assignKey", assign))
 *         .comment("comment")
 *         .inputPath("inputPath")
 *         .itemBatcher(itemBatcher)
 *         .itemReader(itemReader)
 *         .itemSelector(Map.of(
 *                 "itemSelectorKey", itemSelector))
 *         .itemsPath("itemsPath")
 *         .label("label")
 *         .mapExecutionType(StateMachineType.EXPRESS)
 *         .maxConcurrency(123)
 *         .maxConcurrencyPath("maxConcurrencyPath")
 *         .outputPath("outputPath")
 *         .queryLanguage(QueryLanguage.JSON_PATH)
 *         .resultPath("resultPath")
 *         .resultSelector(Map.of(
 *                 "resultSelectorKey", resultSelector))
 *         .resultWriter(resultWriter)
 *         .stateName("stateName")
 *         .toleratedFailureCount(123)
 *         .toleratedFailureCountPath("toleratedFailureCountPath")
 *         .toleratedFailurePercentage(123)
 *         .toleratedFailurePercentagePath("toleratedFailurePercentagePath")
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.106.0 (build e852934)", date = "2025-03-12T01:36:46.357Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_stepfunctions.DistributedMapJsonPathProps")
@software.amazon.jsii.Jsii.Proxy(DistributedMapJsonPathProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface DistributedMapJsonPathProps extends software.amazon.jsii.JsiiSerializable, software.amazon.awscdk.services.stepfunctions.StateBaseProps, software.amazon.awscdk.services.stepfunctions.MapBaseOptions, software.amazon.awscdk.services.stepfunctions.MapBaseJsonPathOptions {

    /**
     * Specifies to process a group of items in a single child workflow execution.
     * <p>
     * Default: - No itemBatcher
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.stepfunctions.ItemBatcher getItemBatcher() {
        return null;
    }

    /**
     * ItemReader.
     * <p>
     * Configuration for where to read items dataset in S3 to iterate
     * <p>
     * Default: - No itemReader
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.stepfunctions.IItemReader getItemReader() {
        return null;
    }

    /**
     * Label.
     * <p>
     * Unique name for the Distributed Map state added to each Map Run
     * <p>
     * Default: - No label
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getLabel() {
        return null;
    }

    /**
     * MapExecutionType.
     * <p>
     * The execution type of the distributed map state
     * <p>
     * This property overwrites ProcessorConfig.executionType
     * <p>
     * Default: StateMachineType.STANDARD
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.stepfunctions.StateMachineType getMapExecutionType() {
        return null;
    }

    /**
     * Configuration for S3 location in which to save Map Run results.
     * <p>
     * Default: - No resultWriter
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.stepfunctions.ResultWriter getResultWriter() {
        return null;
    }

    /**
     * ToleratedFailureCount.
     * <p>
     * Number of failed items to tolerate in a Map Run, as static number
     * <p>
     * Default: - No toleratedFailureCount
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Number getToleratedFailureCount() {
        return null;
    }

    /**
     * ToleratedFailureCountPath.
     * <p>
     * Number of failed items to tolerate in a Map Run, as JsonPath
     * <p>
     * Default: - No toleratedFailureCountPath
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getToleratedFailureCountPath() {
        return null;
    }

    /**
     * ToleratedFailurePercentage.
     * <p>
     * Percentage of failed items to tolerate in a Map Run, as static number
     * <p>
     * Default: - No toleratedFailurePercentage
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Number getToleratedFailurePercentage() {
        return null;
    }

    /**
     * ToleratedFailurePercentagePath.
     * <p>
     * Percentage of failed items to tolerate in a Map Run, as JsonPath
     * <p>
     * Default: - No toleratedFailurePercentagePath
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getToleratedFailurePercentagePath() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link DistributedMapJsonPathProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link DistributedMapJsonPathProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<DistributedMapJsonPathProps> {
        software.amazon.awscdk.services.stepfunctions.ItemBatcher itemBatcher;
        software.amazon.awscdk.services.stepfunctions.IItemReader itemReader;
        java.lang.String label;
        software.amazon.awscdk.services.stepfunctions.StateMachineType mapExecutionType;
        software.amazon.awscdk.services.stepfunctions.ResultWriter resultWriter;
        java.lang.Number toleratedFailureCount;
        java.lang.String toleratedFailureCountPath;
        java.lang.Number toleratedFailurePercentage;
        java.lang.String toleratedFailurePercentagePath;
        java.lang.String comment;
        software.amazon.awscdk.services.stepfunctions.QueryLanguage queryLanguage;
        java.lang.String stateName;
        java.util.Map<java.lang.String, java.lang.Object> itemSelector;
        java.lang.Number maxConcurrency;
        java.util.Map<java.lang.String, java.lang.Object> assign;
        java.lang.String itemsPath;
        java.lang.String maxConcurrencyPath;
        java.lang.String resultPath;
        java.util.Map<java.lang.String, java.lang.Object> resultSelector;
        java.lang.String inputPath;
        java.lang.String outputPath;

        /**
         * Sets the value of {@link DistributedMapJsonPathProps#getItemBatcher}
         * @param itemBatcher Specifies to process a group of items in a single child workflow execution.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder itemBatcher(software.amazon.awscdk.services.stepfunctions.ItemBatcher itemBatcher) {
            this.itemBatcher = itemBatcher;
            return this;
        }

        /**
         * Sets the value of {@link DistributedMapJsonPathProps#getItemReader}
         * @param itemReader ItemReader.
         *                   Configuration for where to read items dataset in S3 to iterate
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder itemReader(software.amazon.awscdk.services.stepfunctions.IItemReader itemReader) {
            this.itemReader = itemReader;
            return this;
        }

        /**
         * Sets the value of {@link DistributedMapJsonPathProps#getLabel}
         * @param label Label.
         *              Unique name for the Distributed Map state added to each Map Run
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder label(java.lang.String label) {
            this.label = label;
            return this;
        }

        /**
         * Sets the value of {@link DistributedMapJsonPathProps#getMapExecutionType}
         * @param mapExecutionType MapExecutionType.
         *                         The execution type of the distributed map state
         *                         <p>
         *                         This property overwrites ProcessorConfig.executionType
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder mapExecutionType(software.amazon.awscdk.services.stepfunctions.StateMachineType mapExecutionType) {
            this.mapExecutionType = mapExecutionType;
            return this;
        }

        /**
         * Sets the value of {@link DistributedMapJsonPathProps#getResultWriter}
         * @param resultWriter Configuration for S3 location in which to save Map Run results.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder resultWriter(software.amazon.awscdk.services.stepfunctions.ResultWriter resultWriter) {
            this.resultWriter = resultWriter;
            return this;
        }

        /**
         * Sets the value of {@link DistributedMapJsonPathProps#getToleratedFailureCount}
         * @param toleratedFailureCount ToleratedFailureCount.
         *                              Number of failed items to tolerate in a Map Run, as static number
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder toleratedFailureCount(java.lang.Number toleratedFailureCount) {
            this.toleratedFailureCount = toleratedFailureCount;
            return this;
        }

        /**
         * Sets the value of {@link DistributedMapJsonPathProps#getToleratedFailureCountPath}
         * @param toleratedFailureCountPath ToleratedFailureCountPath.
         *                                  Number of failed items to tolerate in a Map Run, as JsonPath
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder toleratedFailureCountPath(java.lang.String toleratedFailureCountPath) {
            this.toleratedFailureCountPath = toleratedFailureCountPath;
            return this;
        }

        /**
         * Sets the value of {@link DistributedMapJsonPathProps#getToleratedFailurePercentage}
         * @param toleratedFailurePercentage ToleratedFailurePercentage.
         *                                   Percentage of failed items to tolerate in a Map Run, as static number
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder toleratedFailurePercentage(java.lang.Number toleratedFailurePercentage) {
            this.toleratedFailurePercentage = toleratedFailurePercentage;
            return this;
        }

        /**
         * Sets the value of {@link DistributedMapJsonPathProps#getToleratedFailurePercentagePath}
         * @param toleratedFailurePercentagePath ToleratedFailurePercentagePath.
         *                                       Percentage of failed items to tolerate in a Map Run, as JsonPath
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder toleratedFailurePercentagePath(java.lang.String toleratedFailurePercentagePath) {
            this.toleratedFailurePercentagePath = toleratedFailurePercentagePath;
            return this;
        }

        /**
         * Sets the value of {@link DistributedMapJsonPathProps#getComment}
         * @param comment A comment describing this state.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder comment(java.lang.String comment) {
            this.comment = comment;
            return this;
        }

        /**
         * Sets the value of {@link DistributedMapJsonPathProps#getQueryLanguage}
         * @param queryLanguage The name of the query language used by the state.
         *                      If the state does not contain a <code>queryLanguage</code> field,
         *                      then it will use the query language specified in the top-level <code>queryLanguage</code> field.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder queryLanguage(software.amazon.awscdk.services.stepfunctions.QueryLanguage queryLanguage) {
            this.queryLanguage = queryLanguage;
            return this;
        }

        /**
         * Sets the value of {@link DistributedMapJsonPathProps#getStateName}
         * @param stateName Optional name for this state.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder stateName(java.lang.String stateName) {
            this.stateName = stateName;
            return this;
        }

        /**
         * Sets the value of {@link DistributedMapJsonPathProps#getItemSelector}
         * @param itemSelector The JSON that you want to override your default iteration input (mutually exclusive  with <code>parameters</code>).
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder itemSelector(java.util.Map<java.lang.String, ? extends java.lang.Object> itemSelector) {
            this.itemSelector = (java.util.Map<java.lang.String, java.lang.Object>)itemSelector;
            return this;
        }

        /**
         * Sets the value of {@link DistributedMapJsonPathProps#getMaxConcurrency}
         * @param maxConcurrency MaxConcurrency.
         *                       An upper bound on the number of iterations you want running at once.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder maxConcurrency(java.lang.Number maxConcurrency) {
            this.maxConcurrency = maxConcurrency;
            return this;
        }

        /**
         * Sets the value of {@link DistributedMapJsonPathProps#getAssign}
         * @param assign Workflow variables to store in this step.
         *               Using workflow variables, you can store data in a step and retrieve that data in future steps.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder assign(java.util.Map<java.lang.String, ? extends java.lang.Object> assign) {
            this.assign = (java.util.Map<java.lang.String, java.lang.Object>)assign;
            return this;
        }

        /**
         * Sets the value of {@link DistributedMapJsonPathProps#getItemsPath}
         * @param itemsPath JSONPath expression to select the array to iterate over.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder itemsPath(java.lang.String itemsPath) {
            this.itemsPath = itemsPath;
            return this;
        }

        /**
         * Sets the value of {@link DistributedMapJsonPathProps#getMaxConcurrencyPath}
         * @param maxConcurrencyPath MaxConcurrencyPath.
         *                           A JsonPath that specifies the maximum concurrency dynamically from the state input.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder maxConcurrencyPath(java.lang.String maxConcurrencyPath) {
            this.maxConcurrencyPath = maxConcurrencyPath;
            return this;
        }

        /**
         * Sets the value of {@link DistributedMapJsonPathProps#getResultPath}
         * @param resultPath JSONPath expression to indicate where to inject the state's output.
         *                   May also be the special value JsonPath.DISCARD, which will cause the state's
         *                   input to become its output.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder resultPath(java.lang.String resultPath) {
            this.resultPath = resultPath;
            return this;
        }

        /**
         * Sets the value of {@link DistributedMapJsonPathProps#getResultSelector}
         * @param resultSelector The JSON that will replace the state's raw result and become the effective result before ResultPath is applied.
         *                       You can use ResultSelector to create a payload with values that are static
         *                       or selected from the state's raw result.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder resultSelector(java.util.Map<java.lang.String, ? extends java.lang.Object> resultSelector) {
            this.resultSelector = (java.util.Map<java.lang.String, java.lang.Object>)resultSelector;
            return this;
        }

        /**
         * Sets the value of {@link DistributedMapJsonPathProps#getInputPath}
         * @param inputPath JSONPath expression to select part of the state to be the input to this state.
         *                  May also be the special value JsonPath.DISCARD, which will cause the effective
         *                  input to be the empty object {}.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder inputPath(java.lang.String inputPath) {
            this.inputPath = inputPath;
            return this;
        }

        /**
         * Sets the value of {@link DistributedMapJsonPathProps#getOutputPath}
         * @param outputPath JSONPath expression to select part of the state to be the output to this state.
         *                   May also be the special value JsonPath.DISCARD, which will cause the effective
         *                   output to be the empty object {}.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder outputPath(java.lang.String outputPath) {
            this.outputPath = outputPath;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link DistributedMapJsonPathProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public DistributedMapJsonPathProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link DistributedMapJsonPathProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements DistributedMapJsonPathProps {
        private final software.amazon.awscdk.services.stepfunctions.ItemBatcher itemBatcher;
        private final software.amazon.awscdk.services.stepfunctions.IItemReader itemReader;
        private final java.lang.String label;
        private final software.amazon.awscdk.services.stepfunctions.StateMachineType mapExecutionType;
        private final software.amazon.awscdk.services.stepfunctions.ResultWriter resultWriter;
        private final java.lang.Number toleratedFailureCount;
        private final java.lang.String toleratedFailureCountPath;
        private final java.lang.Number toleratedFailurePercentage;
        private final java.lang.String toleratedFailurePercentagePath;
        private final java.lang.String comment;
        private final software.amazon.awscdk.services.stepfunctions.QueryLanguage queryLanguage;
        private final java.lang.String stateName;
        private final java.util.Map<java.lang.String, java.lang.Object> itemSelector;
        private final java.lang.Number maxConcurrency;
        private final java.util.Map<java.lang.String, java.lang.Object> assign;
        private final java.lang.String itemsPath;
        private final java.lang.String maxConcurrencyPath;
        private final java.lang.String resultPath;
        private final java.util.Map<java.lang.String, java.lang.Object> resultSelector;
        private final java.lang.String inputPath;
        private final java.lang.String outputPath;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.itemBatcher = software.amazon.jsii.Kernel.get(this, "itemBatcher", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.stepfunctions.ItemBatcher.class));
            this.itemReader = software.amazon.jsii.Kernel.get(this, "itemReader", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.stepfunctions.IItemReader.class));
            this.label = software.amazon.jsii.Kernel.get(this, "label", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.mapExecutionType = software.amazon.jsii.Kernel.get(this, "mapExecutionType", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.stepfunctions.StateMachineType.class));
            this.resultWriter = software.amazon.jsii.Kernel.get(this, "resultWriter", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.stepfunctions.ResultWriter.class));
            this.toleratedFailureCount = software.amazon.jsii.Kernel.get(this, "toleratedFailureCount", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            this.toleratedFailureCountPath = software.amazon.jsii.Kernel.get(this, "toleratedFailureCountPath", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.toleratedFailurePercentage = software.amazon.jsii.Kernel.get(this, "toleratedFailurePercentage", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            this.toleratedFailurePercentagePath = software.amazon.jsii.Kernel.get(this, "toleratedFailurePercentagePath", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.comment = software.amazon.jsii.Kernel.get(this, "comment", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.queryLanguage = software.amazon.jsii.Kernel.get(this, "queryLanguage", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.stepfunctions.QueryLanguage.class));
            this.stateName = software.amazon.jsii.Kernel.get(this, "stateName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.itemSelector = software.amazon.jsii.Kernel.get(this, "itemSelector", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class)));
            this.maxConcurrency = software.amazon.jsii.Kernel.get(this, "maxConcurrency", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            this.assign = software.amazon.jsii.Kernel.get(this, "assign", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class)));
            this.itemsPath = software.amazon.jsii.Kernel.get(this, "itemsPath", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.maxConcurrencyPath = software.amazon.jsii.Kernel.get(this, "maxConcurrencyPath", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.resultPath = software.amazon.jsii.Kernel.get(this, "resultPath", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.resultSelector = software.amazon.jsii.Kernel.get(this, "resultSelector", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class)));
            this.inputPath = software.amazon.jsii.Kernel.get(this, "inputPath", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.outputPath = software.amazon.jsii.Kernel.get(this, "outputPath", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.itemBatcher = builder.itemBatcher;
            this.itemReader = builder.itemReader;
            this.label = builder.label;
            this.mapExecutionType = builder.mapExecutionType;
            this.resultWriter = builder.resultWriter;
            this.toleratedFailureCount = builder.toleratedFailureCount;
            this.toleratedFailureCountPath = builder.toleratedFailureCountPath;
            this.toleratedFailurePercentage = builder.toleratedFailurePercentage;
            this.toleratedFailurePercentagePath = builder.toleratedFailurePercentagePath;
            this.comment = builder.comment;
            this.queryLanguage = builder.queryLanguage;
            this.stateName = builder.stateName;
            this.itemSelector = (java.util.Map<java.lang.String, java.lang.Object>)builder.itemSelector;
            this.maxConcurrency = builder.maxConcurrency;
            this.assign = (java.util.Map<java.lang.String, java.lang.Object>)builder.assign;
            this.itemsPath = builder.itemsPath;
            this.maxConcurrencyPath = builder.maxConcurrencyPath;
            this.resultPath = builder.resultPath;
            this.resultSelector = (java.util.Map<java.lang.String, java.lang.Object>)builder.resultSelector;
            this.inputPath = builder.inputPath;
            this.outputPath = builder.outputPath;
        }

        @Override
        public final software.amazon.awscdk.services.stepfunctions.ItemBatcher getItemBatcher() {
            return this.itemBatcher;
        }

        @Override
        public final software.amazon.awscdk.services.stepfunctions.IItemReader getItemReader() {
            return this.itemReader;
        }

        @Override
        public final java.lang.String getLabel() {
            return this.label;
        }

        @Override
        public final software.amazon.awscdk.services.stepfunctions.StateMachineType getMapExecutionType() {
            return this.mapExecutionType;
        }

        @Override
        public final software.amazon.awscdk.services.stepfunctions.ResultWriter getResultWriter() {
            return this.resultWriter;
        }

        @Override
        public final java.lang.Number getToleratedFailureCount() {
            return this.toleratedFailureCount;
        }

        @Override
        public final java.lang.String getToleratedFailureCountPath() {
            return this.toleratedFailureCountPath;
        }

        @Override
        public final java.lang.Number getToleratedFailurePercentage() {
            return this.toleratedFailurePercentage;
        }

        @Override
        public final java.lang.String getToleratedFailurePercentagePath() {
            return this.toleratedFailurePercentagePath;
        }

        @Override
        public final java.lang.String getComment() {
            return this.comment;
        }

        @Override
        public final software.amazon.awscdk.services.stepfunctions.QueryLanguage getQueryLanguage() {
            return this.queryLanguage;
        }

        @Override
        public final java.lang.String getStateName() {
            return this.stateName;
        }

        @Override
        public final java.util.Map<java.lang.String, java.lang.Object> getItemSelector() {
            return this.itemSelector;
        }

        @Override
        public final java.lang.Number getMaxConcurrency() {
            return this.maxConcurrency;
        }

        @Override
        public final java.util.Map<java.lang.String, java.lang.Object> getAssign() {
            return this.assign;
        }

        @Override
        public final java.lang.String getItemsPath() {
            return this.itemsPath;
        }

        @Override
        public final java.lang.String getMaxConcurrencyPath() {
            return this.maxConcurrencyPath;
        }

        @Override
        public final java.lang.String getResultPath() {
            return this.resultPath;
        }

        @Override
        public final java.util.Map<java.lang.String, java.lang.Object> getResultSelector() {
            return this.resultSelector;
        }

        @Override
        public final java.lang.String getInputPath() {
            return this.inputPath;
        }

        @Override
        public final java.lang.String getOutputPath() {
            return this.outputPath;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            if (this.getItemBatcher() != null) {
                data.set("itemBatcher", om.valueToTree(this.getItemBatcher()));
            }
            if (this.getItemReader() != null) {
                data.set("itemReader", om.valueToTree(this.getItemReader()));
            }
            if (this.getLabel() != null) {
                data.set("label", om.valueToTree(this.getLabel()));
            }
            if (this.getMapExecutionType() != null) {
                data.set("mapExecutionType", om.valueToTree(this.getMapExecutionType()));
            }
            if (this.getResultWriter() != null) {
                data.set("resultWriter", om.valueToTree(this.getResultWriter()));
            }
            if (this.getToleratedFailureCount() != null) {
                data.set("toleratedFailureCount", om.valueToTree(this.getToleratedFailureCount()));
            }
            if (this.getToleratedFailureCountPath() != null) {
                data.set("toleratedFailureCountPath", om.valueToTree(this.getToleratedFailureCountPath()));
            }
            if (this.getToleratedFailurePercentage() != null) {
                data.set("toleratedFailurePercentage", om.valueToTree(this.getToleratedFailurePercentage()));
            }
            if (this.getToleratedFailurePercentagePath() != null) {
                data.set("toleratedFailurePercentagePath", om.valueToTree(this.getToleratedFailurePercentagePath()));
            }
            if (this.getComment() != null) {
                data.set("comment", om.valueToTree(this.getComment()));
            }
            if (this.getQueryLanguage() != null) {
                data.set("queryLanguage", om.valueToTree(this.getQueryLanguage()));
            }
            if (this.getStateName() != null) {
                data.set("stateName", om.valueToTree(this.getStateName()));
            }
            if (this.getItemSelector() != null) {
                data.set("itemSelector", om.valueToTree(this.getItemSelector()));
            }
            if (this.getMaxConcurrency() != null) {
                data.set("maxConcurrency", om.valueToTree(this.getMaxConcurrency()));
            }
            if (this.getAssign() != null) {
                data.set("assign", om.valueToTree(this.getAssign()));
            }
            if (this.getItemsPath() != null) {
                data.set("itemsPath", om.valueToTree(this.getItemsPath()));
            }
            if (this.getMaxConcurrencyPath() != null) {
                data.set("maxConcurrencyPath", om.valueToTree(this.getMaxConcurrencyPath()));
            }
            if (this.getResultPath() != null) {
                data.set("resultPath", om.valueToTree(this.getResultPath()));
            }
            if (this.getResultSelector() != null) {
                data.set("resultSelector", om.valueToTree(this.getResultSelector()));
            }
            if (this.getInputPath() != null) {
                data.set("inputPath", om.valueToTree(this.getInputPath()));
            }
            if (this.getOutputPath() != null) {
                data.set("outputPath", om.valueToTree(this.getOutputPath()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_stepfunctions.DistributedMapJsonPathProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            DistributedMapJsonPathProps.Jsii$Proxy that = (DistributedMapJsonPathProps.Jsii$Proxy) o;

            if (this.itemBatcher != null ? !this.itemBatcher.equals(that.itemBatcher) : that.itemBatcher != null) return false;
            if (this.itemReader != null ? !this.itemReader.equals(that.itemReader) : that.itemReader != null) return false;
            if (this.label != null ? !this.label.equals(that.label) : that.label != null) return false;
            if (this.mapExecutionType != null ? !this.mapExecutionType.equals(that.mapExecutionType) : that.mapExecutionType != null) return false;
            if (this.resultWriter != null ? !this.resultWriter.equals(that.resultWriter) : that.resultWriter != null) return false;
            if (this.toleratedFailureCount != null ? !this.toleratedFailureCount.equals(that.toleratedFailureCount) : that.toleratedFailureCount != null) return false;
            if (this.toleratedFailureCountPath != null ? !this.toleratedFailureCountPath.equals(that.toleratedFailureCountPath) : that.toleratedFailureCountPath != null) return false;
            if (this.toleratedFailurePercentage != null ? !this.toleratedFailurePercentage.equals(that.toleratedFailurePercentage) : that.toleratedFailurePercentage != null) return false;
            if (this.toleratedFailurePercentagePath != null ? !this.toleratedFailurePercentagePath.equals(that.toleratedFailurePercentagePath) : that.toleratedFailurePercentagePath != null) return false;
            if (this.comment != null ? !this.comment.equals(that.comment) : that.comment != null) return false;
            if (this.queryLanguage != null ? !this.queryLanguage.equals(that.queryLanguage) : that.queryLanguage != null) return false;
            if (this.stateName != null ? !this.stateName.equals(that.stateName) : that.stateName != null) return false;
            if (this.itemSelector != null ? !this.itemSelector.equals(that.itemSelector) : that.itemSelector != null) return false;
            if (this.maxConcurrency != null ? !this.maxConcurrency.equals(that.maxConcurrency) : that.maxConcurrency != null) return false;
            if (this.assign != null ? !this.assign.equals(that.assign) : that.assign != null) return false;
            if (this.itemsPath != null ? !this.itemsPath.equals(that.itemsPath) : that.itemsPath != null) return false;
            if (this.maxConcurrencyPath != null ? !this.maxConcurrencyPath.equals(that.maxConcurrencyPath) : that.maxConcurrencyPath != null) return false;
            if (this.resultPath != null ? !this.resultPath.equals(that.resultPath) : that.resultPath != null) return false;
            if (this.resultSelector != null ? !this.resultSelector.equals(that.resultSelector) : that.resultSelector != null) return false;
            if (this.inputPath != null ? !this.inputPath.equals(that.inputPath) : that.inputPath != null) return false;
            return this.outputPath != null ? this.outputPath.equals(that.outputPath) : that.outputPath == null;
        }

        @Override
        public final int hashCode() {
            int result = this.itemBatcher != null ? this.itemBatcher.hashCode() : 0;
            result = 31 * result + (this.itemReader != null ? this.itemReader.hashCode() : 0);
            result = 31 * result + (this.label != null ? this.label.hashCode() : 0);
            result = 31 * result + (this.mapExecutionType != null ? this.mapExecutionType.hashCode() : 0);
            result = 31 * result + (this.resultWriter != null ? this.resultWriter.hashCode() : 0);
            result = 31 * result + (this.toleratedFailureCount != null ? this.toleratedFailureCount.hashCode() : 0);
            result = 31 * result + (this.toleratedFailureCountPath != null ? this.toleratedFailureCountPath.hashCode() : 0);
            result = 31 * result + (this.toleratedFailurePercentage != null ? this.toleratedFailurePercentage.hashCode() : 0);
            result = 31 * result + (this.toleratedFailurePercentagePath != null ? this.toleratedFailurePercentagePath.hashCode() : 0);
            result = 31 * result + (this.comment != null ? this.comment.hashCode() : 0);
            result = 31 * result + (this.queryLanguage != null ? this.queryLanguage.hashCode() : 0);
            result = 31 * result + (this.stateName != null ? this.stateName.hashCode() : 0);
            result = 31 * result + (this.itemSelector != null ? this.itemSelector.hashCode() : 0);
            result = 31 * result + (this.maxConcurrency != null ? this.maxConcurrency.hashCode() : 0);
            result = 31 * result + (this.assign != null ? this.assign.hashCode() : 0);
            result = 31 * result + (this.itemsPath != null ? this.itemsPath.hashCode() : 0);
            result = 31 * result + (this.maxConcurrencyPath != null ? this.maxConcurrencyPath.hashCode() : 0);
            result = 31 * result + (this.resultPath != null ? this.resultPath.hashCode() : 0);
            result = 31 * result + (this.resultSelector != null ? this.resultSelector.hashCode() : 0);
            result = 31 * result + (this.inputPath != null ? this.inputPath.hashCode() : 0);
            result = 31 * result + (this.outputPath != null ? this.outputPath.hashCode() : 0);
            return result;
        }
    }
}
