package software.amazon.awscdk.services.stepfunctions;

/**
 * Configuration for writing Distributed Map state results to S3.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * import software.amazon.awscdk.services.s3.*;
 * // create a bucket
 * Bucket bucket = new Bucket(this, "Bucket");
 * DistributedMap distributedMap = DistributedMap.Builder.create(this, "Distributed Map State")
 *         .resultWriter(ResultWriter.Builder.create()
 *                 .bucket(bucket)
 *                 .prefix("my-prefix")
 *                 .build())
 *         .build();
 * distributedMap.itemProcessor(new Pass(this, "Pass State"));
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.106.0 (build e852934)", date = "2025-03-12T01:36:46.419Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_stepfunctions.ResultWriter")
public class ResultWriter extends software.amazon.jsii.JsiiObject {

    protected ResultWriter(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected ResultWriter(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public ResultWriter(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.stepfunctions.ResultWriterProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Compile policy statements to provide relevent permissions to the state machine.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.util.List<software.amazon.awscdk.services.iam.PolicyStatement> providePolicyStatements() {
        return java.util.Collections.unmodifiableList(software.amazon.jsii.Kernel.call(this, "providePolicyStatements", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.iam.PolicyStatement.class))));
    }

    /**
     * Render ResultWriter in ASL JSON format.
     * <p>
     * @param queryLanguage
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.Object render(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.stepfunctions.QueryLanguage queryLanguage) {
        return software.amazon.jsii.Kernel.call(this, "render", software.amazon.jsii.NativeType.forClass(java.lang.Object.class), new Object[] { queryLanguage });
    }

    /**
     * Render ResultWriter in ASL JSON format.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.Object render() {
        return software.amazon.jsii.Kernel.call(this, "render", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * S3 Bucket in which to save Map Run results.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.s3.IBucket getBucket() {
        return software.amazon.jsii.Kernel.get(this, "bucket", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.s3.IBucket.class));
    }

    /**
     * S3 prefix in which to save Map Run results.
     * <p>
     * Default: - No prefix
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getPrefix() {
        return software.amazon.jsii.Kernel.get(this, "prefix", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.stepfunctions.ResultWriter}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.stepfunctions.ResultWriter> {
        /**
         * @return a new instance of {@link Builder}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create() {
            return new Builder();
        }

        private final software.amazon.awscdk.services.stepfunctions.ResultWriterProps.Builder props;

        private Builder() {
            this.props = new software.amazon.awscdk.services.stepfunctions.ResultWriterProps.Builder();
        }

        /**
         * S3 Bucket in which to save Map Run results.
         * <p>
         * @return {@code this}
         * @param bucket S3 Bucket in which to save Map Run results. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder bucket(final software.amazon.awscdk.services.s3.IBucket bucket) {
            this.props.bucket(bucket);
            return this;
        }

        /**
         * S3 prefix in which to save Map Run results.
         * <p>
         * Default: - No prefix
         * <p>
         * @return {@code this}
         * @param prefix S3 prefix in which to save Map Run results. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder prefix(final java.lang.String prefix) {
            this.props.prefix(prefix);
            return this;
        }

        /**
         * @return a newly built instance of {@link software.amazon.awscdk.services.stepfunctions.ResultWriter}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.stepfunctions.ResultWriter build() {
            return new software.amazon.awscdk.services.stepfunctions.ResultWriter(
                this.props.build()
            );
        }
    }
}
