package software.amazon.awscdk.services.stepfunctions.tasks;

/**
 * Basic properties for ECS Tasks.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.ecs.*;
 * import software.amazon.awscdk.services.stepfunctions.*;
 * import software.amazon.awscdk.services.stepfunctions.tasks.*;
 * Cluster cluster;
 * ContainerDefinition containerDefinition;
 * TaskDefinition taskDefinition;
 * CommonEcsRunTaskProps commonEcsRunTaskProps = CommonEcsRunTaskProps.builder()
 *         .cluster(cluster)
 *         .taskDefinition(taskDefinition)
 *         // the properties below are optional
 *         .containerOverrides(List.of(ContainerOverride.builder()
 *                 .containerDefinition(containerDefinition)
 *                 // the properties below are optional
 *                 .command(List.of("command"))
 *                 .cpu(123)
 *                 .environment(List.of(TaskEnvironmentVariable.builder()
 *                         .name("name")
 *                         .value("value")
 *                         .build()))
 *                 .memoryLimit(123)
 *                 .memoryReservation(123)
 *                 .build()))
 *         .integrationPattern(ServiceIntegrationPattern.FIRE_AND_FORGET)
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.106.0 (build e852934)", date = "2025-03-12T01:36:46.584Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_stepfunctions_tasks.CommonEcsRunTaskProps")
@software.amazon.jsii.Jsii.Proxy(CommonEcsRunTaskProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CommonEcsRunTaskProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * The topic to run the task on.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ecs.ICluster getCluster();

    /**
     * Task Definition used for running tasks in the service.
     * <p>
     * Note: this must be TaskDefinition, and not ITaskDefinition,
     * as it requires properties that are not known for imported task definitions
     * If you want to run a RunTask with an imported task definition,
     * consider using CustomState
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ecs.TaskDefinition getTaskDefinition();

    /**
     * Container setting overrides.
     * <p>
     * Key is the name of the container to override, value is the
     * values you want to override.
     * <p>
     * Default: - No overrides
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.services.stepfunctions.tasks.ContainerOverride> getContainerOverrides() {
        return null;
    }

    /**
     * The service integration pattern indicates different ways to call RunTask in ECS.
     * <p>
     * The valid value for Lambda is FIRE_AND_FORGET, SYNC and WAIT_FOR_TASK_TOKEN.
     * <p>
     * Default: FIRE_AND_FORGET
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.stepfunctions.ServiceIntegrationPattern getIntegrationPattern() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CommonEcsRunTaskProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CommonEcsRunTaskProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CommonEcsRunTaskProps> {
        software.amazon.awscdk.services.ecs.ICluster cluster;
        software.amazon.awscdk.services.ecs.TaskDefinition taskDefinition;
        java.util.List<software.amazon.awscdk.services.stepfunctions.tasks.ContainerOverride> containerOverrides;
        software.amazon.awscdk.services.stepfunctions.ServiceIntegrationPattern integrationPattern;

        /**
         * Sets the value of {@link CommonEcsRunTaskProps#getCluster}
         * @param cluster The topic to run the task on. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder cluster(software.amazon.awscdk.services.ecs.ICluster cluster) {
            this.cluster = cluster;
            return this;
        }

        /**
         * Sets the value of {@link CommonEcsRunTaskProps#getTaskDefinition}
         * @param taskDefinition Task Definition used for running tasks in the service. This parameter is required.
         *                       Note: this must be TaskDefinition, and not ITaskDefinition,
         *                       as it requires properties that are not known for imported task definitions
         *                       If you want to run a RunTask with an imported task definition,
         *                       consider using CustomState
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder taskDefinition(software.amazon.awscdk.services.ecs.TaskDefinition taskDefinition) {
            this.taskDefinition = taskDefinition;
            return this;
        }

        /**
         * Sets the value of {@link CommonEcsRunTaskProps#getContainerOverrides}
         * @param containerOverrides Container setting overrides.
         *                           Key is the name of the container to override, value is the
         *                           values you want to override.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder containerOverrides(java.util.List<? extends software.amazon.awscdk.services.stepfunctions.tasks.ContainerOverride> containerOverrides) {
            this.containerOverrides = (java.util.List<software.amazon.awscdk.services.stepfunctions.tasks.ContainerOverride>)containerOverrides;
            return this;
        }

        /**
         * Sets the value of {@link CommonEcsRunTaskProps#getIntegrationPattern}
         * @param integrationPattern The service integration pattern indicates different ways to call RunTask in ECS.
         *                           The valid value for Lambda is FIRE_AND_FORGET, SYNC and WAIT_FOR_TASK_TOKEN.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder integrationPattern(software.amazon.awscdk.services.stepfunctions.ServiceIntegrationPattern integrationPattern) {
            this.integrationPattern = integrationPattern;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CommonEcsRunTaskProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CommonEcsRunTaskProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CommonEcsRunTaskProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CommonEcsRunTaskProps {
        private final software.amazon.awscdk.services.ecs.ICluster cluster;
        private final software.amazon.awscdk.services.ecs.TaskDefinition taskDefinition;
        private final java.util.List<software.amazon.awscdk.services.stepfunctions.tasks.ContainerOverride> containerOverrides;
        private final software.amazon.awscdk.services.stepfunctions.ServiceIntegrationPattern integrationPattern;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.cluster = software.amazon.jsii.Kernel.get(this, "cluster", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ecs.ICluster.class));
            this.taskDefinition = software.amazon.jsii.Kernel.get(this, "taskDefinition", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ecs.TaskDefinition.class));
            this.containerOverrides = software.amazon.jsii.Kernel.get(this, "containerOverrides", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.stepfunctions.tasks.ContainerOverride.class)));
            this.integrationPattern = software.amazon.jsii.Kernel.get(this, "integrationPattern", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.stepfunctions.ServiceIntegrationPattern.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.cluster = java.util.Objects.requireNonNull(builder.cluster, "cluster is required");
            this.taskDefinition = java.util.Objects.requireNonNull(builder.taskDefinition, "taskDefinition is required");
            this.containerOverrides = (java.util.List<software.amazon.awscdk.services.stepfunctions.tasks.ContainerOverride>)builder.containerOverrides;
            this.integrationPattern = builder.integrationPattern;
        }

        @Override
        public final software.amazon.awscdk.services.ecs.ICluster getCluster() {
            return this.cluster;
        }

        @Override
        public final software.amazon.awscdk.services.ecs.TaskDefinition getTaskDefinition() {
            return this.taskDefinition;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.services.stepfunctions.tasks.ContainerOverride> getContainerOverrides() {
            return this.containerOverrides;
        }

        @Override
        public final software.amazon.awscdk.services.stepfunctions.ServiceIntegrationPattern getIntegrationPattern() {
            return this.integrationPattern;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("cluster", om.valueToTree(this.getCluster()));
            data.set("taskDefinition", om.valueToTree(this.getTaskDefinition()));
            if (this.getContainerOverrides() != null) {
                data.set("containerOverrides", om.valueToTree(this.getContainerOverrides()));
            }
            if (this.getIntegrationPattern() != null) {
                data.set("integrationPattern", om.valueToTree(this.getIntegrationPattern()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_stepfunctions_tasks.CommonEcsRunTaskProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CommonEcsRunTaskProps.Jsii$Proxy that = (CommonEcsRunTaskProps.Jsii$Proxy) o;

            if (!cluster.equals(that.cluster)) return false;
            if (!taskDefinition.equals(that.taskDefinition)) return false;
            if (this.containerOverrides != null ? !this.containerOverrides.equals(that.containerOverrides) : that.containerOverrides != null) return false;
            return this.integrationPattern != null ? this.integrationPattern.equals(that.integrationPattern) : that.integrationPattern == null;
        }

        @Override
        public final int hashCode() {
            int result = this.cluster.hashCode();
            result = 31 * result + (this.taskDefinition.hashCode());
            result = 31 * result + (this.containerOverrides != null ? this.containerOverrides.hashCode() : 0);
            result = 31 * result + (this.integrationPattern != null ? this.integrationPattern.hashCode() : 0);
            return result;
        }
    }
}
