package software.amazon.awscdk.services.stepfunctions.tasks;

/**
 * Describes the container, as part of model definition.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * SageMakerCreateModel.Builder.create(this, "Sagemaker")
 *         .modelName("MyModel")
 *         .primaryContainer(ContainerDefinition.Builder.create()
 *                 .image(DockerImage.fromJsonExpression(JsonPath.stringAt("$.Model.imageName")))
 *                 .mode(Mode.SINGLE_MODEL)
 *                 .modelS3Location(S3Location.fromJsonExpression("$.TrainingJob.ModelArtifacts.S3ModelArtifacts"))
 *                 .build())
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_ContainerDefinition.html">https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_ContainerDefinition.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.106.0 (build e852934)", date = "2025-03-12T01:36:46.584Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_stepfunctions_tasks.ContainerDefinition")
public class ContainerDefinition extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.stepfunctions.tasks.IContainerDefinition {

    protected ContainerDefinition(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected ContainerDefinition(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * @param options This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public ContainerDefinition(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.stepfunctions.tasks.ContainerDefinitionOptions options) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(options, "options is required") });
    }

    /**
     * Called when the ContainerDefinition type configured on Sagemaker Task.
     * <p>
     * @param task This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.stepfunctions.tasks.ContainerDefinitionConfig bind(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.stepfunctions.tasks.ISageMakerTask task) {
        return software.amazon.jsii.Kernel.call(this, "bind", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.stepfunctions.tasks.ContainerDefinitionConfig.class), new Object[] { java.util.Objects.requireNonNull(task, "task is required") });
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.stepfunctions.tasks.ContainerDefinition}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.stepfunctions.tasks.ContainerDefinition> {
        /**
         * @return a new instance of {@link Builder}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create() {
            return new Builder();
        }

        private final software.amazon.awscdk.services.stepfunctions.tasks.ContainerDefinitionOptions.Builder options;

        private Builder() {
            this.options = new software.amazon.awscdk.services.stepfunctions.tasks.ContainerDefinitionOptions.Builder();
        }

        /**
         * This parameter is ignored for models that contain only a PrimaryContainer.
         * <p>
         * When a ContainerDefinition is part of an inference pipeline,
         * the value of the parameter uniquely identifies the container for the purposes of logging and metrics.
         * <p>
         * Default: - None
         * <p>
         * @return {@code this}
         * @param containerHostName This parameter is ignored for models that contain only a PrimaryContainer. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder containerHostName(final java.lang.String containerHostName) {
            this.options.containerHostName(containerHostName);
            return this;
        }

        /**
         * The environment variables to set in the Docker container.
         * <p>
         * Default: - No variables
         * <p>
         * @return {@code this}
         * @param environmentVariables The environment variables to set in the Docker container. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder environmentVariables(final software.amazon.awscdk.services.stepfunctions.TaskInput environmentVariables) {
            this.options.environmentVariables(environmentVariables);
            return this;
        }

        /**
         * The Amazon EC2 Container Registry (Amazon ECR) path where inference code is stored.
         * <p>
         * Default: - None
         * <p>
         * @return {@code this}
         * @param image The Amazon EC2 Container Registry (Amazon ECR) path where inference code is stored. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder image(final software.amazon.awscdk.services.stepfunctions.tasks.DockerImage image) {
            this.options.image(image);
            return this;
        }

        /**
         * Defines how many models the container hosts.
         * <p>
         * Default: - Mode.SINGLE_MODEL
         * <p>
         * @return {@code this}
         * @param mode Defines how many models the container hosts. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder mode(final software.amazon.awscdk.services.stepfunctions.tasks.Mode mode) {
            this.options.mode(mode);
            return this;
        }

        /**
         * The name or Amazon Resource Name (ARN) of the model package to use to create the model.
         * <p>
         * Default: - None
         * <p>
         * @return {@code this}
         * @param modelPackageName The name or Amazon Resource Name (ARN) of the model package to use to create the model. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder modelPackageName(final java.lang.String modelPackageName) {
            this.options.modelPackageName(modelPackageName);
            return this;
        }

        /**
         * The S3 path where the model artifacts, which result from model training, are stored.
         * <p>
         * This path must point to a single gzip compressed tar archive (.tar.gz suffix).
         * The S3 path is required for Amazon SageMaker built-in algorithms, but not if you use your own algorithms.
         * <p>
         * Default: - None
         * <p>
         * @return {@code this}
         * @param modelS3Location The S3 path where the model artifacts, which result from model training, are stored. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder modelS3Location(final software.amazon.awscdk.services.stepfunctions.tasks.S3Location modelS3Location) {
            this.options.modelS3Location(modelS3Location);
            return this;
        }

        /**
         * @return a newly built instance of {@link software.amazon.awscdk.services.stepfunctions.tasks.ContainerDefinition}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.stepfunctions.tasks.ContainerDefinition build() {
            return new software.amazon.awscdk.services.stepfunctions.tasks.ContainerDefinition(
                this.options.build()
            );
        }
    }
}
