package software.amazon.awscdk.services.stepfunctions.tasks;

/**
 * Properties for <code>EventBridgeSchedulerTarget</code>.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * import software.amazon.awscdk.services.scheduler.*;
 * import software.amazon.awscdk.services.kms.*;
 * Key key;
 * CfnScheduleGroup scheduleGroup;
 * Queue targetQueue;
 * Queue deadLetterQueue;
 * Role schedulerRole = Role.Builder.create(this, "SchedulerRole")
 *         .assumedBy(new ServicePrincipal("scheduler.amazonaws.com"))
 *         .build();
 * // To send the message to the queue
 * // This policy changes depending on the type of target.
 * schedulerRole.addToPrincipalPolicy(PolicyStatement.Builder.create()
 *         .actions(List.of("sqs:SendMessage"))
 *         .resources(List.of(targetQueue.getQueueArn()))
 *         .build());
 * EventBridgeSchedulerCreateScheduleTask createScheduleTask1 = EventBridgeSchedulerCreateScheduleTask.Builder.create(this, "createSchedule")
 *         .scheduleName("TestSchedule")
 *         .actionAfterCompletion(ActionAfterCompletion.NONE)
 *         .clientToken("testToken")
 *         .description("TestDescription")
 *         .startDate(new Date())
 *         .endDate(new Date(new Date().getTime() + 1000 * 60 * 60))
 *         .flexibleTimeWindow(Duration.minutes(5))
 *         .groupName(scheduleGroup.getRef())
 *         .kmsKey(key)
 *         .schedule(Schedule.rate(Duration.minutes(5)))
 *         .timezone("UTC")
 *         .enabled(true)
 *         .target(EventBridgeSchedulerTarget.Builder.create()
 *                 .arn(targetQueue.getQueueArn())
 *                 .role(schedulerRole)
 *                 .retryPolicy(RetryPolicy.builder()
 *                         .maximumRetryAttempts(2)
 *                         .maximumEventAge(Duration.minutes(5))
 *                         .build())
 *                 .deadLetterQueue(deadLetterQueue)
 *                 .build())
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="https://docs.aws.amazon.com/scheduler/latest/APIReference/API_Target.html#API_Target_Contents">https://docs.aws.amazon.com/scheduler/latest/APIReference/API_Target.html#API_Target_Contents</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.106.0 (build e852934)", date = "2025-03-12T01:36:46.788Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_stepfunctions_tasks.EventBridgeSchedulerTargetProps")
@software.amazon.jsii.Jsii.Proxy(EventBridgeSchedulerTargetProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface EventBridgeSchedulerTargetProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * The Amazon Resource Name (ARN) of the target.
     * <p>
     * @see <a href="https://docs.aws.amazon.com/scheduler/latest/UserGuide/managing-targets.html">https://docs.aws.amazon.com/scheduler/latest/UserGuide/managing-targets.html</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getArn();

    /**
     * The IAM role that EventBridge Scheduler will use for this target when the schedule is invoked.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.IRole getRole();

    /**
     * Dead letter queue for failed events.
     * <p>
     * Default: - No dead letter queue
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.sqs.IQueue getDeadLetterQueue() {
        return null;
    }

    /**
     * The input to the target.
     * <p>
     * Default: - EventBridge Scheduler delivers a default notification to the target
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getInput() {
        return null;
    }

    /**
     * The retry policy settings.
     * <p>
     * Default: - Do not retry
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.stepfunctions.tasks.RetryPolicy getRetryPolicy() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link EventBridgeSchedulerTargetProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link EventBridgeSchedulerTargetProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<EventBridgeSchedulerTargetProps> {
        java.lang.String arn;
        software.amazon.awscdk.services.iam.IRole role;
        software.amazon.awscdk.services.sqs.IQueue deadLetterQueue;
        java.lang.String input;
        software.amazon.awscdk.services.stepfunctions.tasks.RetryPolicy retryPolicy;

        /**
         * Sets the value of {@link EventBridgeSchedulerTargetProps#getArn}
         * @param arn The Amazon Resource Name (ARN) of the target. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder arn(java.lang.String arn) {
            this.arn = arn;
            return this;
        }

        /**
         * Sets the value of {@link EventBridgeSchedulerTargetProps#getRole}
         * @param role The IAM role that EventBridge Scheduler will use for this target when the schedule is invoked. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder role(software.amazon.awscdk.services.iam.IRole role) {
            this.role = role;
            return this;
        }

        /**
         * Sets the value of {@link EventBridgeSchedulerTargetProps#getDeadLetterQueue}
         * @param deadLetterQueue Dead letter queue for failed events.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder deadLetterQueue(software.amazon.awscdk.services.sqs.IQueue deadLetterQueue) {
            this.deadLetterQueue = deadLetterQueue;
            return this;
        }

        /**
         * Sets the value of {@link EventBridgeSchedulerTargetProps#getInput}
         * @param input The input to the target.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder input(java.lang.String input) {
            this.input = input;
            return this;
        }

        /**
         * Sets the value of {@link EventBridgeSchedulerTargetProps#getRetryPolicy}
         * @param retryPolicy The retry policy settings.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder retryPolicy(software.amazon.awscdk.services.stepfunctions.tasks.RetryPolicy retryPolicy) {
            this.retryPolicy = retryPolicy;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link EventBridgeSchedulerTargetProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public EventBridgeSchedulerTargetProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link EventBridgeSchedulerTargetProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements EventBridgeSchedulerTargetProps {
        private final java.lang.String arn;
        private final software.amazon.awscdk.services.iam.IRole role;
        private final software.amazon.awscdk.services.sqs.IQueue deadLetterQueue;
        private final java.lang.String input;
        private final software.amazon.awscdk.services.stepfunctions.tasks.RetryPolicy retryPolicy;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.arn = software.amazon.jsii.Kernel.get(this, "arn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.role = software.amazon.jsii.Kernel.get(this, "role", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.iam.IRole.class));
            this.deadLetterQueue = software.amazon.jsii.Kernel.get(this, "deadLetterQueue", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.sqs.IQueue.class));
            this.input = software.amazon.jsii.Kernel.get(this, "input", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.retryPolicy = software.amazon.jsii.Kernel.get(this, "retryPolicy", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.stepfunctions.tasks.RetryPolicy.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.arn = java.util.Objects.requireNonNull(builder.arn, "arn is required");
            this.role = java.util.Objects.requireNonNull(builder.role, "role is required");
            this.deadLetterQueue = builder.deadLetterQueue;
            this.input = builder.input;
            this.retryPolicy = builder.retryPolicy;
        }

        @Override
        public final java.lang.String getArn() {
            return this.arn;
        }

        @Override
        public final software.amazon.awscdk.services.iam.IRole getRole() {
            return this.role;
        }

        @Override
        public final software.amazon.awscdk.services.sqs.IQueue getDeadLetterQueue() {
            return this.deadLetterQueue;
        }

        @Override
        public final java.lang.String getInput() {
            return this.input;
        }

        @Override
        public final software.amazon.awscdk.services.stepfunctions.tasks.RetryPolicy getRetryPolicy() {
            return this.retryPolicy;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("arn", om.valueToTree(this.getArn()));
            data.set("role", om.valueToTree(this.getRole()));
            if (this.getDeadLetterQueue() != null) {
                data.set("deadLetterQueue", om.valueToTree(this.getDeadLetterQueue()));
            }
            if (this.getInput() != null) {
                data.set("input", om.valueToTree(this.getInput()));
            }
            if (this.getRetryPolicy() != null) {
                data.set("retryPolicy", om.valueToTree(this.getRetryPolicy()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_stepfunctions_tasks.EventBridgeSchedulerTargetProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            EventBridgeSchedulerTargetProps.Jsii$Proxy that = (EventBridgeSchedulerTargetProps.Jsii$Proxy) o;

            if (!arn.equals(that.arn)) return false;
            if (!role.equals(that.role)) return false;
            if (this.deadLetterQueue != null ? !this.deadLetterQueue.equals(that.deadLetterQueue) : that.deadLetterQueue != null) return false;
            if (this.input != null ? !this.input.equals(that.input) : that.input != null) return false;
            return this.retryPolicy != null ? this.retryPolicy.equals(that.retryPolicy) : that.retryPolicy == null;
        }

        @Override
        public final int hashCode() {
            int result = this.arn.hashCode();
            result = 31 * result + (this.role.hashCode());
            result = 31 * result + (this.deadLetterQueue != null ? this.deadLetterQueue.hashCode() : 0);
            result = 31 * result + (this.input != null ? this.input.hashCode() : 0);
            result = 31 * result + (this.retryPolicy != null ? this.retryPolicy.hashCode() : 0);
            return result;
        }
    }
}
