package software.amazon.awscdk.services.transfer;

/**
 * Creates a web app based on specified parameters, and returns the ID for the new web app.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.transfer.*;
 * CfnWebApp cfnWebApp = CfnWebApp.Builder.create(this, "MyCfnWebApp")
 *         .identityProviderDetails(IdentityProviderDetailsProperty.builder()
 *                 .applicationArn("applicationArn")
 *                 .instanceArn("instanceArn")
 *                 .role("role")
 *                 .build())
 *         // the properties below are optional
 *         .accessEndpoint("accessEndpoint")
 *         .tags(List.of(CfnTag.builder()
 *                 .key("key")
 *                 .value("value")
 *                 .build()))
 *         .webAppCustomization(WebAppCustomizationProperty.builder()
 *                 .faviconFile("faviconFile")
 *                 .logoFile("logoFile")
 *                 .title("title")
 *                 .build())
 *         .webAppUnits(WebAppUnitsProperty.builder()
 *                 .provisioned(123)
 *                 .build())
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-transfer-webapp.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-transfer-webapp.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.106.0 (build e852934)", date = "2025-03-12T01:36:47.054Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_transfer.CfnWebApp")
public class CfnWebApp extends software.amazon.awscdk.CfnResource implements software.amazon.awscdk.IInspectable, software.amazon.awscdk.ITaggableV2 {

    protected CfnWebApp(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnWebApp(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        CFN_RESOURCE_TYPE_NAME = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.transfer.CfnWebApp.class, "CFN_RESOURCE_TYPE_NAME", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * @param scope Scope in which this resource is defined. This parameter is required.
     * @param id Construct identifier for this resource (unique in its scope). This parameter is required.
     * @param props Resource properties. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public CfnWebApp(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.transfer.CfnWebAppProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Examines the CloudFormation resource and discloses attributes.
     * <p>
     * @param inspector tree inspector to collect and process attributes. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public void inspect(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.TreeInspector inspector) {
        software.amazon.jsii.Kernel.call(this, "inspect", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(inspector, "inspector is required") });
    }

    /**
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> renderProperties(final @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> props) {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.call(this, "renderProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class)), new Object[] { java.util.Objects.requireNonNull(props, "props is required") }));
    }

    /**
     * The CloudFormation resource type name for this resource class.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String CFN_RESOURCE_TYPE_NAME;

    /**
     * The Amazon Resource Name (ARN) of the web app.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrArn() {
        return software.amazon.jsii.Kernel.get(this, "attrArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The Amazon Resource Name (ARN) for the IAM Identity Center application: this value is set automatically when you create your web app.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrIdentityProviderDetailsApplicationArn() {
        return software.amazon.jsii.Kernel.get(this, "attrIdentityProviderDetailsApplicationArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The unique identifier for the web app.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrWebAppId() {
        return software.amazon.jsii.Kernel.get(this, "attrWebAppId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Tag Manager which manages the tags for this resource.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.TagManager getCdkTagManager() {
        return software.amazon.jsii.Kernel.get(this, "cdkTagManager", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.TagManager.class));
    }

    /**
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> getCfnProperties() {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.get(this, "cfnProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class))));
    }

    /**
     * You can provide a structure that contains the details for the identity provider to use with your web app.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.Object getIdentityProviderDetails() {
        return software.amazon.jsii.Kernel.get(this, "identityProviderDetails", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * You can provide a structure that contains the details for the identity provider to use with your web app.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setIdentityProviderDetails(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "identityProviderDetails", java.util.Objects.requireNonNull(value, "identityProviderDetails is required"));
    }

    /**
     * You can provide a structure that contains the details for the identity provider to use with your web app.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setIdentityProviderDetails(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.transfer.CfnWebApp.IdentityProviderDetailsProperty value) {
        software.amazon.jsii.Kernel.set(this, "identityProviderDetails", java.util.Objects.requireNonNull(value, "identityProviderDetails is required"));
    }

    /**
     * The <code>AccessEndpoint</code> is the URL that you provide to your users for them to interact with the Transfer Family web app.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getAccessEndpoint() {
        return software.amazon.jsii.Kernel.get(this, "accessEndpoint", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The <code>AccessEndpoint</code> is the URL that you provide to your users for them to interact with the Transfer Family web app.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setAccessEndpoint(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "accessEndpoint", value);
    }

    /**
     * Key-value pairs that can be used to group and search for web apps.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.CfnTag> getTags() {
        return java.util.Optional.ofNullable((java.util.List<software.amazon.awscdk.CfnTag>)(software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.CfnTag.class))))).map(java.util.Collections::unmodifiableList).orElse(null);
    }

    /**
     * Key-value pairs that can be used to group and search for web apps.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setTags(final @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.CfnTag> value) {
        software.amazon.jsii.Kernel.set(this, "tags", value);
    }

    /**
     * A structure that contains the customization fields for the web app.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getWebAppCustomization() {
        return software.amazon.jsii.Kernel.get(this, "webAppCustomization", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * A structure that contains the customization fields for the web app.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setWebAppCustomization(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "webAppCustomization", value);
    }

    /**
     * A structure that contains the customization fields for the web app.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setWebAppCustomization(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.transfer.CfnWebApp.WebAppCustomizationProperty value) {
        software.amazon.jsii.Kernel.set(this, "webAppCustomization", value);
    }

    /**
     * A union that contains the value for number of concurrent connections or the user sessions on your web app.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getWebAppUnits() {
        return software.amazon.jsii.Kernel.get(this, "webAppUnits", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * A union that contains the value for number of concurrent connections or the user sessions on your web app.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setWebAppUnits(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "webAppUnits", value);
    }

    /**
     * A union that contains the value for number of concurrent connections or the user sessions on your web app.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setWebAppUnits(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.transfer.CfnWebApp.WebAppUnitsProperty value) {
        software.amazon.jsii.Kernel.set(this, "webAppUnits", value);
    }
    /**
     * A structure that describes the values to use for the IAM Identity Center settings when you create or update a web app.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.transfer.*;
     * IdentityProviderDetailsProperty identityProviderDetailsProperty = IdentityProviderDetailsProperty.builder()
     *         .applicationArn("applicationArn")
     *         .instanceArn("instanceArn")
     *         .role("role")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-transfer-webapp-identityproviderdetails.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-transfer-webapp-identityproviderdetails.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_transfer.CfnWebApp.IdentityProviderDetailsProperty")
    @software.amazon.jsii.Jsii.Proxy(IdentityProviderDetailsProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface IdentityProviderDetailsProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The Amazon Resource Name (ARN) for the IAM Identity Center application: this value is set automatically when you create your web app.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-transfer-webapp-identityproviderdetails.html#cfn-transfer-webapp-identityproviderdetails-applicationarn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-transfer-webapp-identityproviderdetails.html#cfn-transfer-webapp-identityproviderdetails-applicationarn</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getApplicationArn() {
            return null;
        }

        /**
         * The Amazon Resource Name (ARN) for the IAM Identity Center used for the web app.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-transfer-webapp-identityproviderdetails.html#cfn-transfer-webapp-identityproviderdetails-instancearn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-transfer-webapp-identityproviderdetails.html#cfn-transfer-webapp-identityproviderdetails-instancearn</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getInstanceArn() {
            return null;
        }

        /**
         * The IAM role in IAM Identity Center used for the web app.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-transfer-webapp-identityproviderdetails.html#cfn-transfer-webapp-identityproviderdetails-role">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-transfer-webapp-identityproviderdetails.html#cfn-transfer-webapp-identityproviderdetails-role</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getRole() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link IdentityProviderDetailsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link IdentityProviderDetailsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<IdentityProviderDetailsProperty> {
            java.lang.String applicationArn;
            java.lang.String instanceArn;
            java.lang.String role;

            /**
             * Sets the value of {@link IdentityProviderDetailsProperty#getApplicationArn}
             * @param applicationArn The Amazon Resource Name (ARN) for the IAM Identity Center application: this value is set automatically when you create your web app.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder applicationArn(java.lang.String applicationArn) {
                this.applicationArn = applicationArn;
                return this;
            }

            /**
             * Sets the value of {@link IdentityProviderDetailsProperty#getInstanceArn}
             * @param instanceArn The Amazon Resource Name (ARN) for the IAM Identity Center used for the web app.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder instanceArn(java.lang.String instanceArn) {
                this.instanceArn = instanceArn;
                return this;
            }

            /**
             * Sets the value of {@link IdentityProviderDetailsProperty#getRole}
             * @param role The IAM role in IAM Identity Center used for the web app.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder role(java.lang.String role) {
                this.role = role;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link IdentityProviderDetailsProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public IdentityProviderDetailsProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link IdentityProviderDetailsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements IdentityProviderDetailsProperty {
            private final java.lang.String applicationArn;
            private final java.lang.String instanceArn;
            private final java.lang.String role;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.applicationArn = software.amazon.jsii.Kernel.get(this, "applicationArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.instanceArn = software.amazon.jsii.Kernel.get(this, "instanceArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.role = software.amazon.jsii.Kernel.get(this, "role", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.applicationArn = builder.applicationArn;
                this.instanceArn = builder.instanceArn;
                this.role = builder.role;
            }

            @Override
            public final java.lang.String getApplicationArn() {
                return this.applicationArn;
            }

            @Override
            public final java.lang.String getInstanceArn() {
                return this.instanceArn;
            }

            @Override
            public final java.lang.String getRole() {
                return this.role;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getApplicationArn() != null) {
                    data.set("applicationArn", om.valueToTree(this.getApplicationArn()));
                }
                if (this.getInstanceArn() != null) {
                    data.set("instanceArn", om.valueToTree(this.getInstanceArn()));
                }
                if (this.getRole() != null) {
                    data.set("role", om.valueToTree(this.getRole()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_transfer.CfnWebApp.IdentityProviderDetailsProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                IdentityProviderDetailsProperty.Jsii$Proxy that = (IdentityProviderDetailsProperty.Jsii$Proxy) o;

                if (this.applicationArn != null ? !this.applicationArn.equals(that.applicationArn) : that.applicationArn != null) return false;
                if (this.instanceArn != null ? !this.instanceArn.equals(that.instanceArn) : that.instanceArn != null) return false;
                return this.role != null ? this.role.equals(that.role) : that.role == null;
            }

            @Override
            public final int hashCode() {
                int result = this.applicationArn != null ? this.applicationArn.hashCode() : 0;
                result = 31 * result + (this.instanceArn != null ? this.instanceArn.hashCode() : 0);
                result = 31 * result + (this.role != null ? this.role.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * A structure that contains the customization fields for the web app.
     * <p>
     * You can provide a title, logo, and icon to customize the appearance of your web app.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.transfer.*;
     * WebAppCustomizationProperty webAppCustomizationProperty = WebAppCustomizationProperty.builder()
     *         .faviconFile("faviconFile")
     *         .logoFile("logoFile")
     *         .title("title")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-transfer-webapp-webappcustomization.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-transfer-webapp-webappcustomization.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_transfer.CfnWebApp.WebAppCustomizationProperty")
    @software.amazon.jsii.Jsii.Proxy(WebAppCustomizationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface WebAppCustomizationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Returns an icon file data string (in base64 encoding).
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-transfer-webapp-webappcustomization.html#cfn-transfer-webapp-webappcustomization-faviconfile">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-transfer-webapp-webappcustomization.html#cfn-transfer-webapp-webappcustomization-faviconfile</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getFaviconFile() {
            return null;
        }

        /**
         * Returns a logo file data string (in base64 encoding).
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-transfer-webapp-webappcustomization.html#cfn-transfer-webapp-webappcustomization-logofile">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-transfer-webapp-webappcustomization.html#cfn-transfer-webapp-webappcustomization-logofile</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getLogoFile() {
            return null;
        }

        /**
         * Returns the page title that you defined for your web app.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-transfer-webapp-webappcustomization.html#cfn-transfer-webapp-webappcustomization-title">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-transfer-webapp-webappcustomization.html#cfn-transfer-webapp-webappcustomization-title</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getTitle() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link WebAppCustomizationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link WebAppCustomizationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<WebAppCustomizationProperty> {
            java.lang.String faviconFile;
            java.lang.String logoFile;
            java.lang.String title;

            /**
             * Sets the value of {@link WebAppCustomizationProperty#getFaviconFile}
             * @param faviconFile Returns an icon file data string (in base64 encoding).
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder faviconFile(java.lang.String faviconFile) {
                this.faviconFile = faviconFile;
                return this;
            }

            /**
             * Sets the value of {@link WebAppCustomizationProperty#getLogoFile}
             * @param logoFile Returns a logo file data string (in base64 encoding).
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder logoFile(java.lang.String logoFile) {
                this.logoFile = logoFile;
                return this;
            }

            /**
             * Sets the value of {@link WebAppCustomizationProperty#getTitle}
             * @param title Returns the page title that you defined for your web app.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder title(java.lang.String title) {
                this.title = title;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link WebAppCustomizationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public WebAppCustomizationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link WebAppCustomizationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements WebAppCustomizationProperty {
            private final java.lang.String faviconFile;
            private final java.lang.String logoFile;
            private final java.lang.String title;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.faviconFile = software.amazon.jsii.Kernel.get(this, "faviconFile", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.logoFile = software.amazon.jsii.Kernel.get(this, "logoFile", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.title = software.amazon.jsii.Kernel.get(this, "title", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.faviconFile = builder.faviconFile;
                this.logoFile = builder.logoFile;
                this.title = builder.title;
            }

            @Override
            public final java.lang.String getFaviconFile() {
                return this.faviconFile;
            }

            @Override
            public final java.lang.String getLogoFile() {
                return this.logoFile;
            }

            @Override
            public final java.lang.String getTitle() {
                return this.title;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getFaviconFile() != null) {
                    data.set("faviconFile", om.valueToTree(this.getFaviconFile()));
                }
                if (this.getLogoFile() != null) {
                    data.set("logoFile", om.valueToTree(this.getLogoFile()));
                }
                if (this.getTitle() != null) {
                    data.set("title", om.valueToTree(this.getTitle()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_transfer.CfnWebApp.WebAppCustomizationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                WebAppCustomizationProperty.Jsii$Proxy that = (WebAppCustomizationProperty.Jsii$Proxy) o;

                if (this.faviconFile != null ? !this.faviconFile.equals(that.faviconFile) : that.faviconFile != null) return false;
                if (this.logoFile != null ? !this.logoFile.equals(that.logoFile) : that.logoFile != null) return false;
                return this.title != null ? this.title.equals(that.title) : that.title == null;
            }

            @Override
            public final int hashCode() {
                int result = this.faviconFile != null ? this.faviconFile.hashCode() : 0;
                result = 31 * result + (this.logoFile != null ? this.logoFile.hashCode() : 0);
                result = 31 * result + (this.title != null ? this.title.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Contains an integer value that represents the value for number of concurrent connections or the user sessions on your web app.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.transfer.*;
     * WebAppUnitsProperty webAppUnitsProperty = WebAppUnitsProperty.builder()
     *         .provisioned(123)
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-transfer-webapp-webappunits.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-transfer-webapp-webappunits.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_transfer.CfnWebApp.WebAppUnitsProperty")
    @software.amazon.jsii.Jsii.Proxy(WebAppUnitsProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface WebAppUnitsProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * An integer that represents the number of units for your desired number of concurrent connections, or the number of user sessions on your web app at the same time.
         * <p>
         * Each increment allows an additional 250 concurrent sessions: a value of <code>1</code> sets the number of concurrent sessions to 250; <code>2</code> sets a value of 500, and so on.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-transfer-webapp-webappunits.html#cfn-transfer-webapp-webappunits-provisioned">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-transfer-webapp-webappunits.html#cfn-transfer-webapp-webappunits-provisioned</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Number getProvisioned();

        /**
         * @return a {@link Builder} of {@link WebAppUnitsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link WebAppUnitsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<WebAppUnitsProperty> {
            java.lang.Number provisioned;

            /**
             * Sets the value of {@link WebAppUnitsProperty#getProvisioned}
             * @param provisioned An integer that represents the number of units for your desired number of concurrent connections, or the number of user sessions on your web app at the same time. This parameter is required.
             *                    Each increment allows an additional 250 concurrent sessions: a value of <code>1</code> sets the number of concurrent sessions to 250; <code>2</code> sets a value of 500, and so on.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder provisioned(java.lang.Number provisioned) {
                this.provisioned = provisioned;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link WebAppUnitsProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public WebAppUnitsProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link WebAppUnitsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements WebAppUnitsProperty {
            private final java.lang.Number provisioned;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.provisioned = software.amazon.jsii.Kernel.get(this, "provisioned", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.provisioned = java.util.Objects.requireNonNull(builder.provisioned, "provisioned is required");
            }

            @Override
            public final java.lang.Number getProvisioned() {
                return this.provisioned;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("provisioned", om.valueToTree(this.getProvisioned()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_transfer.CfnWebApp.WebAppUnitsProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                WebAppUnitsProperty.Jsii$Proxy that = (WebAppUnitsProperty.Jsii$Proxy) o;

                return this.provisioned.equals(that.provisioned);
            }

            @Override
            public final int hashCode() {
                int result = this.provisioned.hashCode();
                return result;
            }
        }
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.transfer.CfnWebApp}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.transfer.CfnWebApp> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope Scope in which this resource is defined. This parameter is required.
         * @param id Construct identifier for this resource (unique in its scope). This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.transfer.CfnWebAppProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.services.transfer.CfnWebAppProps.Builder();
        }

        /**
         * You can provide a structure that contains the details for the identity provider to use with your web app.
         * <p>
         * For more details about this parameter, see <a href="https://docs.aws.amazon.com//transfer/latest/userguide/webapp-identity-center.html">Configure your identity provider for Transfer Family web apps</a> .
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-transfer-webapp.html#cfn-transfer-webapp-identityproviderdetails">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-transfer-webapp.html#cfn-transfer-webapp-identityproviderdetails</a>
         * @param identityProviderDetails You can provide a structure that contains the details for the identity provider to use with your web app. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder identityProviderDetails(final software.amazon.awscdk.IResolvable identityProviderDetails) {
            this.props.identityProviderDetails(identityProviderDetails);
            return this;
        }
        /**
         * You can provide a structure that contains the details for the identity provider to use with your web app.
         * <p>
         * For more details about this parameter, see <a href="https://docs.aws.amazon.com//transfer/latest/userguide/webapp-identity-center.html">Configure your identity provider for Transfer Family web apps</a> .
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-transfer-webapp.html#cfn-transfer-webapp-identityproviderdetails">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-transfer-webapp.html#cfn-transfer-webapp-identityproviderdetails</a>
         * @param identityProviderDetails You can provide a structure that contains the details for the identity provider to use with your web app. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder identityProviderDetails(final software.amazon.awscdk.services.transfer.CfnWebApp.IdentityProviderDetailsProperty identityProviderDetails) {
            this.props.identityProviderDetails(identityProviderDetails);
            return this;
        }

        /**
         * The <code>AccessEndpoint</code> is the URL that you provide to your users for them to interact with the Transfer Family web app.
         * <p>
         * You can specify a custom URL or use the default value.
         * <p>
         * Before you enter a custom URL for this parameter, follow the steps described in <a href="https://docs.aws.amazon.com//transfer/latest/userguide/webapp-customize.html">Update your access endpoint with a custom URL</a> .
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-transfer-webapp.html#cfn-transfer-webapp-accessendpoint">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-transfer-webapp.html#cfn-transfer-webapp-accessendpoint</a>
         * @param accessEndpoint The <code>AccessEndpoint</code> is the URL that you provide to your users for them to interact with the Transfer Family web app. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder accessEndpoint(final java.lang.String accessEndpoint) {
            this.props.accessEndpoint(accessEndpoint);
            return this;
        }

        /**
         * Key-value pairs that can be used to group and search for web apps.
         * <p>
         * Tags are metadata attached to web apps for any purpose.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-transfer-webapp.html#cfn-transfer-webapp-tags">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-transfer-webapp.html#cfn-transfer-webapp-tags</a>
         * @param tags Key-value pairs that can be used to group and search for web apps. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder tags(final java.util.List<? extends software.amazon.awscdk.CfnTag> tags) {
            this.props.tags(tags);
            return this;
        }

        /**
         * A structure that contains the customization fields for the web app.
         * <p>
         * You can provide a title, logo, and icon to customize the appearance of your web app.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-transfer-webapp.html#cfn-transfer-webapp-webappcustomization">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-transfer-webapp.html#cfn-transfer-webapp-webappcustomization</a>
         * @param webAppCustomization A structure that contains the customization fields for the web app. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder webAppCustomization(final software.amazon.awscdk.IResolvable webAppCustomization) {
            this.props.webAppCustomization(webAppCustomization);
            return this;
        }
        /**
         * A structure that contains the customization fields for the web app.
         * <p>
         * You can provide a title, logo, and icon to customize the appearance of your web app.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-transfer-webapp.html#cfn-transfer-webapp-webappcustomization">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-transfer-webapp.html#cfn-transfer-webapp-webappcustomization</a>
         * @param webAppCustomization A structure that contains the customization fields for the web app. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder webAppCustomization(final software.amazon.awscdk.services.transfer.CfnWebApp.WebAppCustomizationProperty webAppCustomization) {
            this.props.webAppCustomization(webAppCustomization);
            return this;
        }

        /**
         * A union that contains the value for number of concurrent connections or the user sessions on your web app.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-transfer-webapp.html#cfn-transfer-webapp-webappunits">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-transfer-webapp.html#cfn-transfer-webapp-webappunits</a>
         * @param webAppUnits A union that contains the value for number of concurrent connections or the user sessions on your web app. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder webAppUnits(final software.amazon.awscdk.IResolvable webAppUnits) {
            this.props.webAppUnits(webAppUnits);
            return this;
        }
        /**
         * A union that contains the value for number of concurrent connections or the user sessions on your web app.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-transfer-webapp.html#cfn-transfer-webapp-webappunits">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-transfer-webapp.html#cfn-transfer-webapp-webappunits</a>
         * @param webAppUnits A union that contains the value for number of concurrent connections or the user sessions on your web app. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder webAppUnits(final software.amazon.awscdk.services.transfer.CfnWebApp.WebAppUnitsProperty webAppUnits) {
            this.props.webAppUnits(webAppUnits);
            return this;
        }

        /**
         * @return a newly built instance of {@link software.amazon.awscdk.services.transfer.CfnWebApp}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.transfer.CfnWebApp build() {
            return new software.amazon.awscdk.services.transfer.CfnWebApp(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
