package software.amazon.awscdk.services.transfer;

/**
 * Properties for defining a <code>CfnWebApp</code>.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.transfer.*;
 * CfnWebAppProps cfnWebAppProps = CfnWebAppProps.builder()
 *         .identityProviderDetails(IdentityProviderDetailsProperty.builder()
 *                 .applicationArn("applicationArn")
 *                 .instanceArn("instanceArn")
 *                 .role("role")
 *                 .build())
 *         // the properties below are optional
 *         .accessEndpoint("accessEndpoint")
 *         .tags(List.of(CfnTag.builder()
 *                 .key("key")
 *                 .value("value")
 *                 .build()))
 *         .webAppCustomization(WebAppCustomizationProperty.builder()
 *                 .faviconFile("faviconFile")
 *                 .logoFile("logoFile")
 *                 .title("title")
 *                 .build())
 *         .webAppUnits(WebAppUnitsProperty.builder()
 *                 .provisioned(123)
 *                 .build())
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-transfer-webapp.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-transfer-webapp.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.106.0 (build e852934)", date = "2025-03-12T01:36:47.056Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_transfer.CfnWebAppProps")
@software.amazon.jsii.Jsii.Proxy(CfnWebAppProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnWebAppProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * You can provide a structure that contains the details for the identity provider to use with your web app.
     * <p>
     * For more details about this parameter, see <a href="https://docs.aws.amazon.com//transfer/latest/userguide/webapp-identity-center.html">Configure your identity provider for Transfer Family web apps</a> .
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-transfer-webapp.html#cfn-transfer-webapp-identityproviderdetails">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-transfer-webapp.html#cfn-transfer-webapp-identityproviderdetails</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.Object getIdentityProviderDetails();

    /**
     * The <code>AccessEndpoint</code> is the URL that you provide to your users for them to interact with the Transfer Family web app.
     * <p>
     * You can specify a custom URL or use the default value.
     * <p>
     * Before you enter a custom URL for this parameter, follow the steps described in <a href="https://docs.aws.amazon.com//transfer/latest/userguide/webapp-customize.html">Update your access endpoint with a custom URL</a> .
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-transfer-webapp.html#cfn-transfer-webapp-accessendpoint">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-transfer-webapp.html#cfn-transfer-webapp-accessendpoint</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getAccessEndpoint() {
        return null;
    }

    /**
     * Key-value pairs that can be used to group and search for web apps.
     * <p>
     * Tags are metadata attached to web apps for any purpose.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-transfer-webapp.html#cfn-transfer-webapp-tags">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-transfer-webapp.html#cfn-transfer-webapp-tags</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.CfnTag> getTags() {
        return null;
    }

    /**
     * A structure that contains the customization fields for the web app.
     * <p>
     * You can provide a title, logo, and icon to customize the appearance of your web app.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-transfer-webapp.html#cfn-transfer-webapp-webappcustomization">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-transfer-webapp.html#cfn-transfer-webapp-webappcustomization</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getWebAppCustomization() {
        return null;
    }

    /**
     * A union that contains the value for number of concurrent connections or the user sessions on your web app.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-transfer-webapp.html#cfn-transfer-webapp-webappunits">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-transfer-webapp.html#cfn-transfer-webapp-webappunits</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getWebAppUnits() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CfnWebAppProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnWebAppProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnWebAppProps> {
        java.lang.Object identityProviderDetails;
        java.lang.String accessEndpoint;
        java.util.List<software.amazon.awscdk.CfnTag> tags;
        java.lang.Object webAppCustomization;
        java.lang.Object webAppUnits;

        /**
         * Sets the value of {@link CfnWebAppProps#getIdentityProviderDetails}
         * @param identityProviderDetails You can provide a structure that contains the details for the identity provider to use with your web app. This parameter is required.
         *                                For more details about this parameter, see <a href="https://docs.aws.amazon.com//transfer/latest/userguide/webapp-identity-center.html">Configure your identity provider for Transfer Family web apps</a> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder identityProviderDetails(software.amazon.awscdk.IResolvable identityProviderDetails) {
            this.identityProviderDetails = identityProviderDetails;
            return this;
        }

        /**
         * Sets the value of {@link CfnWebAppProps#getIdentityProviderDetails}
         * @param identityProviderDetails You can provide a structure that contains the details for the identity provider to use with your web app. This parameter is required.
         *                                For more details about this parameter, see <a href="https://docs.aws.amazon.com//transfer/latest/userguide/webapp-identity-center.html">Configure your identity provider for Transfer Family web apps</a> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder identityProviderDetails(software.amazon.awscdk.services.transfer.CfnWebApp.IdentityProviderDetailsProperty identityProviderDetails) {
            this.identityProviderDetails = identityProviderDetails;
            return this;
        }

        /**
         * Sets the value of {@link CfnWebAppProps#getAccessEndpoint}
         * @param accessEndpoint The <code>AccessEndpoint</code> is the URL that you provide to your users for them to interact with the Transfer Family web app.
         *                       You can specify a custom URL or use the default value.
         *                       <p>
         *                       Before you enter a custom URL for this parameter, follow the steps described in <a href="https://docs.aws.amazon.com//transfer/latest/userguide/webapp-customize.html">Update your access endpoint with a custom URL</a> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder accessEndpoint(java.lang.String accessEndpoint) {
            this.accessEndpoint = accessEndpoint;
            return this;
        }

        /**
         * Sets the value of {@link CfnWebAppProps#getTags}
         * @param tags Key-value pairs that can be used to group and search for web apps.
         *             Tags are metadata attached to web apps for any purpose.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder tags(java.util.List<? extends software.amazon.awscdk.CfnTag> tags) {
            this.tags = (java.util.List<software.amazon.awscdk.CfnTag>)tags;
            return this;
        }

        /**
         * Sets the value of {@link CfnWebAppProps#getWebAppCustomization}
         * @param webAppCustomization A structure that contains the customization fields for the web app.
         *                            You can provide a title, logo, and icon to customize the appearance of your web app.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder webAppCustomization(software.amazon.awscdk.IResolvable webAppCustomization) {
            this.webAppCustomization = webAppCustomization;
            return this;
        }

        /**
         * Sets the value of {@link CfnWebAppProps#getWebAppCustomization}
         * @param webAppCustomization A structure that contains the customization fields for the web app.
         *                            You can provide a title, logo, and icon to customize the appearance of your web app.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder webAppCustomization(software.amazon.awscdk.services.transfer.CfnWebApp.WebAppCustomizationProperty webAppCustomization) {
            this.webAppCustomization = webAppCustomization;
            return this;
        }

        /**
         * Sets the value of {@link CfnWebAppProps#getWebAppUnits}
         * @param webAppUnits A union that contains the value for number of concurrent connections or the user sessions on your web app.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder webAppUnits(software.amazon.awscdk.IResolvable webAppUnits) {
            this.webAppUnits = webAppUnits;
            return this;
        }

        /**
         * Sets the value of {@link CfnWebAppProps#getWebAppUnits}
         * @param webAppUnits A union that contains the value for number of concurrent connections or the user sessions on your web app.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder webAppUnits(software.amazon.awscdk.services.transfer.CfnWebApp.WebAppUnitsProperty webAppUnits) {
            this.webAppUnits = webAppUnits;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnWebAppProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnWebAppProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnWebAppProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnWebAppProps {
        private final java.lang.Object identityProviderDetails;
        private final java.lang.String accessEndpoint;
        private final java.util.List<software.amazon.awscdk.CfnTag> tags;
        private final java.lang.Object webAppCustomization;
        private final java.lang.Object webAppUnits;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.identityProviderDetails = software.amazon.jsii.Kernel.get(this, "identityProviderDetails", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.accessEndpoint = software.amazon.jsii.Kernel.get(this, "accessEndpoint", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.tags = software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.CfnTag.class)));
            this.webAppCustomization = software.amazon.jsii.Kernel.get(this, "webAppCustomization", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.webAppUnits = software.amazon.jsii.Kernel.get(this, "webAppUnits", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.identityProviderDetails = java.util.Objects.requireNonNull(builder.identityProviderDetails, "identityProviderDetails is required");
            this.accessEndpoint = builder.accessEndpoint;
            this.tags = (java.util.List<software.amazon.awscdk.CfnTag>)builder.tags;
            this.webAppCustomization = builder.webAppCustomization;
            this.webAppUnits = builder.webAppUnits;
        }

        @Override
        public final java.lang.Object getIdentityProviderDetails() {
            return this.identityProviderDetails;
        }

        @Override
        public final java.lang.String getAccessEndpoint() {
            return this.accessEndpoint;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.CfnTag> getTags() {
            return this.tags;
        }

        @Override
        public final java.lang.Object getWebAppCustomization() {
            return this.webAppCustomization;
        }

        @Override
        public final java.lang.Object getWebAppUnits() {
            return this.webAppUnits;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("identityProviderDetails", om.valueToTree(this.getIdentityProviderDetails()));
            if (this.getAccessEndpoint() != null) {
                data.set("accessEndpoint", om.valueToTree(this.getAccessEndpoint()));
            }
            if (this.getTags() != null) {
                data.set("tags", om.valueToTree(this.getTags()));
            }
            if (this.getWebAppCustomization() != null) {
                data.set("webAppCustomization", om.valueToTree(this.getWebAppCustomization()));
            }
            if (this.getWebAppUnits() != null) {
                data.set("webAppUnits", om.valueToTree(this.getWebAppUnits()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_transfer.CfnWebAppProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnWebAppProps.Jsii$Proxy that = (CfnWebAppProps.Jsii$Proxy) o;

            if (!identityProviderDetails.equals(that.identityProviderDetails)) return false;
            if (this.accessEndpoint != null ? !this.accessEndpoint.equals(that.accessEndpoint) : that.accessEndpoint != null) return false;
            if (this.tags != null ? !this.tags.equals(that.tags) : that.tags != null) return false;
            if (this.webAppCustomization != null ? !this.webAppCustomization.equals(that.webAppCustomization) : that.webAppCustomization != null) return false;
            return this.webAppUnits != null ? this.webAppUnits.equals(that.webAppUnits) : that.webAppUnits == null;
        }

        @Override
        public final int hashCode() {
            int result = this.identityProviderDetails.hashCode();
            result = 31 * result + (this.accessEndpoint != null ? this.accessEndpoint.hashCode() : 0);
            result = 31 * result + (this.tags != null ? this.tags.hashCode() : 0);
            result = 31 * result + (this.webAppCustomization != null ? this.webAppCustomization.hashCode() : 0);
            result = 31 * result + (this.webAppUnits != null ? this.webAppUnits.hashCode() : 0);
            return result;
        }
    }
}
