package software.amazon.awscdk.services.wisdom;

/**
 * Properties for defining a <code>CfnAIPrompt</code>.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.wisdom.*;
 * CfnAIPromptProps cfnAIPromptProps = CfnAIPromptProps.builder()
 *         .apiFormat("apiFormat")
 *         .modelId("modelId")
 *         .templateConfiguration(AIPromptTemplateConfigurationProperty.builder()
 *                 .textFullAiPromptEditTemplateConfiguration(TextFullAIPromptEditTemplateConfigurationProperty.builder()
 *                         .text("text")
 *                         .build())
 *                 .build())
 *         .templateType("templateType")
 *         .type("type")
 *         // the properties below are optional
 *         .assistantId("assistantId")
 *         .description("description")
 *         .name("name")
 *         .tags(Map.of(
 *                 "tagsKey", "tags"))
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-wisdom-aiprompt.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-wisdom-aiprompt.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.106.0 (build e852934)", date = "2025-03-12T01:36:47.430Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_wisdom.CfnAIPromptProps")
@software.amazon.jsii.Jsii.Proxy(CfnAIPromptProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnAIPromptProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * The API format used for this AI Prompt.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-wisdom-aiprompt.html#cfn-wisdom-aiprompt-apiformat">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-wisdom-aiprompt.html#cfn-wisdom-aiprompt-apiformat</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getApiFormat();

    /**
     * The identifier of the model used for this AI Prompt.
     * <p>
     * Model Ids supported are: <code>anthropic.claude-3-haiku-20240307-v1:0</code> .
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-wisdom-aiprompt.html#cfn-wisdom-aiprompt-modelid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-wisdom-aiprompt.html#cfn-wisdom-aiprompt-modelid</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getModelId();

    /**
     * The configuration of the prompt template for this AI Prompt.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-wisdom-aiprompt.html#cfn-wisdom-aiprompt-templateconfiguration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-wisdom-aiprompt.html#cfn-wisdom-aiprompt-templateconfiguration</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.Object getTemplateConfiguration();

    /**
     * The type of the prompt template for this AI Prompt.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-wisdom-aiprompt.html#cfn-wisdom-aiprompt-templatetype">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-wisdom-aiprompt.html#cfn-wisdom-aiprompt-templatetype</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getTemplateType();

    /**
     * The type of this AI Prompt.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-wisdom-aiprompt.html#cfn-wisdom-aiprompt-type">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-wisdom-aiprompt.html#cfn-wisdom-aiprompt-type</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getType();

    /**
     * The identifier of the Amazon Q in Connect assistant.
     * <p>
     * Can be either the ID or the ARN. URLs cannot contain the ARN.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-wisdom-aiprompt.html#cfn-wisdom-aiprompt-assistantid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-wisdom-aiprompt.html#cfn-wisdom-aiprompt-assistantid</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getAssistantId() {
        return null;
    }

    /**
     * The description of the AI Prompt.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-wisdom-aiprompt.html#cfn-wisdom-aiprompt-description">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-wisdom-aiprompt.html#cfn-wisdom-aiprompt-description</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getDescription() {
        return null;
    }

    /**
     * The name of the AI Prompt.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-wisdom-aiprompt.html#cfn-wisdom-aiprompt-name">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-wisdom-aiprompt.html#cfn-wisdom-aiprompt-name</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getName() {
        return null;
    }

    /**
     * The tags used to organize, track, or control access for this resource.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-wisdom-aiprompt.html#cfn-wisdom-aiprompt-tags">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-wisdom-aiprompt.html#cfn-wisdom-aiprompt-tags</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.Map<java.lang.String, java.lang.String> getTags() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CfnAIPromptProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnAIPromptProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnAIPromptProps> {
        java.lang.String apiFormat;
        java.lang.String modelId;
        java.lang.Object templateConfiguration;
        java.lang.String templateType;
        java.lang.String type;
        java.lang.String assistantId;
        java.lang.String description;
        java.lang.String name;
        java.util.Map<java.lang.String, java.lang.String> tags;

        /**
         * Sets the value of {@link CfnAIPromptProps#getApiFormat}
         * @param apiFormat The API format used for this AI Prompt. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder apiFormat(java.lang.String apiFormat) {
            this.apiFormat = apiFormat;
            return this;
        }

        /**
         * Sets the value of {@link CfnAIPromptProps#getModelId}
         * @param modelId The identifier of the model used for this AI Prompt. This parameter is required.
         *                Model Ids supported are: <code>anthropic.claude-3-haiku-20240307-v1:0</code> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder modelId(java.lang.String modelId) {
            this.modelId = modelId;
            return this;
        }

        /**
         * Sets the value of {@link CfnAIPromptProps#getTemplateConfiguration}
         * @param templateConfiguration The configuration of the prompt template for this AI Prompt. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder templateConfiguration(software.amazon.awscdk.IResolvable templateConfiguration) {
            this.templateConfiguration = templateConfiguration;
            return this;
        }

        /**
         * Sets the value of {@link CfnAIPromptProps#getTemplateConfiguration}
         * @param templateConfiguration The configuration of the prompt template for this AI Prompt. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder templateConfiguration(software.amazon.awscdk.services.wisdom.CfnAIPrompt.AIPromptTemplateConfigurationProperty templateConfiguration) {
            this.templateConfiguration = templateConfiguration;
            return this;
        }

        /**
         * Sets the value of {@link CfnAIPromptProps#getTemplateType}
         * @param templateType The type of the prompt template for this AI Prompt. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder templateType(java.lang.String templateType) {
            this.templateType = templateType;
            return this;
        }

        /**
         * Sets the value of {@link CfnAIPromptProps#getType}
         * @param type The type of this AI Prompt. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder type(java.lang.String type) {
            this.type = type;
            return this;
        }

        /**
         * Sets the value of {@link CfnAIPromptProps#getAssistantId}
         * @param assistantId The identifier of the Amazon Q in Connect assistant.
         *                    Can be either the ID or the ARN. URLs cannot contain the ARN.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder assistantId(java.lang.String assistantId) {
            this.assistantId = assistantId;
            return this;
        }

        /**
         * Sets the value of {@link CfnAIPromptProps#getDescription}
         * @param description The description of the AI Prompt.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder description(java.lang.String description) {
            this.description = description;
            return this;
        }

        /**
         * Sets the value of {@link CfnAIPromptProps#getName}
         * @param name The name of the AI Prompt.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder name(java.lang.String name) {
            this.name = name;
            return this;
        }

        /**
         * Sets the value of {@link CfnAIPromptProps#getTags}
         * @param tags The tags used to organize, track, or control access for this resource.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder tags(java.util.Map<java.lang.String, java.lang.String> tags) {
            this.tags = tags;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnAIPromptProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnAIPromptProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnAIPromptProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnAIPromptProps {
        private final java.lang.String apiFormat;
        private final java.lang.String modelId;
        private final java.lang.Object templateConfiguration;
        private final java.lang.String templateType;
        private final java.lang.String type;
        private final java.lang.String assistantId;
        private final java.lang.String description;
        private final java.lang.String name;
        private final java.util.Map<java.lang.String, java.lang.String> tags;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.apiFormat = software.amazon.jsii.Kernel.get(this, "apiFormat", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.modelId = software.amazon.jsii.Kernel.get(this, "modelId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.templateConfiguration = software.amazon.jsii.Kernel.get(this, "templateConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.templateType = software.amazon.jsii.Kernel.get(this, "templateType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.type = software.amazon.jsii.Kernel.get(this, "type", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.assistantId = software.amazon.jsii.Kernel.get(this, "assistantId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.description = software.amazon.jsii.Kernel.get(this, "description", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.name = software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.tags = software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.apiFormat = java.util.Objects.requireNonNull(builder.apiFormat, "apiFormat is required");
            this.modelId = java.util.Objects.requireNonNull(builder.modelId, "modelId is required");
            this.templateConfiguration = java.util.Objects.requireNonNull(builder.templateConfiguration, "templateConfiguration is required");
            this.templateType = java.util.Objects.requireNonNull(builder.templateType, "templateType is required");
            this.type = java.util.Objects.requireNonNull(builder.type, "type is required");
            this.assistantId = builder.assistantId;
            this.description = builder.description;
            this.name = builder.name;
            this.tags = builder.tags;
        }

        @Override
        public final java.lang.String getApiFormat() {
            return this.apiFormat;
        }

        @Override
        public final java.lang.String getModelId() {
            return this.modelId;
        }

        @Override
        public final java.lang.Object getTemplateConfiguration() {
            return this.templateConfiguration;
        }

        @Override
        public final java.lang.String getTemplateType() {
            return this.templateType;
        }

        @Override
        public final java.lang.String getType() {
            return this.type;
        }

        @Override
        public final java.lang.String getAssistantId() {
            return this.assistantId;
        }

        @Override
        public final java.lang.String getDescription() {
            return this.description;
        }

        @Override
        public final java.lang.String getName() {
            return this.name;
        }

        @Override
        public final java.util.Map<java.lang.String, java.lang.String> getTags() {
            return this.tags;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("apiFormat", om.valueToTree(this.getApiFormat()));
            data.set("modelId", om.valueToTree(this.getModelId()));
            data.set("templateConfiguration", om.valueToTree(this.getTemplateConfiguration()));
            data.set("templateType", om.valueToTree(this.getTemplateType()));
            data.set("type", om.valueToTree(this.getType()));
            if (this.getAssistantId() != null) {
                data.set("assistantId", om.valueToTree(this.getAssistantId()));
            }
            if (this.getDescription() != null) {
                data.set("description", om.valueToTree(this.getDescription()));
            }
            if (this.getName() != null) {
                data.set("name", om.valueToTree(this.getName()));
            }
            if (this.getTags() != null) {
                data.set("tags", om.valueToTree(this.getTags()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_wisdom.CfnAIPromptProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnAIPromptProps.Jsii$Proxy that = (CfnAIPromptProps.Jsii$Proxy) o;

            if (!apiFormat.equals(that.apiFormat)) return false;
            if (!modelId.equals(that.modelId)) return false;
            if (!templateConfiguration.equals(that.templateConfiguration)) return false;
            if (!templateType.equals(that.templateType)) return false;
            if (!type.equals(that.type)) return false;
            if (this.assistantId != null ? !this.assistantId.equals(that.assistantId) : that.assistantId != null) return false;
            if (this.description != null ? !this.description.equals(that.description) : that.description != null) return false;
            if (this.name != null ? !this.name.equals(that.name) : that.name != null) return false;
            return this.tags != null ? this.tags.equals(that.tags) : that.tags == null;
        }

        @Override
        public final int hashCode() {
            int result = this.apiFormat.hashCode();
            result = 31 * result + (this.modelId.hashCode());
            result = 31 * result + (this.templateConfiguration.hashCode());
            result = 31 * result + (this.templateType.hashCode());
            result = 31 * result + (this.type.hashCode());
            result = 31 * result + (this.assistantId != null ? this.assistantId.hashCode() : 0);
            result = 31 * result + (this.description != null ? this.description.hashCode() : 0);
            result = 31 * result + (this.name != null ? this.name.hashCode() : 0);
            result = 31 * result + (this.tags != null ? this.tags.hashCode() : 0);
            return result;
        }
    }
}
