package software.amazon.awscdk.services.apigateway;

/**
 * The <code>AWS::ApiGateway::DocumentationPart</code> resource creates a documentation part for an API.
 * <p>
 * For more information, see <a href="https://docs.aws.amazon.com/apigateway/latest/developerguide/api-gateway-documenting-api-content-representation.html">Representation of API Documentation in API Gateway</a> in the <em>API Gateway Developer Guide</em> .
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.apigateway.*;
 * CfnDocumentationPart cfnDocumentationPart = CfnDocumentationPart.Builder.create(this, "MyCfnDocumentationPart")
 *         .location(LocationProperty.builder()
 *                 .method("method")
 *                 .name("name")
 *                 .path("path")
 *                 .statusCode("statusCode")
 *                 .type("type")
 *                 .build())
 *         .properties("properties")
 *         .restApiId("restApiId")
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-documentationpart.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-documentationpart.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.109.0 (build c221850)", date = "2025-03-14T03:24:51.530Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_apigateway.CfnDocumentationPart")
public class CfnDocumentationPart extends software.amazon.awscdk.CfnResource implements software.amazon.awscdk.IInspectable {

    protected CfnDocumentationPart(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnDocumentationPart(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        CFN_RESOURCE_TYPE_NAME = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.apigateway.CfnDocumentationPart.class, "CFN_RESOURCE_TYPE_NAME", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * @param scope Scope in which this resource is defined. This parameter is required.
     * @param id Construct identifier for this resource (unique in its scope). This parameter is required.
     * @param props Resource properties. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public CfnDocumentationPart(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.apigateway.CfnDocumentationPartProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Examines the CloudFormation resource and discloses attributes.
     * <p>
     * @param inspector tree inspector to collect and process attributes. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public void inspect(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.TreeInspector inspector) {
        software.amazon.jsii.Kernel.call(this, "inspect", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(inspector, "inspector is required") });
    }

    /**
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> renderProperties(final @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> props) {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.call(this, "renderProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class)), new Object[] { java.util.Objects.requireNonNull(props, "props is required") }));
    }

    /**
     * The CloudFormation resource type name for this resource class.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String CFN_RESOURCE_TYPE_NAME;

    /**
     * The ID for the documentation part.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrDocumentationPartId() {
        return software.amazon.jsii.Kernel.get(this, "attrDocumentationPartId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> getCfnProperties() {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.get(this, "cfnProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class))));
    }

    /**
     * The location of the targeted API entity of the to-be-created documentation part.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.Object getLocation() {
        return software.amazon.jsii.Kernel.get(this, "location", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * The location of the targeted API entity of the to-be-created documentation part.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setLocation(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "location", java.util.Objects.requireNonNull(value, "location is required"));
    }

    /**
     * The location of the targeted API entity of the to-be-created documentation part.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setLocation(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.apigateway.CfnDocumentationPart.LocationProperty value) {
        software.amazon.jsii.Kernel.set(this, "location", java.util.Objects.requireNonNull(value, "location is required"));
    }

    /**
     * The new documentation content map of the targeted API entity.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getProperties() {
        return software.amazon.jsii.Kernel.get(this, "properties", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The new documentation content map of the targeted API entity.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setProperties(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "properties", java.util.Objects.requireNonNull(value, "properties is required"));
    }

    /**
     * The string identifier of the associated RestApi.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getRestApiId() {
        return software.amazon.jsii.Kernel.get(this, "restApiId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The string identifier of the associated RestApi.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setRestApiId(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "restApiId", java.util.Objects.requireNonNull(value, "restApiId is required"));
    }
    /**
     * The <code>Location</code> property specifies the location of the Amazon API Gateway API entity that the documentation applies to.
     * <p>
     * <code>Location</code> is a property of the <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-documentationpart.html">AWS::ApiGateway::DocumentationPart</a> resource.
     * <p>
     * <blockquote>
     * <p>
     * For more information about each property, including constraints and valid values, see <a href="https://docs.aws.amazon.com/apigateway/latest/api/API_DocumentationPartLocation.html">DocumentationPart</a> in the <em>Amazon API Gateway REST API Reference</em> .
     * <p>
     * </blockquote>
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.apigateway.*;
     * LocationProperty locationProperty = LocationProperty.builder()
     *         .method("method")
     *         .name("name")
     *         .path("path")
     *         .statusCode("statusCode")
     *         .type("type")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-documentationpart-location.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-documentationpart-location.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_apigateway.CfnDocumentationPart.LocationProperty")
    @software.amazon.jsii.Jsii.Proxy(LocationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface LocationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The HTTP verb of a method.
         * <p>
         * It is a valid field for the API entity types of <code>METHOD</code> , <code>PATH_PARAMETER</code> , <code>QUERY_PARAMETER</code> , <code>REQUEST_HEADER</code> , <code>REQUEST_BODY</code> , <code>RESPONSE</code> , <code>RESPONSE_HEADER</code> , and <code>RESPONSE_BODY</code> . The default value is <code>*</code> for any method. When an applicable child entity inherits the content of an entity of the same type with more general specifications of the other <code>location</code> attributes, the child entity's <code>method</code> attribute must match that of the parent entity exactly.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-documentationpart-location.html#cfn-apigateway-documentationpart-location-method">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-documentationpart-location.html#cfn-apigateway-documentationpart-location-method</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getMethod() {
            return null;
        }

        /**
         * The name of the targeted API entity.
         * <p>
         * It is a valid and required field for the API entity types of <code>AUTHORIZER</code> , <code>MODEL</code> , <code>PATH_PARAMETER</code> , <code>QUERY_PARAMETER</code> , <code>REQUEST_HEADER</code> , <code>REQUEST_BODY</code> and <code>RESPONSE_HEADER</code> . It is an invalid field for any other entity type.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-documentationpart-location.html#cfn-apigateway-documentationpart-location-name">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-documentationpart-location.html#cfn-apigateway-documentationpart-location-name</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getName() {
            return null;
        }

        /**
         * The URL path of the target.
         * <p>
         * It is a valid field for the API entity types of <code>RESOURCE</code> , <code>METHOD</code> , <code>PATH_PARAMETER</code> , <code>QUERY_PARAMETER</code> , <code>REQUEST_HEADER</code> , <code>REQUEST_BODY</code> , <code>RESPONSE</code> , <code>RESPONSE_HEADER</code> , and <code>RESPONSE_BODY</code> . The default value is <code>/</code> for the root resource. When an applicable child entity inherits the content of another entity of the same type with more general specifications of the other <code>location</code> attributes, the child entity's <code>path</code> attribute must match that of the parent entity as a prefix.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-documentationpart-location.html#cfn-apigateway-documentationpart-location-path">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-documentationpart-location.html#cfn-apigateway-documentationpart-location-path</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getPath() {
            return null;
        }

        /**
         * The HTTP status code of a response.
         * <p>
         * It is a valid field for the API entity types of <code>RESPONSE</code> , <code>RESPONSE_HEADER</code> , and <code>RESPONSE_BODY</code> . The default value is <code>*</code> for any status code. When an applicable child entity inherits the content of an entity of the same type with more general specifications of the other <code>location</code> attributes, the child entity's <code>statusCode</code> attribute must match that of the parent entity exactly.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-documentationpart-location.html#cfn-apigateway-documentationpart-location-statuscode">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-documentationpart-location.html#cfn-apigateway-documentationpart-location-statuscode</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getStatusCode() {
            return null;
        }

        /**
         * The type of API entity to which the documentation content applies.
         * <p>
         * Valid values are <code>API</code> , <code>AUTHORIZER</code> , <code>MODEL</code> , <code>RESOURCE</code> , <code>METHOD</code> , <code>PATH_PARAMETER</code> , <code>QUERY_PARAMETER</code> , <code>REQUEST_HEADER</code> , <code>REQUEST_BODY</code> , <code>RESPONSE</code> , <code>RESPONSE_HEADER</code> , and <code>RESPONSE_BODY</code> . Content inheritance does not apply to any entity of the <code>API</code> , <code>AUTHORIZER</code> , <code>METHOD</code> , <code>MODEL</code> , <code>REQUEST_BODY</code> , or <code>RESOURCE</code> type.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-documentationpart-location.html#cfn-apigateway-documentationpart-location-type">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-documentationpart-location.html#cfn-apigateway-documentationpart-location-type</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getType() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link LocationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link LocationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<LocationProperty> {
            java.lang.String method;
            java.lang.String name;
            java.lang.String path;
            java.lang.String statusCode;
            java.lang.String type;

            /**
             * Sets the value of {@link LocationProperty#getMethod}
             * @param method The HTTP verb of a method.
             *               It is a valid field for the API entity types of <code>METHOD</code> , <code>PATH_PARAMETER</code> , <code>QUERY_PARAMETER</code> , <code>REQUEST_HEADER</code> , <code>REQUEST_BODY</code> , <code>RESPONSE</code> , <code>RESPONSE_HEADER</code> , and <code>RESPONSE_BODY</code> . The default value is <code>*</code> for any method. When an applicable child entity inherits the content of an entity of the same type with more general specifications of the other <code>location</code> attributes, the child entity's <code>method</code> attribute must match that of the parent entity exactly.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder method(java.lang.String method) {
                this.method = method;
                return this;
            }

            /**
             * Sets the value of {@link LocationProperty#getName}
             * @param name The name of the targeted API entity.
             *             It is a valid and required field for the API entity types of <code>AUTHORIZER</code> , <code>MODEL</code> , <code>PATH_PARAMETER</code> , <code>QUERY_PARAMETER</code> , <code>REQUEST_HEADER</code> , <code>REQUEST_BODY</code> and <code>RESPONSE_HEADER</code> . It is an invalid field for any other entity type.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder name(java.lang.String name) {
                this.name = name;
                return this;
            }

            /**
             * Sets the value of {@link LocationProperty#getPath}
             * @param path The URL path of the target.
             *             It is a valid field for the API entity types of <code>RESOURCE</code> , <code>METHOD</code> , <code>PATH_PARAMETER</code> , <code>QUERY_PARAMETER</code> , <code>REQUEST_HEADER</code> , <code>REQUEST_BODY</code> , <code>RESPONSE</code> , <code>RESPONSE_HEADER</code> , and <code>RESPONSE_BODY</code> . The default value is <code>/</code> for the root resource. When an applicable child entity inherits the content of another entity of the same type with more general specifications of the other <code>location</code> attributes, the child entity's <code>path</code> attribute must match that of the parent entity as a prefix.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder path(java.lang.String path) {
                this.path = path;
                return this;
            }

            /**
             * Sets the value of {@link LocationProperty#getStatusCode}
             * @param statusCode The HTTP status code of a response.
             *                   It is a valid field for the API entity types of <code>RESPONSE</code> , <code>RESPONSE_HEADER</code> , and <code>RESPONSE_BODY</code> . The default value is <code>*</code> for any status code. When an applicable child entity inherits the content of an entity of the same type with more general specifications of the other <code>location</code> attributes, the child entity's <code>statusCode</code> attribute must match that of the parent entity exactly.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder statusCode(java.lang.String statusCode) {
                this.statusCode = statusCode;
                return this;
            }

            /**
             * Sets the value of {@link LocationProperty#getType}
             * @param type The type of API entity to which the documentation content applies.
             *             Valid values are <code>API</code> , <code>AUTHORIZER</code> , <code>MODEL</code> , <code>RESOURCE</code> , <code>METHOD</code> , <code>PATH_PARAMETER</code> , <code>QUERY_PARAMETER</code> , <code>REQUEST_HEADER</code> , <code>REQUEST_BODY</code> , <code>RESPONSE</code> , <code>RESPONSE_HEADER</code> , and <code>RESPONSE_BODY</code> . Content inheritance does not apply to any entity of the <code>API</code> , <code>AUTHORIZER</code> , <code>METHOD</code> , <code>MODEL</code> , <code>REQUEST_BODY</code> , or <code>RESOURCE</code> type.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder type(java.lang.String type) {
                this.type = type;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link LocationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public LocationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link LocationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements LocationProperty {
            private final java.lang.String method;
            private final java.lang.String name;
            private final java.lang.String path;
            private final java.lang.String statusCode;
            private final java.lang.String type;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.method = software.amazon.jsii.Kernel.get(this, "method", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.name = software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.path = software.amazon.jsii.Kernel.get(this, "path", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.statusCode = software.amazon.jsii.Kernel.get(this, "statusCode", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.type = software.amazon.jsii.Kernel.get(this, "type", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.method = builder.method;
                this.name = builder.name;
                this.path = builder.path;
                this.statusCode = builder.statusCode;
                this.type = builder.type;
            }

            @Override
            public final java.lang.String getMethod() {
                return this.method;
            }

            @Override
            public final java.lang.String getName() {
                return this.name;
            }

            @Override
            public final java.lang.String getPath() {
                return this.path;
            }

            @Override
            public final java.lang.String getStatusCode() {
                return this.statusCode;
            }

            @Override
            public final java.lang.String getType() {
                return this.type;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getMethod() != null) {
                    data.set("method", om.valueToTree(this.getMethod()));
                }
                if (this.getName() != null) {
                    data.set("name", om.valueToTree(this.getName()));
                }
                if (this.getPath() != null) {
                    data.set("path", om.valueToTree(this.getPath()));
                }
                if (this.getStatusCode() != null) {
                    data.set("statusCode", om.valueToTree(this.getStatusCode()));
                }
                if (this.getType() != null) {
                    data.set("type", om.valueToTree(this.getType()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_apigateway.CfnDocumentationPart.LocationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                LocationProperty.Jsii$Proxy that = (LocationProperty.Jsii$Proxy) o;

                if (this.method != null ? !this.method.equals(that.method) : that.method != null) return false;
                if (this.name != null ? !this.name.equals(that.name) : that.name != null) return false;
                if (this.path != null ? !this.path.equals(that.path) : that.path != null) return false;
                if (this.statusCode != null ? !this.statusCode.equals(that.statusCode) : that.statusCode != null) return false;
                return this.type != null ? this.type.equals(that.type) : that.type == null;
            }

            @Override
            public final int hashCode() {
                int result = this.method != null ? this.method.hashCode() : 0;
                result = 31 * result + (this.name != null ? this.name.hashCode() : 0);
                result = 31 * result + (this.path != null ? this.path.hashCode() : 0);
                result = 31 * result + (this.statusCode != null ? this.statusCode.hashCode() : 0);
                result = 31 * result + (this.type != null ? this.type.hashCode() : 0);
                return result;
            }
        }
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.apigateway.CfnDocumentationPart}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.apigateway.CfnDocumentationPart> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope Scope in which this resource is defined. This parameter is required.
         * @param id Construct identifier for this resource (unique in its scope). This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.apigateway.CfnDocumentationPartProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.services.apigateway.CfnDocumentationPartProps.Builder();
        }

        /**
         * The location of the targeted API entity of the to-be-created documentation part.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-documentationpart.html#cfn-apigateway-documentationpart-location">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-documentationpart.html#cfn-apigateway-documentationpart-location</a>
         * @param location The location of the targeted API entity of the to-be-created documentation part. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder location(final software.amazon.awscdk.IResolvable location) {
            this.props.location(location);
            return this;
        }
        /**
         * The location of the targeted API entity of the to-be-created documentation part.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-documentationpart.html#cfn-apigateway-documentationpart-location">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-documentationpart.html#cfn-apigateway-documentationpart-location</a>
         * @param location The location of the targeted API entity of the to-be-created documentation part. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder location(final software.amazon.awscdk.services.apigateway.CfnDocumentationPart.LocationProperty location) {
            this.props.location(location);
            return this;
        }

        /**
         * The new documentation content map of the targeted API entity.
         * <p>
         * Enclosed key-value pairs are API-specific, but only OpenAPI-compliant key-value pairs can be exported and, hence, published.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-documentationpart.html#cfn-apigateway-documentationpart-properties">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-documentationpart.html#cfn-apigateway-documentationpart-properties</a>
         * @param properties The new documentation content map of the targeted API entity. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder properties(final java.lang.String properties) {
            this.props.properties(properties);
            return this;
        }

        /**
         * The string identifier of the associated RestApi.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-documentationpart.html#cfn-apigateway-documentationpart-restapiid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-documentationpart.html#cfn-apigateway-documentationpart-restapiid</a>
         * @param restApiId The string identifier of the associated RestApi. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder restApiId(final java.lang.String restApiId) {
            this.props.restApiId(restApiId);
            return this;
        }

        /**
         * @return a newly built instance of {@link software.amazon.awscdk.services.apigateway.CfnDocumentationPart}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.apigateway.CfnDocumentationPart build() {
            return new software.amazon.awscdk.services.apigateway.CfnDocumentationPart(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
