package software.amazon.awscdk.services.apigatewayv2;

/**
 * Options for granting invoke access.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.apigatewayv2.*;
 * GrantInvokeOptions grantInvokeOptions = GrantInvokeOptions.builder()
 *         .httpMethods(List.of(HttpMethod.ANY))
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.109.0 (build c221850)", date = "2025-03-14T03:24:51.834Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_apigatewayv2.GrantInvokeOptions")
@software.amazon.jsii.Jsii.Proxy(GrantInvokeOptions.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface GrantInvokeOptions extends software.amazon.jsii.JsiiSerializable {

    /**
     * The HTTP methods to allow.
     * <p>
     * Default: - the HttpMethod of the route
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.services.apigatewayv2.HttpMethod> getHttpMethods() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link GrantInvokeOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link GrantInvokeOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<GrantInvokeOptions> {
        java.util.List<software.amazon.awscdk.services.apigatewayv2.HttpMethod> httpMethods;

        /**
         * Sets the value of {@link GrantInvokeOptions#getHttpMethods}
         * @param httpMethods The HTTP methods to allow.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder httpMethods(java.util.List<? extends software.amazon.awscdk.services.apigatewayv2.HttpMethod> httpMethods) {
            this.httpMethods = (java.util.List<software.amazon.awscdk.services.apigatewayv2.HttpMethod>)httpMethods;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link GrantInvokeOptions}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public GrantInvokeOptions build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link GrantInvokeOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements GrantInvokeOptions {
        private final java.util.List<software.amazon.awscdk.services.apigatewayv2.HttpMethod> httpMethods;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.httpMethods = software.amazon.jsii.Kernel.get(this, "httpMethods", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.apigatewayv2.HttpMethod.class)));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.httpMethods = (java.util.List<software.amazon.awscdk.services.apigatewayv2.HttpMethod>)builder.httpMethods;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.services.apigatewayv2.HttpMethod> getHttpMethods() {
            return this.httpMethods;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            if (this.getHttpMethods() != null) {
                data.set("httpMethods", om.valueToTree(this.getHttpMethods()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_apigatewayv2.GrantInvokeOptions"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            GrantInvokeOptions.Jsii$Proxy that = (GrantInvokeOptions.Jsii$Proxy) o;

            return this.httpMethods != null ? this.httpMethods.equals(that.httpMethods) : that.httpMethods == null;
        }

        @Override
        public final int hashCode() {
            int result = this.httpMethods != null ? this.httpMethods.hashCode() : 0;
            return result;
        }
    }
}
