package software.amazon.awscdk.services.apigatewayv2;

/**
 * HTTP route in APIGateway is a combination of the HTTP method and the path component.
 * <p>
 * This class models that combination.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.apigatewayv2.*;
 * HttpRouteKey httpRouteKey = HttpRouteKey.with("path", HttpMethod.ANY);
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.109.0 (build c221850)", date = "2025-03-14T03:24:51.862Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_apigatewayv2.HttpRouteKey")
public class HttpRouteKey extends software.amazon.jsii.JsiiObject {

    protected HttpRouteKey(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected HttpRouteKey(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        DEFAULT = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.apigatewayv2.HttpRouteKey.class, "DEFAULT", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.apigatewayv2.HttpRouteKey.class));
    }

    /**
     * Create a route key with the combination of the path and the method.
     * <p>
     * @param path This parameter is required.
     * @param method default is 'ANY'.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.apigatewayv2.HttpRouteKey with(final @org.jetbrains.annotations.NotNull java.lang.String path, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.apigatewayv2.HttpMethod method) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.apigatewayv2.HttpRouteKey.class, "with", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.apigatewayv2.HttpRouteKey.class), new Object[] { java.util.Objects.requireNonNull(path, "path is required"), method });
    }

    /**
     * Create a route key with the combination of the path and the method.
     * <p>
     * @param path This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.apigatewayv2.HttpRouteKey with(final @org.jetbrains.annotations.NotNull java.lang.String path) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.apigatewayv2.HttpRouteKey.class, "with", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.apigatewayv2.HttpRouteKey.class), new Object[] { java.util.Objects.requireNonNull(path, "path is required") });
    }

    /**
     * The catch-all route of the API, i.e., when no other routes match.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.apigatewayv2.HttpRouteKey DEFAULT;

    /**
     * The key to the RouteKey as recognized by APIGateway.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getKey() {
        return software.amazon.jsii.Kernel.get(this, "key", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The method of the route.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.apigatewayv2.HttpMethod getMethod() {
        return software.amazon.jsii.Kernel.get(this, "method", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.apigatewayv2.HttpMethod.class));
    }

    /**
     * The path part of this RouteKey.
     * <p>
     * Returns <code>undefined</code> when <code>RouteKey.DEFAULT</code> is used.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getPath() {
        return software.amazon.jsii.Kernel.get(this, "path", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }
}
