package software.amazon.awscdk.services.applicationautoscaling;

/**
 * One of the predefined autoscaling metrics.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * ScalableTarget shardsScalableTarget = ScalableTarget.Builder.create(this, "ElastiCacheRedisShardsScalableTarget")
 *         .serviceNamespace(ServiceNamespace.ELASTICACHE)
 *         .scalableDimension("elasticache:replication-group:NodeGroups")
 *         .minCapacity(2)
 *         .maxCapacity(10)
 *         .resourceId("replication-group/main-cluster")
 *         .build();
 * shardsScalableTarget.scaleToTrackMetric("ElastiCacheRedisShardsCPUUtilization", BasicTargetTrackingScalingPolicyProps.builder()
 *         .targetValue(20)
 *         .predefinedMetric(PredefinedMetric.ELASTICACHE_PRIMARY_ENGINE_CPU_UTILIZATION)
 *         .build());
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.109.0 (build c221850)", date = "2025-03-14T03:24:52.549Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_applicationautoscaling.PredefinedMetric")
public enum PredefinedMetric {
    /**
     * Average percentage of instances in an AppStream fleet that are being used.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    APPSTREAM_AVERAGE_CAPACITY_UTILIZATION,
    /**
     * Percentage of provisioned read capacity units utilized by a Keyspaces table.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    CASSANDRA_READ_CAPACITY_UTILIZATION,
    /**
     * Percentage of provisioned write capacity units utilized by a Keyspaces table.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    CASSANDRA_WRITE_CAPACITY_UTILIZATION,
    /**
     * Percentage of provisioned inference units utilized by a Comprehend endpoint.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    COMPREHEND_INFERENCE_UTILIZATION,
    /**
     * Average CPU Utilization of read replica instances in a Neptune DB cluster.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    NEPTURE_READER_AVERAGE_CPU_UTILIZATION,
    /**
     * Percentage of provisioned read capacity units consumed by a DynamoDB table.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    DYNAMODB_READ_CAPACITY_UTILIZATION,
    /**
     * Percentage of provisioned write capacity units consumed by a DynamoDB table.
     * <p>
     * Suffix <code>dummy</code> is necessary due to jsii bug (https://github.com/aws/jsii/issues/2782).
     * Duplicate values will be dropped, so this suffix is added as a workaround.
     * The value will be replaced when this enum is used.
     * <p>
     * @see <a href="https://docs.aws.amazon.com/autoscaling/application/APIReference/API_PredefinedMetricSpecification.html">https://docs.aws.amazon.com/autoscaling/application/APIReference/API_PredefinedMetricSpecification.html</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    DYNAMODB_WRITE_CAPACITY_UTILIZATION,
    /**
     * (deprecated) DYANMODB_WRITE_CAPACITY_UTILIZATION.
     * <p>
     * @see <a href="https://docs.aws.amazon.com/autoscaling/application/APIReference/API_PredefinedMetricSpecification.html">https://docs.aws.amazon.com/autoscaling/application/APIReference/API_PredefinedMetricSpecification.html</a>
     * @deprecated use <code>PredefinedMetric.DYNAMODB_WRITE_CAPACITY_UTILIZATION</code>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
    @Deprecated
    DYANMODB_WRITE_CAPACITY_UTILIZATION,
    /**
     * ALB_REQUEST_COUNT_PER_TARGET.
     * <p>
     * @see <a href="https://docs.aws.amazon.com/autoscaling/application/APIReference/API_PredefinedMetricSpecification.html">https://docs.aws.amazon.com/autoscaling/application/APIReference/API_PredefinedMetricSpecification.html</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    ALB_REQUEST_COUNT_PER_TARGET,
    /**
     * RDS_READER_AVERAGE_CPU_UTILIZATION.
     * <p>
     * @see <a href="https://docs.aws.amazon.com/autoscaling/application/APIReference/API_PredefinedMetricSpecification.html">https://docs.aws.amazon.com/autoscaling/application/APIReference/API_PredefinedMetricSpecification.html</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    RDS_READER_AVERAGE_CPU_UTILIZATION,
    /**
     * RDS_READER_AVERAGE_DATABASE_CONNECTIONS.
     * <p>
     * @see <a href="https://docs.aws.amazon.com/autoscaling/application/APIReference/API_PredefinedMetricSpecification.html">https://docs.aws.amazon.com/autoscaling/application/APIReference/API_PredefinedMetricSpecification.html</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    RDS_READER_AVERAGE_DATABASE_CONNECTIONS,
    /**
     * EC2_SPOT_FLEET_REQUEST_AVERAGE_CPU_UTILIZATION.
     * <p>
     * @see <a href="https://docs.aws.amazon.com/autoscaling/application/APIReference/API_PredefinedMetricSpecification.html">https://docs.aws.amazon.com/autoscaling/application/APIReference/API_PredefinedMetricSpecification.html</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    EC2_SPOT_FLEET_REQUEST_AVERAGE_CPU_UTILIZATION,
    /**
     * EC2_SPOT_FLEET_REQUEST_AVERAGE_NETWORK_IN.
     * <p>
     * @see <a href="https://docs.aws.amazon.com/autoscaling/application/APIReference/API_PredefinedMetricSpecification.html">https://docs.aws.amazon.com/autoscaling/application/APIReference/API_PredefinedMetricSpecification.html</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    EC2_SPOT_FLEET_REQUEST_AVERAGE_NETWORK_IN,
    /**
     * EC2_SPOT_FLEET_REQUEST_AVERAGE_NETWORK_OUT.
     * <p>
     * @see <a href="https://docs.aws.amazon.com/autoscaling/application/APIReference/API_PredefinedMetricSpecification.html">https://docs.aws.amazon.com/autoscaling/application/APIReference/API_PredefinedMetricSpecification.html</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    EC2_SPOT_FLEET_REQUEST_AVERAGE_NETWORK_OUT,
    /**
     * SAGEMAKER_VARIANT_INVOCATIONS_PER_INSTANCE.
     * <p>
     * @see <a href="https://docs.aws.amazon.com/autoscaling/application/APIReference/API_PredefinedMetricSpecification.html">https://docs.aws.amazon.com/autoscaling/application/APIReference/API_PredefinedMetricSpecification.html</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    SAGEMAKER_VARIANT_INVOCATIONS_PER_INSTANCE,
    /**
     * SAGEMAKER_VARIANT_PROVISIONED_CONCURRENCY_UTILIZATION.
     * <p>
     * @see <a href="https://docs.aws.amazon.com/autoscaling/application/APIReference/API_PredefinedMetricSpecification.html">https://docs.aws.amazon.com/autoscaling/application/APIReference/API_PredefinedMetricSpecification.html</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    SAGEMAKER_VARIANT_PROVISIONED_CONCURRENCY_UTILIZATION,
    /**
     * SAGEMAKER_INFERENCE_COMPONENT_INVOCATIONS_PER_COPY.
     * <p>
     * @see <a href="https://docs.aws.amazon.com/autoscaling/application/APIReference/API_PredefinedMetricSpecification.html">https://docs.aws.amazon.com/autoscaling/application/APIReference/API_PredefinedMetricSpecification.html</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    SAGEMAKER_INFERENCE_COMPONENT_INVOCATIONS_PER_COPY,
    /**
     * ECS_SERVICE_AVERAGE_CPU_UTILIZATION.
     * <p>
     * @see <a href="https://docs.aws.amazon.com/autoscaling/application/APIReference/API_PredefinedMetricSpecification.html">https://docs.aws.amazon.com/autoscaling/application/APIReference/API_PredefinedMetricSpecification.html</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    ECS_SERVICE_AVERAGE_CPU_UTILIZATION,
    /**
     * ECS_SERVICE_AVERAGE_MEMORY_UTILIZATION.
     * <p>
     * @see <a href="https://docs.aws.amazon.com/autoscaling/application/APIReference/API_PredefinedMetricSpecification.html">https://docs.aws.amazon.com/autoscaling/application/APIReference/API_PredefinedMetricSpecification.html</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    ECS_SERVICE_AVERAGE_MEMORY_UTILIZATION,
    /**
     * LAMBDA_PROVISIONED_CONCURRENCY_UTILIZATION.
     * <p>
     * @see <a href="https://docs.aws.amazon.com/lambda/latest/dg/monitoring-metrics.html#monitoring-metrics-concurrency">https://docs.aws.amazon.com/lambda/latest/dg/monitoring-metrics.html#monitoring-metrics-concurrency</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    LAMBDA_PROVISIONED_CONCURRENCY_UTILIZATION,
    /**
     * KAFKA_BROKER_STORAGE_UTILIZATION.
     * <p>
     * @see <a href="https://docs.aws.amazon.com/autoscaling/application/APIReference/API_PredefinedMetricSpecification.html">https://docs.aws.amazon.com/autoscaling/application/APIReference/API_PredefinedMetricSpecification.html</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    KAFKA_BROKER_STORAGE_UTILIZATION,
    /**
     * ELASTICACHE_PRIMARY_ENGINE_CPU_UTILIZATION.
     * <p>
     * @see <a href="https://docs.aws.amazon.com/autoscaling/application/APIReference/API_PredefinedMetricSpecification.html">https://docs.aws.amazon.com/autoscaling/application/APIReference/API_PredefinedMetricSpecification.html</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    ELASTICACHE_PRIMARY_ENGINE_CPU_UTILIZATION,
    /**
     * ELASTICACHE_REPLICA_ENGINE_CPU_UTILIZATION.
     * <p>
     * @see <a href="https://docs.aws.amazon.com/autoscaling/application/APIReference/API_PredefinedMetricSpecification.html">https://docs.aws.amazon.com/autoscaling/application/APIReference/API_PredefinedMetricSpecification.html</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    ELASTICACHE_REPLICA_ENGINE_CPU_UTILIZATION,
    /**
     * ELASTICACHE_DATABASE_MEMORY_USAGE_COUNTED_FOR_EVICT_PERCENTAGE.
     * <p>
     * @see <a href="https://docs.aws.amazon.com/autoscaling/application/APIReference/API_PredefinedMetricSpecification.html">https://docs.aws.amazon.com/autoscaling/application/APIReference/API_PredefinedMetricSpecification.html</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    ELASTICACHE_DATABASE_MEMORY_USAGE_COUNTED_FOR_EVICT_PERCENTAGE,
    /**
     * ELASTICACHE_DATABASE_CAPACITY_USAGE_COUNTED_FOR_EVICT_PERCENTAGE.
     * <p>
     * @see <a href="https://docs.aws.amazon.com/autoscaling/application/APIReference/API_PredefinedMetricSpecification.html">https://docs.aws.amazon.com/autoscaling/application/APIReference/API_PredefinedMetricSpecification.html</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    ELASTICACHE_DATABASE_CAPACITY_USAGE_COUNTED_FOR_EVICT_PERCENTAGE,
    /**
     * SAGEMAKER_INFERENCE_COMPONENT_CONCURRENT_REQUESTS_PER_COPY_HIGH_RESOLUTION.
     * <p>
     * @see <a href="https://docs.aws.amazon.com/autoscaling/application/APIReference/API_PredefinedMetricSpecification.html">https://docs.aws.amazon.com/autoscaling/application/APIReference/API_PredefinedMetricSpecification.html</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    SAGEMAKER_INFERENCE_COMPONENT_CONCURRENT_REQUESTS_PER_COPY_HIGH_RESOLUTION,
    /**
     * SAGEMAKER_VARIANT_CONCURRENT_REQUESTS_PER_MODEL_HIGH_RESOLUTION.
     * <p>
     * @see <a href="https://docs.aws.amazon.com/autoscaling/application/APIReference/API_PredefinedMetricSpecification.html">https://docs.aws.amazon.com/autoscaling/application/APIReference/API_PredefinedMetricSpecification.html</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    SAGEMAKER_VARIANT_CONCURRENT_REQUESTS_PER_MODEL_HIGH_RESOLUTION,
    /**
     * WORKSPACES_AVERAGE_USER_SESSIONS_CAPACITY_UTILIZATION.
     * <p>
     * @see <a href="https://docs.aws.amazon.com/autoscaling/application/APIReference/API_PredefinedMetricSpecification.html">https://docs.aws.amazon.com/autoscaling/application/APIReference/API_PredefinedMetricSpecification.html</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    WORKSPACES_AVERAGE_USER_SESSIONS_CAPACITY_UTILIZATION,
}
