package software.amazon.awscdk.services.applicationautoscaling;

/**
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.*;
 * import software.amazon.awscdk.services.applicationautoscaling.*;
 * import software.amazon.awscdk.services.cloudwatch.*;
 * Metric metric;
 * ScalableTarget scalableTarget;
 * StepScalingPolicyProps stepScalingPolicyProps = StepScalingPolicyProps.builder()
 *         .metric(metric)
 *         .scalingSteps(List.of(ScalingInterval.builder()
 *                 .change(123)
 *                 // the properties below are optional
 *                 .lower(123)
 *                 .upper(123)
 *                 .build()))
 *         .scalingTarget(scalableTarget)
 *         // the properties below are optional
 *         .adjustmentType(AdjustmentType.CHANGE_IN_CAPACITY)
 *         .cooldown(Duration.minutes(30))
 *         .datapointsToAlarm(123)
 *         .evaluationPeriods(123)
 *         .metricAggregationType(MetricAggregationType.AVERAGE)
 *         .minAdjustmentMagnitude(123)
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.109.0 (build c221850)", date = "2025-03-14T03:24:52.566Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_applicationautoscaling.StepScalingPolicyProps")
@software.amazon.jsii.Jsii.Proxy(StepScalingPolicyProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface StepScalingPolicyProps extends software.amazon.jsii.JsiiSerializable, software.amazon.awscdk.services.applicationautoscaling.BasicStepScalingPolicyProps {

    /**
     * The scaling target.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.applicationautoscaling.IScalableTarget getScalingTarget();

    /**
     * @return a {@link Builder} of {@link StepScalingPolicyProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link StepScalingPolicyProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<StepScalingPolicyProps> {
        software.amazon.awscdk.services.applicationautoscaling.IScalableTarget scalingTarget;
        software.amazon.awscdk.services.cloudwatch.IMetric metric;
        java.util.List<software.amazon.awscdk.services.applicationautoscaling.ScalingInterval> scalingSteps;
        software.amazon.awscdk.services.applicationautoscaling.AdjustmentType adjustmentType;
        software.amazon.awscdk.Duration cooldown;
        java.lang.Number datapointsToAlarm;
        java.lang.Number evaluationPeriods;
        software.amazon.awscdk.services.applicationautoscaling.MetricAggregationType metricAggregationType;
        java.lang.Number minAdjustmentMagnitude;

        /**
         * Sets the value of {@link StepScalingPolicyProps#getScalingTarget}
         * @param scalingTarget The scaling target. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder scalingTarget(software.amazon.awscdk.services.applicationautoscaling.IScalableTarget scalingTarget) {
            this.scalingTarget = scalingTarget;
            return this;
        }

        /**
         * Sets the value of {@link StepScalingPolicyProps#getMetric}
         * @param metric Metric to scale on. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder metric(software.amazon.awscdk.services.cloudwatch.IMetric metric) {
            this.metric = metric;
            return this;
        }

        /**
         * Sets the value of {@link StepScalingPolicyProps#getScalingSteps}
         * @param scalingSteps The intervals for scaling. This parameter is required.
         *                     Maps a range of metric values to a particular scaling behavior.
         *                     <p>
         *                     Must be between 2 and 40 steps.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder scalingSteps(java.util.List<? extends software.amazon.awscdk.services.applicationautoscaling.ScalingInterval> scalingSteps) {
            this.scalingSteps = (java.util.List<software.amazon.awscdk.services.applicationautoscaling.ScalingInterval>)scalingSteps;
            return this;
        }

        /**
         * Sets the value of {@link StepScalingPolicyProps#getAdjustmentType}
         * @param adjustmentType How the adjustment numbers inside 'intervals' are interpreted.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder adjustmentType(software.amazon.awscdk.services.applicationautoscaling.AdjustmentType adjustmentType) {
            this.adjustmentType = adjustmentType;
            return this;
        }

        /**
         * Sets the value of {@link StepScalingPolicyProps#getCooldown}
         * @param cooldown Grace period after scaling activity.
         *                 Subsequent scale outs during the cooldown period are squashed so that only
         *                 the biggest scale out happens.
         *                 <p>
         *                 Subsequent scale ins during the cooldown period are ignored.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder cooldown(software.amazon.awscdk.Duration cooldown) {
            this.cooldown = cooldown;
            return this;
        }

        /**
         * Sets the value of {@link StepScalingPolicyProps#getDatapointsToAlarm}
         * @param datapointsToAlarm The number of data points out of the evaluation periods that must be breaching to trigger a scaling action.
         *                          Creates an "M out of N" alarm, where this property is the M and the value set for
         *                          <code>evaluationPeriods</code> is the N value.
         *                          <p>
         *                          Only has meaning if <code>evaluationPeriods != 1</code>.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder datapointsToAlarm(java.lang.Number datapointsToAlarm) {
            this.datapointsToAlarm = datapointsToAlarm;
            return this;
        }

        /**
         * Sets the value of {@link StepScalingPolicyProps#getEvaluationPeriods}
         * @param evaluationPeriods How many evaluation periods of the metric to wait before triggering a scaling action.
         *                          Raising this value can be used to smooth out the metric, at the expense
         *                          of slower response times.
         *                          <p>
         *                          If <code>datapointsToAlarm</code> is not set, then all data points in the evaluation period
         *                          must meet the criteria to trigger a scaling action.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder evaluationPeriods(java.lang.Number evaluationPeriods) {
            this.evaluationPeriods = evaluationPeriods;
            return this;
        }

        /**
         * Sets the value of {@link StepScalingPolicyProps#getMetricAggregationType}
         * @param metricAggregationType Aggregation to apply to all data points over the evaluation periods.
         *                              Only has meaning if <code>evaluationPeriods != 1</code>.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder metricAggregationType(software.amazon.awscdk.services.applicationautoscaling.MetricAggregationType metricAggregationType) {
            this.metricAggregationType = metricAggregationType;
            return this;
        }

        /**
         * Sets the value of {@link StepScalingPolicyProps#getMinAdjustmentMagnitude}
         * @param minAdjustmentMagnitude Minimum absolute number to adjust capacity with as result of percentage scaling.
         *                               Only when using AdjustmentType = PercentChangeInCapacity, this number controls
         *                               the minimum absolute effect size.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder minAdjustmentMagnitude(java.lang.Number minAdjustmentMagnitude) {
            this.minAdjustmentMagnitude = minAdjustmentMagnitude;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link StepScalingPolicyProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public StepScalingPolicyProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link StepScalingPolicyProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements StepScalingPolicyProps {
        private final software.amazon.awscdk.services.applicationautoscaling.IScalableTarget scalingTarget;
        private final software.amazon.awscdk.services.cloudwatch.IMetric metric;
        private final java.util.List<software.amazon.awscdk.services.applicationautoscaling.ScalingInterval> scalingSteps;
        private final software.amazon.awscdk.services.applicationautoscaling.AdjustmentType adjustmentType;
        private final software.amazon.awscdk.Duration cooldown;
        private final java.lang.Number datapointsToAlarm;
        private final java.lang.Number evaluationPeriods;
        private final software.amazon.awscdk.services.applicationautoscaling.MetricAggregationType metricAggregationType;
        private final java.lang.Number minAdjustmentMagnitude;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.scalingTarget = software.amazon.jsii.Kernel.get(this, "scalingTarget", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.applicationautoscaling.IScalableTarget.class));
            this.metric = software.amazon.jsii.Kernel.get(this, "metric", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.IMetric.class));
            this.scalingSteps = software.amazon.jsii.Kernel.get(this, "scalingSteps", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.applicationautoscaling.ScalingInterval.class)));
            this.adjustmentType = software.amazon.jsii.Kernel.get(this, "adjustmentType", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.applicationautoscaling.AdjustmentType.class));
            this.cooldown = software.amazon.jsii.Kernel.get(this, "cooldown", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.Duration.class));
            this.datapointsToAlarm = software.amazon.jsii.Kernel.get(this, "datapointsToAlarm", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            this.evaluationPeriods = software.amazon.jsii.Kernel.get(this, "evaluationPeriods", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            this.metricAggregationType = software.amazon.jsii.Kernel.get(this, "metricAggregationType", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.applicationautoscaling.MetricAggregationType.class));
            this.minAdjustmentMagnitude = software.amazon.jsii.Kernel.get(this, "minAdjustmentMagnitude", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.scalingTarget = java.util.Objects.requireNonNull(builder.scalingTarget, "scalingTarget is required");
            this.metric = java.util.Objects.requireNonNull(builder.metric, "metric is required");
            this.scalingSteps = (java.util.List<software.amazon.awscdk.services.applicationautoscaling.ScalingInterval>)java.util.Objects.requireNonNull(builder.scalingSteps, "scalingSteps is required");
            this.adjustmentType = builder.adjustmentType;
            this.cooldown = builder.cooldown;
            this.datapointsToAlarm = builder.datapointsToAlarm;
            this.evaluationPeriods = builder.evaluationPeriods;
            this.metricAggregationType = builder.metricAggregationType;
            this.minAdjustmentMagnitude = builder.minAdjustmentMagnitude;
        }

        @Override
        public final software.amazon.awscdk.services.applicationautoscaling.IScalableTarget getScalingTarget() {
            return this.scalingTarget;
        }

        @Override
        public final software.amazon.awscdk.services.cloudwatch.IMetric getMetric() {
            return this.metric;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.services.applicationautoscaling.ScalingInterval> getScalingSteps() {
            return this.scalingSteps;
        }

        @Override
        public final software.amazon.awscdk.services.applicationautoscaling.AdjustmentType getAdjustmentType() {
            return this.adjustmentType;
        }

        @Override
        public final software.amazon.awscdk.Duration getCooldown() {
            return this.cooldown;
        }

        @Override
        public final java.lang.Number getDatapointsToAlarm() {
            return this.datapointsToAlarm;
        }

        @Override
        public final java.lang.Number getEvaluationPeriods() {
            return this.evaluationPeriods;
        }

        @Override
        public final software.amazon.awscdk.services.applicationautoscaling.MetricAggregationType getMetricAggregationType() {
            return this.metricAggregationType;
        }

        @Override
        public final java.lang.Number getMinAdjustmentMagnitude() {
            return this.minAdjustmentMagnitude;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("scalingTarget", om.valueToTree(this.getScalingTarget()));
            data.set("metric", om.valueToTree(this.getMetric()));
            data.set("scalingSteps", om.valueToTree(this.getScalingSteps()));
            if (this.getAdjustmentType() != null) {
                data.set("adjustmentType", om.valueToTree(this.getAdjustmentType()));
            }
            if (this.getCooldown() != null) {
                data.set("cooldown", om.valueToTree(this.getCooldown()));
            }
            if (this.getDatapointsToAlarm() != null) {
                data.set("datapointsToAlarm", om.valueToTree(this.getDatapointsToAlarm()));
            }
            if (this.getEvaluationPeriods() != null) {
                data.set("evaluationPeriods", om.valueToTree(this.getEvaluationPeriods()));
            }
            if (this.getMetricAggregationType() != null) {
                data.set("metricAggregationType", om.valueToTree(this.getMetricAggregationType()));
            }
            if (this.getMinAdjustmentMagnitude() != null) {
                data.set("minAdjustmentMagnitude", om.valueToTree(this.getMinAdjustmentMagnitude()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_applicationautoscaling.StepScalingPolicyProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            StepScalingPolicyProps.Jsii$Proxy that = (StepScalingPolicyProps.Jsii$Proxy) o;

            if (!scalingTarget.equals(that.scalingTarget)) return false;
            if (!metric.equals(that.metric)) return false;
            if (!scalingSteps.equals(that.scalingSteps)) return false;
            if (this.adjustmentType != null ? !this.adjustmentType.equals(that.adjustmentType) : that.adjustmentType != null) return false;
            if (this.cooldown != null ? !this.cooldown.equals(that.cooldown) : that.cooldown != null) return false;
            if (this.datapointsToAlarm != null ? !this.datapointsToAlarm.equals(that.datapointsToAlarm) : that.datapointsToAlarm != null) return false;
            if (this.evaluationPeriods != null ? !this.evaluationPeriods.equals(that.evaluationPeriods) : that.evaluationPeriods != null) return false;
            if (this.metricAggregationType != null ? !this.metricAggregationType.equals(that.metricAggregationType) : that.metricAggregationType != null) return false;
            return this.minAdjustmentMagnitude != null ? this.minAdjustmentMagnitude.equals(that.minAdjustmentMagnitude) : that.minAdjustmentMagnitude == null;
        }

        @Override
        public final int hashCode() {
            int result = this.scalingTarget.hashCode();
            result = 31 * result + (this.metric.hashCode());
            result = 31 * result + (this.scalingSteps.hashCode());
            result = 31 * result + (this.adjustmentType != null ? this.adjustmentType.hashCode() : 0);
            result = 31 * result + (this.cooldown != null ? this.cooldown.hashCode() : 0);
            result = 31 * result + (this.datapointsToAlarm != null ? this.datapointsToAlarm.hashCode() : 0);
            result = 31 * result + (this.evaluationPeriods != null ? this.evaluationPeriods.hashCode() : 0);
            result = 31 * result + (this.metricAggregationType != null ? this.metricAggregationType.hashCode() : 0);
            result = 31 * result + (this.minAdjustmentMagnitude != null ? this.minAdjustmentMagnitude.hashCode() : 0);
            return result;
        }
    }
}
