package software.amazon.awscdk.services.appmesh;

/**
 * Interface with properties ncecessary to import a reusable VirtualRouter.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.appmesh.*;
 * Mesh mesh;
 * VirtualRouterAttributes virtualRouterAttributes = VirtualRouterAttributes.builder()
 *         .mesh(mesh)
 *         .virtualRouterName("virtualRouterName")
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.109.0 (build c221850)", date = "2025-03-14T03:24:53.106Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_appmesh.VirtualRouterAttributes")
@software.amazon.jsii.Jsii.Proxy(VirtualRouterAttributes.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface VirtualRouterAttributes extends software.amazon.jsii.JsiiSerializable {

    /**
     * The Mesh which the VirtualRouter belongs to.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.appmesh.IMesh getMesh();

    /**
     * The name of the VirtualRouter.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getVirtualRouterName();

    /**
     * @return a {@link Builder} of {@link VirtualRouterAttributes}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link VirtualRouterAttributes}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<VirtualRouterAttributes> {
        software.amazon.awscdk.services.appmesh.IMesh mesh;
        java.lang.String virtualRouterName;

        /**
         * Sets the value of {@link VirtualRouterAttributes#getMesh}
         * @param mesh The Mesh which the VirtualRouter belongs to. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder mesh(software.amazon.awscdk.services.appmesh.IMesh mesh) {
            this.mesh = mesh;
            return this;
        }

        /**
         * Sets the value of {@link VirtualRouterAttributes#getVirtualRouterName}
         * @param virtualRouterName The name of the VirtualRouter. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder virtualRouterName(java.lang.String virtualRouterName) {
            this.virtualRouterName = virtualRouterName;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link VirtualRouterAttributes}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public VirtualRouterAttributes build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link VirtualRouterAttributes}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements VirtualRouterAttributes {
        private final software.amazon.awscdk.services.appmesh.IMesh mesh;
        private final java.lang.String virtualRouterName;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.mesh = software.amazon.jsii.Kernel.get(this, "mesh", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.appmesh.IMesh.class));
            this.virtualRouterName = software.amazon.jsii.Kernel.get(this, "virtualRouterName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.mesh = java.util.Objects.requireNonNull(builder.mesh, "mesh is required");
            this.virtualRouterName = java.util.Objects.requireNonNull(builder.virtualRouterName, "virtualRouterName is required");
        }

        @Override
        public final software.amazon.awscdk.services.appmesh.IMesh getMesh() {
            return this.mesh;
        }

        @Override
        public final java.lang.String getVirtualRouterName() {
            return this.virtualRouterName;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("mesh", om.valueToTree(this.getMesh()));
            data.set("virtualRouterName", om.valueToTree(this.getVirtualRouterName()));

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_appmesh.VirtualRouterAttributes"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            VirtualRouterAttributes.Jsii$Proxy that = (VirtualRouterAttributes.Jsii$Proxy) o;

            if (!mesh.equals(that.mesh)) return false;
            return this.virtualRouterName.equals(that.virtualRouterName);
        }

        @Override
        public final int hashCode() {
            int result = this.mesh.hashCode();
            result = 31 * result + (this.virtualRouterName.hashCode());
            return result;
        }
    }
}
