package software.amazon.awscdk.services.appsync;

/**
 * Additional property for an AppSync channel namespace for an Event API reference.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * EventApi api;
 * ChannelNamespace.Builder.create(this, "Namespace")
 *         .api(api)
 *         .authorizationConfig(NamespaceAuthConfig.builder()
 *                 // Override publishing authorization to API Key
 *                 .publishAuthModeTypes(List.of(AppSyncAuthorizationType.API_KEY))
 *                 // Override subscribing authorization to Lambda
 *                 .subscribeAuthModeTypes(List.of(AppSyncAuthorizationType.LAMBDA))
 *                 .build())
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.109.0 (build c221850)", date = "2025-03-14T03:24:53.573Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_appsync.ChannelNamespaceProps")
@software.amazon.jsii.Jsii.Proxy(ChannelNamespaceProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface ChannelNamespaceProps extends software.amazon.jsii.JsiiSerializable, software.amazon.awscdk.services.appsync.BaseChannelNamespaceProps {

    /**
     * The API this channel namespace is associated with.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.appsync.IEventApi getApi();

    /**
     * @return a {@link Builder} of {@link ChannelNamespaceProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link ChannelNamespaceProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<ChannelNamespaceProps> {
        software.amazon.awscdk.services.appsync.IEventApi api;
        software.amazon.awscdk.services.appsync.NamespaceAuthConfig authorizationConfig;
        java.lang.String channelNamespaceName;
        software.amazon.awscdk.services.appsync.Code code;

        /**
         * Sets the value of {@link ChannelNamespaceProps#getApi}
         * @param api The API this channel namespace is associated with. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder api(software.amazon.awscdk.services.appsync.IEventApi api) {
            this.api = api;
            return this;
        }

        /**
         * Sets the value of {@link ChannelNamespaceProps#getAuthorizationConfig}
         * @param authorizationConfig Authorization config for channel namespace.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder authorizationConfig(software.amazon.awscdk.services.appsync.NamespaceAuthConfig authorizationConfig) {
            this.authorizationConfig = authorizationConfig;
            return this;
        }

        /**
         * Sets the value of {@link ChannelNamespaceProps#getChannelNamespaceName}
         * @param channelNamespaceName the name of the channel namespace.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder channelNamespaceName(java.lang.String channelNamespaceName) {
            this.channelNamespaceName = channelNamespaceName;
            return this;
        }

        /**
         * Sets the value of {@link ChannelNamespaceProps#getCode}
         * @param code The Event Handler code.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder code(software.amazon.awscdk.services.appsync.Code code) {
            this.code = code;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link ChannelNamespaceProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public ChannelNamespaceProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link ChannelNamespaceProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ChannelNamespaceProps {
        private final software.amazon.awscdk.services.appsync.IEventApi api;
        private final software.amazon.awscdk.services.appsync.NamespaceAuthConfig authorizationConfig;
        private final java.lang.String channelNamespaceName;
        private final software.amazon.awscdk.services.appsync.Code code;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.api = software.amazon.jsii.Kernel.get(this, "api", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.appsync.IEventApi.class));
            this.authorizationConfig = software.amazon.jsii.Kernel.get(this, "authorizationConfig", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.appsync.NamespaceAuthConfig.class));
            this.channelNamespaceName = software.amazon.jsii.Kernel.get(this, "channelNamespaceName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.code = software.amazon.jsii.Kernel.get(this, "code", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.appsync.Code.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.api = java.util.Objects.requireNonNull(builder.api, "api is required");
            this.authorizationConfig = builder.authorizationConfig;
            this.channelNamespaceName = builder.channelNamespaceName;
            this.code = builder.code;
        }

        @Override
        public final software.amazon.awscdk.services.appsync.IEventApi getApi() {
            return this.api;
        }

        @Override
        public final software.amazon.awscdk.services.appsync.NamespaceAuthConfig getAuthorizationConfig() {
            return this.authorizationConfig;
        }

        @Override
        public final java.lang.String getChannelNamespaceName() {
            return this.channelNamespaceName;
        }

        @Override
        public final software.amazon.awscdk.services.appsync.Code getCode() {
            return this.code;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("api", om.valueToTree(this.getApi()));
            if (this.getAuthorizationConfig() != null) {
                data.set("authorizationConfig", om.valueToTree(this.getAuthorizationConfig()));
            }
            if (this.getChannelNamespaceName() != null) {
                data.set("channelNamespaceName", om.valueToTree(this.getChannelNamespaceName()));
            }
            if (this.getCode() != null) {
                data.set("code", om.valueToTree(this.getCode()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_appsync.ChannelNamespaceProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            ChannelNamespaceProps.Jsii$Proxy that = (ChannelNamespaceProps.Jsii$Proxy) o;

            if (!api.equals(that.api)) return false;
            if (this.authorizationConfig != null ? !this.authorizationConfig.equals(that.authorizationConfig) : that.authorizationConfig != null) return false;
            if (this.channelNamespaceName != null ? !this.channelNamespaceName.equals(that.channelNamespaceName) : that.channelNamespaceName != null) return false;
            return this.code != null ? this.code.equals(that.code) : that.code == null;
        }

        @Override
        public final int hashCode() {
            int result = this.api.hashCode();
            result = 31 * result + (this.authorizationConfig != null ? this.authorizationConfig.hashCode() : 0);
            result = 31 * result + (this.channelNamespaceName != null ? this.channelNamespaceName.hashCode() : 0);
            result = 31 * result + (this.code != null ? this.code.hashCode() : 0);
            return result;
        }
    }
}
