package software.amazon.awscdk.services.athena;

/**
 * The AWS::Athena::WorkGroup resource specifies an Amazon Athena workgroup, which contains a name, description, creation time, state, and other configuration, listed under <code>WorkGroupConfiguration</code> .
 * <p>
 * Each workgroup enables you to isolate queries for you or your group from other queries in the same account. For more information, see <a href="https://docs.aws.amazon.com/athena/latest/APIReference/API_CreateWorkGroup.html">CreateWorkGroup</a> in the <em>Amazon Athena API Reference</em> .
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.athena.*;
 * CfnWorkGroup cfnWorkGroup = CfnWorkGroup.Builder.create(this, "MyCfnWorkGroup")
 *         .name("name")
 *         // the properties below are optional
 *         .description("description")
 *         .recursiveDeleteOption(false)
 *         .state("state")
 *         .tags(List.of(CfnTag.builder()
 *                 .key("key")
 *                 .value("value")
 *                 .build()))
 *         .workGroupConfiguration(WorkGroupConfigurationProperty.builder()
 *                 .additionalConfiguration("additionalConfiguration")
 *                 .bytesScannedCutoffPerQuery(123)
 *                 .customerContentEncryptionConfiguration(CustomerContentEncryptionConfigurationProperty.builder()
 *                         .kmsKey("kmsKey")
 *                         .build())
 *                 .enforceWorkGroupConfiguration(false)
 *                 .engineVersion(EngineVersionProperty.builder()
 *                         .effectiveEngineVersion("effectiveEngineVersion")
 *                         .selectedEngineVersion("selectedEngineVersion")
 *                         .build())
 *                 .executionRole("executionRole")
 *                 .publishCloudWatchMetricsEnabled(false)
 *                 .requesterPaysEnabled(false)
 *                 .resultConfiguration(ResultConfigurationProperty.builder()
 *                         .aclConfiguration(AclConfigurationProperty.builder()
 *                                 .s3AclOption("s3AclOption")
 *                                 .build())
 *                         .encryptionConfiguration(EncryptionConfigurationProperty.builder()
 *                                 .encryptionOption("encryptionOption")
 *                                 // the properties below are optional
 *                                 .kmsKey("kmsKey")
 *                                 .build())
 *                         .expectedBucketOwner("expectedBucketOwner")
 *                         .outputLocation("outputLocation")
 *                         .build())
 *                 .build())
 *         .workGroupConfigurationUpdates(WorkGroupConfigurationUpdatesProperty.builder()
 *                 .additionalConfiguration("additionalConfiguration")
 *                 .bytesScannedCutoffPerQuery(123)
 *                 .customerContentEncryptionConfiguration(CustomerContentEncryptionConfigurationProperty.builder()
 *                         .kmsKey("kmsKey")
 *                         .build())
 *                 .enforceWorkGroupConfiguration(false)
 *                 .engineVersion(EngineVersionProperty.builder()
 *                         .effectiveEngineVersion("effectiveEngineVersion")
 *                         .selectedEngineVersion("selectedEngineVersion")
 *                         .build())
 *                 .executionRole("executionRole")
 *                 .publishCloudWatchMetricsEnabled(false)
 *                 .removeBytesScannedCutoffPerQuery(false)
 *                 .removeCustomerContentEncryptionConfiguration(false)
 *                 .requesterPaysEnabled(false)
 *                 .resultConfigurationUpdates(ResultConfigurationUpdatesProperty.builder()
 *                         .aclConfiguration(AclConfigurationProperty.builder()
 *                                 .s3AclOption("s3AclOption")
 *                                 .build())
 *                         .encryptionConfiguration(EncryptionConfigurationProperty.builder()
 *                                 .encryptionOption("encryptionOption")
 *                                 // the properties below are optional
 *                                 .kmsKey("kmsKey")
 *                                 .build())
 *                         .expectedBucketOwner("expectedBucketOwner")
 *                         .outputLocation("outputLocation")
 *                         .removeAclConfiguration(false)
 *                         .removeEncryptionConfiguration(false)
 *                         .removeExpectedBucketOwner(false)
 *                         .removeOutputLocation(false)
 *                         .build())
 *                 .build())
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-athena-workgroup.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-athena-workgroup.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.109.0 (build c221850)", date = "2025-03-14T03:24:53.684Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_athena.CfnWorkGroup")
public class CfnWorkGroup extends software.amazon.awscdk.CfnResource implements software.amazon.awscdk.IInspectable, software.amazon.awscdk.ITaggable {

    protected CfnWorkGroup(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnWorkGroup(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        CFN_RESOURCE_TYPE_NAME = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.athena.CfnWorkGroup.class, "CFN_RESOURCE_TYPE_NAME", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * @param scope Scope in which this resource is defined. This parameter is required.
     * @param id Construct identifier for this resource (unique in its scope). This parameter is required.
     * @param props Resource properties. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public CfnWorkGroup(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.athena.CfnWorkGroupProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Examines the CloudFormation resource and discloses attributes.
     * <p>
     * @param inspector tree inspector to collect and process attributes. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public void inspect(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.TreeInspector inspector) {
        software.amazon.jsii.Kernel.call(this, "inspect", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(inspector, "inspector is required") });
    }

    /**
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> renderProperties(final @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> props) {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.call(this, "renderProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class)), new Object[] { java.util.Objects.requireNonNull(props, "props is required") }));
    }

    /**
     * The CloudFormation resource type name for this resource class.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String CFN_RESOURCE_TYPE_NAME;

    /**
     * The date and time the workgroup was created, as a UNIX timestamp in seconds.
     * <p>
     * For example: <code>1582761016</code> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrCreationTime() {
        return software.amazon.jsii.Kernel.get(this, "attrCreationTime", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Read only.
     * <p>
     * The engine version on which the query runs. If the user requests a valid engine version other than Auto, the effective engine version is the same as the engine version that the user requested. If the user requests Auto, the effective engine version is chosen by Athena. When a request to update the engine version is made by a CreateWorkGroup or UpdateWorkGroup operation, the EffectiveEngineVersion field is ignored.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrWorkGroupConfigurationEngineVersionEffectiveEngineVersion() {
        return software.amazon.jsii.Kernel.get(this, "attrWorkGroupConfigurationEngineVersionEffectiveEngineVersion", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Read only.
     * <p>
     * The engine version on which the query runs. If the user requests a valid engine version other than Auto, the effective engine version is the same as the engine version that the user requested. If the user requests Auto, the effective engine version is chosen by Athena. When a request to update the engine version is made by a <code>CreateWorkGroup</code> or <code>UpdateWorkGroup</code> operation, the <code>EffectiveEngineVersion</code> field is ignored.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrWorkGroupConfigurationUpdatesEngineVersionEffectiveEngineVersion() {
        return software.amazon.jsii.Kernel.get(this, "attrWorkGroupConfigurationUpdatesEngineVersionEffectiveEngineVersion", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> getCfnProperties() {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.get(this, "cfnProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class))));
    }

    /**
     * Tag Manager which manages the tags for this resource.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.TagManager getTags() {
        return software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.TagManager.class));
    }

    /**
     * The workgroup name.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getName() {
        return software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The workgroup name.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setName(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "name", java.util.Objects.requireNonNull(value, "name is required"));
    }

    /**
     * The workgroup description.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getDescription() {
        return software.amazon.jsii.Kernel.get(this, "description", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The workgroup description.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setDescription(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "description", value);
    }

    /**
     * The option to delete a workgroup and its contents even if the workgroup contains any named queries.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getRecursiveDeleteOption() {
        return software.amazon.jsii.Kernel.get(this, "recursiveDeleteOption", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * The option to delete a workgroup and its contents even if the workgroup contains any named queries.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setRecursiveDeleteOption(final @org.jetbrains.annotations.Nullable java.lang.Boolean value) {
        software.amazon.jsii.Kernel.set(this, "recursiveDeleteOption", value);
    }

    /**
     * The option to delete a workgroup and its contents even if the workgroup contains any named queries.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setRecursiveDeleteOption(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "recursiveDeleteOption", value);
    }

    /**
     * The state of the workgroup: ENABLED or DISABLED.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getState() {
        return software.amazon.jsii.Kernel.get(this, "state", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The state of the workgroup: ENABLED or DISABLED.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setState(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "state", value);
    }

    /**
     * The tags (key-value pairs) to associate with this resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.CfnTag> getTagsRaw() {
        return java.util.Optional.ofNullable((java.util.List<software.amazon.awscdk.CfnTag>)(software.amazon.jsii.Kernel.get(this, "tagsRaw", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.CfnTag.class))))).map(java.util.Collections::unmodifiableList).orElse(null);
    }

    /**
     * The tags (key-value pairs) to associate with this resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setTagsRaw(final @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.CfnTag> value) {
        software.amazon.jsii.Kernel.set(this, "tagsRaw", value);
    }

    /**
     * The configuration of the workgroup, which includes the location in Amazon S3 where query results are stored, the encryption option, if any, used for query results, whether Amazon CloudWatch Metrics are enabled for the workgroup, and the limit for the amount of bytes scanned (cutoff) per query, if it is specified.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getWorkGroupConfiguration() {
        return software.amazon.jsii.Kernel.get(this, "workGroupConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * The configuration of the workgroup, which includes the location in Amazon S3 where query results are stored, the encryption option, if any, used for query results, whether Amazon CloudWatch Metrics are enabled for the workgroup, and the limit for the amount of bytes scanned (cutoff) per query, if it is specified.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setWorkGroupConfiguration(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "workGroupConfiguration", value);
    }

    /**
     * The configuration of the workgroup, which includes the location in Amazon S3 where query results are stored, the encryption option, if any, used for query results, whether Amazon CloudWatch Metrics are enabled for the workgroup, and the limit for the amount of bytes scanned (cutoff) per query, if it is specified.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setWorkGroupConfiguration(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.athena.CfnWorkGroup.WorkGroupConfigurationProperty value) {
        software.amazon.jsii.Kernel.set(this, "workGroupConfiguration", value);
    }

    /**
     * (deprecated) The configuration information that will be updated for this workgroup, which includes the location in Amazon S3 where query results are stored, the encryption option, if any, used for query results, whether the Amazon CloudWatch Metrics are enabled for the workgroup, whether the workgroup settings override the client-side settings, and the data usage limit for the amount of bytes scanned per query, if it is specified.
     * <p>
     * @deprecated this property has been deprecated
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
    @Deprecated
    public @org.jetbrains.annotations.Nullable java.lang.Object getWorkGroupConfigurationUpdates() {
        return software.amazon.jsii.Kernel.get(this, "workGroupConfigurationUpdates", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * (deprecated) The configuration information that will be updated for this workgroup, which includes the location in Amazon S3 where query results are stored, the encryption option, if any, used for query results, whether the Amazon CloudWatch Metrics are enabled for the workgroup, whether the workgroup settings override the client-side settings, and the data usage limit for the amount of bytes scanned per query, if it is specified.
     * <p>
     * @deprecated this property has been deprecated
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
    @Deprecated
    public void setWorkGroupConfigurationUpdates(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "workGroupConfigurationUpdates", value);
    }

    /**
     * (deprecated) The configuration information that will be updated for this workgroup, which includes the location in Amazon S3 where query results are stored, the encryption option, if any, used for query results, whether the Amazon CloudWatch Metrics are enabled for the workgroup, whether the workgroup settings override the client-side settings, and the data usage limit for the amount of bytes scanned per query, if it is specified.
     * <p>
     * @deprecated this property has been deprecated
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
    @Deprecated
    public void setWorkGroupConfigurationUpdates(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.athena.CfnWorkGroup.WorkGroupConfigurationUpdatesProperty value) {
        software.amazon.jsii.Kernel.set(this, "workGroupConfigurationUpdates", value);
    }
    /**
     * Indicates that an Amazon S3 canned ACL should be set to control ownership of stored query results, including data files inserted by Athena as the result of statements like CTAS or INSERT INTO.
     * <p>
     * When Athena stores query results in Amazon S3, the canned ACL is set with the <code>x-amz-acl</code> request header. For more information about S3 Object Ownership, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/about-object-ownership.html#object-ownership-overview">Object Ownership settings</a> in the <em>Amazon S3 User Guide</em> .
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.athena.*;
     * AclConfigurationProperty aclConfigurationProperty = AclConfigurationProperty.builder()
     *         .s3AclOption("s3AclOption")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-athena-workgroup-aclconfiguration.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-athena-workgroup-aclconfiguration.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_athena.CfnWorkGroup.AclConfigurationProperty")
    @software.amazon.jsii.Jsii.Proxy(AclConfigurationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface AclConfigurationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The Amazon S3 canned ACL that Athena should specify when storing query results, including data files inserted by Athena as the result of statements like CTAS or INSERT INTO.
         * <p>
         * Currently the only supported canned ACL is <code>BUCKET_OWNER_FULL_CONTROL</code> . If a query runs in a workgroup and the workgroup overrides client-side settings, then the Amazon S3 canned ACL specified in the workgroup's settings is used for all queries that run in the workgroup. For more information about Amazon S3 canned ACLs, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/acl-overview.html#canned-acl">Canned ACL</a> in the <em>Amazon S3 User Guide</em> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-athena-workgroup-aclconfiguration.html#cfn-athena-workgroup-aclconfiguration-s3acloption">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-athena-workgroup-aclconfiguration.html#cfn-athena-workgroup-aclconfiguration-s3acloption</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getS3AclOption();

        /**
         * @return a {@link Builder} of {@link AclConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link AclConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<AclConfigurationProperty> {
            java.lang.String s3AclOption;

            /**
             * Sets the value of {@link AclConfigurationProperty#getS3AclOption}
             * @param s3AclOption The Amazon S3 canned ACL that Athena should specify when storing query results, including data files inserted by Athena as the result of statements like CTAS or INSERT INTO. This parameter is required.
             *                    Currently the only supported canned ACL is <code>BUCKET_OWNER_FULL_CONTROL</code> . If a query runs in a workgroup and the workgroup overrides client-side settings, then the Amazon S3 canned ACL specified in the workgroup's settings is used for all queries that run in the workgroup. For more information about Amazon S3 canned ACLs, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/acl-overview.html#canned-acl">Canned ACL</a> in the <em>Amazon S3 User Guide</em> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder s3AclOption(java.lang.String s3AclOption) {
                this.s3AclOption = s3AclOption;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link AclConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public AclConfigurationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link AclConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements AclConfigurationProperty {
            private final java.lang.String s3AclOption;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.s3AclOption = software.amazon.jsii.Kernel.get(this, "s3AclOption", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.s3AclOption = java.util.Objects.requireNonNull(builder.s3AclOption, "s3AclOption is required");
            }

            @Override
            public final java.lang.String getS3AclOption() {
                return this.s3AclOption;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("s3AclOption", om.valueToTree(this.getS3AclOption()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_athena.CfnWorkGroup.AclConfigurationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                AclConfigurationProperty.Jsii$Proxy that = (AclConfigurationProperty.Jsii$Proxy) o;

                return this.s3AclOption.equals(that.s3AclOption);
            }

            @Override
            public final int hashCode() {
                int result = this.s3AclOption.hashCode();
                return result;
            }
        }
    }
    /**
     * Specifies the customer managed KMS key that is used to encrypt the user's data stores in Athena.
     * <p>
     * When an AWS managed key is used, this value is null. This setting does not apply to Athena SQL workgroups.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.athena.*;
     * CustomerContentEncryptionConfigurationProperty customerContentEncryptionConfigurationProperty = CustomerContentEncryptionConfigurationProperty.builder()
     *         .kmsKey("kmsKey")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-athena-workgroup-customercontentencryptionconfiguration.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-athena-workgroup-customercontentencryptionconfiguration.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_athena.CfnWorkGroup.CustomerContentEncryptionConfigurationProperty")
    @software.amazon.jsii.Jsii.Proxy(CustomerContentEncryptionConfigurationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface CustomerContentEncryptionConfigurationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The customer managed KMS key that is used to encrypt the user's data stores in Athena.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-athena-workgroup-customercontentencryptionconfiguration.html#cfn-athena-workgroup-customercontentencryptionconfiguration-kmskey">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-athena-workgroup-customercontentencryptionconfiguration.html#cfn-athena-workgroup-customercontentencryptionconfiguration-kmskey</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getKmsKey();

        /**
         * @return a {@link Builder} of {@link CustomerContentEncryptionConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link CustomerContentEncryptionConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<CustomerContentEncryptionConfigurationProperty> {
            java.lang.String kmsKey;

            /**
             * Sets the value of {@link CustomerContentEncryptionConfigurationProperty#getKmsKey}
             * @param kmsKey The customer managed KMS key that is used to encrypt the user's data stores in Athena. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder kmsKey(java.lang.String kmsKey) {
                this.kmsKey = kmsKey;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link CustomerContentEncryptionConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public CustomerContentEncryptionConfigurationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link CustomerContentEncryptionConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CustomerContentEncryptionConfigurationProperty {
            private final java.lang.String kmsKey;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.kmsKey = software.amazon.jsii.Kernel.get(this, "kmsKey", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.kmsKey = java.util.Objects.requireNonNull(builder.kmsKey, "kmsKey is required");
            }

            @Override
            public final java.lang.String getKmsKey() {
                return this.kmsKey;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("kmsKey", om.valueToTree(this.getKmsKey()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_athena.CfnWorkGroup.CustomerContentEncryptionConfigurationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                CustomerContentEncryptionConfigurationProperty.Jsii$Proxy that = (CustomerContentEncryptionConfigurationProperty.Jsii$Proxy) o;

                return this.kmsKey.equals(that.kmsKey);
            }

            @Override
            public final int hashCode() {
                int result = this.kmsKey.hashCode();
                return result;
            }
        }
    }
    /**
     * If query results are encrypted in Amazon S3, indicates the encryption option used (for example, <code>SSE_KMS</code> or <code>CSE_KMS</code> ) and key information.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.athena.*;
     * EncryptionConfigurationProperty encryptionConfigurationProperty = EncryptionConfigurationProperty.builder()
     *         .encryptionOption("encryptionOption")
     *         // the properties below are optional
     *         .kmsKey("kmsKey")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-athena-workgroup-encryptionconfiguration.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-athena-workgroup-encryptionconfiguration.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_athena.CfnWorkGroup.EncryptionConfigurationProperty")
    @software.amazon.jsii.Jsii.Proxy(EncryptionConfigurationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface EncryptionConfigurationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Indicates whether Amazon S3 server-side encryption with Amazon S3-managed keys ( <code>SSE_S3</code> ), server-side encryption with KMS-managed keys ( <code>SSE_KMS</code> ), or client-side encryption with KMS-managed keys ( <code>CSE_KMS</code> ) is used.
         * <p>
         * If a query runs in a workgroup and the workgroup overrides client-side settings, then the workgroup's setting for encryption is used. It specifies whether query results must be encrypted, for all queries that run in this workgroup.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-athena-workgroup-encryptionconfiguration.html#cfn-athena-workgroup-encryptionconfiguration-encryptionoption">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-athena-workgroup-encryptionconfiguration.html#cfn-athena-workgroup-encryptionconfiguration-encryptionoption</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getEncryptionOption();

        /**
         * For <code>SSE_KMS</code> and <code>CSE_KMS</code> , this is the KMS key ARN or ID.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-athena-workgroup-encryptionconfiguration.html#cfn-athena-workgroup-encryptionconfiguration-kmskey">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-athena-workgroup-encryptionconfiguration.html#cfn-athena-workgroup-encryptionconfiguration-kmskey</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getKmsKey() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link EncryptionConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link EncryptionConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<EncryptionConfigurationProperty> {
            java.lang.String encryptionOption;
            java.lang.String kmsKey;

            /**
             * Sets the value of {@link EncryptionConfigurationProperty#getEncryptionOption}
             * @param encryptionOption Indicates whether Amazon S3 server-side encryption with Amazon S3-managed keys ( <code>SSE_S3</code> ), server-side encryption with KMS-managed keys ( <code>SSE_KMS</code> ), or client-side encryption with KMS-managed keys ( <code>CSE_KMS</code> ) is used. This parameter is required.
             *                         If a query runs in a workgroup and the workgroup overrides client-side settings, then the workgroup's setting for encryption is used. It specifies whether query results must be encrypted, for all queries that run in this workgroup.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder encryptionOption(java.lang.String encryptionOption) {
                this.encryptionOption = encryptionOption;
                return this;
            }

            /**
             * Sets the value of {@link EncryptionConfigurationProperty#getKmsKey}
             * @param kmsKey For <code>SSE_KMS</code> and <code>CSE_KMS</code> , this is the KMS key ARN or ID.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder kmsKey(java.lang.String kmsKey) {
                this.kmsKey = kmsKey;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link EncryptionConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public EncryptionConfigurationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link EncryptionConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements EncryptionConfigurationProperty {
            private final java.lang.String encryptionOption;
            private final java.lang.String kmsKey;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.encryptionOption = software.amazon.jsii.Kernel.get(this, "encryptionOption", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.kmsKey = software.amazon.jsii.Kernel.get(this, "kmsKey", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.encryptionOption = java.util.Objects.requireNonNull(builder.encryptionOption, "encryptionOption is required");
                this.kmsKey = builder.kmsKey;
            }

            @Override
            public final java.lang.String getEncryptionOption() {
                return this.encryptionOption;
            }

            @Override
            public final java.lang.String getKmsKey() {
                return this.kmsKey;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("encryptionOption", om.valueToTree(this.getEncryptionOption()));
                if (this.getKmsKey() != null) {
                    data.set("kmsKey", om.valueToTree(this.getKmsKey()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_athena.CfnWorkGroup.EncryptionConfigurationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                EncryptionConfigurationProperty.Jsii$Proxy that = (EncryptionConfigurationProperty.Jsii$Proxy) o;

                if (!encryptionOption.equals(that.encryptionOption)) return false;
                return this.kmsKey != null ? this.kmsKey.equals(that.kmsKey) : that.kmsKey == null;
            }

            @Override
            public final int hashCode() {
                int result = this.encryptionOption.hashCode();
                result = 31 * result + (this.kmsKey != null ? this.kmsKey.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * The Athena engine version for running queries, or the PySpark engine version for running sessions.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.athena.*;
     * EngineVersionProperty engineVersionProperty = EngineVersionProperty.builder()
     *         .effectiveEngineVersion("effectiveEngineVersion")
     *         .selectedEngineVersion("selectedEngineVersion")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-athena-workgroup-engineversion.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-athena-workgroup-engineversion.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_athena.CfnWorkGroup.EngineVersionProperty")
    @software.amazon.jsii.Jsii.Proxy(EngineVersionProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface EngineVersionProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Read only.
         * <p>
         * The engine version on which the query runs. If the user requests a valid engine version other than Auto, the effective engine version is the same as the engine version that the user requested. If the user requests Auto, the effective engine version is chosen by Athena. When a request to update the engine version is made by a <code>CreateWorkGroup</code> or <code>UpdateWorkGroup</code> operation, the <code>EffectiveEngineVersion</code> field is ignored.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-athena-workgroup-engineversion.html#cfn-athena-workgroup-engineversion-effectiveengineversion">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-athena-workgroup-engineversion.html#cfn-athena-workgroup-engineversion-effectiveengineversion</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getEffectiveEngineVersion() {
            return null;
        }

        /**
         * The engine version requested by the user.
         * <p>
         * Possible values are determined by the output of <code>ListEngineVersions</code> , including AUTO. The default is AUTO.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-athena-workgroup-engineversion.html#cfn-athena-workgroup-engineversion-selectedengineversion">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-athena-workgroup-engineversion.html#cfn-athena-workgroup-engineversion-selectedengineversion</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getSelectedEngineVersion() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link EngineVersionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link EngineVersionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<EngineVersionProperty> {
            java.lang.String effectiveEngineVersion;
            java.lang.String selectedEngineVersion;

            /**
             * Sets the value of {@link EngineVersionProperty#getEffectiveEngineVersion}
             * @param effectiveEngineVersion Read only.
             *                               The engine version on which the query runs. If the user requests a valid engine version other than Auto, the effective engine version is the same as the engine version that the user requested. If the user requests Auto, the effective engine version is chosen by Athena. When a request to update the engine version is made by a <code>CreateWorkGroup</code> or <code>UpdateWorkGroup</code> operation, the <code>EffectiveEngineVersion</code> field is ignored.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder effectiveEngineVersion(java.lang.String effectiveEngineVersion) {
                this.effectiveEngineVersion = effectiveEngineVersion;
                return this;
            }

            /**
             * Sets the value of {@link EngineVersionProperty#getSelectedEngineVersion}
             * @param selectedEngineVersion The engine version requested by the user.
             *                              Possible values are determined by the output of <code>ListEngineVersions</code> , including AUTO. The default is AUTO.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder selectedEngineVersion(java.lang.String selectedEngineVersion) {
                this.selectedEngineVersion = selectedEngineVersion;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link EngineVersionProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public EngineVersionProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link EngineVersionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements EngineVersionProperty {
            private final java.lang.String effectiveEngineVersion;
            private final java.lang.String selectedEngineVersion;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.effectiveEngineVersion = software.amazon.jsii.Kernel.get(this, "effectiveEngineVersion", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.selectedEngineVersion = software.amazon.jsii.Kernel.get(this, "selectedEngineVersion", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.effectiveEngineVersion = builder.effectiveEngineVersion;
                this.selectedEngineVersion = builder.selectedEngineVersion;
            }

            @Override
            public final java.lang.String getEffectiveEngineVersion() {
                return this.effectiveEngineVersion;
            }

            @Override
            public final java.lang.String getSelectedEngineVersion() {
                return this.selectedEngineVersion;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getEffectiveEngineVersion() != null) {
                    data.set("effectiveEngineVersion", om.valueToTree(this.getEffectiveEngineVersion()));
                }
                if (this.getSelectedEngineVersion() != null) {
                    data.set("selectedEngineVersion", om.valueToTree(this.getSelectedEngineVersion()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_athena.CfnWorkGroup.EngineVersionProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                EngineVersionProperty.Jsii$Proxy that = (EngineVersionProperty.Jsii$Proxy) o;

                if (this.effectiveEngineVersion != null ? !this.effectiveEngineVersion.equals(that.effectiveEngineVersion) : that.effectiveEngineVersion != null) return false;
                return this.selectedEngineVersion != null ? this.selectedEngineVersion.equals(that.selectedEngineVersion) : that.selectedEngineVersion == null;
            }

            @Override
            public final int hashCode() {
                int result = this.effectiveEngineVersion != null ? this.effectiveEngineVersion.hashCode() : 0;
                result = 31 * result + (this.selectedEngineVersion != null ? this.selectedEngineVersion.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * The location in Amazon S3 where query and calculation results are stored and the encryption option, if any, used for query and calculation results.
     * <p>
     * These are known as "client-side settings". If workgroup settings override client-side settings, then the query uses the workgroup settings.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.athena.*;
     * ResultConfigurationProperty resultConfigurationProperty = ResultConfigurationProperty.builder()
     *         .aclConfiguration(AclConfigurationProperty.builder()
     *                 .s3AclOption("s3AclOption")
     *                 .build())
     *         .encryptionConfiguration(EncryptionConfigurationProperty.builder()
     *                 .encryptionOption("encryptionOption")
     *                 // the properties below are optional
     *                 .kmsKey("kmsKey")
     *                 .build())
     *         .expectedBucketOwner("expectedBucketOwner")
     *         .outputLocation("outputLocation")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-athena-workgroup-resultconfiguration.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-athena-workgroup-resultconfiguration.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_athena.CfnWorkGroup.ResultConfigurationProperty")
    @software.amazon.jsii.Jsii.Proxy(ResultConfigurationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ResultConfigurationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Indicates that an Amazon S3 canned ACL should be set to control ownership of stored query results.
         * <p>
         * Currently the only supported canned ACL is <code>BUCKET_OWNER_FULL_CONTROL</code> . This is a client-side setting. If workgroup settings override client-side settings, then the query uses the ACL configuration that is specified for the workgroup, and also uses the location for storing query results specified in the workgroup. See <code>EnforceWorkGroupConfiguration</code> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-athena-workgroup-resultconfiguration.html#cfn-athena-workgroup-resultconfiguration-aclconfiguration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-athena-workgroup-resultconfiguration.html#cfn-athena-workgroup-resultconfiguration-aclconfiguration</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getAclConfiguration() {
            return null;
        }

        /**
         * If query results are encrypted in Amazon S3, indicates the encryption option used (for example, <code>SSE_KMS</code> or <code>CSE_KMS</code> ) and key information.
         * <p>
         * This is a client-side setting. If workgroup settings override client-side settings, then the query uses the encryption configuration that is specified for the workgroup, and also uses the location for storing query results specified in the workgroup. See <code>EnforceWorkGroupConfiguration</code> and <a href="https://docs.aws.amazon.com/athena/latest/ug/workgroups-settings-override.html">Override client-side settings</a> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-athena-workgroup-resultconfiguration.html#cfn-athena-workgroup-resultconfiguration-encryptionconfiguration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-athena-workgroup-resultconfiguration.html#cfn-athena-workgroup-resultconfiguration-encryptionconfiguration</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getEncryptionConfiguration() {
            return null;
        }

        /**
         * The account ID that you expect to be the owner of the Amazon S3 bucket specified by <code>ResultConfiguration:OutputLocation</code> .
         * <p>
         * If set, Athena uses the value for <code>ExpectedBucketOwner</code> when it makes Amazon S3 calls to your specified output location. If the <code>ExpectedBucketOwner</code> account ID does not match the actual owner of the Amazon S3 bucket, the call fails with a permissions error.
         * <p>
         * This is a client-side setting. If workgroup settings override client-side settings, then the query uses the <code>ExpectedBucketOwner</code> setting that is specified for the workgroup, and also uses the location for storing query results specified in the workgroup. See <code>EnforceWorkGroupConfiguration</code> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-athena-workgroup-resultconfiguration.html#cfn-athena-workgroup-resultconfiguration-expectedbucketowner">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-athena-workgroup-resultconfiguration.html#cfn-athena-workgroup-resultconfiguration-expectedbucketowner</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getExpectedBucketOwner() {
            return null;
        }

        /**
         * The location in Amazon S3 where your query results are stored, such as <code>s3://path/to/query/bucket/</code> .
         * <p>
         * To run a query, you must specify the query results location using either a client-side setting for individual queries or a location specified by the workgroup. If workgroup settings override client-side settings, then the query uses the location specified for the workgroup. If no query location is set, Athena issues an error. For more information, see <a href="https://docs.aws.amazon.com/athena/latest/ug/querying.html">Work with query results and recent queries</a> and <code>EnforceWorkGroupConfiguration</code> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-athena-workgroup-resultconfiguration.html#cfn-athena-workgroup-resultconfiguration-outputlocation">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-athena-workgroup-resultconfiguration.html#cfn-athena-workgroup-resultconfiguration-outputlocation</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getOutputLocation() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link ResultConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ResultConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ResultConfigurationProperty> {
            java.lang.Object aclConfiguration;
            java.lang.Object encryptionConfiguration;
            java.lang.String expectedBucketOwner;
            java.lang.String outputLocation;

            /**
             * Sets the value of {@link ResultConfigurationProperty#getAclConfiguration}
             * @param aclConfiguration Indicates that an Amazon S3 canned ACL should be set to control ownership of stored query results.
             *                         Currently the only supported canned ACL is <code>BUCKET_OWNER_FULL_CONTROL</code> . This is a client-side setting. If workgroup settings override client-side settings, then the query uses the ACL configuration that is specified for the workgroup, and also uses the location for storing query results specified in the workgroup. See <code>EnforceWorkGroupConfiguration</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder aclConfiguration(software.amazon.awscdk.IResolvable aclConfiguration) {
                this.aclConfiguration = aclConfiguration;
                return this;
            }

            /**
             * Sets the value of {@link ResultConfigurationProperty#getAclConfiguration}
             * @param aclConfiguration Indicates that an Amazon S3 canned ACL should be set to control ownership of stored query results.
             *                         Currently the only supported canned ACL is <code>BUCKET_OWNER_FULL_CONTROL</code> . This is a client-side setting. If workgroup settings override client-side settings, then the query uses the ACL configuration that is specified for the workgroup, and also uses the location for storing query results specified in the workgroup. See <code>EnforceWorkGroupConfiguration</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder aclConfiguration(software.amazon.awscdk.services.athena.CfnWorkGroup.AclConfigurationProperty aclConfiguration) {
                this.aclConfiguration = aclConfiguration;
                return this;
            }

            /**
             * Sets the value of {@link ResultConfigurationProperty#getEncryptionConfiguration}
             * @param encryptionConfiguration If query results are encrypted in Amazon S3, indicates the encryption option used (for example, <code>SSE_KMS</code> or <code>CSE_KMS</code> ) and key information.
             *                                This is a client-side setting. If workgroup settings override client-side settings, then the query uses the encryption configuration that is specified for the workgroup, and also uses the location for storing query results specified in the workgroup. See <code>EnforceWorkGroupConfiguration</code> and <a href="https://docs.aws.amazon.com/athena/latest/ug/workgroups-settings-override.html">Override client-side settings</a> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder encryptionConfiguration(software.amazon.awscdk.IResolvable encryptionConfiguration) {
                this.encryptionConfiguration = encryptionConfiguration;
                return this;
            }

            /**
             * Sets the value of {@link ResultConfigurationProperty#getEncryptionConfiguration}
             * @param encryptionConfiguration If query results are encrypted in Amazon S3, indicates the encryption option used (for example, <code>SSE_KMS</code> or <code>CSE_KMS</code> ) and key information.
             *                                This is a client-side setting. If workgroup settings override client-side settings, then the query uses the encryption configuration that is specified for the workgroup, and also uses the location for storing query results specified in the workgroup. See <code>EnforceWorkGroupConfiguration</code> and <a href="https://docs.aws.amazon.com/athena/latest/ug/workgroups-settings-override.html">Override client-side settings</a> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder encryptionConfiguration(software.amazon.awscdk.services.athena.CfnWorkGroup.EncryptionConfigurationProperty encryptionConfiguration) {
                this.encryptionConfiguration = encryptionConfiguration;
                return this;
            }

            /**
             * Sets the value of {@link ResultConfigurationProperty#getExpectedBucketOwner}
             * @param expectedBucketOwner The account ID that you expect to be the owner of the Amazon S3 bucket specified by <code>ResultConfiguration:OutputLocation</code> .
             *                            If set, Athena uses the value for <code>ExpectedBucketOwner</code> when it makes Amazon S3 calls to your specified output location. If the <code>ExpectedBucketOwner</code> account ID does not match the actual owner of the Amazon S3 bucket, the call fails with a permissions error.
             *                            <p>
             *                            This is a client-side setting. If workgroup settings override client-side settings, then the query uses the <code>ExpectedBucketOwner</code> setting that is specified for the workgroup, and also uses the location for storing query results specified in the workgroup. See <code>EnforceWorkGroupConfiguration</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder expectedBucketOwner(java.lang.String expectedBucketOwner) {
                this.expectedBucketOwner = expectedBucketOwner;
                return this;
            }

            /**
             * Sets the value of {@link ResultConfigurationProperty#getOutputLocation}
             * @param outputLocation The location in Amazon S3 where your query results are stored, such as <code>s3://path/to/query/bucket/</code> .
             *                       To run a query, you must specify the query results location using either a client-side setting for individual queries or a location specified by the workgroup. If workgroup settings override client-side settings, then the query uses the location specified for the workgroup. If no query location is set, Athena issues an error. For more information, see <a href="https://docs.aws.amazon.com/athena/latest/ug/querying.html">Work with query results and recent queries</a> and <code>EnforceWorkGroupConfiguration</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder outputLocation(java.lang.String outputLocation) {
                this.outputLocation = outputLocation;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ResultConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ResultConfigurationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link ResultConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ResultConfigurationProperty {
            private final java.lang.Object aclConfiguration;
            private final java.lang.Object encryptionConfiguration;
            private final java.lang.String expectedBucketOwner;
            private final java.lang.String outputLocation;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.aclConfiguration = software.amazon.jsii.Kernel.get(this, "aclConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.encryptionConfiguration = software.amazon.jsii.Kernel.get(this, "encryptionConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.expectedBucketOwner = software.amazon.jsii.Kernel.get(this, "expectedBucketOwner", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.outputLocation = software.amazon.jsii.Kernel.get(this, "outputLocation", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.aclConfiguration = builder.aclConfiguration;
                this.encryptionConfiguration = builder.encryptionConfiguration;
                this.expectedBucketOwner = builder.expectedBucketOwner;
                this.outputLocation = builder.outputLocation;
            }

            @Override
            public final java.lang.Object getAclConfiguration() {
                return this.aclConfiguration;
            }

            @Override
            public final java.lang.Object getEncryptionConfiguration() {
                return this.encryptionConfiguration;
            }

            @Override
            public final java.lang.String getExpectedBucketOwner() {
                return this.expectedBucketOwner;
            }

            @Override
            public final java.lang.String getOutputLocation() {
                return this.outputLocation;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getAclConfiguration() != null) {
                    data.set("aclConfiguration", om.valueToTree(this.getAclConfiguration()));
                }
                if (this.getEncryptionConfiguration() != null) {
                    data.set("encryptionConfiguration", om.valueToTree(this.getEncryptionConfiguration()));
                }
                if (this.getExpectedBucketOwner() != null) {
                    data.set("expectedBucketOwner", om.valueToTree(this.getExpectedBucketOwner()));
                }
                if (this.getOutputLocation() != null) {
                    data.set("outputLocation", om.valueToTree(this.getOutputLocation()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_athena.CfnWorkGroup.ResultConfigurationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ResultConfigurationProperty.Jsii$Proxy that = (ResultConfigurationProperty.Jsii$Proxy) o;

                if (this.aclConfiguration != null ? !this.aclConfiguration.equals(that.aclConfiguration) : that.aclConfiguration != null) return false;
                if (this.encryptionConfiguration != null ? !this.encryptionConfiguration.equals(that.encryptionConfiguration) : that.encryptionConfiguration != null) return false;
                if (this.expectedBucketOwner != null ? !this.expectedBucketOwner.equals(that.expectedBucketOwner) : that.expectedBucketOwner != null) return false;
                return this.outputLocation != null ? this.outputLocation.equals(that.outputLocation) : that.outputLocation == null;
            }

            @Override
            public final int hashCode() {
                int result = this.aclConfiguration != null ? this.aclConfiguration.hashCode() : 0;
                result = 31 * result + (this.encryptionConfiguration != null ? this.encryptionConfiguration.hashCode() : 0);
                result = 31 * result + (this.expectedBucketOwner != null ? this.expectedBucketOwner.hashCode() : 0);
                result = 31 * result + (this.outputLocation != null ? this.outputLocation.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * The information about the updates in the query results, such as output location and encryption configuration for the query results.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.athena.*;
     * ResultConfigurationUpdatesProperty resultConfigurationUpdatesProperty = ResultConfigurationUpdatesProperty.builder()
     *         .aclConfiguration(AclConfigurationProperty.builder()
     *                 .s3AclOption("s3AclOption")
     *                 .build())
     *         .encryptionConfiguration(EncryptionConfigurationProperty.builder()
     *                 .encryptionOption("encryptionOption")
     *                 // the properties below are optional
     *                 .kmsKey("kmsKey")
     *                 .build())
     *         .expectedBucketOwner("expectedBucketOwner")
     *         .outputLocation("outputLocation")
     *         .removeAclConfiguration(false)
     *         .removeEncryptionConfiguration(false)
     *         .removeExpectedBucketOwner(false)
     *         .removeOutputLocation(false)
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-athena-workgroup-resultconfigurationupdates.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-athena-workgroup-resultconfigurationupdates.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_athena.CfnWorkGroup.ResultConfigurationUpdatesProperty")
    @software.amazon.jsii.Jsii.Proxy(ResultConfigurationUpdatesProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ResultConfigurationUpdatesProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The ACL configuration for the query results.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-athena-workgroup-resultconfigurationupdates.html#cfn-athena-workgroup-resultconfigurationupdates-aclconfiguration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-athena-workgroup-resultconfigurationupdates.html#cfn-athena-workgroup-resultconfigurationupdates-aclconfiguration</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getAclConfiguration() {
            return null;
        }

        /**
         * The encryption configuration for the query results.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-athena-workgroup-resultconfigurationupdates.html#cfn-athena-workgroup-resultconfigurationupdates-encryptionconfiguration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-athena-workgroup-resultconfigurationupdates.html#cfn-athena-workgroup-resultconfigurationupdates-encryptionconfiguration</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getEncryptionConfiguration() {
            return null;
        }

        /**
         * The AWS account ID that you expect to be the owner of the Amazon S3 bucket specified by <code>ResultConfiguration$OutputLocation</code> .
         * <p>
         * If set, Athena uses the value for <code>ExpectedBucketOwner</code> when it makes Amazon S3 calls to your specified output location. If the <code>ExpectedBucketOwner</code> AWS account ID does not match the actual owner of the Amazon S3 bucket, the call fails with a permissions error.
         * <p>
         * If workgroup settings override client-side settings, then the query uses the <code>ExpectedBucketOwner</code> setting that is specified for the workgroup, and also uses the location for storing query results specified in the workgroup. See <code>WorkGroupConfiguration$EnforceWorkGroupConfiguration</code> and <a href="https://docs.aws.amazon.com/athena/latest/ug/workgroups-settings-override.html">Workgroup Settings Override Client-Side Settings</a> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-athena-workgroup-resultconfigurationupdates.html#cfn-athena-workgroup-resultconfigurationupdates-expectedbucketowner">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-athena-workgroup-resultconfigurationupdates.html#cfn-athena-workgroup-resultconfigurationupdates-expectedbucketowner</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getExpectedBucketOwner() {
            return null;
        }

        /**
         * The location in Amazon S3 where your query results are stored, such as <code>s3://path/to/query/bucket/</code> .
         * <p>
         * For more information, see <a href="https://docs.aws.amazon.com/athena/latest/ug/querying.html">Query Results</a> If workgroup settings override client-side settings, then the query uses the location for the query results and the encryption configuration that are specified for the workgroup. The "workgroup settings override" is specified in EnforceWorkGroupConfiguration (true/false) in the WorkGroupConfiguration. See <code>EnforceWorkGroupConfiguration</code> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-athena-workgroup-resultconfigurationupdates.html#cfn-athena-workgroup-resultconfigurationupdates-outputlocation">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-athena-workgroup-resultconfigurationupdates.html#cfn-athena-workgroup-resultconfigurationupdates-outputlocation</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getOutputLocation() {
            return null;
        }

        /**
         * If set to <code>true</code> , indicates that the previously-specified ACL configuration for queries in this workgroup should be ignored and set to null.
         * <p>
         * If set to <code>false</code> or not set, and a value is present in the <code>AclConfiguration</code> of <code>ResultConfigurationUpdates</code> , the <code>AclConfiguration</code> in the workgroup's <code>ResultConfiguration</code> is updated with the new value. For more information, see <a href="https://docs.aws.amazon.com/athena/latest/ug/workgroups-settings-override.html">Workgroup Settings Override Client-Side Settings</a> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-athena-workgroup-resultconfigurationupdates.html#cfn-athena-workgroup-resultconfigurationupdates-removeaclconfiguration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-athena-workgroup-resultconfigurationupdates.html#cfn-athena-workgroup-resultconfigurationupdates-removeaclconfiguration</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getRemoveAclConfiguration() {
            return null;
        }

        /**
         * If set to "true", indicates that the previously-specified encryption configuration (also known as the client-side setting) for queries in this workgroup should be ignored and set to null.
         * <p>
         * If set to "false" or not set, and a value is present in the EncryptionConfiguration in ResultConfigurationUpdates (the client-side setting), the EncryptionConfiguration in the workgroup's ResultConfiguration will be updated with the new value. For more information, see <a href="https://docs.aws.amazon.com/athena/latest/ug/workgroups-settings-override.html">Override Client-Side Settings</a> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-athena-workgroup-resultconfigurationupdates.html#cfn-athena-workgroup-resultconfigurationupdates-removeencryptionconfiguration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-athena-workgroup-resultconfigurationupdates.html#cfn-athena-workgroup-resultconfigurationupdates-removeencryptionconfiguration</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getRemoveEncryptionConfiguration() {
            return null;
        }

        /**
         * If set to "true", removes the AWS account ID previously specified for <code>ResultConfiguration$ExpectedBucketOwner</code> .
         * <p>
         * If set to "false" or not set, and a value is present in the <code>ExpectedBucketOwner</code> in <code>ResultConfigurationUpdates</code> (the client-side setting), the <code>ExpectedBucketOwner</code> in the workgroup's <code>ResultConfiguration</code> is updated with the new value. For more information, see <a href="https://docs.aws.amazon.com/athena/latest/ug/workgroups-settings-override.html">Workgroup Settings Override Client-Side Settings</a> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-athena-workgroup-resultconfigurationupdates.html#cfn-athena-workgroup-resultconfigurationupdates-removeexpectedbucketowner">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-athena-workgroup-resultconfigurationupdates.html#cfn-athena-workgroup-resultconfigurationupdates-removeexpectedbucketowner</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getRemoveExpectedBucketOwner() {
            return null;
        }

        /**
         * If set to "true", indicates that the previously-specified query results location (also known as a client-side setting) for queries in this workgroup should be ignored and set to null.
         * <p>
         * If set to "false" or not set, and a value is present in the OutputLocation in ResultConfigurationUpdates (the client-side setting), the OutputLocation in the workgroup's ResultConfiguration will be updated with the new value. For more information, see <a href="https://docs.aws.amazon.com/athena/latest/ug/workgroups-settings-override.html">Override Client-Side Settings</a> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-athena-workgroup-resultconfigurationupdates.html#cfn-athena-workgroup-resultconfigurationupdates-removeoutputlocation">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-athena-workgroup-resultconfigurationupdates.html#cfn-athena-workgroup-resultconfigurationupdates-removeoutputlocation</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getRemoveOutputLocation() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link ResultConfigurationUpdatesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ResultConfigurationUpdatesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ResultConfigurationUpdatesProperty> {
            java.lang.Object aclConfiguration;
            java.lang.Object encryptionConfiguration;
            java.lang.String expectedBucketOwner;
            java.lang.String outputLocation;
            java.lang.Object removeAclConfiguration;
            java.lang.Object removeEncryptionConfiguration;
            java.lang.Object removeExpectedBucketOwner;
            java.lang.Object removeOutputLocation;

            /**
             * Sets the value of {@link ResultConfigurationUpdatesProperty#getAclConfiguration}
             * @param aclConfiguration The ACL configuration for the query results.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder aclConfiguration(software.amazon.awscdk.IResolvable aclConfiguration) {
                this.aclConfiguration = aclConfiguration;
                return this;
            }

            /**
             * Sets the value of {@link ResultConfigurationUpdatesProperty#getAclConfiguration}
             * @param aclConfiguration The ACL configuration for the query results.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder aclConfiguration(software.amazon.awscdk.services.athena.CfnWorkGroup.AclConfigurationProperty aclConfiguration) {
                this.aclConfiguration = aclConfiguration;
                return this;
            }

            /**
             * Sets the value of {@link ResultConfigurationUpdatesProperty#getEncryptionConfiguration}
             * @param encryptionConfiguration The encryption configuration for the query results.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder encryptionConfiguration(software.amazon.awscdk.IResolvable encryptionConfiguration) {
                this.encryptionConfiguration = encryptionConfiguration;
                return this;
            }

            /**
             * Sets the value of {@link ResultConfigurationUpdatesProperty#getEncryptionConfiguration}
             * @param encryptionConfiguration The encryption configuration for the query results.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder encryptionConfiguration(software.amazon.awscdk.services.athena.CfnWorkGroup.EncryptionConfigurationProperty encryptionConfiguration) {
                this.encryptionConfiguration = encryptionConfiguration;
                return this;
            }

            /**
             * Sets the value of {@link ResultConfigurationUpdatesProperty#getExpectedBucketOwner}
             * @param expectedBucketOwner The AWS account ID that you expect to be the owner of the Amazon S3 bucket specified by <code>ResultConfiguration$OutputLocation</code> .
             *                            If set, Athena uses the value for <code>ExpectedBucketOwner</code> when it makes Amazon S3 calls to your specified output location. If the <code>ExpectedBucketOwner</code> AWS account ID does not match the actual owner of the Amazon S3 bucket, the call fails with a permissions error.
             *                            <p>
             *                            If workgroup settings override client-side settings, then the query uses the <code>ExpectedBucketOwner</code> setting that is specified for the workgroup, and also uses the location for storing query results specified in the workgroup. See <code>WorkGroupConfiguration$EnforceWorkGroupConfiguration</code> and <a href="https://docs.aws.amazon.com/athena/latest/ug/workgroups-settings-override.html">Workgroup Settings Override Client-Side Settings</a> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder expectedBucketOwner(java.lang.String expectedBucketOwner) {
                this.expectedBucketOwner = expectedBucketOwner;
                return this;
            }

            /**
             * Sets the value of {@link ResultConfigurationUpdatesProperty#getOutputLocation}
             * @param outputLocation The location in Amazon S3 where your query results are stored, such as <code>s3://path/to/query/bucket/</code> .
             *                       For more information, see <a href="https://docs.aws.amazon.com/athena/latest/ug/querying.html">Query Results</a> If workgroup settings override client-side settings, then the query uses the location for the query results and the encryption configuration that are specified for the workgroup. The "workgroup settings override" is specified in EnforceWorkGroupConfiguration (true/false) in the WorkGroupConfiguration. See <code>EnforceWorkGroupConfiguration</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder outputLocation(java.lang.String outputLocation) {
                this.outputLocation = outputLocation;
                return this;
            }

            /**
             * Sets the value of {@link ResultConfigurationUpdatesProperty#getRemoveAclConfiguration}
             * @param removeAclConfiguration If set to <code>true</code> , indicates that the previously-specified ACL configuration for queries in this workgroup should be ignored and set to null.
             *                               If set to <code>false</code> or not set, and a value is present in the <code>AclConfiguration</code> of <code>ResultConfigurationUpdates</code> , the <code>AclConfiguration</code> in the workgroup's <code>ResultConfiguration</code> is updated with the new value. For more information, see <a href="https://docs.aws.amazon.com/athena/latest/ug/workgroups-settings-override.html">Workgroup Settings Override Client-Side Settings</a> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder removeAclConfiguration(java.lang.Boolean removeAclConfiguration) {
                this.removeAclConfiguration = removeAclConfiguration;
                return this;
            }

            /**
             * Sets the value of {@link ResultConfigurationUpdatesProperty#getRemoveAclConfiguration}
             * @param removeAclConfiguration If set to <code>true</code> , indicates that the previously-specified ACL configuration for queries in this workgroup should be ignored and set to null.
             *                               If set to <code>false</code> or not set, and a value is present in the <code>AclConfiguration</code> of <code>ResultConfigurationUpdates</code> , the <code>AclConfiguration</code> in the workgroup's <code>ResultConfiguration</code> is updated with the new value. For more information, see <a href="https://docs.aws.amazon.com/athena/latest/ug/workgroups-settings-override.html">Workgroup Settings Override Client-Side Settings</a> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder removeAclConfiguration(software.amazon.awscdk.IResolvable removeAclConfiguration) {
                this.removeAclConfiguration = removeAclConfiguration;
                return this;
            }

            /**
             * Sets the value of {@link ResultConfigurationUpdatesProperty#getRemoveEncryptionConfiguration}
             * @param removeEncryptionConfiguration If set to "true", indicates that the previously-specified encryption configuration (also known as the client-side setting) for queries in this workgroup should be ignored and set to null.
             *                                      If set to "false" or not set, and a value is present in the EncryptionConfiguration in ResultConfigurationUpdates (the client-side setting), the EncryptionConfiguration in the workgroup's ResultConfiguration will be updated with the new value. For more information, see <a href="https://docs.aws.amazon.com/athena/latest/ug/workgroups-settings-override.html">Override Client-Side Settings</a> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder removeEncryptionConfiguration(java.lang.Boolean removeEncryptionConfiguration) {
                this.removeEncryptionConfiguration = removeEncryptionConfiguration;
                return this;
            }

            /**
             * Sets the value of {@link ResultConfigurationUpdatesProperty#getRemoveEncryptionConfiguration}
             * @param removeEncryptionConfiguration If set to "true", indicates that the previously-specified encryption configuration (also known as the client-side setting) for queries in this workgroup should be ignored and set to null.
             *                                      If set to "false" or not set, and a value is present in the EncryptionConfiguration in ResultConfigurationUpdates (the client-side setting), the EncryptionConfiguration in the workgroup's ResultConfiguration will be updated with the new value. For more information, see <a href="https://docs.aws.amazon.com/athena/latest/ug/workgroups-settings-override.html">Override Client-Side Settings</a> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder removeEncryptionConfiguration(software.amazon.awscdk.IResolvable removeEncryptionConfiguration) {
                this.removeEncryptionConfiguration = removeEncryptionConfiguration;
                return this;
            }

            /**
             * Sets the value of {@link ResultConfigurationUpdatesProperty#getRemoveExpectedBucketOwner}
             * @param removeExpectedBucketOwner If set to "true", removes the AWS account ID previously specified for <code>ResultConfiguration$ExpectedBucketOwner</code> .
             *                                  If set to "false" or not set, and a value is present in the <code>ExpectedBucketOwner</code> in <code>ResultConfigurationUpdates</code> (the client-side setting), the <code>ExpectedBucketOwner</code> in the workgroup's <code>ResultConfiguration</code> is updated with the new value. For more information, see <a href="https://docs.aws.amazon.com/athena/latest/ug/workgroups-settings-override.html">Workgroup Settings Override Client-Side Settings</a> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder removeExpectedBucketOwner(java.lang.Boolean removeExpectedBucketOwner) {
                this.removeExpectedBucketOwner = removeExpectedBucketOwner;
                return this;
            }

            /**
             * Sets the value of {@link ResultConfigurationUpdatesProperty#getRemoveExpectedBucketOwner}
             * @param removeExpectedBucketOwner If set to "true", removes the AWS account ID previously specified for <code>ResultConfiguration$ExpectedBucketOwner</code> .
             *                                  If set to "false" or not set, and a value is present in the <code>ExpectedBucketOwner</code> in <code>ResultConfigurationUpdates</code> (the client-side setting), the <code>ExpectedBucketOwner</code> in the workgroup's <code>ResultConfiguration</code> is updated with the new value. For more information, see <a href="https://docs.aws.amazon.com/athena/latest/ug/workgroups-settings-override.html">Workgroup Settings Override Client-Side Settings</a> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder removeExpectedBucketOwner(software.amazon.awscdk.IResolvable removeExpectedBucketOwner) {
                this.removeExpectedBucketOwner = removeExpectedBucketOwner;
                return this;
            }

            /**
             * Sets the value of {@link ResultConfigurationUpdatesProperty#getRemoveOutputLocation}
             * @param removeOutputLocation If set to "true", indicates that the previously-specified query results location (also known as a client-side setting) for queries in this workgroup should be ignored and set to null.
             *                             If set to "false" or not set, and a value is present in the OutputLocation in ResultConfigurationUpdates (the client-side setting), the OutputLocation in the workgroup's ResultConfiguration will be updated with the new value. For more information, see <a href="https://docs.aws.amazon.com/athena/latest/ug/workgroups-settings-override.html">Override Client-Side Settings</a> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder removeOutputLocation(java.lang.Boolean removeOutputLocation) {
                this.removeOutputLocation = removeOutputLocation;
                return this;
            }

            /**
             * Sets the value of {@link ResultConfigurationUpdatesProperty#getRemoveOutputLocation}
             * @param removeOutputLocation If set to "true", indicates that the previously-specified query results location (also known as a client-side setting) for queries in this workgroup should be ignored and set to null.
             *                             If set to "false" or not set, and a value is present in the OutputLocation in ResultConfigurationUpdates (the client-side setting), the OutputLocation in the workgroup's ResultConfiguration will be updated with the new value. For more information, see <a href="https://docs.aws.amazon.com/athena/latest/ug/workgroups-settings-override.html">Override Client-Side Settings</a> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder removeOutputLocation(software.amazon.awscdk.IResolvable removeOutputLocation) {
                this.removeOutputLocation = removeOutputLocation;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ResultConfigurationUpdatesProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ResultConfigurationUpdatesProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link ResultConfigurationUpdatesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ResultConfigurationUpdatesProperty {
            private final java.lang.Object aclConfiguration;
            private final java.lang.Object encryptionConfiguration;
            private final java.lang.String expectedBucketOwner;
            private final java.lang.String outputLocation;
            private final java.lang.Object removeAclConfiguration;
            private final java.lang.Object removeEncryptionConfiguration;
            private final java.lang.Object removeExpectedBucketOwner;
            private final java.lang.Object removeOutputLocation;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.aclConfiguration = software.amazon.jsii.Kernel.get(this, "aclConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.encryptionConfiguration = software.amazon.jsii.Kernel.get(this, "encryptionConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.expectedBucketOwner = software.amazon.jsii.Kernel.get(this, "expectedBucketOwner", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.outputLocation = software.amazon.jsii.Kernel.get(this, "outputLocation", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.removeAclConfiguration = software.amazon.jsii.Kernel.get(this, "removeAclConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.removeEncryptionConfiguration = software.amazon.jsii.Kernel.get(this, "removeEncryptionConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.removeExpectedBucketOwner = software.amazon.jsii.Kernel.get(this, "removeExpectedBucketOwner", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.removeOutputLocation = software.amazon.jsii.Kernel.get(this, "removeOutputLocation", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.aclConfiguration = builder.aclConfiguration;
                this.encryptionConfiguration = builder.encryptionConfiguration;
                this.expectedBucketOwner = builder.expectedBucketOwner;
                this.outputLocation = builder.outputLocation;
                this.removeAclConfiguration = builder.removeAclConfiguration;
                this.removeEncryptionConfiguration = builder.removeEncryptionConfiguration;
                this.removeExpectedBucketOwner = builder.removeExpectedBucketOwner;
                this.removeOutputLocation = builder.removeOutputLocation;
            }

            @Override
            public final java.lang.Object getAclConfiguration() {
                return this.aclConfiguration;
            }

            @Override
            public final java.lang.Object getEncryptionConfiguration() {
                return this.encryptionConfiguration;
            }

            @Override
            public final java.lang.String getExpectedBucketOwner() {
                return this.expectedBucketOwner;
            }

            @Override
            public final java.lang.String getOutputLocation() {
                return this.outputLocation;
            }

            @Override
            public final java.lang.Object getRemoveAclConfiguration() {
                return this.removeAclConfiguration;
            }

            @Override
            public final java.lang.Object getRemoveEncryptionConfiguration() {
                return this.removeEncryptionConfiguration;
            }

            @Override
            public final java.lang.Object getRemoveExpectedBucketOwner() {
                return this.removeExpectedBucketOwner;
            }

            @Override
            public final java.lang.Object getRemoveOutputLocation() {
                return this.removeOutputLocation;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getAclConfiguration() != null) {
                    data.set("aclConfiguration", om.valueToTree(this.getAclConfiguration()));
                }
                if (this.getEncryptionConfiguration() != null) {
                    data.set("encryptionConfiguration", om.valueToTree(this.getEncryptionConfiguration()));
                }
                if (this.getExpectedBucketOwner() != null) {
                    data.set("expectedBucketOwner", om.valueToTree(this.getExpectedBucketOwner()));
                }
                if (this.getOutputLocation() != null) {
                    data.set("outputLocation", om.valueToTree(this.getOutputLocation()));
                }
                if (this.getRemoveAclConfiguration() != null) {
                    data.set("removeAclConfiguration", om.valueToTree(this.getRemoveAclConfiguration()));
                }
                if (this.getRemoveEncryptionConfiguration() != null) {
                    data.set("removeEncryptionConfiguration", om.valueToTree(this.getRemoveEncryptionConfiguration()));
                }
                if (this.getRemoveExpectedBucketOwner() != null) {
                    data.set("removeExpectedBucketOwner", om.valueToTree(this.getRemoveExpectedBucketOwner()));
                }
                if (this.getRemoveOutputLocation() != null) {
                    data.set("removeOutputLocation", om.valueToTree(this.getRemoveOutputLocation()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_athena.CfnWorkGroup.ResultConfigurationUpdatesProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ResultConfigurationUpdatesProperty.Jsii$Proxy that = (ResultConfigurationUpdatesProperty.Jsii$Proxy) o;

                if (this.aclConfiguration != null ? !this.aclConfiguration.equals(that.aclConfiguration) : that.aclConfiguration != null) return false;
                if (this.encryptionConfiguration != null ? !this.encryptionConfiguration.equals(that.encryptionConfiguration) : that.encryptionConfiguration != null) return false;
                if (this.expectedBucketOwner != null ? !this.expectedBucketOwner.equals(that.expectedBucketOwner) : that.expectedBucketOwner != null) return false;
                if (this.outputLocation != null ? !this.outputLocation.equals(that.outputLocation) : that.outputLocation != null) return false;
                if (this.removeAclConfiguration != null ? !this.removeAclConfiguration.equals(that.removeAclConfiguration) : that.removeAclConfiguration != null) return false;
                if (this.removeEncryptionConfiguration != null ? !this.removeEncryptionConfiguration.equals(that.removeEncryptionConfiguration) : that.removeEncryptionConfiguration != null) return false;
                if (this.removeExpectedBucketOwner != null ? !this.removeExpectedBucketOwner.equals(that.removeExpectedBucketOwner) : that.removeExpectedBucketOwner != null) return false;
                return this.removeOutputLocation != null ? this.removeOutputLocation.equals(that.removeOutputLocation) : that.removeOutputLocation == null;
            }

            @Override
            public final int hashCode() {
                int result = this.aclConfiguration != null ? this.aclConfiguration.hashCode() : 0;
                result = 31 * result + (this.encryptionConfiguration != null ? this.encryptionConfiguration.hashCode() : 0);
                result = 31 * result + (this.expectedBucketOwner != null ? this.expectedBucketOwner.hashCode() : 0);
                result = 31 * result + (this.outputLocation != null ? this.outputLocation.hashCode() : 0);
                result = 31 * result + (this.removeAclConfiguration != null ? this.removeAclConfiguration.hashCode() : 0);
                result = 31 * result + (this.removeEncryptionConfiguration != null ? this.removeEncryptionConfiguration.hashCode() : 0);
                result = 31 * result + (this.removeExpectedBucketOwner != null ? this.removeExpectedBucketOwner.hashCode() : 0);
                result = 31 * result + (this.removeOutputLocation != null ? this.removeOutputLocation.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * The configuration of the workgroup, which includes the location in Amazon S3 where query results are stored, the encryption option, if any, used for query results, whether Amazon CloudWatch Metrics are enabled for the workgroup, and the limit for the amount of bytes scanned (cutoff) per query, if it is specified.
     * <p>
     * The <code>EnforceWorkGroupConfiguration</code> option determines whether workgroup settings override client-side query settings.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.athena.*;
     * WorkGroupConfigurationProperty workGroupConfigurationProperty = WorkGroupConfigurationProperty.builder()
     *         .additionalConfiguration("additionalConfiguration")
     *         .bytesScannedCutoffPerQuery(123)
     *         .customerContentEncryptionConfiguration(CustomerContentEncryptionConfigurationProperty.builder()
     *                 .kmsKey("kmsKey")
     *                 .build())
     *         .enforceWorkGroupConfiguration(false)
     *         .engineVersion(EngineVersionProperty.builder()
     *                 .effectiveEngineVersion("effectiveEngineVersion")
     *                 .selectedEngineVersion("selectedEngineVersion")
     *                 .build())
     *         .executionRole("executionRole")
     *         .publishCloudWatchMetricsEnabled(false)
     *         .requesterPaysEnabled(false)
     *         .resultConfiguration(ResultConfigurationProperty.builder()
     *                 .aclConfiguration(AclConfigurationProperty.builder()
     *                         .s3AclOption("s3AclOption")
     *                         .build())
     *                 .encryptionConfiguration(EncryptionConfigurationProperty.builder()
     *                         .encryptionOption("encryptionOption")
     *                         // the properties below are optional
     *                         .kmsKey("kmsKey")
     *                         .build())
     *                 .expectedBucketOwner("expectedBucketOwner")
     *                 .outputLocation("outputLocation")
     *                 .build())
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-athena-workgroup-workgroupconfiguration.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-athena-workgroup-workgroupconfiguration.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_athena.CfnWorkGroup.WorkGroupConfigurationProperty")
    @software.amazon.jsii.Jsii.Proxy(WorkGroupConfigurationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface WorkGroupConfigurationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Specifies a user defined JSON string that is passed to the session engine.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-athena-workgroup-workgroupconfiguration.html#cfn-athena-workgroup-workgroupconfiguration-additionalconfiguration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-athena-workgroup-workgroupconfiguration.html#cfn-athena-workgroup-workgroupconfiguration-additionalconfiguration</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getAdditionalConfiguration() {
            return null;
        }

        /**
         * The upper limit (cutoff) for the amount of bytes a single query in a workgroup is allowed to scan.
         * <p>
         * No default is defined.
         * <p>
         * <blockquote>
         * <p>
         * This property currently supports integer types. Support for long values is planned.
         * <p>
         * </blockquote>
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-athena-workgroup-workgroupconfiguration.html#cfn-athena-workgroup-workgroupconfiguration-bytesscannedcutoffperquery">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-athena-workgroup-workgroupconfiguration.html#cfn-athena-workgroup-workgroupconfiguration-bytesscannedcutoffperquery</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getBytesScannedCutoffPerQuery() {
            return null;
        }

        /**
         * Specifies the KMS key that is used to encrypt the user's data stores in Athena.
         * <p>
         * This setting does not apply to Athena SQL workgroups.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-athena-workgroup-workgroupconfiguration.html#cfn-athena-workgroup-workgroupconfiguration-customercontentencryptionconfiguration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-athena-workgroup-workgroupconfiguration.html#cfn-athena-workgroup-workgroupconfiguration-customercontentencryptionconfiguration</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getCustomerContentEncryptionConfiguration() {
            return null;
        }

        /**
         * If set to "true", the settings for the workgroup override client-side settings.
         * <p>
         * If set to "false", client-side settings are used. For more information, see <a href="https://docs.aws.amazon.com/athena/latest/ug/workgroups-settings-override.html">Override client-side settings</a> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-athena-workgroup-workgroupconfiguration.html#cfn-athena-workgroup-workgroupconfiguration-enforceworkgroupconfiguration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-athena-workgroup-workgroupconfiguration.html#cfn-athena-workgroup-workgroupconfiguration-enforceworkgroupconfiguration</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getEnforceWorkGroupConfiguration() {
            return null;
        }

        /**
         * The engine version that all queries running on the workgroup use.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-athena-workgroup-workgroupconfiguration.html#cfn-athena-workgroup-workgroupconfiguration-engineversion">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-athena-workgroup-workgroupconfiguration.html#cfn-athena-workgroup-workgroupconfiguration-engineversion</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getEngineVersion() {
            return null;
        }

        /**
         * Role used to access user resources in an Athena for Apache Spark session.
         * <p>
         * This property applies only to Spark-enabled workgroups in Athena.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-athena-workgroup-workgroupconfiguration.html#cfn-athena-workgroup-workgroupconfiguration-executionrole">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-athena-workgroup-workgroupconfiguration.html#cfn-athena-workgroup-workgroupconfiguration-executionrole</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getExecutionRole() {
            return null;
        }

        /**
         * Indicates that the Amazon CloudWatch metrics are enabled for the workgroup.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-athena-workgroup-workgroupconfiguration.html#cfn-athena-workgroup-workgroupconfiguration-publishcloudwatchmetricsenabled">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-athena-workgroup-workgroupconfiguration.html#cfn-athena-workgroup-workgroupconfiguration-publishcloudwatchmetricsenabled</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getPublishCloudWatchMetricsEnabled() {
            return null;
        }

        /**
         * If set to <code>true</code> , allows members assigned to a workgroup to reference Amazon S3 Requester Pays buckets in queries.
         * <p>
         * If set to <code>false</code> , workgroup members cannot query data from Requester Pays buckets, and queries that retrieve data from Requester Pays buckets cause an error. The default is <code>false</code> . For more information about Requester Pays buckets, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/RequesterPaysBuckets.html">Requester Pays Buckets</a> in the <em>Amazon Simple Storage Service Developer Guide</em> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-athena-workgroup-workgroupconfiguration.html#cfn-athena-workgroup-workgroupconfiguration-requesterpaysenabled">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-athena-workgroup-workgroupconfiguration.html#cfn-athena-workgroup-workgroupconfiguration-requesterpaysenabled</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getRequesterPaysEnabled() {
            return null;
        }

        /**
         * Specifies the location in Amazon S3 where query results are stored and the encryption option, if any, used for query results.
         * <p>
         * For more information, see <a href="https://docs.aws.amazon.com/athena/latest/ug/querying.html">Work with query results and recent queries</a> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-athena-workgroup-workgroupconfiguration.html#cfn-athena-workgroup-workgroupconfiguration-resultconfiguration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-athena-workgroup-workgroupconfiguration.html#cfn-athena-workgroup-workgroupconfiguration-resultconfiguration</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getResultConfiguration() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link WorkGroupConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link WorkGroupConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<WorkGroupConfigurationProperty> {
            java.lang.String additionalConfiguration;
            java.lang.Number bytesScannedCutoffPerQuery;
            java.lang.Object customerContentEncryptionConfiguration;
            java.lang.Object enforceWorkGroupConfiguration;
            java.lang.Object engineVersion;
            java.lang.String executionRole;
            java.lang.Object publishCloudWatchMetricsEnabled;
            java.lang.Object requesterPaysEnabled;
            java.lang.Object resultConfiguration;

            /**
             * Sets the value of {@link WorkGroupConfigurationProperty#getAdditionalConfiguration}
             * @param additionalConfiguration Specifies a user defined JSON string that is passed to the session engine.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder additionalConfiguration(java.lang.String additionalConfiguration) {
                this.additionalConfiguration = additionalConfiguration;
                return this;
            }

            /**
             * Sets the value of {@link WorkGroupConfigurationProperty#getBytesScannedCutoffPerQuery}
             * @param bytesScannedCutoffPerQuery The upper limit (cutoff) for the amount of bytes a single query in a workgroup is allowed to scan.
             *                                   No default is defined.
             *                                   <p>
             *                                   <blockquote>
             *                                   <p>
             *                                   This property currently supports integer types. Support for long values is planned.
             *                                   <p>
             *                                   </blockquote>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder bytesScannedCutoffPerQuery(java.lang.Number bytesScannedCutoffPerQuery) {
                this.bytesScannedCutoffPerQuery = bytesScannedCutoffPerQuery;
                return this;
            }

            /**
             * Sets the value of {@link WorkGroupConfigurationProperty#getCustomerContentEncryptionConfiguration}
             * @param customerContentEncryptionConfiguration Specifies the KMS key that is used to encrypt the user's data stores in Athena.
             *                                               This setting does not apply to Athena SQL workgroups.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder customerContentEncryptionConfiguration(software.amazon.awscdk.IResolvable customerContentEncryptionConfiguration) {
                this.customerContentEncryptionConfiguration = customerContentEncryptionConfiguration;
                return this;
            }

            /**
             * Sets the value of {@link WorkGroupConfigurationProperty#getCustomerContentEncryptionConfiguration}
             * @param customerContentEncryptionConfiguration Specifies the KMS key that is used to encrypt the user's data stores in Athena.
             *                                               This setting does not apply to Athena SQL workgroups.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder customerContentEncryptionConfiguration(software.amazon.awscdk.services.athena.CfnWorkGroup.CustomerContentEncryptionConfigurationProperty customerContentEncryptionConfiguration) {
                this.customerContentEncryptionConfiguration = customerContentEncryptionConfiguration;
                return this;
            }

            /**
             * Sets the value of {@link WorkGroupConfigurationProperty#getEnforceWorkGroupConfiguration}
             * @param enforceWorkGroupConfiguration If set to "true", the settings for the workgroup override client-side settings.
             *                                      If set to "false", client-side settings are used. For more information, see <a href="https://docs.aws.amazon.com/athena/latest/ug/workgroups-settings-override.html">Override client-side settings</a> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder enforceWorkGroupConfiguration(java.lang.Boolean enforceWorkGroupConfiguration) {
                this.enforceWorkGroupConfiguration = enforceWorkGroupConfiguration;
                return this;
            }

            /**
             * Sets the value of {@link WorkGroupConfigurationProperty#getEnforceWorkGroupConfiguration}
             * @param enforceWorkGroupConfiguration If set to "true", the settings for the workgroup override client-side settings.
             *                                      If set to "false", client-side settings are used. For more information, see <a href="https://docs.aws.amazon.com/athena/latest/ug/workgroups-settings-override.html">Override client-side settings</a> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder enforceWorkGroupConfiguration(software.amazon.awscdk.IResolvable enforceWorkGroupConfiguration) {
                this.enforceWorkGroupConfiguration = enforceWorkGroupConfiguration;
                return this;
            }

            /**
             * Sets the value of {@link WorkGroupConfigurationProperty#getEngineVersion}
             * @param engineVersion The engine version that all queries running on the workgroup use.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder engineVersion(software.amazon.awscdk.IResolvable engineVersion) {
                this.engineVersion = engineVersion;
                return this;
            }

            /**
             * Sets the value of {@link WorkGroupConfigurationProperty#getEngineVersion}
             * @param engineVersion The engine version that all queries running on the workgroup use.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder engineVersion(software.amazon.awscdk.services.athena.CfnWorkGroup.EngineVersionProperty engineVersion) {
                this.engineVersion = engineVersion;
                return this;
            }

            /**
             * Sets the value of {@link WorkGroupConfigurationProperty#getExecutionRole}
             * @param executionRole Role used to access user resources in an Athena for Apache Spark session.
             *                      This property applies only to Spark-enabled workgroups in Athena.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder executionRole(java.lang.String executionRole) {
                this.executionRole = executionRole;
                return this;
            }

            /**
             * Sets the value of {@link WorkGroupConfigurationProperty#getPublishCloudWatchMetricsEnabled}
             * @param publishCloudWatchMetricsEnabled Indicates that the Amazon CloudWatch metrics are enabled for the workgroup.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder publishCloudWatchMetricsEnabled(java.lang.Boolean publishCloudWatchMetricsEnabled) {
                this.publishCloudWatchMetricsEnabled = publishCloudWatchMetricsEnabled;
                return this;
            }

            /**
             * Sets the value of {@link WorkGroupConfigurationProperty#getPublishCloudWatchMetricsEnabled}
             * @param publishCloudWatchMetricsEnabled Indicates that the Amazon CloudWatch metrics are enabled for the workgroup.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder publishCloudWatchMetricsEnabled(software.amazon.awscdk.IResolvable publishCloudWatchMetricsEnabled) {
                this.publishCloudWatchMetricsEnabled = publishCloudWatchMetricsEnabled;
                return this;
            }

            /**
             * Sets the value of {@link WorkGroupConfigurationProperty#getRequesterPaysEnabled}
             * @param requesterPaysEnabled If set to <code>true</code> , allows members assigned to a workgroup to reference Amazon S3 Requester Pays buckets in queries.
             *                             If set to <code>false</code> , workgroup members cannot query data from Requester Pays buckets, and queries that retrieve data from Requester Pays buckets cause an error. The default is <code>false</code> . For more information about Requester Pays buckets, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/RequesterPaysBuckets.html">Requester Pays Buckets</a> in the <em>Amazon Simple Storage Service Developer Guide</em> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder requesterPaysEnabled(java.lang.Boolean requesterPaysEnabled) {
                this.requesterPaysEnabled = requesterPaysEnabled;
                return this;
            }

            /**
             * Sets the value of {@link WorkGroupConfigurationProperty#getRequesterPaysEnabled}
             * @param requesterPaysEnabled If set to <code>true</code> , allows members assigned to a workgroup to reference Amazon S3 Requester Pays buckets in queries.
             *                             If set to <code>false</code> , workgroup members cannot query data from Requester Pays buckets, and queries that retrieve data from Requester Pays buckets cause an error. The default is <code>false</code> . For more information about Requester Pays buckets, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/RequesterPaysBuckets.html">Requester Pays Buckets</a> in the <em>Amazon Simple Storage Service Developer Guide</em> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder requesterPaysEnabled(software.amazon.awscdk.IResolvable requesterPaysEnabled) {
                this.requesterPaysEnabled = requesterPaysEnabled;
                return this;
            }

            /**
             * Sets the value of {@link WorkGroupConfigurationProperty#getResultConfiguration}
             * @param resultConfiguration Specifies the location in Amazon S3 where query results are stored and the encryption option, if any, used for query results.
             *                            For more information, see <a href="https://docs.aws.amazon.com/athena/latest/ug/querying.html">Work with query results and recent queries</a> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder resultConfiguration(software.amazon.awscdk.IResolvable resultConfiguration) {
                this.resultConfiguration = resultConfiguration;
                return this;
            }

            /**
             * Sets the value of {@link WorkGroupConfigurationProperty#getResultConfiguration}
             * @param resultConfiguration Specifies the location in Amazon S3 where query results are stored and the encryption option, if any, used for query results.
             *                            For more information, see <a href="https://docs.aws.amazon.com/athena/latest/ug/querying.html">Work with query results and recent queries</a> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder resultConfiguration(software.amazon.awscdk.services.athena.CfnWorkGroup.ResultConfigurationProperty resultConfiguration) {
                this.resultConfiguration = resultConfiguration;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link WorkGroupConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public WorkGroupConfigurationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link WorkGroupConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements WorkGroupConfigurationProperty {
            private final java.lang.String additionalConfiguration;
            private final java.lang.Number bytesScannedCutoffPerQuery;
            private final java.lang.Object customerContentEncryptionConfiguration;
            private final java.lang.Object enforceWorkGroupConfiguration;
            private final java.lang.Object engineVersion;
            private final java.lang.String executionRole;
            private final java.lang.Object publishCloudWatchMetricsEnabled;
            private final java.lang.Object requesterPaysEnabled;
            private final java.lang.Object resultConfiguration;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.additionalConfiguration = software.amazon.jsii.Kernel.get(this, "additionalConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.bytesScannedCutoffPerQuery = software.amazon.jsii.Kernel.get(this, "bytesScannedCutoffPerQuery", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.customerContentEncryptionConfiguration = software.amazon.jsii.Kernel.get(this, "customerContentEncryptionConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.enforceWorkGroupConfiguration = software.amazon.jsii.Kernel.get(this, "enforceWorkGroupConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.engineVersion = software.amazon.jsii.Kernel.get(this, "engineVersion", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.executionRole = software.amazon.jsii.Kernel.get(this, "executionRole", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.publishCloudWatchMetricsEnabled = software.amazon.jsii.Kernel.get(this, "publishCloudWatchMetricsEnabled", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.requesterPaysEnabled = software.amazon.jsii.Kernel.get(this, "requesterPaysEnabled", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.resultConfiguration = software.amazon.jsii.Kernel.get(this, "resultConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.additionalConfiguration = builder.additionalConfiguration;
                this.bytesScannedCutoffPerQuery = builder.bytesScannedCutoffPerQuery;
                this.customerContentEncryptionConfiguration = builder.customerContentEncryptionConfiguration;
                this.enforceWorkGroupConfiguration = builder.enforceWorkGroupConfiguration;
                this.engineVersion = builder.engineVersion;
                this.executionRole = builder.executionRole;
                this.publishCloudWatchMetricsEnabled = builder.publishCloudWatchMetricsEnabled;
                this.requesterPaysEnabled = builder.requesterPaysEnabled;
                this.resultConfiguration = builder.resultConfiguration;
            }

            @Override
            public final java.lang.String getAdditionalConfiguration() {
                return this.additionalConfiguration;
            }

            @Override
            public final java.lang.Number getBytesScannedCutoffPerQuery() {
                return this.bytesScannedCutoffPerQuery;
            }

            @Override
            public final java.lang.Object getCustomerContentEncryptionConfiguration() {
                return this.customerContentEncryptionConfiguration;
            }

            @Override
            public final java.lang.Object getEnforceWorkGroupConfiguration() {
                return this.enforceWorkGroupConfiguration;
            }

            @Override
            public final java.lang.Object getEngineVersion() {
                return this.engineVersion;
            }

            @Override
            public final java.lang.String getExecutionRole() {
                return this.executionRole;
            }

            @Override
            public final java.lang.Object getPublishCloudWatchMetricsEnabled() {
                return this.publishCloudWatchMetricsEnabled;
            }

            @Override
            public final java.lang.Object getRequesterPaysEnabled() {
                return this.requesterPaysEnabled;
            }

            @Override
            public final java.lang.Object getResultConfiguration() {
                return this.resultConfiguration;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getAdditionalConfiguration() != null) {
                    data.set("additionalConfiguration", om.valueToTree(this.getAdditionalConfiguration()));
                }
                if (this.getBytesScannedCutoffPerQuery() != null) {
                    data.set("bytesScannedCutoffPerQuery", om.valueToTree(this.getBytesScannedCutoffPerQuery()));
                }
                if (this.getCustomerContentEncryptionConfiguration() != null) {
                    data.set("customerContentEncryptionConfiguration", om.valueToTree(this.getCustomerContentEncryptionConfiguration()));
                }
                if (this.getEnforceWorkGroupConfiguration() != null) {
                    data.set("enforceWorkGroupConfiguration", om.valueToTree(this.getEnforceWorkGroupConfiguration()));
                }
                if (this.getEngineVersion() != null) {
                    data.set("engineVersion", om.valueToTree(this.getEngineVersion()));
                }
                if (this.getExecutionRole() != null) {
                    data.set("executionRole", om.valueToTree(this.getExecutionRole()));
                }
                if (this.getPublishCloudWatchMetricsEnabled() != null) {
                    data.set("publishCloudWatchMetricsEnabled", om.valueToTree(this.getPublishCloudWatchMetricsEnabled()));
                }
                if (this.getRequesterPaysEnabled() != null) {
                    data.set("requesterPaysEnabled", om.valueToTree(this.getRequesterPaysEnabled()));
                }
                if (this.getResultConfiguration() != null) {
                    data.set("resultConfiguration", om.valueToTree(this.getResultConfiguration()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_athena.CfnWorkGroup.WorkGroupConfigurationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                WorkGroupConfigurationProperty.Jsii$Proxy that = (WorkGroupConfigurationProperty.Jsii$Proxy) o;

                if (this.additionalConfiguration != null ? !this.additionalConfiguration.equals(that.additionalConfiguration) : that.additionalConfiguration != null) return false;
                if (this.bytesScannedCutoffPerQuery != null ? !this.bytesScannedCutoffPerQuery.equals(that.bytesScannedCutoffPerQuery) : that.bytesScannedCutoffPerQuery != null) return false;
                if (this.customerContentEncryptionConfiguration != null ? !this.customerContentEncryptionConfiguration.equals(that.customerContentEncryptionConfiguration) : that.customerContentEncryptionConfiguration != null) return false;
                if (this.enforceWorkGroupConfiguration != null ? !this.enforceWorkGroupConfiguration.equals(that.enforceWorkGroupConfiguration) : that.enforceWorkGroupConfiguration != null) return false;
                if (this.engineVersion != null ? !this.engineVersion.equals(that.engineVersion) : that.engineVersion != null) return false;
                if (this.executionRole != null ? !this.executionRole.equals(that.executionRole) : that.executionRole != null) return false;
                if (this.publishCloudWatchMetricsEnabled != null ? !this.publishCloudWatchMetricsEnabled.equals(that.publishCloudWatchMetricsEnabled) : that.publishCloudWatchMetricsEnabled != null) return false;
                if (this.requesterPaysEnabled != null ? !this.requesterPaysEnabled.equals(that.requesterPaysEnabled) : that.requesterPaysEnabled != null) return false;
                return this.resultConfiguration != null ? this.resultConfiguration.equals(that.resultConfiguration) : that.resultConfiguration == null;
            }

            @Override
            public final int hashCode() {
                int result = this.additionalConfiguration != null ? this.additionalConfiguration.hashCode() : 0;
                result = 31 * result + (this.bytesScannedCutoffPerQuery != null ? this.bytesScannedCutoffPerQuery.hashCode() : 0);
                result = 31 * result + (this.customerContentEncryptionConfiguration != null ? this.customerContentEncryptionConfiguration.hashCode() : 0);
                result = 31 * result + (this.enforceWorkGroupConfiguration != null ? this.enforceWorkGroupConfiguration.hashCode() : 0);
                result = 31 * result + (this.engineVersion != null ? this.engineVersion.hashCode() : 0);
                result = 31 * result + (this.executionRole != null ? this.executionRole.hashCode() : 0);
                result = 31 * result + (this.publishCloudWatchMetricsEnabled != null ? this.publishCloudWatchMetricsEnabled.hashCode() : 0);
                result = 31 * result + (this.requesterPaysEnabled != null ? this.requesterPaysEnabled.hashCode() : 0);
                result = 31 * result + (this.resultConfiguration != null ? this.resultConfiguration.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * The configuration information that will be updated for this workgroup, which includes the location in Amazon S3 where query results are stored, the encryption option, if any, used for query results, whether the Amazon CloudWatch Metrics are enabled for the workgroup, whether the workgroup settings override the client-side settings, and the data usage limit for the amount of bytes scanned per query, if it is specified.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.athena.*;
     * WorkGroupConfigurationUpdatesProperty workGroupConfigurationUpdatesProperty = WorkGroupConfigurationUpdatesProperty.builder()
     *         .additionalConfiguration("additionalConfiguration")
     *         .bytesScannedCutoffPerQuery(123)
     *         .customerContentEncryptionConfiguration(CustomerContentEncryptionConfigurationProperty.builder()
     *                 .kmsKey("kmsKey")
     *                 .build())
     *         .enforceWorkGroupConfiguration(false)
     *         .engineVersion(EngineVersionProperty.builder()
     *                 .effectiveEngineVersion("effectiveEngineVersion")
     *                 .selectedEngineVersion("selectedEngineVersion")
     *                 .build())
     *         .executionRole("executionRole")
     *         .publishCloudWatchMetricsEnabled(false)
     *         .removeBytesScannedCutoffPerQuery(false)
     *         .removeCustomerContentEncryptionConfiguration(false)
     *         .requesterPaysEnabled(false)
     *         .resultConfigurationUpdates(ResultConfigurationUpdatesProperty.builder()
     *                 .aclConfiguration(AclConfigurationProperty.builder()
     *                         .s3AclOption("s3AclOption")
     *                         .build())
     *                 .encryptionConfiguration(EncryptionConfigurationProperty.builder()
     *                         .encryptionOption("encryptionOption")
     *                         // the properties below are optional
     *                         .kmsKey("kmsKey")
     *                         .build())
     *                 .expectedBucketOwner("expectedBucketOwner")
     *                 .outputLocation("outputLocation")
     *                 .removeAclConfiguration(false)
     *                 .removeEncryptionConfiguration(false)
     *                 .removeExpectedBucketOwner(false)
     *                 .removeOutputLocation(false)
     *                 .build())
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-athena-workgroup-workgroupconfigurationupdates.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-athena-workgroup-workgroupconfigurationupdates.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_athena.CfnWorkGroup.WorkGroupConfigurationUpdatesProperty")
    @software.amazon.jsii.Jsii.Proxy(WorkGroupConfigurationUpdatesProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface WorkGroupConfigurationUpdatesProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Additional Configuration that are passed to Athena Spark Calculations running in this workgroup.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-athena-workgroup-workgroupconfigurationupdates.html#cfn-athena-workgroup-workgroupconfigurationupdates-additionalconfiguration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-athena-workgroup-workgroupconfigurationupdates.html#cfn-athena-workgroup-workgroupconfigurationupdates-additionalconfiguration</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getAdditionalConfiguration() {
            return null;
        }

        /**
         * The upper data usage limit (cutoff) for the amount of bytes a single query in a workgroup is allowed to scan.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-athena-workgroup-workgroupconfigurationupdates.html#cfn-athena-workgroup-workgroupconfigurationupdates-bytesscannedcutoffperquery">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-athena-workgroup-workgroupconfigurationupdates.html#cfn-athena-workgroup-workgroupconfigurationupdates-bytesscannedcutoffperquery</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getBytesScannedCutoffPerQuery() {
            return null;
        }

        /**
         * Indicates the KMS key for encrypting notebook content.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-athena-workgroup-workgroupconfigurationupdates.html#cfn-athena-workgroup-workgroupconfigurationupdates-customercontentencryptionconfiguration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-athena-workgroup-workgroupconfigurationupdates.html#cfn-athena-workgroup-workgroupconfigurationupdates-customercontentencryptionconfiguration</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getCustomerContentEncryptionConfiguration() {
            return null;
        }

        /**
         * If set to "true", the settings for the workgroup override client-side settings.
         * <p>
         * If set to "false", client-side settings are used
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-athena-workgroup-workgroupconfigurationupdates.html#cfn-athena-workgroup-workgroupconfigurationupdates-enforceworkgroupconfiguration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-athena-workgroup-workgroupconfigurationupdates.html#cfn-athena-workgroup-workgroupconfigurationupdates-enforceworkgroupconfiguration</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getEnforceWorkGroupConfiguration() {
            return null;
        }

        /**
         * The Athena engine version for running queries.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-athena-workgroup-workgroupconfigurationupdates.html#cfn-athena-workgroup-workgroupconfigurationupdates-engineversion">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-athena-workgroup-workgroupconfigurationupdates.html#cfn-athena-workgroup-workgroupconfigurationupdates-engineversion</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getEngineVersion() {
            return null;
        }

        /**
         * Execution Role ARN required to run Athena Spark Calculations.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-athena-workgroup-workgroupconfigurationupdates.html#cfn-athena-workgroup-workgroupconfigurationupdates-executionrole">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-athena-workgroup-workgroupconfigurationupdates.html#cfn-athena-workgroup-workgroupconfigurationupdates-executionrole</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getExecutionRole() {
            return null;
        }

        /**
         * Indicates that the Amazon CloudWatch metrics are enabled for the workgroup.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-athena-workgroup-workgroupconfigurationupdates.html#cfn-athena-workgroup-workgroupconfigurationupdates-publishcloudwatchmetricsenabled">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-athena-workgroup-workgroupconfigurationupdates.html#cfn-athena-workgroup-workgroupconfigurationupdates-publishcloudwatchmetricsenabled</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getPublishCloudWatchMetricsEnabled() {
            return null;
        }

        /**
         * Indicates that the data usage control limit per query is removed.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-athena-workgroup-workgroupconfigurationupdates.html#cfn-athena-workgroup-workgroupconfigurationupdates-removebytesscannedcutoffperquery">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-athena-workgroup-workgroupconfigurationupdates.html#cfn-athena-workgroup-workgroupconfigurationupdates-removebytesscannedcutoffperquery</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getRemoveBytesScannedCutoffPerQuery() {
            return null;
        }

        /**
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-athena-workgroup-workgroupconfigurationupdates.html#cfn-athena-workgroup-workgroupconfigurationupdates-removecustomercontentencryptionconfiguration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-athena-workgroup-workgroupconfigurationupdates.html#cfn-athena-workgroup-workgroupconfigurationupdates-removecustomercontentencryptionconfiguration</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getRemoveCustomerContentEncryptionConfiguration() {
            return null;
        }

        /**
         * If set to true, allows members assigned to a workgroup to reference Amazon S3 Requester Pays buckets in queries.
         * <p>
         * If set to false, workgroup members cannot query data from Requester Pays buckets, and queries that retrieve data from Requester Pays buckets cause an error.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-athena-workgroup-workgroupconfigurationupdates.html#cfn-athena-workgroup-workgroupconfigurationupdates-requesterpaysenabled">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-athena-workgroup-workgroupconfigurationupdates.html#cfn-athena-workgroup-workgroupconfigurationupdates-requesterpaysenabled</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getRequesterPaysEnabled() {
            return null;
        }

        /**
         * The result configuration information about the queries in this workgroup that will be updated.
         * <p>
         * Includes the updated results location and an updated option for encrypting query results.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-athena-workgroup-workgroupconfigurationupdates.html#cfn-athena-workgroup-workgroupconfigurationupdates-resultconfigurationupdates">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-athena-workgroup-workgroupconfigurationupdates.html#cfn-athena-workgroup-workgroupconfigurationupdates-resultconfigurationupdates</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getResultConfigurationUpdates() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link WorkGroupConfigurationUpdatesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link WorkGroupConfigurationUpdatesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<WorkGroupConfigurationUpdatesProperty> {
            java.lang.String additionalConfiguration;
            java.lang.Number bytesScannedCutoffPerQuery;
            java.lang.Object customerContentEncryptionConfiguration;
            java.lang.Object enforceWorkGroupConfiguration;
            java.lang.Object engineVersion;
            java.lang.String executionRole;
            java.lang.Object publishCloudWatchMetricsEnabled;
            java.lang.Object removeBytesScannedCutoffPerQuery;
            java.lang.Object removeCustomerContentEncryptionConfiguration;
            java.lang.Object requesterPaysEnabled;
            java.lang.Object resultConfigurationUpdates;

            /**
             * Sets the value of {@link WorkGroupConfigurationUpdatesProperty#getAdditionalConfiguration}
             * @param additionalConfiguration Additional Configuration that are passed to Athena Spark Calculations running in this workgroup.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder additionalConfiguration(java.lang.String additionalConfiguration) {
                this.additionalConfiguration = additionalConfiguration;
                return this;
            }

            /**
             * Sets the value of {@link WorkGroupConfigurationUpdatesProperty#getBytesScannedCutoffPerQuery}
             * @param bytesScannedCutoffPerQuery The upper data usage limit (cutoff) for the amount of bytes a single query in a workgroup is allowed to scan.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder bytesScannedCutoffPerQuery(java.lang.Number bytesScannedCutoffPerQuery) {
                this.bytesScannedCutoffPerQuery = bytesScannedCutoffPerQuery;
                return this;
            }

            /**
             * Sets the value of {@link WorkGroupConfigurationUpdatesProperty#getCustomerContentEncryptionConfiguration}
             * @param customerContentEncryptionConfiguration Indicates the KMS key for encrypting notebook content.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder customerContentEncryptionConfiguration(software.amazon.awscdk.IResolvable customerContentEncryptionConfiguration) {
                this.customerContentEncryptionConfiguration = customerContentEncryptionConfiguration;
                return this;
            }

            /**
             * Sets the value of {@link WorkGroupConfigurationUpdatesProperty#getCustomerContentEncryptionConfiguration}
             * @param customerContentEncryptionConfiguration Indicates the KMS key for encrypting notebook content.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder customerContentEncryptionConfiguration(software.amazon.awscdk.services.athena.CfnWorkGroup.CustomerContentEncryptionConfigurationProperty customerContentEncryptionConfiguration) {
                this.customerContentEncryptionConfiguration = customerContentEncryptionConfiguration;
                return this;
            }

            /**
             * Sets the value of {@link WorkGroupConfigurationUpdatesProperty#getEnforceWorkGroupConfiguration}
             * @param enforceWorkGroupConfiguration If set to "true", the settings for the workgroup override client-side settings.
             *                                      If set to "false", client-side settings are used
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder enforceWorkGroupConfiguration(java.lang.Boolean enforceWorkGroupConfiguration) {
                this.enforceWorkGroupConfiguration = enforceWorkGroupConfiguration;
                return this;
            }

            /**
             * Sets the value of {@link WorkGroupConfigurationUpdatesProperty#getEnforceWorkGroupConfiguration}
             * @param enforceWorkGroupConfiguration If set to "true", the settings for the workgroup override client-side settings.
             *                                      If set to "false", client-side settings are used
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder enforceWorkGroupConfiguration(software.amazon.awscdk.IResolvable enforceWorkGroupConfiguration) {
                this.enforceWorkGroupConfiguration = enforceWorkGroupConfiguration;
                return this;
            }

            /**
             * Sets the value of {@link WorkGroupConfigurationUpdatesProperty#getEngineVersion}
             * @param engineVersion The Athena engine version for running queries.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder engineVersion(software.amazon.awscdk.IResolvable engineVersion) {
                this.engineVersion = engineVersion;
                return this;
            }

            /**
             * Sets the value of {@link WorkGroupConfigurationUpdatesProperty#getEngineVersion}
             * @param engineVersion The Athena engine version for running queries.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder engineVersion(software.amazon.awscdk.services.athena.CfnWorkGroup.EngineVersionProperty engineVersion) {
                this.engineVersion = engineVersion;
                return this;
            }

            /**
             * Sets the value of {@link WorkGroupConfigurationUpdatesProperty#getExecutionRole}
             * @param executionRole Execution Role ARN required to run Athena Spark Calculations.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder executionRole(java.lang.String executionRole) {
                this.executionRole = executionRole;
                return this;
            }

            /**
             * Sets the value of {@link WorkGroupConfigurationUpdatesProperty#getPublishCloudWatchMetricsEnabled}
             * @param publishCloudWatchMetricsEnabled Indicates that the Amazon CloudWatch metrics are enabled for the workgroup.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder publishCloudWatchMetricsEnabled(java.lang.Boolean publishCloudWatchMetricsEnabled) {
                this.publishCloudWatchMetricsEnabled = publishCloudWatchMetricsEnabled;
                return this;
            }

            /**
             * Sets the value of {@link WorkGroupConfigurationUpdatesProperty#getPublishCloudWatchMetricsEnabled}
             * @param publishCloudWatchMetricsEnabled Indicates that the Amazon CloudWatch metrics are enabled for the workgroup.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder publishCloudWatchMetricsEnabled(software.amazon.awscdk.IResolvable publishCloudWatchMetricsEnabled) {
                this.publishCloudWatchMetricsEnabled = publishCloudWatchMetricsEnabled;
                return this;
            }

            /**
             * Sets the value of {@link WorkGroupConfigurationUpdatesProperty#getRemoveBytesScannedCutoffPerQuery}
             * @param removeBytesScannedCutoffPerQuery Indicates that the data usage control limit per query is removed.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder removeBytesScannedCutoffPerQuery(java.lang.Boolean removeBytesScannedCutoffPerQuery) {
                this.removeBytesScannedCutoffPerQuery = removeBytesScannedCutoffPerQuery;
                return this;
            }

            /**
             * Sets the value of {@link WorkGroupConfigurationUpdatesProperty#getRemoveBytesScannedCutoffPerQuery}
             * @param removeBytesScannedCutoffPerQuery Indicates that the data usage control limit per query is removed.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder removeBytesScannedCutoffPerQuery(software.amazon.awscdk.IResolvable removeBytesScannedCutoffPerQuery) {
                this.removeBytesScannedCutoffPerQuery = removeBytesScannedCutoffPerQuery;
                return this;
            }

            /**
             * Sets the value of {@link WorkGroupConfigurationUpdatesProperty#getRemoveCustomerContentEncryptionConfiguration}
             * @param removeCustomerContentEncryptionConfiguration the value to be set.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder removeCustomerContentEncryptionConfiguration(java.lang.Boolean removeCustomerContentEncryptionConfiguration) {
                this.removeCustomerContentEncryptionConfiguration = removeCustomerContentEncryptionConfiguration;
                return this;
            }

            /**
             * Sets the value of {@link WorkGroupConfigurationUpdatesProperty#getRemoveCustomerContentEncryptionConfiguration}
             * @param removeCustomerContentEncryptionConfiguration the value to be set.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder removeCustomerContentEncryptionConfiguration(software.amazon.awscdk.IResolvable removeCustomerContentEncryptionConfiguration) {
                this.removeCustomerContentEncryptionConfiguration = removeCustomerContentEncryptionConfiguration;
                return this;
            }

            /**
             * Sets the value of {@link WorkGroupConfigurationUpdatesProperty#getRequesterPaysEnabled}
             * @param requesterPaysEnabled If set to true, allows members assigned to a workgroup to reference Amazon S3 Requester Pays buckets in queries.
             *                             If set to false, workgroup members cannot query data from Requester Pays buckets, and queries that retrieve data from Requester Pays buckets cause an error.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder requesterPaysEnabled(java.lang.Boolean requesterPaysEnabled) {
                this.requesterPaysEnabled = requesterPaysEnabled;
                return this;
            }

            /**
             * Sets the value of {@link WorkGroupConfigurationUpdatesProperty#getRequesterPaysEnabled}
             * @param requesterPaysEnabled If set to true, allows members assigned to a workgroup to reference Amazon S3 Requester Pays buckets in queries.
             *                             If set to false, workgroup members cannot query data from Requester Pays buckets, and queries that retrieve data from Requester Pays buckets cause an error.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder requesterPaysEnabled(software.amazon.awscdk.IResolvable requesterPaysEnabled) {
                this.requesterPaysEnabled = requesterPaysEnabled;
                return this;
            }

            /**
             * Sets the value of {@link WorkGroupConfigurationUpdatesProperty#getResultConfigurationUpdates}
             * @param resultConfigurationUpdates The result configuration information about the queries in this workgroup that will be updated.
             *                                   Includes the updated results location and an updated option for encrypting query results.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder resultConfigurationUpdates(software.amazon.awscdk.IResolvable resultConfigurationUpdates) {
                this.resultConfigurationUpdates = resultConfigurationUpdates;
                return this;
            }

            /**
             * Sets the value of {@link WorkGroupConfigurationUpdatesProperty#getResultConfigurationUpdates}
             * @param resultConfigurationUpdates The result configuration information about the queries in this workgroup that will be updated.
             *                                   Includes the updated results location and an updated option for encrypting query results.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder resultConfigurationUpdates(software.amazon.awscdk.services.athena.CfnWorkGroup.ResultConfigurationUpdatesProperty resultConfigurationUpdates) {
                this.resultConfigurationUpdates = resultConfigurationUpdates;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link WorkGroupConfigurationUpdatesProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public WorkGroupConfigurationUpdatesProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link WorkGroupConfigurationUpdatesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements WorkGroupConfigurationUpdatesProperty {
            private final java.lang.String additionalConfiguration;
            private final java.lang.Number bytesScannedCutoffPerQuery;
            private final java.lang.Object customerContentEncryptionConfiguration;
            private final java.lang.Object enforceWorkGroupConfiguration;
            private final java.lang.Object engineVersion;
            private final java.lang.String executionRole;
            private final java.lang.Object publishCloudWatchMetricsEnabled;
            private final java.lang.Object removeBytesScannedCutoffPerQuery;
            private final java.lang.Object removeCustomerContentEncryptionConfiguration;
            private final java.lang.Object requesterPaysEnabled;
            private final java.lang.Object resultConfigurationUpdates;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.additionalConfiguration = software.amazon.jsii.Kernel.get(this, "additionalConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.bytesScannedCutoffPerQuery = software.amazon.jsii.Kernel.get(this, "bytesScannedCutoffPerQuery", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.customerContentEncryptionConfiguration = software.amazon.jsii.Kernel.get(this, "customerContentEncryptionConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.enforceWorkGroupConfiguration = software.amazon.jsii.Kernel.get(this, "enforceWorkGroupConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.engineVersion = software.amazon.jsii.Kernel.get(this, "engineVersion", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.executionRole = software.amazon.jsii.Kernel.get(this, "executionRole", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.publishCloudWatchMetricsEnabled = software.amazon.jsii.Kernel.get(this, "publishCloudWatchMetricsEnabled", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.removeBytesScannedCutoffPerQuery = software.amazon.jsii.Kernel.get(this, "removeBytesScannedCutoffPerQuery", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.removeCustomerContentEncryptionConfiguration = software.amazon.jsii.Kernel.get(this, "removeCustomerContentEncryptionConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.requesterPaysEnabled = software.amazon.jsii.Kernel.get(this, "requesterPaysEnabled", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.resultConfigurationUpdates = software.amazon.jsii.Kernel.get(this, "resultConfigurationUpdates", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.additionalConfiguration = builder.additionalConfiguration;
                this.bytesScannedCutoffPerQuery = builder.bytesScannedCutoffPerQuery;
                this.customerContentEncryptionConfiguration = builder.customerContentEncryptionConfiguration;
                this.enforceWorkGroupConfiguration = builder.enforceWorkGroupConfiguration;
                this.engineVersion = builder.engineVersion;
                this.executionRole = builder.executionRole;
                this.publishCloudWatchMetricsEnabled = builder.publishCloudWatchMetricsEnabled;
                this.removeBytesScannedCutoffPerQuery = builder.removeBytesScannedCutoffPerQuery;
                this.removeCustomerContentEncryptionConfiguration = builder.removeCustomerContentEncryptionConfiguration;
                this.requesterPaysEnabled = builder.requesterPaysEnabled;
                this.resultConfigurationUpdates = builder.resultConfigurationUpdates;
            }

            @Override
            public final java.lang.String getAdditionalConfiguration() {
                return this.additionalConfiguration;
            }

            @Override
            public final java.lang.Number getBytesScannedCutoffPerQuery() {
                return this.bytesScannedCutoffPerQuery;
            }

            @Override
            public final java.lang.Object getCustomerContentEncryptionConfiguration() {
                return this.customerContentEncryptionConfiguration;
            }

            @Override
            public final java.lang.Object getEnforceWorkGroupConfiguration() {
                return this.enforceWorkGroupConfiguration;
            }

            @Override
            public final java.lang.Object getEngineVersion() {
                return this.engineVersion;
            }

            @Override
            public final java.lang.String getExecutionRole() {
                return this.executionRole;
            }

            @Override
            public final java.lang.Object getPublishCloudWatchMetricsEnabled() {
                return this.publishCloudWatchMetricsEnabled;
            }

            @Override
            public final java.lang.Object getRemoveBytesScannedCutoffPerQuery() {
                return this.removeBytesScannedCutoffPerQuery;
            }

            @Override
            public final java.lang.Object getRemoveCustomerContentEncryptionConfiguration() {
                return this.removeCustomerContentEncryptionConfiguration;
            }

            @Override
            public final java.lang.Object getRequesterPaysEnabled() {
                return this.requesterPaysEnabled;
            }

            @Override
            public final java.lang.Object getResultConfigurationUpdates() {
                return this.resultConfigurationUpdates;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getAdditionalConfiguration() != null) {
                    data.set("additionalConfiguration", om.valueToTree(this.getAdditionalConfiguration()));
                }
                if (this.getBytesScannedCutoffPerQuery() != null) {
                    data.set("bytesScannedCutoffPerQuery", om.valueToTree(this.getBytesScannedCutoffPerQuery()));
                }
                if (this.getCustomerContentEncryptionConfiguration() != null) {
                    data.set("customerContentEncryptionConfiguration", om.valueToTree(this.getCustomerContentEncryptionConfiguration()));
                }
                if (this.getEnforceWorkGroupConfiguration() != null) {
                    data.set("enforceWorkGroupConfiguration", om.valueToTree(this.getEnforceWorkGroupConfiguration()));
                }
                if (this.getEngineVersion() != null) {
                    data.set("engineVersion", om.valueToTree(this.getEngineVersion()));
                }
                if (this.getExecutionRole() != null) {
                    data.set("executionRole", om.valueToTree(this.getExecutionRole()));
                }
                if (this.getPublishCloudWatchMetricsEnabled() != null) {
                    data.set("publishCloudWatchMetricsEnabled", om.valueToTree(this.getPublishCloudWatchMetricsEnabled()));
                }
                if (this.getRemoveBytesScannedCutoffPerQuery() != null) {
                    data.set("removeBytesScannedCutoffPerQuery", om.valueToTree(this.getRemoveBytesScannedCutoffPerQuery()));
                }
                if (this.getRemoveCustomerContentEncryptionConfiguration() != null) {
                    data.set("removeCustomerContentEncryptionConfiguration", om.valueToTree(this.getRemoveCustomerContentEncryptionConfiguration()));
                }
                if (this.getRequesterPaysEnabled() != null) {
                    data.set("requesterPaysEnabled", om.valueToTree(this.getRequesterPaysEnabled()));
                }
                if (this.getResultConfigurationUpdates() != null) {
                    data.set("resultConfigurationUpdates", om.valueToTree(this.getResultConfigurationUpdates()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_athena.CfnWorkGroup.WorkGroupConfigurationUpdatesProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                WorkGroupConfigurationUpdatesProperty.Jsii$Proxy that = (WorkGroupConfigurationUpdatesProperty.Jsii$Proxy) o;

                if (this.additionalConfiguration != null ? !this.additionalConfiguration.equals(that.additionalConfiguration) : that.additionalConfiguration != null) return false;
                if (this.bytesScannedCutoffPerQuery != null ? !this.bytesScannedCutoffPerQuery.equals(that.bytesScannedCutoffPerQuery) : that.bytesScannedCutoffPerQuery != null) return false;
                if (this.customerContentEncryptionConfiguration != null ? !this.customerContentEncryptionConfiguration.equals(that.customerContentEncryptionConfiguration) : that.customerContentEncryptionConfiguration != null) return false;
                if (this.enforceWorkGroupConfiguration != null ? !this.enforceWorkGroupConfiguration.equals(that.enforceWorkGroupConfiguration) : that.enforceWorkGroupConfiguration != null) return false;
                if (this.engineVersion != null ? !this.engineVersion.equals(that.engineVersion) : that.engineVersion != null) return false;
                if (this.executionRole != null ? !this.executionRole.equals(that.executionRole) : that.executionRole != null) return false;
                if (this.publishCloudWatchMetricsEnabled != null ? !this.publishCloudWatchMetricsEnabled.equals(that.publishCloudWatchMetricsEnabled) : that.publishCloudWatchMetricsEnabled != null) return false;
                if (this.removeBytesScannedCutoffPerQuery != null ? !this.removeBytesScannedCutoffPerQuery.equals(that.removeBytesScannedCutoffPerQuery) : that.removeBytesScannedCutoffPerQuery != null) return false;
                if (this.removeCustomerContentEncryptionConfiguration != null ? !this.removeCustomerContentEncryptionConfiguration.equals(that.removeCustomerContentEncryptionConfiguration) : that.removeCustomerContentEncryptionConfiguration != null) return false;
                if (this.requesterPaysEnabled != null ? !this.requesterPaysEnabled.equals(that.requesterPaysEnabled) : that.requesterPaysEnabled != null) return false;
                return this.resultConfigurationUpdates != null ? this.resultConfigurationUpdates.equals(that.resultConfigurationUpdates) : that.resultConfigurationUpdates == null;
            }

            @Override
            public final int hashCode() {
                int result = this.additionalConfiguration != null ? this.additionalConfiguration.hashCode() : 0;
                result = 31 * result + (this.bytesScannedCutoffPerQuery != null ? this.bytesScannedCutoffPerQuery.hashCode() : 0);
                result = 31 * result + (this.customerContentEncryptionConfiguration != null ? this.customerContentEncryptionConfiguration.hashCode() : 0);
                result = 31 * result + (this.enforceWorkGroupConfiguration != null ? this.enforceWorkGroupConfiguration.hashCode() : 0);
                result = 31 * result + (this.engineVersion != null ? this.engineVersion.hashCode() : 0);
                result = 31 * result + (this.executionRole != null ? this.executionRole.hashCode() : 0);
                result = 31 * result + (this.publishCloudWatchMetricsEnabled != null ? this.publishCloudWatchMetricsEnabled.hashCode() : 0);
                result = 31 * result + (this.removeBytesScannedCutoffPerQuery != null ? this.removeBytesScannedCutoffPerQuery.hashCode() : 0);
                result = 31 * result + (this.removeCustomerContentEncryptionConfiguration != null ? this.removeCustomerContentEncryptionConfiguration.hashCode() : 0);
                result = 31 * result + (this.requesterPaysEnabled != null ? this.requesterPaysEnabled.hashCode() : 0);
                result = 31 * result + (this.resultConfigurationUpdates != null ? this.resultConfigurationUpdates.hashCode() : 0);
                return result;
            }
        }
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.athena.CfnWorkGroup}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.athena.CfnWorkGroup> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope Scope in which this resource is defined. This parameter is required.
         * @param id Construct identifier for this resource (unique in its scope). This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.athena.CfnWorkGroupProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.services.athena.CfnWorkGroupProps.Builder();
        }

        /**
         * The workgroup name.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-athena-workgroup.html#cfn-athena-workgroup-name">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-athena-workgroup.html#cfn-athena-workgroup-name</a>
         * @param name The workgroup name. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder name(final java.lang.String name) {
            this.props.name(name);
            return this;
        }

        /**
         * The workgroup description.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-athena-workgroup.html#cfn-athena-workgroup-description">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-athena-workgroup.html#cfn-athena-workgroup-description</a>
         * @param description The workgroup description. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder description(final java.lang.String description) {
            this.props.description(description);
            return this;
        }

        /**
         * The option to delete a workgroup and its contents even if the workgroup contains any named queries.
         * <p>
         * The default is false.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-athena-workgroup.html#cfn-athena-workgroup-recursivedeleteoption">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-athena-workgroup.html#cfn-athena-workgroup-recursivedeleteoption</a>
         * @param recursiveDeleteOption The option to delete a workgroup and its contents even if the workgroup contains any named queries. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder recursiveDeleteOption(final java.lang.Boolean recursiveDeleteOption) {
            this.props.recursiveDeleteOption(recursiveDeleteOption);
            return this;
        }
        /**
         * The option to delete a workgroup and its contents even if the workgroup contains any named queries.
         * <p>
         * The default is false.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-athena-workgroup.html#cfn-athena-workgroup-recursivedeleteoption">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-athena-workgroup.html#cfn-athena-workgroup-recursivedeleteoption</a>
         * @param recursiveDeleteOption The option to delete a workgroup and its contents even if the workgroup contains any named queries. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder recursiveDeleteOption(final software.amazon.awscdk.IResolvable recursiveDeleteOption) {
            this.props.recursiveDeleteOption(recursiveDeleteOption);
            return this;
        }

        /**
         * The state of the workgroup: ENABLED or DISABLED.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-athena-workgroup.html#cfn-athena-workgroup-state">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-athena-workgroup.html#cfn-athena-workgroup-state</a>
         * @param state The state of the workgroup: ENABLED or DISABLED. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder state(final java.lang.String state) {
            this.props.state(state);
            return this;
        }

        /**
         * The tags (key-value pairs) to associate with this resource.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-athena-workgroup.html#cfn-athena-workgroup-tags">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-athena-workgroup.html#cfn-athena-workgroup-tags</a>
         * @param tags The tags (key-value pairs) to associate with this resource. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder tags(final java.util.List<? extends software.amazon.awscdk.CfnTag> tags) {
            this.props.tags(tags);
            return this;
        }

        /**
         * The configuration of the workgroup, which includes the location in Amazon S3 where query results are stored, the encryption option, if any, used for query results, whether Amazon CloudWatch Metrics are enabled for the workgroup, and the limit for the amount of bytes scanned (cutoff) per query, if it is specified.
         * <p>
         * The <code>EnforceWorkGroupConfiguration</code> option determines whether workgroup settings override client-side query settings.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-athena-workgroup.html#cfn-athena-workgroup-workgroupconfiguration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-athena-workgroup.html#cfn-athena-workgroup-workgroupconfiguration</a>
         * @param workGroupConfiguration The configuration of the workgroup, which includes the location in Amazon S3 where query results are stored, the encryption option, if any, used for query results, whether Amazon CloudWatch Metrics are enabled for the workgroup, and the limit for the amount of bytes scanned (cutoff) per query, if it is specified. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder workGroupConfiguration(final software.amazon.awscdk.IResolvable workGroupConfiguration) {
            this.props.workGroupConfiguration(workGroupConfiguration);
            return this;
        }
        /**
         * The configuration of the workgroup, which includes the location in Amazon S3 where query results are stored, the encryption option, if any, used for query results, whether Amazon CloudWatch Metrics are enabled for the workgroup, and the limit for the amount of bytes scanned (cutoff) per query, if it is specified.
         * <p>
         * The <code>EnforceWorkGroupConfiguration</code> option determines whether workgroup settings override client-side query settings.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-athena-workgroup.html#cfn-athena-workgroup-workgroupconfiguration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-athena-workgroup.html#cfn-athena-workgroup-workgroupconfiguration</a>
         * @param workGroupConfiguration The configuration of the workgroup, which includes the location in Amazon S3 where query results are stored, the encryption option, if any, used for query results, whether Amazon CloudWatch Metrics are enabled for the workgroup, and the limit for the amount of bytes scanned (cutoff) per query, if it is specified. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder workGroupConfiguration(final software.amazon.awscdk.services.athena.CfnWorkGroup.WorkGroupConfigurationProperty workGroupConfiguration) {
            this.props.workGroupConfiguration(workGroupConfiguration);
            return this;
        }

        /**
         * (deprecated) The configuration information that will be updated for this workgroup, which includes the location in Amazon S3 where query results are stored, the encryption option, if any, used for query results, whether the Amazon CloudWatch Metrics are enabled for the workgroup, whether the workgroup settings override the client-side settings, and the data usage limit for the amount of bytes scanned per query, if it is specified.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-athena-workgroup.html#cfn-athena-workgroup-workgroupconfigurationupdates">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-athena-workgroup.html#cfn-athena-workgroup-workgroupconfigurationupdates</a>
         * @deprecated this property has been deprecated
         * @param workGroupConfigurationUpdates The configuration information that will be updated for this workgroup, which includes the location in Amazon S3 where query results are stored, the encryption option, if any, used for query results, whether the Amazon CloudWatch Metrics are enabled for the workgroup, whether the workgroup settings override the client-side settings, and the data usage limit for the amount of bytes scanned per query, if it is specified. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
        @Deprecated
        public Builder workGroupConfigurationUpdates(final software.amazon.awscdk.IResolvable workGroupConfigurationUpdates) {
            this.props.workGroupConfigurationUpdates(workGroupConfigurationUpdates);
            return this;
        }
        /**
         * (deprecated) The configuration information that will be updated for this workgroup, which includes the location in Amazon S3 where query results are stored, the encryption option, if any, used for query results, whether the Amazon CloudWatch Metrics are enabled for the workgroup, whether the workgroup settings override the client-side settings, and the data usage limit for the amount of bytes scanned per query, if it is specified.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-athena-workgroup.html#cfn-athena-workgroup-workgroupconfigurationupdates">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-athena-workgroup.html#cfn-athena-workgroup-workgroupconfigurationupdates</a>
         * @deprecated this property has been deprecated
         * @param workGroupConfigurationUpdates The configuration information that will be updated for this workgroup, which includes the location in Amazon S3 where query results are stored, the encryption option, if any, used for query results, whether the Amazon CloudWatch Metrics are enabled for the workgroup, whether the workgroup settings override the client-side settings, and the data usage limit for the amount of bytes scanned per query, if it is specified. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
        @Deprecated
        public Builder workGroupConfigurationUpdates(final software.amazon.awscdk.services.athena.CfnWorkGroup.WorkGroupConfigurationUpdatesProperty workGroupConfigurationUpdates) {
            this.props.workGroupConfigurationUpdates(workGroupConfigurationUpdates);
            return this;
        }

        /**
         * @return a newly built instance of {@link software.amazon.awscdk.services.athena.CfnWorkGroup}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.athena.CfnWorkGroup build() {
            return new software.amazon.awscdk.services.athena.CfnWorkGroup(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
