package software.amazon.awscdk.services.batch;

/**
 * Properties for defining a <code>CfnJobQueue</code>.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.batch.*;
 * CfnJobQueueProps cfnJobQueueProps = CfnJobQueueProps.builder()
 *         .computeEnvironmentOrder(List.of(ComputeEnvironmentOrderProperty.builder()
 *                 .computeEnvironment("computeEnvironment")
 *                 .order(123)
 *                 .build()))
 *         .priority(123)
 *         // the properties below are optional
 *         .jobQueueName("jobQueueName")
 *         .jobStateTimeLimitActions(List.of(JobStateTimeLimitActionProperty.builder()
 *                 .action("action")
 *                 .maxTimeSeconds(123)
 *                 .reason("reason")
 *                 .state("state")
 *                 .build()))
 *         .schedulingPolicyArn("schedulingPolicyArn")
 *         .state("state")
 *         .tags(Map.of(
 *                 "tagsKey", "tags"))
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-batch-jobqueue.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-batch-jobqueue.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.109.0 (build c221850)", date = "2025-03-14T03:24:54.088Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_batch.CfnJobQueueProps")
@software.amazon.jsii.Jsii.Proxy(CfnJobQueueProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnJobQueueProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * The set of compute environments mapped to a job queue and their order relative to each other.
     * <p>
     * The job scheduler uses this parameter to determine which compute environment runs a specific job. Compute environments must be in the <code>VALID</code> state before you can associate them with a job queue. You can associate up to three compute environments with a job queue. All of the compute environments must be either EC2 ( <code>EC2</code> or <code>SPOT</code> ) or Fargate ( <code>FARGATE</code> or <code>FARGATE_SPOT</code> ); EC2 and Fargate compute environments can't be mixed.
     * <p>
     * <blockquote>
     * <p>
     * All compute environments that are associated with a job queue must share the same architecture. AWS Batch doesn't support mixing compute environment architecture types in a single job queue.
     * <p>
     * </blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-batch-jobqueue.html#cfn-batch-jobqueue-computeenvironmentorder">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-batch-jobqueue.html#cfn-batch-jobqueue-computeenvironmentorder</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.Object getComputeEnvironmentOrder();

    /**
     * The priority of the job queue.
     * <p>
     * Job queues with a higher priority (or a higher integer value for the <code>priority</code> parameter) are evaluated first when associated with the same compute environment. Priority is determined in descending order. For example, a job queue with a priority value of <code>10</code> is given scheduling preference over a job queue with a priority value of <code>1</code> . All of the compute environments must be either EC2 ( <code>EC2</code> or <code>SPOT</code> ) or Fargate ( <code>FARGATE</code> or <code>FARGATE_SPOT</code> ); EC2 and Fargate compute environments can't be mixed.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-batch-jobqueue.html#cfn-batch-jobqueue-priority">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-batch-jobqueue.html#cfn-batch-jobqueue-priority</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.Number getPriority();

    /**
     * The name of the job queue.
     * <p>
     * It can be up to 128 letters long. It can contain uppercase and lowercase letters, numbers, hyphens (-), and underscores (_).
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-batch-jobqueue.html#cfn-batch-jobqueue-jobqueuename">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-batch-jobqueue.html#cfn-batch-jobqueue-jobqueuename</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getJobQueueName() {
        return null;
    }

    /**
     * The set of actions that AWS Batch perform on jobs that remain at the head of the job queue in the specified state longer than specified times.
     * <p>
     * AWS Batch will perform each action after <code>maxTimeSeconds</code> has passed.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-batch-jobqueue.html#cfn-batch-jobqueue-jobstatetimelimitactions">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-batch-jobqueue.html#cfn-batch-jobqueue-jobstatetimelimitactions</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getJobStateTimeLimitActions() {
        return null;
    }

    /**
     * The Amazon Resource Name (ARN) of the scheduling policy.
     * <p>
     * The format is <code>aws: *Partition* :batch: *Region* : *Account* :scheduling-policy/ *Name*</code> . For example, <code>aws:aws:batch:us-west-2:123456789012:scheduling-policy/MySchedulingPolicy</code> .
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-batch-jobqueue.html#cfn-batch-jobqueue-schedulingpolicyarn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-batch-jobqueue.html#cfn-batch-jobqueue-schedulingpolicyarn</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getSchedulingPolicyArn() {
        return null;
    }

    /**
     * The state of the job queue.
     * <p>
     * If the job queue state is <code>ENABLED</code> , it is able to accept jobs. If the job queue state is <code>DISABLED</code> , new jobs can't be added to the queue, but jobs already in the queue can finish.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-batch-jobqueue.html#cfn-batch-jobqueue-state">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-batch-jobqueue.html#cfn-batch-jobqueue-state</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getState() {
        return null;
    }

    /**
     * The tags that are applied to the job queue.
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/batch/latest/userguide/using-tags.html">Tagging your AWS Batch resources</a> in <em>AWS Batch User Guide</em> .
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-batch-jobqueue.html#cfn-batch-jobqueue-tags">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-batch-jobqueue.html#cfn-batch-jobqueue-tags</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.Map<java.lang.String, java.lang.String> getTags() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CfnJobQueueProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnJobQueueProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnJobQueueProps> {
        java.lang.Object computeEnvironmentOrder;
        java.lang.Number priority;
        java.lang.String jobQueueName;
        java.lang.Object jobStateTimeLimitActions;
        java.lang.String schedulingPolicyArn;
        java.lang.String state;
        java.util.Map<java.lang.String, java.lang.String> tags;

        /**
         * Sets the value of {@link CfnJobQueueProps#getComputeEnvironmentOrder}
         * @param computeEnvironmentOrder The set of compute environments mapped to a job queue and their order relative to each other. This parameter is required.
         *                                The job scheduler uses this parameter to determine which compute environment runs a specific job. Compute environments must be in the <code>VALID</code> state before you can associate them with a job queue. You can associate up to three compute environments with a job queue. All of the compute environments must be either EC2 ( <code>EC2</code> or <code>SPOT</code> ) or Fargate ( <code>FARGATE</code> or <code>FARGATE_SPOT</code> ); EC2 and Fargate compute environments can't be mixed.
         *                                <p>
         *                                <blockquote>
         *                                <p>
         *                                All compute environments that are associated with a job queue must share the same architecture. AWS Batch doesn't support mixing compute environment architecture types in a single job queue.
         *                                <p>
         *                                </blockquote>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder computeEnvironmentOrder(software.amazon.awscdk.IResolvable computeEnvironmentOrder) {
            this.computeEnvironmentOrder = computeEnvironmentOrder;
            return this;
        }

        /**
         * Sets the value of {@link CfnJobQueueProps#getComputeEnvironmentOrder}
         * @param computeEnvironmentOrder The set of compute environments mapped to a job queue and their order relative to each other. This parameter is required.
         *                                The job scheduler uses this parameter to determine which compute environment runs a specific job. Compute environments must be in the <code>VALID</code> state before you can associate them with a job queue. You can associate up to three compute environments with a job queue. All of the compute environments must be either EC2 ( <code>EC2</code> or <code>SPOT</code> ) or Fargate ( <code>FARGATE</code> or <code>FARGATE_SPOT</code> ); EC2 and Fargate compute environments can't be mixed.
         *                                <p>
         *                                <blockquote>
         *                                <p>
         *                                All compute environments that are associated with a job queue must share the same architecture. AWS Batch doesn't support mixing compute environment architecture types in a single job queue.
         *                                <p>
         *                                </blockquote>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder computeEnvironmentOrder(java.util.List<? extends java.lang.Object> computeEnvironmentOrder) {
            this.computeEnvironmentOrder = computeEnvironmentOrder;
            return this;
        }

        /**
         * Sets the value of {@link CfnJobQueueProps#getPriority}
         * @param priority The priority of the job queue. This parameter is required.
         *                 Job queues with a higher priority (or a higher integer value for the <code>priority</code> parameter) are evaluated first when associated with the same compute environment. Priority is determined in descending order. For example, a job queue with a priority value of <code>10</code> is given scheduling preference over a job queue with a priority value of <code>1</code> . All of the compute environments must be either EC2 ( <code>EC2</code> or <code>SPOT</code> ) or Fargate ( <code>FARGATE</code> or <code>FARGATE_SPOT</code> ); EC2 and Fargate compute environments can't be mixed.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder priority(java.lang.Number priority) {
            this.priority = priority;
            return this;
        }

        /**
         * Sets the value of {@link CfnJobQueueProps#getJobQueueName}
         * @param jobQueueName The name of the job queue.
         *                     It can be up to 128 letters long. It can contain uppercase and lowercase letters, numbers, hyphens (-), and underscores (_).
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder jobQueueName(java.lang.String jobQueueName) {
            this.jobQueueName = jobQueueName;
            return this;
        }

        /**
         * Sets the value of {@link CfnJobQueueProps#getJobStateTimeLimitActions}
         * @param jobStateTimeLimitActions The set of actions that AWS Batch perform on jobs that remain at the head of the job queue in the specified state longer than specified times.
         *                                 AWS Batch will perform each action after <code>maxTimeSeconds</code> has passed.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder jobStateTimeLimitActions(software.amazon.awscdk.IResolvable jobStateTimeLimitActions) {
            this.jobStateTimeLimitActions = jobStateTimeLimitActions;
            return this;
        }

        /**
         * Sets the value of {@link CfnJobQueueProps#getJobStateTimeLimitActions}
         * @param jobStateTimeLimitActions The set of actions that AWS Batch perform on jobs that remain at the head of the job queue in the specified state longer than specified times.
         *                                 AWS Batch will perform each action after <code>maxTimeSeconds</code> has passed.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder jobStateTimeLimitActions(java.util.List<? extends java.lang.Object> jobStateTimeLimitActions) {
            this.jobStateTimeLimitActions = jobStateTimeLimitActions;
            return this;
        }

        /**
         * Sets the value of {@link CfnJobQueueProps#getSchedulingPolicyArn}
         * @param schedulingPolicyArn The Amazon Resource Name (ARN) of the scheduling policy.
         *                            The format is <code>aws: *Partition* :batch: *Region* : *Account* :scheduling-policy/ *Name*</code> . For example, <code>aws:aws:batch:us-west-2:123456789012:scheduling-policy/MySchedulingPolicy</code> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder schedulingPolicyArn(java.lang.String schedulingPolicyArn) {
            this.schedulingPolicyArn = schedulingPolicyArn;
            return this;
        }

        /**
         * Sets the value of {@link CfnJobQueueProps#getState}
         * @param state The state of the job queue.
         *              If the job queue state is <code>ENABLED</code> , it is able to accept jobs. If the job queue state is <code>DISABLED</code> , new jobs can't be added to the queue, but jobs already in the queue can finish.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder state(java.lang.String state) {
            this.state = state;
            return this;
        }

        /**
         * Sets the value of {@link CfnJobQueueProps#getTags}
         * @param tags The tags that are applied to the job queue.
         *             For more information, see <a href="https://docs.aws.amazon.com/batch/latest/userguide/using-tags.html">Tagging your AWS Batch resources</a> in <em>AWS Batch User Guide</em> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder tags(java.util.Map<java.lang.String, java.lang.String> tags) {
            this.tags = tags;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnJobQueueProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnJobQueueProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnJobQueueProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnJobQueueProps {
        private final java.lang.Object computeEnvironmentOrder;
        private final java.lang.Number priority;
        private final java.lang.String jobQueueName;
        private final java.lang.Object jobStateTimeLimitActions;
        private final java.lang.String schedulingPolicyArn;
        private final java.lang.String state;
        private final java.util.Map<java.lang.String, java.lang.String> tags;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.computeEnvironmentOrder = software.amazon.jsii.Kernel.get(this, "computeEnvironmentOrder", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.priority = software.amazon.jsii.Kernel.get(this, "priority", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            this.jobQueueName = software.amazon.jsii.Kernel.get(this, "jobQueueName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.jobStateTimeLimitActions = software.amazon.jsii.Kernel.get(this, "jobStateTimeLimitActions", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.schedulingPolicyArn = software.amazon.jsii.Kernel.get(this, "schedulingPolicyArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.state = software.amazon.jsii.Kernel.get(this, "state", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.tags = software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.computeEnvironmentOrder = java.util.Objects.requireNonNull(builder.computeEnvironmentOrder, "computeEnvironmentOrder is required");
            this.priority = java.util.Objects.requireNonNull(builder.priority, "priority is required");
            this.jobQueueName = builder.jobQueueName;
            this.jobStateTimeLimitActions = builder.jobStateTimeLimitActions;
            this.schedulingPolicyArn = builder.schedulingPolicyArn;
            this.state = builder.state;
            this.tags = builder.tags;
        }

        @Override
        public final java.lang.Object getComputeEnvironmentOrder() {
            return this.computeEnvironmentOrder;
        }

        @Override
        public final java.lang.Number getPriority() {
            return this.priority;
        }

        @Override
        public final java.lang.String getJobQueueName() {
            return this.jobQueueName;
        }

        @Override
        public final java.lang.Object getJobStateTimeLimitActions() {
            return this.jobStateTimeLimitActions;
        }

        @Override
        public final java.lang.String getSchedulingPolicyArn() {
            return this.schedulingPolicyArn;
        }

        @Override
        public final java.lang.String getState() {
            return this.state;
        }

        @Override
        public final java.util.Map<java.lang.String, java.lang.String> getTags() {
            return this.tags;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("computeEnvironmentOrder", om.valueToTree(this.getComputeEnvironmentOrder()));
            data.set("priority", om.valueToTree(this.getPriority()));
            if (this.getJobQueueName() != null) {
                data.set("jobQueueName", om.valueToTree(this.getJobQueueName()));
            }
            if (this.getJobStateTimeLimitActions() != null) {
                data.set("jobStateTimeLimitActions", om.valueToTree(this.getJobStateTimeLimitActions()));
            }
            if (this.getSchedulingPolicyArn() != null) {
                data.set("schedulingPolicyArn", om.valueToTree(this.getSchedulingPolicyArn()));
            }
            if (this.getState() != null) {
                data.set("state", om.valueToTree(this.getState()));
            }
            if (this.getTags() != null) {
                data.set("tags", om.valueToTree(this.getTags()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_batch.CfnJobQueueProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnJobQueueProps.Jsii$Proxy that = (CfnJobQueueProps.Jsii$Proxy) o;

            if (!computeEnvironmentOrder.equals(that.computeEnvironmentOrder)) return false;
            if (!priority.equals(that.priority)) return false;
            if (this.jobQueueName != null ? !this.jobQueueName.equals(that.jobQueueName) : that.jobQueueName != null) return false;
            if (this.jobStateTimeLimitActions != null ? !this.jobStateTimeLimitActions.equals(that.jobStateTimeLimitActions) : that.jobStateTimeLimitActions != null) return false;
            if (this.schedulingPolicyArn != null ? !this.schedulingPolicyArn.equals(that.schedulingPolicyArn) : that.schedulingPolicyArn != null) return false;
            if (this.state != null ? !this.state.equals(that.state) : that.state != null) return false;
            return this.tags != null ? this.tags.equals(that.tags) : that.tags == null;
        }

        @Override
        public final int hashCode() {
            int result = this.computeEnvironmentOrder.hashCode();
            result = 31 * result + (this.priority.hashCode());
            result = 31 * result + (this.jobQueueName != null ? this.jobQueueName.hashCode() : 0);
            result = 31 * result + (this.jobStateTimeLimitActions != null ? this.jobStateTimeLimitActions.hashCode() : 0);
            result = 31 * result + (this.schedulingPolicyArn != null ? this.schedulingPolicyArn.hashCode() : 0);
            result = 31 * result + (this.state != null ? this.state.hashCode() : 0);
            result = 31 * result + (this.tags != null ? this.tags.hashCode() : 0);
            return result;
        }
    }
}
