package software.amazon.awscdk.services.batch;

/**
 * A Volume that uses an AWS Elastic File System (EFS);
 * <p>
 * this volume can grow and shrink as needed
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.batch.*;
 * import software.amazon.awscdk.services.efs.*;
 * FileSystem fileSystem;
 * EfsVolume efsVolume = EfsVolume.Builder.create()
 *         .containerPath("containerPath")
 *         .fileSystem(fileSystem)
 *         .name("name")
 *         // the properties below are optional
 *         .accessPointId("accessPointId")
 *         .enableTransitEncryption(false)
 *         .readonly(false)
 *         .rootDirectory("rootDirectory")
 *         .transitEncryptionPort(123)
 *         .useJobRole(false)
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.109.0 (build c221850)", date = "2025-03-14T03:24:54.102Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_batch.EfsVolume")
public class EfsVolume extends software.amazon.awscdk.services.batch.EcsVolume {

    protected EfsVolume(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected EfsVolume(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * @param options This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public EfsVolume(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.batch.EfsVolumeOptions options) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(options, "options is required") });
    }

    /**
     * Returns true if x is an EfsVolume, false otherwise.
     * <p>
     * @param x This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull java.lang.Boolean isEfsVolume(final @org.jetbrains.annotations.NotNull java.lang.Object x) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.batch.EfsVolume.class, "isEfsVolume", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class), new Object[] { x });
    }

    /**
     * The EFS File System that supports this volume.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.efs.IFileSystem getFileSystem() {
        return software.amazon.jsii.Kernel.get(this, "fileSystem", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.efs.IFileSystem.class));
    }

    /**
     * The Amazon EFS access point ID to use.
     * <p>
     * If an access point is specified, <code>rootDirectory</code> must either be omitted or set to <code>/</code>
     * which enforces the path set on the EFS access point.
     * If an access point is used, <code>enableTransitEncryption</code> must be <code>true</code>.
     * <p>
     * Default: - no accessPointId
     * <p>
     * @see <a href="https://docs.aws.amazon.com/efs/latest/ug/efs-access-points.html">https://docs.aws.amazon.com/efs/latest/ug/efs-access-points.html</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getAccessPointId() {
        return software.amazon.jsii.Kernel.get(this, "accessPointId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Enables encryption for Amazon EFS data in transit between the Amazon ECS host and the Amazon EFS server.
     * <p>
     * Default: false
     * <p>
     * @see <a href="https://docs.aws.amazon.com/efs/latest/ug/encryption-in-transit.html">https://docs.aws.amazon.com/efs/latest/ug/encryption-in-transit.html</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Boolean getEnableTransitEncryption() {
        return software.amazon.jsii.Kernel.get(this, "enableTransitEncryption", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
    }

    /**
     * The directory within the Amazon EFS file system to mount as the root directory inside the host.
     * <p>
     * If this parameter is omitted, the root of the Amazon EFS volume is used instead.
     * Specifying <code>/</code> has the same effect as omitting this parameter.
     * The maximum length is 4,096 characters.
     * <p>
     * Default: - root of the EFS File System
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getRootDirectory() {
        return software.amazon.jsii.Kernel.get(this, "rootDirectory", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The port to use when sending encrypted data between the Amazon ECS host and the Amazon EFS server.
     * <p>
     * The value must be between 0 and 65,535.
     * <p>
     * Default: - chosen by the EFS Mount Helper
     * <p>
     * @see <a href="https://docs.aws.amazon.com/efs/latest/ug/efs-mount-helper.html">https://docs.aws.amazon.com/efs/latest/ug/efs-mount-helper.html</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Number getTransitEncryptionPort() {
        return software.amazon.jsii.Kernel.get(this, "transitEncryptionPort", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
    }

    /**
     * Whether or not to use the AWS Batch job IAM role defined in a job definition when mounting the Amazon EFS file system.
     * <p>
     * If specified, <code>enableTransitEncryption</code> must be <code>true</code>.
     * <p>
     * Default: false
     * <p>
     * @see <a href="https://docs.aws.amazon.com/batch/latest/userguide/efs-volumes.html#efs-volume-accesspoints">https://docs.aws.amazon.com/batch/latest/userguide/efs-volumes.html#efs-volume-accesspoints</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Boolean getUseJobRole() {
        return software.amazon.jsii.Kernel.get(this, "useJobRole", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.batch.EfsVolume}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.batch.EfsVolume> {
        /**
         * @return a new instance of {@link Builder}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create() {
            return new Builder();
        }

        private final software.amazon.awscdk.services.batch.EfsVolumeOptions.Builder options;

        private Builder() {
            this.options = new software.amazon.awscdk.services.batch.EfsVolumeOptions.Builder();
        }

        /**
         * the path on the container where this volume is mounted.
         * <p>
         * @return {@code this}
         * @param containerPath the path on the container where this volume is mounted. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder containerPath(final java.lang.String containerPath) {
            this.options.containerPath(containerPath);
            return this;
        }

        /**
         * the name of this volume.
         * <p>
         * @return {@code this}
         * @param name the name of this volume. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder name(final java.lang.String name) {
            this.options.name(name);
            return this;
        }

        /**
         * if set, the container will have readonly access to the volume.
         * <p>
         * Default: false
         * <p>
         * @return {@code this}
         * @param readonly if set, the container will have readonly access to the volume. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder readonly(final java.lang.Boolean readonly) {
            this.options.readonly(readonly);
            return this;
        }

        /**
         * The EFS File System that supports this volume.
         * <p>
         * @return {@code this}
         * @param fileSystem The EFS File System that supports this volume. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder fileSystem(final software.amazon.awscdk.services.efs.IFileSystem fileSystem) {
            this.options.fileSystem(fileSystem);
            return this;
        }

        /**
         * The Amazon EFS access point ID to use.
         * <p>
         * If an access point is specified, <code>rootDirectory</code> must either be omitted or set to <code>/</code>
         * which enforces the path set on the EFS access point.
         * If an access point is used, <code>enableTransitEncryption</code> must be <code>true</code>.
         * <p>
         * Default: - no accessPointId
         * <p>
         * @return {@code this}
         * @see <a href="https://docs.aws.amazon.com/efs/latest/ug/efs-access-points.html">https://docs.aws.amazon.com/efs/latest/ug/efs-access-points.html</a>
         * @param accessPointId The Amazon EFS access point ID to use. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder accessPointId(final java.lang.String accessPointId) {
            this.options.accessPointId(accessPointId);
            return this;
        }

        /**
         * Enables encryption for Amazon EFS data in transit between the Amazon ECS host and the Amazon EFS server.
         * <p>
         * Default: false
         * <p>
         * @return {@code this}
         * @see <a href="https://docs.aws.amazon.com/efs/latest/ug/encryption-in-transit.html">https://docs.aws.amazon.com/efs/latest/ug/encryption-in-transit.html</a>
         * @param enableTransitEncryption Enables encryption for Amazon EFS data in transit between the Amazon ECS host and the Amazon EFS server. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder enableTransitEncryption(final java.lang.Boolean enableTransitEncryption) {
            this.options.enableTransitEncryption(enableTransitEncryption);
            return this;
        }

        /**
         * The directory within the Amazon EFS file system to mount as the root directory inside the host.
         * <p>
         * If this parameter is omitted, the root of the Amazon EFS volume is used instead.
         * Specifying <code>/</code> has the same effect as omitting this parameter.
         * The maximum length is 4,096 characters.
         * <p>
         * Default: - root of the EFS File System
         * <p>
         * @return {@code this}
         * @param rootDirectory The directory within the Amazon EFS file system to mount as the root directory inside the host. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder rootDirectory(final java.lang.String rootDirectory) {
            this.options.rootDirectory(rootDirectory);
            return this;
        }

        /**
         * The port to use when sending encrypted data between the Amazon ECS host and the Amazon EFS server.
         * <p>
         * The value must be between 0 and 65,535.
         * <p>
         * Default: - chosen by the EFS Mount Helper
         * <p>
         * @return {@code this}
         * @see <a href="https://docs.aws.amazon.com/efs/latest/ug/efs-mount-helper.html">https://docs.aws.amazon.com/efs/latest/ug/efs-mount-helper.html</a>
         * @param transitEncryptionPort The port to use when sending encrypted data between the Amazon ECS host and the Amazon EFS server. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder transitEncryptionPort(final java.lang.Number transitEncryptionPort) {
            this.options.transitEncryptionPort(transitEncryptionPort);
            return this;
        }

        /**
         * Whether or not to use the AWS Batch job IAM role defined in a job definition when mounting the Amazon EFS file system.
         * <p>
         * If specified, <code>enableTransitEncryption</code> must be <code>true</code>.
         * <p>
         * Default: false
         * <p>
         * @return {@code this}
         * @see <a href="https://docs.aws.amazon.com/batch/latest/userguide/efs-volumes.html#efs-volume-accesspoints">https://docs.aws.amazon.com/batch/latest/userguide/efs-volumes.html#efs-volume-accesspoints</a>
         * @param useJobRole Whether or not to use the AWS Batch job IAM role defined in a job definition when mounting the Amazon EFS file system. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder useJobRole(final java.lang.Boolean useJobRole) {
            this.options.useJobRole(useJobRole);
            return this;
        }

        /**
         * @return a newly built instance of {@link software.amazon.awscdk.services.batch.EfsVolume}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.batch.EfsVolume build() {
            return new software.amazon.awscdk.services.batch.EfsVolume(
                this.options.build()
            );
        }
    }
}
