package software.amazon.awscdk.services.bedrock;

/**
 * Properties for defining a <code>CfnDataAutomationProject</code>.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.bedrock.*;
 * CfnDataAutomationProjectProps cfnDataAutomationProjectProps = CfnDataAutomationProjectProps.builder()
 *         .projectName("projectName")
 *         // the properties below are optional
 *         .customOutputConfiguration(CustomOutputConfigurationProperty.builder()
 *                 .blueprints(List.of(BlueprintItemProperty.builder()
 *                         .blueprintArn("blueprintArn")
 *                         // the properties below are optional
 *                         .blueprintStage("blueprintStage")
 *                         .blueprintVersion("blueprintVersion")
 *                         .build()))
 *                 .build())
 *         .kmsEncryptionContext(Map.of(
 *                 "kmsEncryptionContextKey", "kmsEncryptionContext"))
 *         .kmsKeyId("kmsKeyId")
 *         .overrideConfiguration(OverrideConfigurationProperty.builder()
 *                 .document(DocumentOverrideConfigurationProperty.builder()
 *                         .splitter(SplitterConfigurationProperty.builder()
 *                                 .state("state")
 *                                 .build())
 *                         .build())
 *                 .build())
 *         .projectDescription("projectDescription")
 *         .standardOutputConfiguration(StandardOutputConfigurationProperty.builder()
 *                 .audio(AudioStandardOutputConfigurationProperty.builder()
 *                         .extraction(AudioStandardExtractionProperty.builder()
 *                                 .category(AudioExtractionCategoryProperty.builder()
 *                                         .state("state")
 *                                         // the properties below are optional
 *                                         .types(List.of("types"))
 *                                         .build())
 *                                 .build())
 *                         .generativeField(AudioStandardGenerativeFieldProperty.builder()
 *                                 .state("state")
 *                                 // the properties below are optional
 *                                 .types(List.of("types"))
 *                                 .build())
 *                         .build())
 *                 .document(DocumentStandardOutputConfigurationProperty.builder()
 *                         .extraction(DocumentStandardExtractionProperty.builder()
 *                                 .boundingBox(DocumentBoundingBoxProperty.builder()
 *                                         .state("state")
 *                                         .build())
 *                                 .granularity(DocumentExtractionGranularityProperty.builder()
 *                                         .types(List.of("types"))
 *                                         .build())
 *                                 .build())
 *                         .generativeField(DocumentStandardGenerativeFieldProperty.builder()
 *                                 .state("state")
 *                                 .build())
 *                         .outputFormat(DocumentOutputFormatProperty.builder()
 *                                 .additionalFileFormat(DocumentOutputAdditionalFileFormatProperty.builder()
 *                                         .state("state")
 *                                         .build())
 *                                 .textFormat(DocumentOutputTextFormatProperty.builder()
 *                                         .types(List.of("types"))
 *                                         .build())
 *                                 .build())
 *                         .build())
 *                 .image(ImageStandardOutputConfigurationProperty.builder()
 *                         .extraction(ImageStandardExtractionProperty.builder()
 *                                 .boundingBox(ImageBoundingBoxProperty.builder()
 *                                         .state("state")
 *                                         .build())
 *                                 .category(ImageExtractionCategoryProperty.builder()
 *                                         .state("state")
 *                                         // the properties below are optional
 *                                         .types(List.of("types"))
 *                                         .build())
 *                                 .build())
 *                         .generativeField(ImageStandardGenerativeFieldProperty.builder()
 *                                 .state("state")
 *                                 // the properties below are optional
 *                                 .types(List.of("types"))
 *                                 .build())
 *                         .build())
 *                 .video(VideoStandardOutputConfigurationProperty.builder()
 *                         .extraction(VideoStandardExtractionProperty.builder()
 *                                 .boundingBox(VideoBoundingBoxProperty.builder()
 *                                         .state("state")
 *                                         .build())
 *                                 .category(VideoExtractionCategoryProperty.builder()
 *                                         .state("state")
 *                                         // the properties below are optional
 *                                         .types(List.of("types"))
 *                                         .build())
 *                                 .build())
 *                         .generativeField(VideoStandardGenerativeFieldProperty.builder()
 *                                 .state("state")
 *                                 // the properties below are optional
 *                                 .types(List.of("types"))
 *                                 .build())
 *                         .build())
 *                 .build())
 *         .tags(List.of(CfnTag.builder()
 *                 .key("key")
 *                 .value("value")
 *                 .build()))
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-bedrock-dataautomationproject.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-bedrock-dataautomationproject.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.109.0 (build c221850)", date = "2025-03-14T03:24:54.237Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_bedrock.CfnDataAutomationProjectProps")
@software.amazon.jsii.Jsii.Proxy(CfnDataAutomationProjectProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnDataAutomationProjectProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * Name of the DataAutomationProject.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-bedrock-dataautomationproject.html#cfn-bedrock-dataautomationproject-projectname">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-bedrock-dataautomationproject.html#cfn-bedrock-dataautomationproject-projectname</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getProjectName();

    /**
     * Custom output configuration.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-bedrock-dataautomationproject.html#cfn-bedrock-dataautomationproject-customoutputconfiguration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-bedrock-dataautomationproject.html#cfn-bedrock-dataautomationproject-customoutputconfiguration</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getCustomOutputConfiguration() {
        return null;
    }

    /**
     * KMS encryption context.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-bedrock-dataautomationproject.html#cfn-bedrock-dataautomationproject-kmsencryptioncontext">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-bedrock-dataautomationproject.html#cfn-bedrock-dataautomationproject-kmsencryptioncontext</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getKmsEncryptionContext() {
        return null;
    }

    /**
     * KMS key identifier.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-bedrock-dataautomationproject.html#cfn-bedrock-dataautomationproject-kmskeyid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-bedrock-dataautomationproject.html#cfn-bedrock-dataautomationproject-kmskeyid</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getKmsKeyId() {
        return null;
    }

    /**
     * Override configuration.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-bedrock-dataautomationproject.html#cfn-bedrock-dataautomationproject-overrideconfiguration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-bedrock-dataautomationproject.html#cfn-bedrock-dataautomationproject-overrideconfiguration</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getOverrideConfiguration() {
        return null;
    }

    /**
     * Description of the DataAutomationProject.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-bedrock-dataautomationproject.html#cfn-bedrock-dataautomationproject-projectdescription">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-bedrock-dataautomationproject.html#cfn-bedrock-dataautomationproject-projectdescription</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getProjectDescription() {
        return null;
    }

    /**
     * Standard output configuration.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-bedrock-dataautomationproject.html#cfn-bedrock-dataautomationproject-standardoutputconfiguration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-bedrock-dataautomationproject.html#cfn-bedrock-dataautomationproject-standardoutputconfiguration</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getStandardOutputConfiguration() {
        return null;
    }

    /**
     * List of Tags.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-bedrock-dataautomationproject.html#cfn-bedrock-dataautomationproject-tags">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-bedrock-dataautomationproject.html#cfn-bedrock-dataautomationproject-tags</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.CfnTag> getTags() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CfnDataAutomationProjectProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnDataAutomationProjectProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnDataAutomationProjectProps> {
        java.lang.String projectName;
        java.lang.Object customOutputConfiguration;
        java.lang.Object kmsEncryptionContext;
        java.lang.String kmsKeyId;
        java.lang.Object overrideConfiguration;
        java.lang.String projectDescription;
        java.lang.Object standardOutputConfiguration;
        java.util.List<software.amazon.awscdk.CfnTag> tags;

        /**
         * Sets the value of {@link CfnDataAutomationProjectProps#getProjectName}
         * @param projectName Name of the DataAutomationProject. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder projectName(java.lang.String projectName) {
            this.projectName = projectName;
            return this;
        }

        /**
         * Sets the value of {@link CfnDataAutomationProjectProps#getCustomOutputConfiguration}
         * @param customOutputConfiguration Custom output configuration.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder customOutputConfiguration(software.amazon.awscdk.IResolvable customOutputConfiguration) {
            this.customOutputConfiguration = customOutputConfiguration;
            return this;
        }

        /**
         * Sets the value of {@link CfnDataAutomationProjectProps#getCustomOutputConfiguration}
         * @param customOutputConfiguration Custom output configuration.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder customOutputConfiguration(software.amazon.awscdk.services.bedrock.CfnDataAutomationProject.CustomOutputConfigurationProperty customOutputConfiguration) {
            this.customOutputConfiguration = customOutputConfiguration;
            return this;
        }

        /**
         * Sets the value of {@link CfnDataAutomationProjectProps#getKmsEncryptionContext}
         * @param kmsEncryptionContext KMS encryption context.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder kmsEncryptionContext(java.util.Map<java.lang.String, java.lang.String> kmsEncryptionContext) {
            this.kmsEncryptionContext = kmsEncryptionContext;
            return this;
        }

        /**
         * Sets the value of {@link CfnDataAutomationProjectProps#getKmsEncryptionContext}
         * @param kmsEncryptionContext KMS encryption context.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder kmsEncryptionContext(software.amazon.awscdk.IResolvable kmsEncryptionContext) {
            this.kmsEncryptionContext = kmsEncryptionContext;
            return this;
        }

        /**
         * Sets the value of {@link CfnDataAutomationProjectProps#getKmsKeyId}
         * @param kmsKeyId KMS key identifier.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder kmsKeyId(java.lang.String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
            return this;
        }

        /**
         * Sets the value of {@link CfnDataAutomationProjectProps#getOverrideConfiguration}
         * @param overrideConfiguration Override configuration.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder overrideConfiguration(software.amazon.awscdk.IResolvable overrideConfiguration) {
            this.overrideConfiguration = overrideConfiguration;
            return this;
        }

        /**
         * Sets the value of {@link CfnDataAutomationProjectProps#getOverrideConfiguration}
         * @param overrideConfiguration Override configuration.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder overrideConfiguration(software.amazon.awscdk.services.bedrock.CfnDataAutomationProject.OverrideConfigurationProperty overrideConfiguration) {
            this.overrideConfiguration = overrideConfiguration;
            return this;
        }

        /**
         * Sets the value of {@link CfnDataAutomationProjectProps#getProjectDescription}
         * @param projectDescription Description of the DataAutomationProject.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder projectDescription(java.lang.String projectDescription) {
            this.projectDescription = projectDescription;
            return this;
        }

        /**
         * Sets the value of {@link CfnDataAutomationProjectProps#getStandardOutputConfiguration}
         * @param standardOutputConfiguration Standard output configuration.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder standardOutputConfiguration(software.amazon.awscdk.IResolvable standardOutputConfiguration) {
            this.standardOutputConfiguration = standardOutputConfiguration;
            return this;
        }

        /**
         * Sets the value of {@link CfnDataAutomationProjectProps#getStandardOutputConfiguration}
         * @param standardOutputConfiguration Standard output configuration.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder standardOutputConfiguration(software.amazon.awscdk.services.bedrock.CfnDataAutomationProject.StandardOutputConfigurationProperty standardOutputConfiguration) {
            this.standardOutputConfiguration = standardOutputConfiguration;
            return this;
        }

        /**
         * Sets the value of {@link CfnDataAutomationProjectProps#getTags}
         * @param tags List of Tags.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder tags(java.util.List<? extends software.amazon.awscdk.CfnTag> tags) {
            this.tags = (java.util.List<software.amazon.awscdk.CfnTag>)tags;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnDataAutomationProjectProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnDataAutomationProjectProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnDataAutomationProjectProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnDataAutomationProjectProps {
        private final java.lang.String projectName;
        private final java.lang.Object customOutputConfiguration;
        private final java.lang.Object kmsEncryptionContext;
        private final java.lang.String kmsKeyId;
        private final java.lang.Object overrideConfiguration;
        private final java.lang.String projectDescription;
        private final java.lang.Object standardOutputConfiguration;
        private final java.util.List<software.amazon.awscdk.CfnTag> tags;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.projectName = software.amazon.jsii.Kernel.get(this, "projectName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.customOutputConfiguration = software.amazon.jsii.Kernel.get(this, "customOutputConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.kmsEncryptionContext = software.amazon.jsii.Kernel.get(this, "kmsEncryptionContext", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.kmsKeyId = software.amazon.jsii.Kernel.get(this, "kmsKeyId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.overrideConfiguration = software.amazon.jsii.Kernel.get(this, "overrideConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.projectDescription = software.amazon.jsii.Kernel.get(this, "projectDescription", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.standardOutputConfiguration = software.amazon.jsii.Kernel.get(this, "standardOutputConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.tags = software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.CfnTag.class)));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.projectName = java.util.Objects.requireNonNull(builder.projectName, "projectName is required");
            this.customOutputConfiguration = builder.customOutputConfiguration;
            this.kmsEncryptionContext = builder.kmsEncryptionContext;
            this.kmsKeyId = builder.kmsKeyId;
            this.overrideConfiguration = builder.overrideConfiguration;
            this.projectDescription = builder.projectDescription;
            this.standardOutputConfiguration = builder.standardOutputConfiguration;
            this.tags = (java.util.List<software.amazon.awscdk.CfnTag>)builder.tags;
        }

        @Override
        public final java.lang.String getProjectName() {
            return this.projectName;
        }

        @Override
        public final java.lang.Object getCustomOutputConfiguration() {
            return this.customOutputConfiguration;
        }

        @Override
        public final java.lang.Object getKmsEncryptionContext() {
            return this.kmsEncryptionContext;
        }

        @Override
        public final java.lang.String getKmsKeyId() {
            return this.kmsKeyId;
        }

        @Override
        public final java.lang.Object getOverrideConfiguration() {
            return this.overrideConfiguration;
        }

        @Override
        public final java.lang.String getProjectDescription() {
            return this.projectDescription;
        }

        @Override
        public final java.lang.Object getStandardOutputConfiguration() {
            return this.standardOutputConfiguration;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.CfnTag> getTags() {
            return this.tags;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("projectName", om.valueToTree(this.getProjectName()));
            if (this.getCustomOutputConfiguration() != null) {
                data.set("customOutputConfiguration", om.valueToTree(this.getCustomOutputConfiguration()));
            }
            if (this.getKmsEncryptionContext() != null) {
                data.set("kmsEncryptionContext", om.valueToTree(this.getKmsEncryptionContext()));
            }
            if (this.getKmsKeyId() != null) {
                data.set("kmsKeyId", om.valueToTree(this.getKmsKeyId()));
            }
            if (this.getOverrideConfiguration() != null) {
                data.set("overrideConfiguration", om.valueToTree(this.getOverrideConfiguration()));
            }
            if (this.getProjectDescription() != null) {
                data.set("projectDescription", om.valueToTree(this.getProjectDescription()));
            }
            if (this.getStandardOutputConfiguration() != null) {
                data.set("standardOutputConfiguration", om.valueToTree(this.getStandardOutputConfiguration()));
            }
            if (this.getTags() != null) {
                data.set("tags", om.valueToTree(this.getTags()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_bedrock.CfnDataAutomationProjectProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnDataAutomationProjectProps.Jsii$Proxy that = (CfnDataAutomationProjectProps.Jsii$Proxy) o;

            if (!projectName.equals(that.projectName)) return false;
            if (this.customOutputConfiguration != null ? !this.customOutputConfiguration.equals(that.customOutputConfiguration) : that.customOutputConfiguration != null) return false;
            if (this.kmsEncryptionContext != null ? !this.kmsEncryptionContext.equals(that.kmsEncryptionContext) : that.kmsEncryptionContext != null) return false;
            if (this.kmsKeyId != null ? !this.kmsKeyId.equals(that.kmsKeyId) : that.kmsKeyId != null) return false;
            if (this.overrideConfiguration != null ? !this.overrideConfiguration.equals(that.overrideConfiguration) : that.overrideConfiguration != null) return false;
            if (this.projectDescription != null ? !this.projectDescription.equals(that.projectDescription) : that.projectDescription != null) return false;
            if (this.standardOutputConfiguration != null ? !this.standardOutputConfiguration.equals(that.standardOutputConfiguration) : that.standardOutputConfiguration != null) return false;
            return this.tags != null ? this.tags.equals(that.tags) : that.tags == null;
        }

        @Override
        public final int hashCode() {
            int result = this.projectName.hashCode();
            result = 31 * result + (this.customOutputConfiguration != null ? this.customOutputConfiguration.hashCode() : 0);
            result = 31 * result + (this.kmsEncryptionContext != null ? this.kmsEncryptionContext.hashCode() : 0);
            result = 31 * result + (this.kmsKeyId != null ? this.kmsKeyId.hashCode() : 0);
            result = 31 * result + (this.overrideConfiguration != null ? this.overrideConfiguration.hashCode() : 0);
            result = 31 * result + (this.projectDescription != null ? this.projectDescription.hashCode() : 0);
            result = 31 * result + (this.standardOutputConfiguration != null ? this.standardOutputConfiguration.hashCode() : 0);
            result = 31 * result + (this.tags != null ? this.tags.hashCode() : 0);
            return result;
        }
    }
}
