package software.amazon.awscdk.services.cleanrooms;

/**
 * Properties for defining a <code>CfnMembership</code>.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.cleanrooms.*;
 * CfnMembershipProps cfnMembershipProps = CfnMembershipProps.builder()
 *         .collaborationIdentifier("collaborationIdentifier")
 *         .queryLogStatus("queryLogStatus")
 *         // the properties below are optional
 *         .defaultResultConfiguration(MembershipProtectedQueryResultConfigurationProperty.builder()
 *                 .outputConfiguration(MembershipProtectedQueryOutputConfigurationProperty.builder()
 *                         .s3(ProtectedQueryS3OutputConfigurationProperty.builder()
 *                                 .bucket("bucket")
 *                                 .resultFormat("resultFormat")
 *                                 // the properties below are optional
 *                                 .keyPrefix("keyPrefix")
 *                                 .singleFileOutput(false)
 *                                 .build())
 *                         .build())
 *                 // the properties below are optional
 *                 .roleArn("roleArn")
 *                 .build())
 *         .paymentConfiguration(MembershipPaymentConfigurationProperty.builder()
 *                 .queryCompute(MembershipQueryComputePaymentConfigProperty.builder()
 *                         .isResponsible(false)
 *                         .build())
 *                 // the properties below are optional
 *                 .machineLearning(MembershipMLPaymentConfigProperty.builder()
 *                         .modelInference(MembershipModelInferencePaymentConfigProperty.builder()
 *                                 .isResponsible(false)
 *                                 .build())
 *                         .modelTraining(MembershipModelTrainingPaymentConfigProperty.builder()
 *                                 .isResponsible(false)
 *                                 .build())
 *                         .build())
 *                 .build())
 *         .tags(List.of(CfnTag.builder()
 *                 .key("key")
 *                 .value("value")
 *                 .build()))
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cleanrooms-membership.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cleanrooms-membership.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.109.0 (build c221850)", date = "2025-03-14T03:24:54.557Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_cleanrooms.CfnMembershipProps")
@software.amazon.jsii.Jsii.Proxy(CfnMembershipProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnMembershipProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * The unique ID for the associated collaboration.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cleanrooms-membership.html#cfn-cleanrooms-membership-collaborationidentifier">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cleanrooms-membership.html#cfn-cleanrooms-membership-collaborationidentifier</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getCollaborationIdentifier();

    /**
     * An indicator as to whether query logging has been enabled or disabled for the membership.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cleanrooms-membership.html#cfn-cleanrooms-membership-querylogstatus">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cleanrooms-membership.html#cfn-cleanrooms-membership-querylogstatus</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getQueryLogStatus();

    /**
     * The default protected query result configuration as specified by the member who can receive results.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cleanrooms-membership.html#cfn-cleanrooms-membership-defaultresultconfiguration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cleanrooms-membership.html#cfn-cleanrooms-membership-defaultresultconfiguration</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getDefaultResultConfiguration() {
        return null;
    }

    /**
     * The payment responsibilities accepted by the collaboration member.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cleanrooms-membership.html#cfn-cleanrooms-membership-paymentconfiguration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cleanrooms-membership.html#cfn-cleanrooms-membership-paymentconfiguration</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getPaymentConfiguration() {
        return null;
    }

    /**
     * An optional label that you can assign to a resource when you create it.
     * <p>
     * Each tag consists of a key and an optional value, both of which you define. When you use tagging, you can also use tag-based access control in IAM policies to control access to this resource.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cleanrooms-membership.html#cfn-cleanrooms-membership-tags">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cleanrooms-membership.html#cfn-cleanrooms-membership-tags</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.CfnTag> getTags() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CfnMembershipProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnMembershipProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnMembershipProps> {
        java.lang.String collaborationIdentifier;
        java.lang.String queryLogStatus;
        java.lang.Object defaultResultConfiguration;
        java.lang.Object paymentConfiguration;
        java.util.List<software.amazon.awscdk.CfnTag> tags;

        /**
         * Sets the value of {@link CfnMembershipProps#getCollaborationIdentifier}
         * @param collaborationIdentifier The unique ID for the associated collaboration. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder collaborationIdentifier(java.lang.String collaborationIdentifier) {
            this.collaborationIdentifier = collaborationIdentifier;
            return this;
        }

        /**
         * Sets the value of {@link CfnMembershipProps#getQueryLogStatus}
         * @param queryLogStatus An indicator as to whether query logging has been enabled or disabled for the membership. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder queryLogStatus(java.lang.String queryLogStatus) {
            this.queryLogStatus = queryLogStatus;
            return this;
        }

        /**
         * Sets the value of {@link CfnMembershipProps#getDefaultResultConfiguration}
         * @param defaultResultConfiguration The default protected query result configuration as specified by the member who can receive results.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder defaultResultConfiguration(software.amazon.awscdk.IResolvable defaultResultConfiguration) {
            this.defaultResultConfiguration = defaultResultConfiguration;
            return this;
        }

        /**
         * Sets the value of {@link CfnMembershipProps#getDefaultResultConfiguration}
         * @param defaultResultConfiguration The default protected query result configuration as specified by the member who can receive results.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder defaultResultConfiguration(software.amazon.awscdk.services.cleanrooms.CfnMembership.MembershipProtectedQueryResultConfigurationProperty defaultResultConfiguration) {
            this.defaultResultConfiguration = defaultResultConfiguration;
            return this;
        }

        /**
         * Sets the value of {@link CfnMembershipProps#getPaymentConfiguration}
         * @param paymentConfiguration The payment responsibilities accepted by the collaboration member.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder paymentConfiguration(software.amazon.awscdk.IResolvable paymentConfiguration) {
            this.paymentConfiguration = paymentConfiguration;
            return this;
        }

        /**
         * Sets the value of {@link CfnMembershipProps#getPaymentConfiguration}
         * @param paymentConfiguration The payment responsibilities accepted by the collaboration member.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder paymentConfiguration(software.amazon.awscdk.services.cleanrooms.CfnMembership.MembershipPaymentConfigurationProperty paymentConfiguration) {
            this.paymentConfiguration = paymentConfiguration;
            return this;
        }

        /**
         * Sets the value of {@link CfnMembershipProps#getTags}
         * @param tags An optional label that you can assign to a resource when you create it.
         *             Each tag consists of a key and an optional value, both of which you define. When you use tagging, you can also use tag-based access control in IAM policies to control access to this resource.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder tags(java.util.List<? extends software.amazon.awscdk.CfnTag> tags) {
            this.tags = (java.util.List<software.amazon.awscdk.CfnTag>)tags;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnMembershipProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnMembershipProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnMembershipProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnMembershipProps {
        private final java.lang.String collaborationIdentifier;
        private final java.lang.String queryLogStatus;
        private final java.lang.Object defaultResultConfiguration;
        private final java.lang.Object paymentConfiguration;
        private final java.util.List<software.amazon.awscdk.CfnTag> tags;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.collaborationIdentifier = software.amazon.jsii.Kernel.get(this, "collaborationIdentifier", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.queryLogStatus = software.amazon.jsii.Kernel.get(this, "queryLogStatus", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.defaultResultConfiguration = software.amazon.jsii.Kernel.get(this, "defaultResultConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.paymentConfiguration = software.amazon.jsii.Kernel.get(this, "paymentConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.tags = software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.CfnTag.class)));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.collaborationIdentifier = java.util.Objects.requireNonNull(builder.collaborationIdentifier, "collaborationIdentifier is required");
            this.queryLogStatus = java.util.Objects.requireNonNull(builder.queryLogStatus, "queryLogStatus is required");
            this.defaultResultConfiguration = builder.defaultResultConfiguration;
            this.paymentConfiguration = builder.paymentConfiguration;
            this.tags = (java.util.List<software.amazon.awscdk.CfnTag>)builder.tags;
        }

        @Override
        public final java.lang.String getCollaborationIdentifier() {
            return this.collaborationIdentifier;
        }

        @Override
        public final java.lang.String getQueryLogStatus() {
            return this.queryLogStatus;
        }

        @Override
        public final java.lang.Object getDefaultResultConfiguration() {
            return this.defaultResultConfiguration;
        }

        @Override
        public final java.lang.Object getPaymentConfiguration() {
            return this.paymentConfiguration;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.CfnTag> getTags() {
            return this.tags;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("collaborationIdentifier", om.valueToTree(this.getCollaborationIdentifier()));
            data.set("queryLogStatus", om.valueToTree(this.getQueryLogStatus()));
            if (this.getDefaultResultConfiguration() != null) {
                data.set("defaultResultConfiguration", om.valueToTree(this.getDefaultResultConfiguration()));
            }
            if (this.getPaymentConfiguration() != null) {
                data.set("paymentConfiguration", om.valueToTree(this.getPaymentConfiguration()));
            }
            if (this.getTags() != null) {
                data.set("tags", om.valueToTree(this.getTags()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_cleanrooms.CfnMembershipProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnMembershipProps.Jsii$Proxy that = (CfnMembershipProps.Jsii$Proxy) o;

            if (!collaborationIdentifier.equals(that.collaborationIdentifier)) return false;
            if (!queryLogStatus.equals(that.queryLogStatus)) return false;
            if (this.defaultResultConfiguration != null ? !this.defaultResultConfiguration.equals(that.defaultResultConfiguration) : that.defaultResultConfiguration != null) return false;
            if (this.paymentConfiguration != null ? !this.paymentConfiguration.equals(that.paymentConfiguration) : that.paymentConfiguration != null) return false;
            return this.tags != null ? this.tags.equals(that.tags) : that.tags == null;
        }

        @Override
        public final int hashCode() {
            int result = this.collaborationIdentifier.hashCode();
            result = 31 * result + (this.queryLogStatus.hashCode());
            result = 31 * result + (this.defaultResultConfiguration != null ? this.defaultResultConfiguration.hashCode() : 0);
            result = 31 * result + (this.paymentConfiguration != null ? this.paymentConfiguration.hashCode() : 0);
            result = 31 * result + (this.tags != null ? this.tags.hashCode() : 0);
            return result;
        }
    }
}
