package software.amazon.awscdk.services.cloudfront;

/**
 * Creates a continuous deployment policy that routes a subset of production traffic from a primary distribution to a staging distribution.
 * <p>
 * After you create and update a staging distribution, you can use a continuous deployment policy to incrementally move traffic to the staging distribution. This enables you to test changes to a distribution's configuration before moving all of your production traffic to the new configuration.
 * <p>
 * For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/continuous-deployment.html">Using CloudFront continuous deployment to safely test CDN configuration changes</a> in the <em>Amazon CloudFront Developer Guide</em> .
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.cloudfront.*;
 * CfnContinuousDeploymentPolicy cfnContinuousDeploymentPolicy = CfnContinuousDeploymentPolicy.Builder.create(this, "MyCfnContinuousDeploymentPolicy")
 *         .continuousDeploymentPolicyConfig(ContinuousDeploymentPolicyConfigProperty.builder()
 *                 .enabled(false)
 *                 .stagingDistributionDnsNames(List.of("stagingDistributionDnsNames"))
 *                 // the properties below are optional
 *                 .singleHeaderPolicyConfig(SingleHeaderPolicyConfigProperty.builder()
 *                         .header("header")
 *                         .value("value")
 *                         .build())
 *                 .singleWeightPolicyConfig(SingleWeightPolicyConfigProperty.builder()
 *                         .weight(123)
 *                         // the properties below are optional
 *                         .sessionStickinessConfig(SessionStickinessConfigProperty.builder()
 *                                 .idleTtl(123)
 *                                 .maximumTtl(123)
 *                                 .build())
 *                         .build())
 *                 .trafficConfig(TrafficConfigProperty.builder()
 *                         .type("type")
 *                         // the properties below are optional
 *                         .singleHeaderConfig(SingleHeaderConfigProperty.builder()
 *                                 .header("header")
 *                                 .value("value")
 *                                 .build())
 *                         .singleWeightConfig(SingleWeightConfigProperty.builder()
 *                                 .weight(123)
 *                                 // the properties below are optional
 *                                 .sessionStickinessConfig(SessionStickinessConfigProperty.builder()
 *                                         .idleTtl(123)
 *                                         .maximumTtl(123)
 *                                         .build())
 *                                 .build())
 *                         .build())
 *                 .type("type")
 *                 .build())
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudfront-continuousdeploymentpolicy.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudfront-continuousdeploymentpolicy.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.109.0 (build c221850)", date = "2025-03-14T03:24:54.679Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_cloudfront.CfnContinuousDeploymentPolicy")
public class CfnContinuousDeploymentPolicy extends software.amazon.awscdk.CfnResource implements software.amazon.awscdk.IInspectable {

    protected CfnContinuousDeploymentPolicy(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnContinuousDeploymentPolicy(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        CFN_RESOURCE_TYPE_NAME = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.cloudfront.CfnContinuousDeploymentPolicy.class, "CFN_RESOURCE_TYPE_NAME", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * @param scope Scope in which this resource is defined. This parameter is required.
     * @param id Construct identifier for this resource (unique in its scope). This parameter is required.
     * @param props Resource properties. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public CfnContinuousDeploymentPolicy(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudfront.CfnContinuousDeploymentPolicyProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Examines the CloudFormation resource and discloses attributes.
     * <p>
     * @param inspector tree inspector to collect and process attributes. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public void inspect(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.TreeInspector inspector) {
        software.amazon.jsii.Kernel.call(this, "inspect", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(inspector, "inspector is required") });
    }

    /**
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> renderProperties(final @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> props) {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.call(this, "renderProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class)), new Object[] { java.util.Objects.requireNonNull(props, "props is required") }));
    }

    /**
     * The CloudFormation resource type name for this resource class.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String CFN_RESOURCE_TYPE_NAME;

    /**
     * The identifier of the cotinuous deployment policy.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrId() {
        return software.amazon.jsii.Kernel.get(this, "attrId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The date and time when the continuous deployment policy was last modified.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrLastModifiedTime() {
        return software.amazon.jsii.Kernel.get(this, "attrLastModifiedTime", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> getCfnProperties() {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.get(this, "cfnProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class))));
    }

    /**
     * Contains the configuration for a continuous deployment policy.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.Object getContinuousDeploymentPolicyConfig() {
        return software.amazon.jsii.Kernel.get(this, "continuousDeploymentPolicyConfig", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * Contains the configuration for a continuous deployment policy.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setContinuousDeploymentPolicyConfig(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "continuousDeploymentPolicyConfig", java.util.Objects.requireNonNull(value, "continuousDeploymentPolicyConfig is required"));
    }

    /**
     * Contains the configuration for a continuous deployment policy.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setContinuousDeploymentPolicyConfig(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudfront.CfnContinuousDeploymentPolicy.ContinuousDeploymentPolicyConfigProperty value) {
        software.amazon.jsii.Kernel.set(this, "continuousDeploymentPolicyConfig", java.util.Objects.requireNonNull(value, "continuousDeploymentPolicyConfig is required"));
    }
    /**
     * Contains the configuration for a continuous deployment policy.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.cloudfront.*;
     * ContinuousDeploymentPolicyConfigProperty continuousDeploymentPolicyConfigProperty = ContinuousDeploymentPolicyConfigProperty.builder()
     *         .enabled(false)
     *         .stagingDistributionDnsNames(List.of("stagingDistributionDnsNames"))
     *         // the properties below are optional
     *         .singleHeaderPolicyConfig(SingleHeaderPolicyConfigProperty.builder()
     *                 .header("header")
     *                 .value("value")
     *                 .build())
     *         .singleWeightPolicyConfig(SingleWeightPolicyConfigProperty.builder()
     *                 .weight(123)
     *                 // the properties below are optional
     *                 .sessionStickinessConfig(SessionStickinessConfigProperty.builder()
     *                         .idleTtl(123)
     *                         .maximumTtl(123)
     *                         .build())
     *                 .build())
     *         .trafficConfig(TrafficConfigProperty.builder()
     *                 .type("type")
     *                 // the properties below are optional
     *                 .singleHeaderConfig(SingleHeaderConfigProperty.builder()
     *                         .header("header")
     *                         .value("value")
     *                         .build())
     *                 .singleWeightConfig(SingleWeightConfigProperty.builder()
     *                         .weight(123)
     *                         // the properties below are optional
     *                         .sessionStickinessConfig(SessionStickinessConfigProperty.builder()
     *                                 .idleTtl(123)
     *                                 .maximumTtl(123)
     *                                 .build())
     *                         .build())
     *                 .build())
     *         .type("type")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-continuousdeploymentpolicy-continuousdeploymentpolicyconfig.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-continuousdeploymentpolicy-continuousdeploymentpolicyconfig.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_cloudfront.CfnContinuousDeploymentPolicy.ContinuousDeploymentPolicyConfigProperty")
    @software.amazon.jsii.Jsii.Proxy(ContinuousDeploymentPolicyConfigProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ContinuousDeploymentPolicyConfigProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * A Boolean that indicates whether this continuous deployment policy is enabled (in effect).
         * <p>
         * When this value is <code>true</code> , this policy is enabled and in effect. When this value is <code>false</code> , this policy is not enabled and has no effect.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-continuousdeploymentpolicy-continuousdeploymentpolicyconfig.html#cfn-cloudfront-continuousdeploymentpolicy-continuousdeploymentpolicyconfig-enabled">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-continuousdeploymentpolicy-continuousdeploymentpolicyconfig.html#cfn-cloudfront-continuousdeploymentpolicy-continuousdeploymentpolicyconfig-enabled</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getEnabled();

        /**
         * The CloudFront domain name of the staging distribution.
         * <p>
         * For example: <code>d111111abcdef8.cloudfront.net</code> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-continuousdeploymentpolicy-continuousdeploymentpolicyconfig.html#cfn-cloudfront-continuousdeploymentpolicy-continuousdeploymentpolicyconfig-stagingdistributiondnsnames">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-continuousdeploymentpolicy-continuousdeploymentpolicyconfig.html#cfn-cloudfront-continuousdeploymentpolicy-continuousdeploymentpolicyconfig-stagingdistributiondnsnames</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.util.List<java.lang.String> getStagingDistributionDnsNames();

        /**
         * This configuration determines which HTTP requests are sent to the staging distribution.
         * <p>
         * If the HTTP request contains a header and value that matches what you specify here, the request is sent to the staging distribution. Otherwise the request is sent to the primary distribution.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-continuousdeploymentpolicy-continuousdeploymentpolicyconfig.html#cfn-cloudfront-continuousdeploymentpolicy-continuousdeploymentpolicyconfig-singleheaderpolicyconfig">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-continuousdeploymentpolicy-continuousdeploymentpolicyconfig.html#cfn-cloudfront-continuousdeploymentpolicy-continuousdeploymentpolicyconfig-singleheaderpolicyconfig</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getSingleHeaderPolicyConfig() {
            return null;
        }

        /**
         * This configuration determines the percentage of HTTP requests that are sent to the staging distribution.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-continuousdeploymentpolicy-continuousdeploymentpolicyconfig.html#cfn-cloudfront-continuousdeploymentpolicy-continuousdeploymentpolicyconfig-singleweightpolicyconfig">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-continuousdeploymentpolicy-continuousdeploymentpolicyconfig.html#cfn-cloudfront-continuousdeploymentpolicy-continuousdeploymentpolicyconfig-singleweightpolicyconfig</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getSingleWeightPolicyConfig() {
            return null;
        }

        /**
         * Contains the parameters for routing production traffic from your primary to staging distributions.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-continuousdeploymentpolicy-continuousdeploymentpolicyconfig.html#cfn-cloudfront-continuousdeploymentpolicy-continuousdeploymentpolicyconfig-trafficconfig">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-continuousdeploymentpolicy-continuousdeploymentpolicyconfig.html#cfn-cloudfront-continuousdeploymentpolicy-continuousdeploymentpolicyconfig-trafficconfig</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getTrafficConfig() {
            return null;
        }

        /**
         * The type of traffic configuration.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-continuousdeploymentpolicy-continuousdeploymentpolicyconfig.html#cfn-cloudfront-continuousdeploymentpolicy-continuousdeploymentpolicyconfig-type">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-continuousdeploymentpolicy-continuousdeploymentpolicyconfig.html#cfn-cloudfront-continuousdeploymentpolicy-continuousdeploymentpolicyconfig-type</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getType() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link ContinuousDeploymentPolicyConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ContinuousDeploymentPolicyConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ContinuousDeploymentPolicyConfigProperty> {
            java.lang.Object enabled;
            java.util.List<java.lang.String> stagingDistributionDnsNames;
            java.lang.Object singleHeaderPolicyConfig;
            java.lang.Object singleWeightPolicyConfig;
            java.lang.Object trafficConfig;
            java.lang.String type;

            /**
             * Sets the value of {@link ContinuousDeploymentPolicyConfigProperty#getEnabled}
             * @param enabled A Boolean that indicates whether this continuous deployment policy is enabled (in effect). This parameter is required.
             *                When this value is <code>true</code> , this policy is enabled and in effect. When this value is <code>false</code> , this policy is not enabled and has no effect.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder enabled(java.lang.Boolean enabled) {
                this.enabled = enabled;
                return this;
            }

            /**
             * Sets the value of {@link ContinuousDeploymentPolicyConfigProperty#getEnabled}
             * @param enabled A Boolean that indicates whether this continuous deployment policy is enabled (in effect). This parameter is required.
             *                When this value is <code>true</code> , this policy is enabled and in effect. When this value is <code>false</code> , this policy is not enabled and has no effect.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder enabled(software.amazon.awscdk.IResolvable enabled) {
                this.enabled = enabled;
                return this;
            }

            /**
             * Sets the value of {@link ContinuousDeploymentPolicyConfigProperty#getStagingDistributionDnsNames}
             * @param stagingDistributionDnsNames The CloudFront domain name of the staging distribution. This parameter is required.
             *                                    For example: <code>d111111abcdef8.cloudfront.net</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder stagingDistributionDnsNames(java.util.List<java.lang.String> stagingDistributionDnsNames) {
                this.stagingDistributionDnsNames = stagingDistributionDnsNames;
                return this;
            }

            /**
             * Sets the value of {@link ContinuousDeploymentPolicyConfigProperty#getSingleHeaderPolicyConfig}
             * @param singleHeaderPolicyConfig This configuration determines which HTTP requests are sent to the staging distribution.
             *                                 If the HTTP request contains a header and value that matches what you specify here, the request is sent to the staging distribution. Otherwise the request is sent to the primary distribution.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder singleHeaderPolicyConfig(software.amazon.awscdk.IResolvable singleHeaderPolicyConfig) {
                this.singleHeaderPolicyConfig = singleHeaderPolicyConfig;
                return this;
            }

            /**
             * Sets the value of {@link ContinuousDeploymentPolicyConfigProperty#getSingleHeaderPolicyConfig}
             * @param singleHeaderPolicyConfig This configuration determines which HTTP requests are sent to the staging distribution.
             *                                 If the HTTP request contains a header and value that matches what you specify here, the request is sent to the staging distribution. Otherwise the request is sent to the primary distribution.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder singleHeaderPolicyConfig(software.amazon.awscdk.services.cloudfront.CfnContinuousDeploymentPolicy.SingleHeaderPolicyConfigProperty singleHeaderPolicyConfig) {
                this.singleHeaderPolicyConfig = singleHeaderPolicyConfig;
                return this;
            }

            /**
             * Sets the value of {@link ContinuousDeploymentPolicyConfigProperty#getSingleWeightPolicyConfig}
             * @param singleWeightPolicyConfig This configuration determines the percentage of HTTP requests that are sent to the staging distribution.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder singleWeightPolicyConfig(software.amazon.awscdk.IResolvable singleWeightPolicyConfig) {
                this.singleWeightPolicyConfig = singleWeightPolicyConfig;
                return this;
            }

            /**
             * Sets the value of {@link ContinuousDeploymentPolicyConfigProperty#getSingleWeightPolicyConfig}
             * @param singleWeightPolicyConfig This configuration determines the percentage of HTTP requests that are sent to the staging distribution.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder singleWeightPolicyConfig(software.amazon.awscdk.services.cloudfront.CfnContinuousDeploymentPolicy.SingleWeightPolicyConfigProperty singleWeightPolicyConfig) {
                this.singleWeightPolicyConfig = singleWeightPolicyConfig;
                return this;
            }

            /**
             * Sets the value of {@link ContinuousDeploymentPolicyConfigProperty#getTrafficConfig}
             * @param trafficConfig Contains the parameters for routing production traffic from your primary to staging distributions.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder trafficConfig(software.amazon.awscdk.IResolvable trafficConfig) {
                this.trafficConfig = trafficConfig;
                return this;
            }

            /**
             * Sets the value of {@link ContinuousDeploymentPolicyConfigProperty#getTrafficConfig}
             * @param trafficConfig Contains the parameters for routing production traffic from your primary to staging distributions.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder trafficConfig(software.amazon.awscdk.services.cloudfront.CfnContinuousDeploymentPolicy.TrafficConfigProperty trafficConfig) {
                this.trafficConfig = trafficConfig;
                return this;
            }

            /**
             * Sets the value of {@link ContinuousDeploymentPolicyConfigProperty#getType}
             * @param type The type of traffic configuration.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder type(java.lang.String type) {
                this.type = type;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ContinuousDeploymentPolicyConfigProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ContinuousDeploymentPolicyConfigProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link ContinuousDeploymentPolicyConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ContinuousDeploymentPolicyConfigProperty {
            private final java.lang.Object enabled;
            private final java.util.List<java.lang.String> stagingDistributionDnsNames;
            private final java.lang.Object singleHeaderPolicyConfig;
            private final java.lang.Object singleWeightPolicyConfig;
            private final java.lang.Object trafficConfig;
            private final java.lang.String type;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.enabled = software.amazon.jsii.Kernel.get(this, "enabled", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.stagingDistributionDnsNames = software.amazon.jsii.Kernel.get(this, "stagingDistributionDnsNames", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
                this.singleHeaderPolicyConfig = software.amazon.jsii.Kernel.get(this, "singleHeaderPolicyConfig", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.singleWeightPolicyConfig = software.amazon.jsii.Kernel.get(this, "singleWeightPolicyConfig", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.trafficConfig = software.amazon.jsii.Kernel.get(this, "trafficConfig", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.type = software.amazon.jsii.Kernel.get(this, "type", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.enabled = java.util.Objects.requireNonNull(builder.enabled, "enabled is required");
                this.stagingDistributionDnsNames = java.util.Objects.requireNonNull(builder.stagingDistributionDnsNames, "stagingDistributionDnsNames is required");
                this.singleHeaderPolicyConfig = builder.singleHeaderPolicyConfig;
                this.singleWeightPolicyConfig = builder.singleWeightPolicyConfig;
                this.trafficConfig = builder.trafficConfig;
                this.type = builder.type;
            }

            @Override
            public final java.lang.Object getEnabled() {
                return this.enabled;
            }

            @Override
            public final java.util.List<java.lang.String> getStagingDistributionDnsNames() {
                return this.stagingDistributionDnsNames;
            }

            @Override
            public final java.lang.Object getSingleHeaderPolicyConfig() {
                return this.singleHeaderPolicyConfig;
            }

            @Override
            public final java.lang.Object getSingleWeightPolicyConfig() {
                return this.singleWeightPolicyConfig;
            }

            @Override
            public final java.lang.Object getTrafficConfig() {
                return this.trafficConfig;
            }

            @Override
            public final java.lang.String getType() {
                return this.type;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("enabled", om.valueToTree(this.getEnabled()));
                data.set("stagingDistributionDnsNames", om.valueToTree(this.getStagingDistributionDnsNames()));
                if (this.getSingleHeaderPolicyConfig() != null) {
                    data.set("singleHeaderPolicyConfig", om.valueToTree(this.getSingleHeaderPolicyConfig()));
                }
                if (this.getSingleWeightPolicyConfig() != null) {
                    data.set("singleWeightPolicyConfig", om.valueToTree(this.getSingleWeightPolicyConfig()));
                }
                if (this.getTrafficConfig() != null) {
                    data.set("trafficConfig", om.valueToTree(this.getTrafficConfig()));
                }
                if (this.getType() != null) {
                    data.set("type", om.valueToTree(this.getType()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_cloudfront.CfnContinuousDeploymentPolicy.ContinuousDeploymentPolicyConfigProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ContinuousDeploymentPolicyConfigProperty.Jsii$Proxy that = (ContinuousDeploymentPolicyConfigProperty.Jsii$Proxy) o;

                if (!enabled.equals(that.enabled)) return false;
                if (!stagingDistributionDnsNames.equals(that.stagingDistributionDnsNames)) return false;
                if (this.singleHeaderPolicyConfig != null ? !this.singleHeaderPolicyConfig.equals(that.singleHeaderPolicyConfig) : that.singleHeaderPolicyConfig != null) return false;
                if (this.singleWeightPolicyConfig != null ? !this.singleWeightPolicyConfig.equals(that.singleWeightPolicyConfig) : that.singleWeightPolicyConfig != null) return false;
                if (this.trafficConfig != null ? !this.trafficConfig.equals(that.trafficConfig) : that.trafficConfig != null) return false;
                return this.type != null ? this.type.equals(that.type) : that.type == null;
            }

            @Override
            public final int hashCode() {
                int result = this.enabled.hashCode();
                result = 31 * result + (this.stagingDistributionDnsNames.hashCode());
                result = 31 * result + (this.singleHeaderPolicyConfig != null ? this.singleHeaderPolicyConfig.hashCode() : 0);
                result = 31 * result + (this.singleWeightPolicyConfig != null ? this.singleWeightPolicyConfig.hashCode() : 0);
                result = 31 * result + (this.trafficConfig != null ? this.trafficConfig.hashCode() : 0);
                result = 31 * result + (this.type != null ? this.type.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Session stickiness provides the ability to define multiple requests from a single viewer as a single session.
     * <p>
     * This prevents the potentially inconsistent experience of sending some of a given user's requests to your staging distribution, while others are sent to your primary distribution. Define the session duration using TTL values.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.cloudfront.*;
     * SessionStickinessConfigProperty sessionStickinessConfigProperty = SessionStickinessConfigProperty.builder()
     *         .idleTtl(123)
     *         .maximumTtl(123)
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-continuousdeploymentpolicy-sessionstickinessconfig.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-continuousdeploymentpolicy-sessionstickinessconfig.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_cloudfront.CfnContinuousDeploymentPolicy.SessionStickinessConfigProperty")
    @software.amazon.jsii.Jsii.Proxy(SessionStickinessConfigProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface SessionStickinessConfigProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The amount of time after which you want sessions to cease if no requests are received.
         * <p>
         * Allowed values are 300–3600 seconds (5–60 minutes).
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-continuousdeploymentpolicy-sessionstickinessconfig.html#cfn-cloudfront-continuousdeploymentpolicy-sessionstickinessconfig-idlettl">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-continuousdeploymentpolicy-sessionstickinessconfig.html#cfn-cloudfront-continuousdeploymentpolicy-sessionstickinessconfig-idlettl</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Number getIdleTtl();

        /**
         * The maximum amount of time to consider requests from the viewer as being part of the same session.
         * <p>
         * Allowed values are 300–3600 seconds (5–60 minutes).
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-continuousdeploymentpolicy-sessionstickinessconfig.html#cfn-cloudfront-continuousdeploymentpolicy-sessionstickinessconfig-maximumttl">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-continuousdeploymentpolicy-sessionstickinessconfig.html#cfn-cloudfront-continuousdeploymentpolicy-sessionstickinessconfig-maximumttl</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Number getMaximumTtl();

        /**
         * @return a {@link Builder} of {@link SessionStickinessConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link SessionStickinessConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<SessionStickinessConfigProperty> {
            java.lang.Number idleTtl;
            java.lang.Number maximumTtl;

            /**
             * Sets the value of {@link SessionStickinessConfigProperty#getIdleTtl}
             * @param idleTtl The amount of time after which you want sessions to cease if no requests are received. This parameter is required.
             *                Allowed values are 300–3600 seconds (5–60 minutes).
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder idleTtl(java.lang.Number idleTtl) {
                this.idleTtl = idleTtl;
                return this;
            }

            /**
             * Sets the value of {@link SessionStickinessConfigProperty#getMaximumTtl}
             * @param maximumTtl The maximum amount of time to consider requests from the viewer as being part of the same session. This parameter is required.
             *                   Allowed values are 300–3600 seconds (5–60 minutes).
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder maximumTtl(java.lang.Number maximumTtl) {
                this.maximumTtl = maximumTtl;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link SessionStickinessConfigProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public SessionStickinessConfigProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link SessionStickinessConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements SessionStickinessConfigProperty {
            private final java.lang.Number idleTtl;
            private final java.lang.Number maximumTtl;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.idleTtl = software.amazon.jsii.Kernel.get(this, "idleTtl", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.maximumTtl = software.amazon.jsii.Kernel.get(this, "maximumTtl", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.idleTtl = java.util.Objects.requireNonNull(builder.idleTtl, "idleTtl is required");
                this.maximumTtl = java.util.Objects.requireNonNull(builder.maximumTtl, "maximumTtl is required");
            }

            @Override
            public final java.lang.Number getIdleTtl() {
                return this.idleTtl;
            }

            @Override
            public final java.lang.Number getMaximumTtl() {
                return this.maximumTtl;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("idleTtl", om.valueToTree(this.getIdleTtl()));
                data.set("maximumTtl", om.valueToTree(this.getMaximumTtl()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_cloudfront.CfnContinuousDeploymentPolicy.SessionStickinessConfigProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                SessionStickinessConfigProperty.Jsii$Proxy that = (SessionStickinessConfigProperty.Jsii$Proxy) o;

                if (!idleTtl.equals(that.idleTtl)) return false;
                return this.maximumTtl.equals(that.maximumTtl);
            }

            @Override
            public final int hashCode() {
                int result = this.idleTtl.hashCode();
                result = 31 * result + (this.maximumTtl.hashCode());
                return result;
            }
        }
    }
    /**
     * Determines which HTTP requests are sent to the staging distribution.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.cloudfront.*;
     * SingleHeaderConfigProperty singleHeaderConfigProperty = SingleHeaderConfigProperty.builder()
     *         .header("header")
     *         .value("value")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-continuousdeploymentpolicy-singleheaderconfig.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-continuousdeploymentpolicy-singleheaderconfig.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_cloudfront.CfnContinuousDeploymentPolicy.SingleHeaderConfigProperty")
    @software.amazon.jsii.Jsii.Proxy(SingleHeaderConfigProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface SingleHeaderConfigProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The request header name that you want CloudFront to send to your staging distribution.
         * <p>
         * The header must contain the prefix <code>aws-cf-cd-</code> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-continuousdeploymentpolicy-singleheaderconfig.html#cfn-cloudfront-continuousdeploymentpolicy-singleheaderconfig-header">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-continuousdeploymentpolicy-singleheaderconfig.html#cfn-cloudfront-continuousdeploymentpolicy-singleheaderconfig-header</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getHeader();

        /**
         * The request header value.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-continuousdeploymentpolicy-singleheaderconfig.html#cfn-cloudfront-continuousdeploymentpolicy-singleheaderconfig-value">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-continuousdeploymentpolicy-singleheaderconfig.html#cfn-cloudfront-continuousdeploymentpolicy-singleheaderconfig-value</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getValue();

        /**
         * @return a {@link Builder} of {@link SingleHeaderConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link SingleHeaderConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<SingleHeaderConfigProperty> {
            java.lang.String header;
            java.lang.String value;

            /**
             * Sets the value of {@link SingleHeaderConfigProperty#getHeader}
             * @param header The request header name that you want CloudFront to send to your staging distribution. This parameter is required.
             *               The header must contain the prefix <code>aws-cf-cd-</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder header(java.lang.String header) {
                this.header = header;
                return this;
            }

            /**
             * Sets the value of {@link SingleHeaderConfigProperty#getValue}
             * @param value The request header value. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder value(java.lang.String value) {
                this.value = value;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link SingleHeaderConfigProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public SingleHeaderConfigProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link SingleHeaderConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements SingleHeaderConfigProperty {
            private final java.lang.String header;
            private final java.lang.String value;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.header = software.amazon.jsii.Kernel.get(this, "header", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.value = software.amazon.jsii.Kernel.get(this, "value", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.header = java.util.Objects.requireNonNull(builder.header, "header is required");
                this.value = java.util.Objects.requireNonNull(builder.value, "value is required");
            }

            @Override
            public final java.lang.String getHeader() {
                return this.header;
            }

            @Override
            public final java.lang.String getValue() {
                return this.value;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("header", om.valueToTree(this.getHeader()));
                data.set("value", om.valueToTree(this.getValue()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_cloudfront.CfnContinuousDeploymentPolicy.SingleHeaderConfigProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                SingleHeaderConfigProperty.Jsii$Proxy that = (SingleHeaderConfigProperty.Jsii$Proxy) o;

                if (!header.equals(that.header)) return false;
                return this.value.equals(that.value);
            }

            @Override
            public final int hashCode() {
                int result = this.header.hashCode();
                result = 31 * result + (this.value.hashCode());
                return result;
            }
        }
    }
    /**
     * Defines a single header policy for a CloudFront distribution.
     * <p>
     * <blockquote>
     * <p>
     * This property is legacy. We recommend that you use <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-continuousdeploymentpolicy-trafficconfig.html">TrafficConfig</a> and specify the <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-continuousdeploymentpolicy-trafficconfig.html#cfn-cloudfront-continuousdeploymentpolicy-trafficconfig-singleheaderconfig">SingleHeaderConfig</a> property instead.
     * <p>
     * </blockquote>
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.cloudfront.*;
     * SingleHeaderPolicyConfigProperty singleHeaderPolicyConfigProperty = SingleHeaderPolicyConfigProperty.builder()
     *         .header("header")
     *         .value("value")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-continuousdeploymentpolicy-singleheaderpolicyconfig.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-continuousdeploymentpolicy-singleheaderpolicyconfig.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_cloudfront.CfnContinuousDeploymentPolicy.SingleHeaderPolicyConfigProperty")
    @software.amazon.jsii.Jsii.Proxy(SingleHeaderPolicyConfigProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface SingleHeaderPolicyConfigProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The name of the HTTP header that CloudFront uses to configure for the single header policy.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-continuousdeploymentpolicy-singleheaderpolicyconfig.html#cfn-cloudfront-continuousdeploymentpolicy-singleheaderpolicyconfig-header">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-continuousdeploymentpolicy-singleheaderpolicyconfig.html#cfn-cloudfront-continuousdeploymentpolicy-singleheaderpolicyconfig-header</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getHeader();

        /**
         * Specifies the value to assign to the header for a single header policy.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-continuousdeploymentpolicy-singleheaderpolicyconfig.html#cfn-cloudfront-continuousdeploymentpolicy-singleheaderpolicyconfig-value">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-continuousdeploymentpolicy-singleheaderpolicyconfig.html#cfn-cloudfront-continuousdeploymentpolicy-singleheaderpolicyconfig-value</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getValue();

        /**
         * @return a {@link Builder} of {@link SingleHeaderPolicyConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link SingleHeaderPolicyConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<SingleHeaderPolicyConfigProperty> {
            java.lang.String header;
            java.lang.String value;

            /**
             * Sets the value of {@link SingleHeaderPolicyConfigProperty#getHeader}
             * @param header The name of the HTTP header that CloudFront uses to configure for the single header policy. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder header(java.lang.String header) {
                this.header = header;
                return this;
            }

            /**
             * Sets the value of {@link SingleHeaderPolicyConfigProperty#getValue}
             * @param value Specifies the value to assign to the header for a single header policy. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder value(java.lang.String value) {
                this.value = value;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link SingleHeaderPolicyConfigProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public SingleHeaderPolicyConfigProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link SingleHeaderPolicyConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements SingleHeaderPolicyConfigProperty {
            private final java.lang.String header;
            private final java.lang.String value;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.header = software.amazon.jsii.Kernel.get(this, "header", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.value = software.amazon.jsii.Kernel.get(this, "value", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.header = java.util.Objects.requireNonNull(builder.header, "header is required");
                this.value = java.util.Objects.requireNonNull(builder.value, "value is required");
            }

            @Override
            public final java.lang.String getHeader() {
                return this.header;
            }

            @Override
            public final java.lang.String getValue() {
                return this.value;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("header", om.valueToTree(this.getHeader()));
                data.set("value", om.valueToTree(this.getValue()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_cloudfront.CfnContinuousDeploymentPolicy.SingleHeaderPolicyConfigProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                SingleHeaderPolicyConfigProperty.Jsii$Proxy that = (SingleHeaderPolicyConfigProperty.Jsii$Proxy) o;

                if (!header.equals(that.header)) return false;
                return this.value.equals(that.value);
            }

            @Override
            public final int hashCode() {
                int result = this.header.hashCode();
                result = 31 * result + (this.value.hashCode());
                return result;
            }
        }
    }
    /**
     * This configuration determines the percentage of HTTP requests that are sent to the staging distribution.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.cloudfront.*;
     * SingleWeightConfigProperty singleWeightConfigProperty = SingleWeightConfigProperty.builder()
     *         .weight(123)
     *         // the properties below are optional
     *         .sessionStickinessConfig(SessionStickinessConfigProperty.builder()
     *                 .idleTtl(123)
     *                 .maximumTtl(123)
     *                 .build())
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-continuousdeploymentpolicy-singleweightconfig.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-continuousdeploymentpolicy-singleweightconfig.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_cloudfront.CfnContinuousDeploymentPolicy.SingleWeightConfigProperty")
    @software.amazon.jsii.Jsii.Proxy(SingleWeightConfigProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface SingleWeightConfigProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The percentage of traffic to send to a staging distribution, expressed as a decimal number between 0 and 0.15. For example, a value of 0.10 means 10% of traffic is sent to the staging distribution.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-continuousdeploymentpolicy-singleweightconfig.html#cfn-cloudfront-continuousdeploymentpolicy-singleweightconfig-weight">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-continuousdeploymentpolicy-singleweightconfig.html#cfn-cloudfront-continuousdeploymentpolicy-singleweightconfig-weight</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Number getWeight();

        /**
         * Session stickiness provides the ability to define multiple requests from a single viewer as a single session.
         * <p>
         * This prevents the potentially inconsistent experience of sending some of a given user's requests to your staging distribution, while others are sent to your primary distribution. Define the session duration using TTL values.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-continuousdeploymentpolicy-singleweightconfig.html#cfn-cloudfront-continuousdeploymentpolicy-singleweightconfig-sessionstickinessconfig">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-continuousdeploymentpolicy-singleweightconfig.html#cfn-cloudfront-continuousdeploymentpolicy-singleweightconfig-sessionstickinessconfig</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getSessionStickinessConfig() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link SingleWeightConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link SingleWeightConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<SingleWeightConfigProperty> {
            java.lang.Number weight;
            java.lang.Object sessionStickinessConfig;

            /**
             * Sets the value of {@link SingleWeightConfigProperty#getWeight}
             * @param weight The percentage of traffic to send to a staging distribution, expressed as a decimal number between 0 and 0.15. For example, a value of 0.10 means 10% of traffic is sent to the staging distribution. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder weight(java.lang.Number weight) {
                this.weight = weight;
                return this;
            }

            /**
             * Sets the value of {@link SingleWeightConfigProperty#getSessionStickinessConfig}
             * @param sessionStickinessConfig Session stickiness provides the ability to define multiple requests from a single viewer as a single session.
             *                                This prevents the potentially inconsistent experience of sending some of a given user's requests to your staging distribution, while others are sent to your primary distribution. Define the session duration using TTL values.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder sessionStickinessConfig(software.amazon.awscdk.IResolvable sessionStickinessConfig) {
                this.sessionStickinessConfig = sessionStickinessConfig;
                return this;
            }

            /**
             * Sets the value of {@link SingleWeightConfigProperty#getSessionStickinessConfig}
             * @param sessionStickinessConfig Session stickiness provides the ability to define multiple requests from a single viewer as a single session.
             *                                This prevents the potentially inconsistent experience of sending some of a given user's requests to your staging distribution, while others are sent to your primary distribution. Define the session duration using TTL values.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder sessionStickinessConfig(software.amazon.awscdk.services.cloudfront.CfnContinuousDeploymentPolicy.SessionStickinessConfigProperty sessionStickinessConfig) {
                this.sessionStickinessConfig = sessionStickinessConfig;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link SingleWeightConfigProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public SingleWeightConfigProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link SingleWeightConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements SingleWeightConfigProperty {
            private final java.lang.Number weight;
            private final java.lang.Object sessionStickinessConfig;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.weight = software.amazon.jsii.Kernel.get(this, "weight", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.sessionStickinessConfig = software.amazon.jsii.Kernel.get(this, "sessionStickinessConfig", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.weight = java.util.Objects.requireNonNull(builder.weight, "weight is required");
                this.sessionStickinessConfig = builder.sessionStickinessConfig;
            }

            @Override
            public final java.lang.Number getWeight() {
                return this.weight;
            }

            @Override
            public final java.lang.Object getSessionStickinessConfig() {
                return this.sessionStickinessConfig;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("weight", om.valueToTree(this.getWeight()));
                if (this.getSessionStickinessConfig() != null) {
                    data.set("sessionStickinessConfig", om.valueToTree(this.getSessionStickinessConfig()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_cloudfront.CfnContinuousDeploymentPolicy.SingleWeightConfigProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                SingleWeightConfigProperty.Jsii$Proxy that = (SingleWeightConfigProperty.Jsii$Proxy) o;

                if (!weight.equals(that.weight)) return false;
                return this.sessionStickinessConfig != null ? this.sessionStickinessConfig.equals(that.sessionStickinessConfig) : that.sessionStickinessConfig == null;
            }

            @Override
            public final int hashCode() {
                int result = this.weight.hashCode();
                result = 31 * result + (this.sessionStickinessConfig != null ? this.sessionStickinessConfig.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Configure a policy that CloudFront uses to route requests to different origins or use different cache settings, based on the weight assigned to each option.
     * <p>
     * <blockquote>
     * <p>
     * This property is legacy. We recommend that you use <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-continuousdeploymentpolicy-trafficconfig.html">TrafficConfig</a> and specify the <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-continuousdeploymentpolicy-trafficconfig.html#cfn-cloudfront-continuousdeploymentpolicy-trafficconfig-singleweightconfig">SingleWeightConfig</a> property instead.
     * <p>
     * </blockquote>
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.cloudfront.*;
     * SingleWeightPolicyConfigProperty singleWeightPolicyConfigProperty = SingleWeightPolicyConfigProperty.builder()
     *         .weight(123)
     *         // the properties below are optional
     *         .sessionStickinessConfig(SessionStickinessConfigProperty.builder()
     *                 .idleTtl(123)
     *                 .maximumTtl(123)
     *                 .build())
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-continuousdeploymentpolicy-singleweightpolicyconfig.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-continuousdeploymentpolicy-singleweightpolicyconfig.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_cloudfront.CfnContinuousDeploymentPolicy.SingleWeightPolicyConfigProperty")
    @software.amazon.jsii.Jsii.Proxy(SingleWeightPolicyConfigProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface SingleWeightPolicyConfigProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The percentage of requests that CloudFront will use to send to an associated origin or cache settings.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-continuousdeploymentpolicy-singleweightpolicyconfig.html#cfn-cloudfront-continuousdeploymentpolicy-singleweightpolicyconfig-weight">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-continuousdeploymentpolicy-singleweightpolicyconfig.html#cfn-cloudfront-continuousdeploymentpolicy-singleweightpolicyconfig-weight</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Number getWeight();

        /**
         * Enable session stickiness for the associated origin or cache settings.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-continuousdeploymentpolicy-singleweightpolicyconfig.html#cfn-cloudfront-continuousdeploymentpolicy-singleweightpolicyconfig-sessionstickinessconfig">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-continuousdeploymentpolicy-singleweightpolicyconfig.html#cfn-cloudfront-continuousdeploymentpolicy-singleweightpolicyconfig-sessionstickinessconfig</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getSessionStickinessConfig() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link SingleWeightPolicyConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link SingleWeightPolicyConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<SingleWeightPolicyConfigProperty> {
            java.lang.Number weight;
            java.lang.Object sessionStickinessConfig;

            /**
             * Sets the value of {@link SingleWeightPolicyConfigProperty#getWeight}
             * @param weight The percentage of requests that CloudFront will use to send to an associated origin or cache settings. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder weight(java.lang.Number weight) {
                this.weight = weight;
                return this;
            }

            /**
             * Sets the value of {@link SingleWeightPolicyConfigProperty#getSessionStickinessConfig}
             * @param sessionStickinessConfig Enable session stickiness for the associated origin or cache settings.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder sessionStickinessConfig(software.amazon.awscdk.IResolvable sessionStickinessConfig) {
                this.sessionStickinessConfig = sessionStickinessConfig;
                return this;
            }

            /**
             * Sets the value of {@link SingleWeightPolicyConfigProperty#getSessionStickinessConfig}
             * @param sessionStickinessConfig Enable session stickiness for the associated origin or cache settings.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder sessionStickinessConfig(software.amazon.awscdk.services.cloudfront.CfnContinuousDeploymentPolicy.SessionStickinessConfigProperty sessionStickinessConfig) {
                this.sessionStickinessConfig = sessionStickinessConfig;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link SingleWeightPolicyConfigProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public SingleWeightPolicyConfigProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link SingleWeightPolicyConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements SingleWeightPolicyConfigProperty {
            private final java.lang.Number weight;
            private final java.lang.Object sessionStickinessConfig;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.weight = software.amazon.jsii.Kernel.get(this, "weight", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.sessionStickinessConfig = software.amazon.jsii.Kernel.get(this, "sessionStickinessConfig", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.weight = java.util.Objects.requireNonNull(builder.weight, "weight is required");
                this.sessionStickinessConfig = builder.sessionStickinessConfig;
            }

            @Override
            public final java.lang.Number getWeight() {
                return this.weight;
            }

            @Override
            public final java.lang.Object getSessionStickinessConfig() {
                return this.sessionStickinessConfig;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("weight", om.valueToTree(this.getWeight()));
                if (this.getSessionStickinessConfig() != null) {
                    data.set("sessionStickinessConfig", om.valueToTree(this.getSessionStickinessConfig()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_cloudfront.CfnContinuousDeploymentPolicy.SingleWeightPolicyConfigProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                SingleWeightPolicyConfigProperty.Jsii$Proxy that = (SingleWeightPolicyConfigProperty.Jsii$Proxy) o;

                if (!weight.equals(that.weight)) return false;
                return this.sessionStickinessConfig != null ? this.sessionStickinessConfig.equals(that.sessionStickinessConfig) : that.sessionStickinessConfig == null;
            }

            @Override
            public final int hashCode() {
                int result = this.weight.hashCode();
                result = 31 * result + (this.sessionStickinessConfig != null ? this.sessionStickinessConfig.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * The traffic configuration of your continuous deployment.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.cloudfront.*;
     * TrafficConfigProperty trafficConfigProperty = TrafficConfigProperty.builder()
     *         .type("type")
     *         // the properties below are optional
     *         .singleHeaderConfig(SingleHeaderConfigProperty.builder()
     *                 .header("header")
     *                 .value("value")
     *                 .build())
     *         .singleWeightConfig(SingleWeightConfigProperty.builder()
     *                 .weight(123)
     *                 // the properties below are optional
     *                 .sessionStickinessConfig(SessionStickinessConfigProperty.builder()
     *                         .idleTtl(123)
     *                         .maximumTtl(123)
     *                         .build())
     *                 .build())
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-continuousdeploymentpolicy-trafficconfig.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-continuousdeploymentpolicy-trafficconfig.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_cloudfront.CfnContinuousDeploymentPolicy.TrafficConfigProperty")
    @software.amazon.jsii.Jsii.Proxy(TrafficConfigProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface TrafficConfigProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The type of traffic configuration.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-continuousdeploymentpolicy-trafficconfig.html#cfn-cloudfront-continuousdeploymentpolicy-trafficconfig-type">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-continuousdeploymentpolicy-trafficconfig.html#cfn-cloudfront-continuousdeploymentpolicy-trafficconfig-type</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getType();

        /**
         * Determines which HTTP requests are sent to the staging distribution.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-continuousdeploymentpolicy-trafficconfig.html#cfn-cloudfront-continuousdeploymentpolicy-trafficconfig-singleheaderconfig">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-continuousdeploymentpolicy-trafficconfig.html#cfn-cloudfront-continuousdeploymentpolicy-trafficconfig-singleheaderconfig</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getSingleHeaderConfig() {
            return null;
        }

        /**
         * Contains the percentage of traffic to send to the staging distribution.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-continuousdeploymentpolicy-trafficconfig.html#cfn-cloudfront-continuousdeploymentpolicy-trafficconfig-singleweightconfig">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-continuousdeploymentpolicy-trafficconfig.html#cfn-cloudfront-continuousdeploymentpolicy-trafficconfig-singleweightconfig</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getSingleWeightConfig() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link TrafficConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link TrafficConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<TrafficConfigProperty> {
            java.lang.String type;
            java.lang.Object singleHeaderConfig;
            java.lang.Object singleWeightConfig;

            /**
             * Sets the value of {@link TrafficConfigProperty#getType}
             * @param type The type of traffic configuration. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder type(java.lang.String type) {
                this.type = type;
                return this;
            }

            /**
             * Sets the value of {@link TrafficConfigProperty#getSingleHeaderConfig}
             * @param singleHeaderConfig Determines which HTTP requests are sent to the staging distribution.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder singleHeaderConfig(software.amazon.awscdk.IResolvable singleHeaderConfig) {
                this.singleHeaderConfig = singleHeaderConfig;
                return this;
            }

            /**
             * Sets the value of {@link TrafficConfigProperty#getSingleHeaderConfig}
             * @param singleHeaderConfig Determines which HTTP requests are sent to the staging distribution.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder singleHeaderConfig(software.amazon.awscdk.services.cloudfront.CfnContinuousDeploymentPolicy.SingleHeaderConfigProperty singleHeaderConfig) {
                this.singleHeaderConfig = singleHeaderConfig;
                return this;
            }

            /**
             * Sets the value of {@link TrafficConfigProperty#getSingleWeightConfig}
             * @param singleWeightConfig Contains the percentage of traffic to send to the staging distribution.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder singleWeightConfig(software.amazon.awscdk.IResolvable singleWeightConfig) {
                this.singleWeightConfig = singleWeightConfig;
                return this;
            }

            /**
             * Sets the value of {@link TrafficConfigProperty#getSingleWeightConfig}
             * @param singleWeightConfig Contains the percentage of traffic to send to the staging distribution.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder singleWeightConfig(software.amazon.awscdk.services.cloudfront.CfnContinuousDeploymentPolicy.SingleWeightConfigProperty singleWeightConfig) {
                this.singleWeightConfig = singleWeightConfig;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link TrafficConfigProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public TrafficConfigProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link TrafficConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements TrafficConfigProperty {
            private final java.lang.String type;
            private final java.lang.Object singleHeaderConfig;
            private final java.lang.Object singleWeightConfig;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.type = software.amazon.jsii.Kernel.get(this, "type", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.singleHeaderConfig = software.amazon.jsii.Kernel.get(this, "singleHeaderConfig", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.singleWeightConfig = software.amazon.jsii.Kernel.get(this, "singleWeightConfig", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.type = java.util.Objects.requireNonNull(builder.type, "type is required");
                this.singleHeaderConfig = builder.singleHeaderConfig;
                this.singleWeightConfig = builder.singleWeightConfig;
            }

            @Override
            public final java.lang.String getType() {
                return this.type;
            }

            @Override
            public final java.lang.Object getSingleHeaderConfig() {
                return this.singleHeaderConfig;
            }

            @Override
            public final java.lang.Object getSingleWeightConfig() {
                return this.singleWeightConfig;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("type", om.valueToTree(this.getType()));
                if (this.getSingleHeaderConfig() != null) {
                    data.set("singleHeaderConfig", om.valueToTree(this.getSingleHeaderConfig()));
                }
                if (this.getSingleWeightConfig() != null) {
                    data.set("singleWeightConfig", om.valueToTree(this.getSingleWeightConfig()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_cloudfront.CfnContinuousDeploymentPolicy.TrafficConfigProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                TrafficConfigProperty.Jsii$Proxy that = (TrafficConfigProperty.Jsii$Proxy) o;

                if (!type.equals(that.type)) return false;
                if (this.singleHeaderConfig != null ? !this.singleHeaderConfig.equals(that.singleHeaderConfig) : that.singleHeaderConfig != null) return false;
                return this.singleWeightConfig != null ? this.singleWeightConfig.equals(that.singleWeightConfig) : that.singleWeightConfig == null;
            }

            @Override
            public final int hashCode() {
                int result = this.type.hashCode();
                result = 31 * result + (this.singleHeaderConfig != null ? this.singleHeaderConfig.hashCode() : 0);
                result = 31 * result + (this.singleWeightConfig != null ? this.singleWeightConfig.hashCode() : 0);
                return result;
            }
        }
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.cloudfront.CfnContinuousDeploymentPolicy}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.cloudfront.CfnContinuousDeploymentPolicy> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope Scope in which this resource is defined. This parameter is required.
         * @param id Construct identifier for this resource (unique in its scope). This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.cloudfront.CfnContinuousDeploymentPolicyProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.services.cloudfront.CfnContinuousDeploymentPolicyProps.Builder();
        }

        /**
         * Contains the configuration for a continuous deployment policy.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudfront-continuousdeploymentpolicy.html#cfn-cloudfront-continuousdeploymentpolicy-continuousdeploymentpolicyconfig">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudfront-continuousdeploymentpolicy.html#cfn-cloudfront-continuousdeploymentpolicy-continuousdeploymentpolicyconfig</a>
         * @param continuousDeploymentPolicyConfig Contains the configuration for a continuous deployment policy. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder continuousDeploymentPolicyConfig(final software.amazon.awscdk.IResolvable continuousDeploymentPolicyConfig) {
            this.props.continuousDeploymentPolicyConfig(continuousDeploymentPolicyConfig);
            return this;
        }
        /**
         * Contains the configuration for a continuous deployment policy.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudfront-continuousdeploymentpolicy.html#cfn-cloudfront-continuousdeploymentpolicy-continuousdeploymentpolicyconfig">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudfront-continuousdeploymentpolicy.html#cfn-cloudfront-continuousdeploymentpolicy-continuousdeploymentpolicyconfig</a>
         * @param continuousDeploymentPolicyConfig Contains the configuration for a continuous deployment policy. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder continuousDeploymentPolicyConfig(final software.amazon.awscdk.services.cloudfront.CfnContinuousDeploymentPolicy.ContinuousDeploymentPolicyConfigProperty continuousDeploymentPolicyConfig) {
            this.props.continuousDeploymentPolicyConfig(continuousDeploymentPolicyConfig);
            return this;
        }

        /**
         * @return a newly built instance of {@link software.amazon.awscdk.services.cloudfront.CfnContinuousDeploymentPolicy}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.cloudfront.CfnContinuousDeploymentPolicy build() {
            return new software.amazon.awscdk.services.cloudfront.CfnContinuousDeploymentPolicy(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
