package software.amazon.awscdk.services.cloudfront;

/**
 * A CloudFront Function.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * KeyValueStore store = new KeyValueStore(this, "KeyValueStore");
 * Function.Builder.create(this, "Function")
 *         .code(FunctionCode.fromInline("function handler(event) { return event.request }"))
 *         // Note that JS_2_0 must be used for Key Value Store support
 *         .runtime(FunctionRuntime.JS_2_0)
 *         .keyValueStore(store)
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.109.0 (build c221850)", date = "2025-03-14T03:24:54.798Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_cloudfront.Function")
public class Function extends software.amazon.awscdk.Resource implements software.amazon.awscdk.services.cloudfront.IFunction {

    protected Function(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected Function(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * @param scope This parameter is required.
     * @param id This parameter is required.
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public Function(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudfront.FunctionProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Imports a function by its name and ARN.
     * <p>
     * @param scope This parameter is required.
     * @param id This parameter is required.
     * @param attrs This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudfront.IFunction fromFunctionAttributes(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudfront.FunctionAttributes attrs) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.cloudfront.Function.class, "fromFunctionAttributes", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudfront.IFunction.class), new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(attrs, "attrs is required") });
    }

    /**
     * the ARN of the CloudFront function.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getFunctionArn() {
        return software.amazon.jsii.Kernel.get(this, "functionArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * the name of the CloudFront function.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getFunctionName() {
        return software.amazon.jsii.Kernel.get(this, "functionName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * the runtime of the CloudFront function.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getFunctionRuntime() {
        return software.amazon.jsii.Kernel.get(this, "functionRuntime", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * the deployment stage of the CloudFront function.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getFunctionStage() {
        return software.amazon.jsii.Kernel.get(this, "functionStage", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.cloudfront.Function}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.cloudfront.Function> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope This parameter is required.
         * @param id This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.cloudfront.FunctionProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.services.cloudfront.FunctionProps.Builder();
        }

        /**
         * The source code of the function.
         * <p>
         * @return {@code this}
         * @param code The source code of the function. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder code(final software.amazon.awscdk.services.cloudfront.FunctionCode code) {
            this.props.code(code);
            return this;
        }

        /**
         * A flag that determines whether to automatically publish the function to the LIVE stage when it’s created.
         * <p>
         * Default: - true
         * <p>
         * @return {@code this}
         * @param autoPublish A flag that determines whether to automatically publish the function to the LIVE stage when it’s created. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder autoPublish(final java.lang.Boolean autoPublish) {
            this.props.autoPublish(autoPublish);
            return this;
        }

        /**
         * A comment to describe the function.
         * <p>
         * Default: - same as `functionName`
         * <p>
         * @return {@code this}
         * @param comment A comment to describe the function. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder comment(final java.lang.String comment) {
            this.props.comment(comment);
            return this;
        }

        /**
         * A name to identify the function.
         * <p>
         * Default: - generated from the `id`
         * <p>
         * @return {@code this}
         * @param functionName A name to identify the function. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder functionName(final java.lang.String functionName) {
            this.props.functionName(functionName);
            return this;
        }

        /**
         * The Key Value Store to associate with this function.
         * <p>
         * In order to associate a Key Value Store, the <code>runtime</code> must be
         * <code>cloudfront-js-2.0</code> or newer.
         * <p>
         * Default: - no key value store is associated
         * <p>
         * @return {@code this}
         * @param keyValueStore The Key Value Store to associate with this function. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder keyValueStore(final software.amazon.awscdk.services.cloudfront.IKeyValueStore keyValueStore) {
            this.props.keyValueStore(keyValueStore);
            return this;
        }

        /**
         * The runtime environment for the function.
         * <p>
         * Default: FunctionRuntime.JS_1_0 (unless `keyValueStore` is specified, then `FunctionRuntime.JS_2_0`)
         * <p>
         * @return {@code this}
         * @param runtime The runtime environment for the function. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder runtime(final software.amazon.awscdk.services.cloudfront.FunctionRuntime runtime) {
            this.props.runtime(runtime);
            return this;
        }

        /**
         * @return a newly built instance of {@link software.amazon.awscdk.services.cloudfront.Function}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.cloudfront.Function build() {
            return new software.amazon.awscdk.services.cloudfront.Function(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
