package software.amazon.awscdk.services.cloudfront;

/**
 * The function's runtime environment version.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * KeyValueStore store = new KeyValueStore(this, "KeyValueStore");
 * Function.Builder.create(this, "Function")
 *         .code(FunctionCode.fromInline("function handler(event) { return event.request }"))
 *         // Note that JS_2_0 must be used for Key Value Store support
 *         .runtime(FunctionRuntime.JS_2_0)
 *         .keyValueStore(store)
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.109.0 (build c221850)", date = "2025-03-14T03:24:54.801Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_cloudfront.FunctionRuntime")
public class FunctionRuntime extends software.amazon.jsii.JsiiObject {

    protected FunctionRuntime(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected FunctionRuntime(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        JS_1_0 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.cloudfront.FunctionRuntime.class, "JS_1_0", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudfront.FunctionRuntime.class));
        JS_2_0 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.cloudfront.FunctionRuntime.class, "JS_2_0", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudfront.FunctionRuntime.class));
    }

    /**
     * A custom runtime string.
     * <p>
     * Gives full control over the runtime string fragment.
     * <p>
     * @param runtimeString This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudfront.FunctionRuntime custom(final @org.jetbrains.annotations.NotNull java.lang.String runtimeString) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.cloudfront.FunctionRuntime.class, "custom", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudfront.FunctionRuntime.class), new Object[] { java.util.Objects.requireNonNull(runtimeString, "runtimeString is required") });
    }

    /**
     * cloudfront-js-1.0.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.cloudfront.FunctionRuntime JS_1_0;

    /**
     * cloudfront-js-2.0.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.cloudfront.FunctionRuntime JS_2_0;

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getValue() {
        return software.amazon.jsii.Kernel.get(this, "value", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }
}
