package software.amazon.awscdk.services.cloudfront;

/**
 * The selection criteria for the origin group.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * Distribution.Builder.create(this, "myDist")
 *         .defaultBehavior(BehaviorOptions.builder()
 *                 .origin(OriginGroup.Builder.create()
 *                         .primaryOrigin(new HttpOrigin("&lt;AWS Elemental MediaPackageV2 origin 1&gt;"))
 *                         .fallbackOrigin(new HttpOrigin("&lt;AWS Elemental MediaPackageV2 origin 2&gt;"))
 *                         .fallbackStatusCodes(List.of(404))
 *                         .selectionCriteria(OriginSelectionCriteria.MEDIA_QUALITY_BASED)
 *                         .build())
 *                 .build())
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.109.0 (build c221850)", date = "2025-03-14T03:24:54.821Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_cloudfront.OriginSelectionCriteria")
public enum OriginSelectionCriteria {
    /**
     * Default selection behavior.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    DEFAULT,
    /**
     * Selection based on media quality.
     * <p>
     * This option is only valid for AWS Elemental MediaPackage v2 Origins.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    MEDIA_QUALITY_BASED,
}
