package software.amazon.awscdk.services.cloudfront;

/**
 * Properties for defining a RealtimeLogConfig resource.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // Adding realtime logs config to a Cloudfront Distribution on default behavior.
 * import software.amazon.awscdk.services.kinesis.*;
 * Stream stream;
 * RealtimeLogConfig realTimeConfig = RealtimeLogConfig.Builder.create(this, "realtimeLog")
 *         .endPoints(List.of(Endpoint.fromKinesisStream(stream)))
 *         .fields(List.of("timestamp", "c-ip", "time-to-first-byte", "sc-status"))
 *         .realtimeLogConfigName("my-delivery-stream")
 *         .samplingRate(100)
 *         .build();
 * Distribution.Builder.create(this, "myCdn")
 *         .defaultBehavior(BehaviorOptions.builder()
 *                 .origin(new HttpOrigin("www.example.com"))
 *                 .realtimeLogConfig(realTimeConfig)
 *                 .build())
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.109.0 (build c221850)", date = "2025-03-14T03:24:54.834Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_cloudfront.RealtimeLogConfigProps")
@software.amazon.jsii.Jsii.Proxy(RealtimeLogConfigProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface RealtimeLogConfigProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * Contains information about the Amazon Kinesis data stream where you are sending real-time log data for this real-time log configuration.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.util.List<software.amazon.awscdk.services.cloudfront.Endpoint> getEndPoints();

    /**
     * A list of fields that are included in each real-time log record.
     * <p>
     * @see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/real-time-logs.html#understand-real-time-log-config-fields">https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/real-time-logs.html#understand-real-time-log-config-fields</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.util.List<java.lang.String> getFields();

    /**
     * The sampling rate for this real-time log configuration.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.Number getSamplingRate();

    /**
     * The unique name of this real-time log configuration.
     * <p>
     * Default: - the unique construct ID
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getRealtimeLogConfigName() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link RealtimeLogConfigProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link RealtimeLogConfigProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<RealtimeLogConfigProps> {
        java.util.List<software.amazon.awscdk.services.cloudfront.Endpoint> endPoints;
        java.util.List<java.lang.String> fields;
        java.lang.Number samplingRate;
        java.lang.String realtimeLogConfigName;

        /**
         * Sets the value of {@link RealtimeLogConfigProps#getEndPoints}
         * @param endPoints Contains information about the Amazon Kinesis data stream where you are sending real-time log data for this real-time log configuration. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder endPoints(java.util.List<? extends software.amazon.awscdk.services.cloudfront.Endpoint> endPoints) {
            this.endPoints = (java.util.List<software.amazon.awscdk.services.cloudfront.Endpoint>)endPoints;
            return this;
        }

        /**
         * Sets the value of {@link RealtimeLogConfigProps#getFields}
         * @param fields A list of fields that are included in each real-time log record. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder fields(java.util.List<java.lang.String> fields) {
            this.fields = fields;
            return this;
        }

        /**
         * Sets the value of {@link RealtimeLogConfigProps#getSamplingRate}
         * @param samplingRate The sampling rate for this real-time log configuration. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder samplingRate(java.lang.Number samplingRate) {
            this.samplingRate = samplingRate;
            return this;
        }

        /**
         * Sets the value of {@link RealtimeLogConfigProps#getRealtimeLogConfigName}
         * @param realtimeLogConfigName The unique name of this real-time log configuration.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder realtimeLogConfigName(java.lang.String realtimeLogConfigName) {
            this.realtimeLogConfigName = realtimeLogConfigName;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link RealtimeLogConfigProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public RealtimeLogConfigProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link RealtimeLogConfigProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements RealtimeLogConfigProps {
        private final java.util.List<software.amazon.awscdk.services.cloudfront.Endpoint> endPoints;
        private final java.util.List<java.lang.String> fields;
        private final java.lang.Number samplingRate;
        private final java.lang.String realtimeLogConfigName;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.endPoints = software.amazon.jsii.Kernel.get(this, "endPoints", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudfront.Endpoint.class)));
            this.fields = software.amazon.jsii.Kernel.get(this, "fields", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.samplingRate = software.amazon.jsii.Kernel.get(this, "samplingRate", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            this.realtimeLogConfigName = software.amazon.jsii.Kernel.get(this, "realtimeLogConfigName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.endPoints = (java.util.List<software.amazon.awscdk.services.cloudfront.Endpoint>)java.util.Objects.requireNonNull(builder.endPoints, "endPoints is required");
            this.fields = java.util.Objects.requireNonNull(builder.fields, "fields is required");
            this.samplingRate = java.util.Objects.requireNonNull(builder.samplingRate, "samplingRate is required");
            this.realtimeLogConfigName = builder.realtimeLogConfigName;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.services.cloudfront.Endpoint> getEndPoints() {
            return this.endPoints;
        }

        @Override
        public final java.util.List<java.lang.String> getFields() {
            return this.fields;
        }

        @Override
        public final java.lang.Number getSamplingRate() {
            return this.samplingRate;
        }

        @Override
        public final java.lang.String getRealtimeLogConfigName() {
            return this.realtimeLogConfigName;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("endPoints", om.valueToTree(this.getEndPoints()));
            data.set("fields", om.valueToTree(this.getFields()));
            data.set("samplingRate", om.valueToTree(this.getSamplingRate()));
            if (this.getRealtimeLogConfigName() != null) {
                data.set("realtimeLogConfigName", om.valueToTree(this.getRealtimeLogConfigName()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_cloudfront.RealtimeLogConfigProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            RealtimeLogConfigProps.Jsii$Proxy that = (RealtimeLogConfigProps.Jsii$Proxy) o;

            if (!endPoints.equals(that.endPoints)) return false;
            if (!fields.equals(that.fields)) return false;
            if (!samplingRate.equals(that.samplingRate)) return false;
            return this.realtimeLogConfigName != null ? this.realtimeLogConfigName.equals(that.realtimeLogConfigName) : that.realtimeLogConfigName == null;
        }

        @Override
        public final int hashCode() {
            int result = this.endPoints.hashCode();
            result = 31 * result + (this.fields.hashCode());
            result = 31 * result + (this.samplingRate.hashCode());
            result = 31 * result + (this.realtimeLogConfigName != null ? this.realtimeLogConfigName.hashCode() : 0);
            return result;
        }
    }
}
