package software.amazon.awscdk.services.cloudwatch;

/**
 * Properties for a TableWidget.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * Dashboard dashboard;
 * dashboard.addWidgets(TableWidget.Builder.create()
 *         // ...
 *         .layout(TableLayout.VERTICAL)
 *         .build());
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.109.0 (build c221850)", date = "2025-03-14T03:24:55.057Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_cloudwatch.TableWidgetProps")
@software.amazon.jsii.Jsii.Proxy(TableWidgetProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface TableWidgetProps extends software.amazon.jsii.JsiiSerializable, software.amazon.awscdk.services.cloudwatch.MetricWidgetProps {

    /**
     * The end of the time range to use for each widget independently from those of the dashboard.
     * <p>
     * If you specify a value for end, you must also specify a value for start.
     * Specify an absolute time in the ISO 8601 format. For example, 2018-12-17T06:00:00.000Z.
     * <p>
     * Default: When the dashboard loads, the end date will be the current time.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getEnd() {
        return null;
    }

    /**
     * Whether to show as many digits as can fit, before rounding.
     * <p>
     * Default: false
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getFullPrecision() {
        return null;
    }

    /**
     * Table layout.
     * <p>
     * Default: - TableLayout.HORIZONTAL
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cloudwatch.TableLayout getLayout() {
        return null;
    }

    /**
     * Whether the graph should show live data.
     * <p>
     * Default: false
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getLiveData() {
        return null;
    }

    /**
     * Metrics to display in the table.
     * <p>
     * Default: - No metrics
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.services.cloudwatch.IMetric> getMetrics() {
        return null;
    }

    /**
     * The default period for all metrics in this widget.
     * <p>
     * The period is the length of time represented by one data point on the graph.
     * This default can be overridden within each metric definition.
     * <p>
     * Default: cdk.Duration.seconds(300)
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.Duration getPeriod() {
        return null;
    }

    /**
     * Whether to show the value from the entire time range. Only applicable for Bar and Pie charts.
     * <p>
     * If false, values will be from the most recent period of your chosen time range;
     * if true, shows the value from the entire time range.
     * <p>
     * Default: false
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getSetPeriodToTimeRange() {
        return null;
    }

    /**
     * Show the metrics units in the label column.
     * <p>
     * Default: - false
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getShowUnitsInLabel() {
        return null;
    }

    /**
     * The start of the time range to use for each widget independently from those of the dashboard.
     * <p>
     * You can specify start without specifying end to specify a relative time range that ends with the current time.
     * In this case, the value of start must begin with -P, and you can use M, H, D, W and M as abbreviations for
     * minutes, hours, days, weeks and months. For example, -PT8H shows the last 8 hours and -P3M shows the last three months.
     * You can also use start along with an end field, to specify an absolute time range.
     * When specifying an absolute time range, use the ISO 8601 format. For example, 2018-12-17T06:00:00.000Z.
     * <p>
     * Default: When the dashboard loads, the start time will be the default time range.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getStart() {
        return null;
    }

    /**
     * The default statistic to be displayed for each metric.
     * <p>
     * This default can be overridden within the definition of each individual metric
     * <p>
     * Default: - The statistic for each metric is used
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getStatistic() {
        return null;
    }

    /**
     * Properties for displaying summary columns.
     * <p>
     * Default: - no summary columns are shown
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cloudwatch.TableSummaryProps getSummary() {
        return null;
    }

    /**
     * Thresholds for highlighting table cells.
     * <p>
     * Default: - No thresholds
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.services.cloudwatch.TableThreshold> getThresholds() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link TableWidgetProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link TableWidgetProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<TableWidgetProps> {
        java.lang.String end;
        java.lang.Boolean fullPrecision;
        software.amazon.awscdk.services.cloudwatch.TableLayout layout;
        java.lang.Boolean liveData;
        java.util.List<software.amazon.awscdk.services.cloudwatch.IMetric> metrics;
        software.amazon.awscdk.Duration period;
        java.lang.Boolean setPeriodToTimeRange;
        java.lang.Boolean showUnitsInLabel;
        java.lang.String start;
        java.lang.String statistic;
        software.amazon.awscdk.services.cloudwatch.TableSummaryProps summary;
        java.util.List<software.amazon.awscdk.services.cloudwatch.TableThreshold> thresholds;
        java.lang.Number height;
        java.lang.String region;
        java.lang.String title;
        java.lang.Number width;

        /**
         * Sets the value of {@link TableWidgetProps#getEnd}
         * @param end The end of the time range to use for each widget independently from those of the dashboard.
         *            If you specify a value for end, you must also specify a value for start.
         *            Specify an absolute time in the ISO 8601 format. For example, 2018-12-17T06:00:00.000Z.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder end(java.lang.String end) {
            this.end = end;
            return this;
        }

        /**
         * Sets the value of {@link TableWidgetProps#getFullPrecision}
         * @param fullPrecision Whether to show as many digits as can fit, before rounding.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder fullPrecision(java.lang.Boolean fullPrecision) {
            this.fullPrecision = fullPrecision;
            return this;
        }

        /**
         * Sets the value of {@link TableWidgetProps#getLayout}
         * @param layout Table layout.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder layout(software.amazon.awscdk.services.cloudwatch.TableLayout layout) {
            this.layout = layout;
            return this;
        }

        /**
         * Sets the value of {@link TableWidgetProps#getLiveData}
         * @param liveData Whether the graph should show live data.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder liveData(java.lang.Boolean liveData) {
            this.liveData = liveData;
            return this;
        }

        /**
         * Sets the value of {@link TableWidgetProps#getMetrics}
         * @param metrics Metrics to display in the table.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder metrics(java.util.List<? extends software.amazon.awscdk.services.cloudwatch.IMetric> metrics) {
            this.metrics = (java.util.List<software.amazon.awscdk.services.cloudwatch.IMetric>)metrics;
            return this;
        }

        /**
         * Sets the value of {@link TableWidgetProps#getPeriod}
         * @param period The default period for all metrics in this widget.
         *               The period is the length of time represented by one data point on the graph.
         *               This default can be overridden within each metric definition.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder period(software.amazon.awscdk.Duration period) {
            this.period = period;
            return this;
        }

        /**
         * Sets the value of {@link TableWidgetProps#getSetPeriodToTimeRange}
         * @param setPeriodToTimeRange Whether to show the value from the entire time range. Only applicable for Bar and Pie charts.
         *                             If false, values will be from the most recent period of your chosen time range;
         *                             if true, shows the value from the entire time range.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder setPeriodToTimeRange(java.lang.Boolean setPeriodToTimeRange) {
            this.setPeriodToTimeRange = setPeriodToTimeRange;
            return this;
        }

        /**
         * Sets the value of {@link TableWidgetProps#getShowUnitsInLabel}
         * @param showUnitsInLabel Show the metrics units in the label column.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder showUnitsInLabel(java.lang.Boolean showUnitsInLabel) {
            this.showUnitsInLabel = showUnitsInLabel;
            return this;
        }

        /**
         * Sets the value of {@link TableWidgetProps#getStart}
         * @param start The start of the time range to use for each widget independently from those of the dashboard.
         *              You can specify start without specifying end to specify a relative time range that ends with the current time.
         *              In this case, the value of start must begin with -P, and you can use M, H, D, W and M as abbreviations for
         *              minutes, hours, days, weeks and months. For example, -PT8H shows the last 8 hours and -P3M shows the last three months.
         *              You can also use start along with an end field, to specify an absolute time range.
         *              When specifying an absolute time range, use the ISO 8601 format. For example, 2018-12-17T06:00:00.000Z.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder start(java.lang.String start) {
            this.start = start;
            return this;
        }

        /**
         * Sets the value of {@link TableWidgetProps#getStatistic}
         * @param statistic The default statistic to be displayed for each metric.
         *                  This default can be overridden within the definition of each individual metric
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder statistic(java.lang.String statistic) {
            this.statistic = statistic;
            return this;
        }

        /**
         * Sets the value of {@link TableWidgetProps#getSummary}
         * @param summary Properties for displaying summary columns.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder summary(software.amazon.awscdk.services.cloudwatch.TableSummaryProps summary) {
            this.summary = summary;
            return this;
        }

        /**
         * Sets the value of {@link TableWidgetProps#getThresholds}
         * @param thresholds Thresholds for highlighting table cells.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder thresholds(java.util.List<? extends software.amazon.awscdk.services.cloudwatch.TableThreshold> thresholds) {
            this.thresholds = (java.util.List<software.amazon.awscdk.services.cloudwatch.TableThreshold>)thresholds;
            return this;
        }

        /**
         * Sets the value of {@link TableWidgetProps#getHeight}
         * @param height Height of the widget.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder height(java.lang.Number height) {
            this.height = height;
            return this;
        }

        /**
         * Sets the value of {@link TableWidgetProps#getRegion}
         * @param region The region the metrics of this graph should be taken from.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder region(java.lang.String region) {
            this.region = region;
            return this;
        }

        /**
         * Sets the value of {@link TableWidgetProps#getTitle}
         * @param title Title for the graph.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder title(java.lang.String title) {
            this.title = title;
            return this;
        }

        /**
         * Sets the value of {@link TableWidgetProps#getWidth}
         * @param width Width of the widget, in a grid of 24 units wide.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder width(java.lang.Number width) {
            this.width = width;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link TableWidgetProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public TableWidgetProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link TableWidgetProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements TableWidgetProps {
        private final java.lang.String end;
        private final java.lang.Boolean fullPrecision;
        private final software.amazon.awscdk.services.cloudwatch.TableLayout layout;
        private final java.lang.Boolean liveData;
        private final java.util.List<software.amazon.awscdk.services.cloudwatch.IMetric> metrics;
        private final software.amazon.awscdk.Duration period;
        private final java.lang.Boolean setPeriodToTimeRange;
        private final java.lang.Boolean showUnitsInLabel;
        private final java.lang.String start;
        private final java.lang.String statistic;
        private final software.amazon.awscdk.services.cloudwatch.TableSummaryProps summary;
        private final java.util.List<software.amazon.awscdk.services.cloudwatch.TableThreshold> thresholds;
        private final java.lang.Number height;
        private final java.lang.String region;
        private final java.lang.String title;
        private final java.lang.Number width;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.end = software.amazon.jsii.Kernel.get(this, "end", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.fullPrecision = software.amazon.jsii.Kernel.get(this, "fullPrecision", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.layout = software.amazon.jsii.Kernel.get(this, "layout", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.TableLayout.class));
            this.liveData = software.amazon.jsii.Kernel.get(this, "liveData", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.metrics = software.amazon.jsii.Kernel.get(this, "metrics", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.IMetric.class)));
            this.period = software.amazon.jsii.Kernel.get(this, "period", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.Duration.class));
            this.setPeriodToTimeRange = software.amazon.jsii.Kernel.get(this, "setPeriodToTimeRange", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.showUnitsInLabel = software.amazon.jsii.Kernel.get(this, "showUnitsInLabel", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.start = software.amazon.jsii.Kernel.get(this, "start", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.statistic = software.amazon.jsii.Kernel.get(this, "statistic", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.summary = software.amazon.jsii.Kernel.get(this, "summary", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.TableSummaryProps.class));
            this.thresholds = software.amazon.jsii.Kernel.get(this, "thresholds", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.TableThreshold.class)));
            this.height = software.amazon.jsii.Kernel.get(this, "height", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            this.region = software.amazon.jsii.Kernel.get(this, "region", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.title = software.amazon.jsii.Kernel.get(this, "title", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.width = software.amazon.jsii.Kernel.get(this, "width", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.end = builder.end;
            this.fullPrecision = builder.fullPrecision;
            this.layout = builder.layout;
            this.liveData = builder.liveData;
            this.metrics = (java.util.List<software.amazon.awscdk.services.cloudwatch.IMetric>)builder.metrics;
            this.period = builder.period;
            this.setPeriodToTimeRange = builder.setPeriodToTimeRange;
            this.showUnitsInLabel = builder.showUnitsInLabel;
            this.start = builder.start;
            this.statistic = builder.statistic;
            this.summary = builder.summary;
            this.thresholds = (java.util.List<software.amazon.awscdk.services.cloudwatch.TableThreshold>)builder.thresholds;
            this.height = builder.height;
            this.region = builder.region;
            this.title = builder.title;
            this.width = builder.width;
        }

        @Override
        public final java.lang.String getEnd() {
            return this.end;
        }

        @Override
        public final java.lang.Boolean getFullPrecision() {
            return this.fullPrecision;
        }

        @Override
        public final software.amazon.awscdk.services.cloudwatch.TableLayout getLayout() {
            return this.layout;
        }

        @Override
        public final java.lang.Boolean getLiveData() {
            return this.liveData;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.services.cloudwatch.IMetric> getMetrics() {
            return this.metrics;
        }

        @Override
        public final software.amazon.awscdk.Duration getPeriod() {
            return this.period;
        }

        @Override
        public final java.lang.Boolean getSetPeriodToTimeRange() {
            return this.setPeriodToTimeRange;
        }

        @Override
        public final java.lang.Boolean getShowUnitsInLabel() {
            return this.showUnitsInLabel;
        }

        @Override
        public final java.lang.String getStart() {
            return this.start;
        }

        @Override
        public final java.lang.String getStatistic() {
            return this.statistic;
        }

        @Override
        public final software.amazon.awscdk.services.cloudwatch.TableSummaryProps getSummary() {
            return this.summary;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.services.cloudwatch.TableThreshold> getThresholds() {
            return this.thresholds;
        }

        @Override
        public final java.lang.Number getHeight() {
            return this.height;
        }

        @Override
        public final java.lang.String getRegion() {
            return this.region;
        }

        @Override
        public final java.lang.String getTitle() {
            return this.title;
        }

        @Override
        public final java.lang.Number getWidth() {
            return this.width;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            if (this.getEnd() != null) {
                data.set("end", om.valueToTree(this.getEnd()));
            }
            if (this.getFullPrecision() != null) {
                data.set("fullPrecision", om.valueToTree(this.getFullPrecision()));
            }
            if (this.getLayout() != null) {
                data.set("layout", om.valueToTree(this.getLayout()));
            }
            if (this.getLiveData() != null) {
                data.set("liveData", om.valueToTree(this.getLiveData()));
            }
            if (this.getMetrics() != null) {
                data.set("metrics", om.valueToTree(this.getMetrics()));
            }
            if (this.getPeriod() != null) {
                data.set("period", om.valueToTree(this.getPeriod()));
            }
            if (this.getSetPeriodToTimeRange() != null) {
                data.set("setPeriodToTimeRange", om.valueToTree(this.getSetPeriodToTimeRange()));
            }
            if (this.getShowUnitsInLabel() != null) {
                data.set("showUnitsInLabel", om.valueToTree(this.getShowUnitsInLabel()));
            }
            if (this.getStart() != null) {
                data.set("start", om.valueToTree(this.getStart()));
            }
            if (this.getStatistic() != null) {
                data.set("statistic", om.valueToTree(this.getStatistic()));
            }
            if (this.getSummary() != null) {
                data.set("summary", om.valueToTree(this.getSummary()));
            }
            if (this.getThresholds() != null) {
                data.set("thresholds", om.valueToTree(this.getThresholds()));
            }
            if (this.getHeight() != null) {
                data.set("height", om.valueToTree(this.getHeight()));
            }
            if (this.getRegion() != null) {
                data.set("region", om.valueToTree(this.getRegion()));
            }
            if (this.getTitle() != null) {
                data.set("title", om.valueToTree(this.getTitle()));
            }
            if (this.getWidth() != null) {
                data.set("width", om.valueToTree(this.getWidth()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_cloudwatch.TableWidgetProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            TableWidgetProps.Jsii$Proxy that = (TableWidgetProps.Jsii$Proxy) o;

            if (this.end != null ? !this.end.equals(that.end) : that.end != null) return false;
            if (this.fullPrecision != null ? !this.fullPrecision.equals(that.fullPrecision) : that.fullPrecision != null) return false;
            if (this.layout != null ? !this.layout.equals(that.layout) : that.layout != null) return false;
            if (this.liveData != null ? !this.liveData.equals(that.liveData) : that.liveData != null) return false;
            if (this.metrics != null ? !this.metrics.equals(that.metrics) : that.metrics != null) return false;
            if (this.period != null ? !this.period.equals(that.period) : that.period != null) return false;
            if (this.setPeriodToTimeRange != null ? !this.setPeriodToTimeRange.equals(that.setPeriodToTimeRange) : that.setPeriodToTimeRange != null) return false;
            if (this.showUnitsInLabel != null ? !this.showUnitsInLabel.equals(that.showUnitsInLabel) : that.showUnitsInLabel != null) return false;
            if (this.start != null ? !this.start.equals(that.start) : that.start != null) return false;
            if (this.statistic != null ? !this.statistic.equals(that.statistic) : that.statistic != null) return false;
            if (this.summary != null ? !this.summary.equals(that.summary) : that.summary != null) return false;
            if (this.thresholds != null ? !this.thresholds.equals(that.thresholds) : that.thresholds != null) return false;
            if (this.height != null ? !this.height.equals(that.height) : that.height != null) return false;
            if (this.region != null ? !this.region.equals(that.region) : that.region != null) return false;
            if (this.title != null ? !this.title.equals(that.title) : that.title != null) return false;
            return this.width != null ? this.width.equals(that.width) : that.width == null;
        }

        @Override
        public final int hashCode() {
            int result = this.end != null ? this.end.hashCode() : 0;
            result = 31 * result + (this.fullPrecision != null ? this.fullPrecision.hashCode() : 0);
            result = 31 * result + (this.layout != null ? this.layout.hashCode() : 0);
            result = 31 * result + (this.liveData != null ? this.liveData.hashCode() : 0);
            result = 31 * result + (this.metrics != null ? this.metrics.hashCode() : 0);
            result = 31 * result + (this.period != null ? this.period.hashCode() : 0);
            result = 31 * result + (this.setPeriodToTimeRange != null ? this.setPeriodToTimeRange.hashCode() : 0);
            result = 31 * result + (this.showUnitsInLabel != null ? this.showUnitsInLabel.hashCode() : 0);
            result = 31 * result + (this.start != null ? this.start.hashCode() : 0);
            result = 31 * result + (this.statistic != null ? this.statistic.hashCode() : 0);
            result = 31 * result + (this.summary != null ? this.summary.hashCode() : 0);
            result = 31 * result + (this.thresholds != null ? this.thresholds.hashCode() : 0);
            result = 31 * result + (this.height != null ? this.height.hashCode() : 0);
            result = 31 * result + (this.region != null ? this.region.hashCode() : 0);
            result = 31 * result + (this.title != null ? this.title.hashCode() : 0);
            result = 31 * result + (this.width != null ? this.width.hashCode() : 0);
            return result;
        }
    }
}
