package software.amazon.awscdk.services.codebuild;

/**
 * The ReportGroup resource class.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * Source source;
 * // create a new ReportGroup
 * ReportGroup reportGroup = new ReportGroup(this, "ReportGroup");
 * Project project = Project.Builder.create(this, "Project")
 *         .source(source)
 *         .buildSpec(BuildSpec.fromObject(Map.of(
 *                 // ...
 *                 "reports", Map.of(
 *                         reportGroup.getReportGroupArn(), Map.of(
 *                                 "files", "**&#47;*",
 *                                 "base-directory", "build/test-results")))))
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.109.0 (build c221850)", date = "2025-03-14T03:24:55.206Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_codebuild.ReportGroup")
public class ReportGroup extends software.amazon.awscdk.Resource implements software.amazon.awscdk.services.codebuild.IReportGroup {

    protected ReportGroup(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected ReportGroup(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * @param scope This parameter is required.
     * @param id This parameter is required.
     * @param props
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public ReportGroup(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.codebuild.ReportGroupProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), props });
    }

    /**
     * @param scope This parameter is required.
     * @param id This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public ReportGroup(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required") });
    }

    /**
     * Reference an existing ReportGroup, defined outside of the CDK code, by name.
     * <p>
     * @param scope This parameter is required.
     * @param id This parameter is required.
     * @param reportGroupName This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.codebuild.IReportGroup fromReportGroupName(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull java.lang.String reportGroupName) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.codebuild.ReportGroup.class, "fromReportGroupName", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.codebuild.IReportGroup.class), new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(reportGroupName, "reportGroupName is required") });
    }

    /**
     * Grants the given entity permissions to write (that is, upload reports to) this report group.
     * <p>
     * @param identity This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.Grant grantWrite(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.IGrantable identity) {
        return software.amazon.jsii.Kernel.call(this, "grantWrite", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.iam.Grant.class), new Object[] { java.util.Objects.requireNonNull(identity, "identity is required") });
    }

    /**
     * The ARN of the ReportGroup.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getReportGroupArn() {
        return software.amazon.jsii.Kernel.get(this, "reportGroupArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The name of the ReportGroup.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getReportGroupName() {
        return software.amazon.jsii.Kernel.get(this, "reportGroupName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.s3.IBucket getExportBucket() {
        return software.amazon.jsii.Kernel.get(this, "exportBucket", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.s3.IBucket.class));
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.codebuild.ReportGroupType getType() {
        return software.amazon.jsii.Kernel.get(this, "type", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.codebuild.ReportGroupType.class));
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.codebuild.ReportGroup}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.codebuild.ReportGroup> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope This parameter is required.
         * @param id This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private software.amazon.awscdk.services.codebuild.ReportGroupProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
        }

        /**
         * If true, deleting the report group force deletes the contents of the report group.
         * <p>
         * If false, the report group must be empty before attempting to delete it.
         * <p>
         * Default: false
         * <p>
         * @return {@code this}
         * @param deleteReports If true, deleting the report group force deletes the contents of the report group. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder deleteReports(final java.lang.Boolean deleteReports) {
            this.props().deleteReports(deleteReports);
            return this;
        }

        /**
         * An optional S3 bucket to export the reports to.
         * <p>
         * Default: - the reports will not be exported
         * <p>
         * @return {@code this}
         * @param exportBucket An optional S3 bucket to export the reports to. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder exportBucket(final software.amazon.awscdk.services.s3.IBucket exportBucket) {
            this.props().exportBucket(exportBucket);
            return this;
        }

        /**
         * What to do when this resource is deleted from a stack.
         * <p>
         * As CodeBuild does not allow deleting a ResourceGroup that has reports inside of it,
         * this is set to retain the resource by default.
         * <p>
         * Default: RemovalPolicy.RETAIN
         * <p>
         * @return {@code this}
         * @param removalPolicy What to do when this resource is deleted from a stack. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder removalPolicy(final software.amazon.awscdk.RemovalPolicy removalPolicy) {
            this.props().removalPolicy(removalPolicy);
            return this;
        }

        /**
         * The physical name of the report group.
         * <p>
         * Default: - CloudFormation-generated name
         * <p>
         * @return {@code this}
         * @param reportGroupName The physical name of the report group. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder reportGroupName(final java.lang.String reportGroupName) {
            this.props().reportGroupName(reportGroupName);
            return this;
        }

        /**
         * The type of report group. This can be one of the following values:.
         * <p>
         * <ul>
         * <li><strong>TEST</strong> - The report group contains test reports.</li>
         * <li><strong>CODE_COVERAGE</strong> - The report group contains code coverage reports.</li>
         * </ul>
         * <p>
         * Default: TEST
         * <p>
         * @return {@code this}
         * @param type The type of report group. This can be one of the following values:. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder type(final software.amazon.awscdk.services.codebuild.ReportGroupType type) {
            this.props().type(type);
            return this;
        }

        /**
         * Whether to output the report files into the export bucket as-is, or create a ZIP from them before doing the export.
         * <p>
         * Ignored if <code>exportBucket</code> has not been provided.
         * <p>
         * Default: - false (the files will not be ZIPped)
         * <p>
         * @return {@code this}
         * @param zipExport Whether to output the report files into the export bucket as-is, or create a ZIP from them before doing the export. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder zipExport(final java.lang.Boolean zipExport) {
            this.props().zipExport(zipExport);
            return this;
        }

        /**
         * @return a newly built instance of {@link software.amazon.awscdk.services.codebuild.ReportGroup}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.codebuild.ReportGroup build() {
            return new software.amazon.awscdk.services.codebuild.ReportGroup(
                this.scope,
                this.id,
                this.props != null ? this.props.build() : null
            );
        }

        private software.amazon.awscdk.services.codebuild.ReportGroupProps.Builder props() {
            if (this.props == null) {
                this.props = new software.amazon.awscdk.services.codebuild.ReportGroupProps.Builder();
            }
            return this.props;
        }
    }
}
