package software.amazon.awscdk.services.codepipeline;

/**
 * An AWS CodePipeline pipeline with its associated IAM role and S3 bucket.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // create a pipeline
 * import software.amazon.awscdk.services.codecommit.*;
 * // add a source action to the stage
 * Repository repo;
 * Artifact sourceArtifact;
 * Pipeline pipeline = new Pipeline(this, "Pipeline");
 * // add a stage
 * IStage sourceStage = pipeline.addStage(StageOptions.builder().stageName("Source").build());
 * sourceStage.addAction(CodeCommitSourceAction.Builder.create()
 *         .actionName("Source")
 *         .output(sourceArtifact)
 *         .repository(repo)
 *         .build());
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.109.0 (build c221850)", date = "2025-03-14T03:24:55.404Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_codepipeline.Pipeline")
public class Pipeline extends software.amazon.awscdk.Resource implements software.amazon.awscdk.services.codepipeline.IPipeline {

    protected Pipeline(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected Pipeline(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * @param scope This parameter is required.
     * @param id This parameter is required.
     * @param props
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public Pipeline(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.codepipeline.PipelineProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), props });
    }

    /**
     * @param scope This parameter is required.
     * @param id This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public Pipeline(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required") });
    }

    /**
     * Import a pipeline into this app.
     * <p>
     * @param scope the scope into which to import this pipeline. This parameter is required.
     * @param id the logical ID of the returned pipeline construct. This parameter is required.
     * @param pipelineArn The ARN of the pipeline (e.g. <code>arn:aws:codepipeline:us-east-1:123456789012:MyDemoPipeline</code>). This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.codepipeline.IPipeline fromPipelineArn(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull java.lang.String pipelineArn) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.codepipeline.Pipeline.class, "fromPipelineArn", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.codepipeline.IPipeline.class), new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(pipelineArn, "pipelineArn is required") });
    }

    /**
     * Creates a new Stage, and adds it to this Pipeline.
     * <p>
     * @return the newly created Stage
     * @param props the creation properties of the new Stage. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.codepipeline.IStage addStage(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.codepipeline.StageOptions props) {
        return software.amazon.jsii.Kernel.call(this, "addStage", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.codepipeline.IStage.class), new Object[] { java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Adds a statement to the pipeline role.
     * <p>
     * @param statement This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void addToRolePolicy(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.PolicyStatement statement) {
        software.amazon.jsii.Kernel.call(this, "addToRolePolicy", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(statement, "statement is required") });
    }

    /**
     * Adds a new Trigger to this Pipeline.
     * <p>
     * @return the newly created trigger
     * @param props Trigger property to add to this Pipeline. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.codepipeline.Trigger addTrigger(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.codepipeline.TriggerProps props) {
        return software.amazon.jsii.Kernel.call(this, "addTrigger", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.codepipeline.Trigger.class), new Object[] { java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Adds a new Variable to this Pipeline.
     * <p>
     * @return the newly created variable
     * @param variable Variable instance to add to this Pipeline. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.codepipeline.Variable addVariable(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.codepipeline.Variable variable) {
        return software.amazon.jsii.Kernel.call(this, "addVariable", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.codepipeline.Variable.class), new Object[] { java.util.Objects.requireNonNull(variable, "variable is required") });
    }

    /**
     * Returns a source configuration for notification rule.
     * <p>
     * @param _scope This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.codestarnotifications.NotificationRuleSourceConfig bindAsNotificationRuleSource(final @org.jetbrains.annotations.NotNull software.constructs.Construct _scope) {
        return software.amazon.jsii.Kernel.call(this, "bindAsNotificationRuleSource", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.codestarnotifications.NotificationRuleSourceConfig.class), new Object[] { java.util.Objects.requireNonNull(_scope, "_scope is required") });
    }

    /**
     * Defines a CodeStar notification rule triggered when the pipeline events emitted by you specified, it very similar to <code>onEvent</code> API.
     * <p>
     * You can also use the methods <code>notifyOnExecutionStateChange</code>, <code>notifyOnAnyStageStateChange</code>,
     * <code>notifyOnAnyActionStateChange</code> and <code>notifyOnAnyManualApprovalStateChange</code>
     * to define rules for these specific event emitted.
     * <p>
     * @param id This parameter is required.
     * @param target This parameter is required.
     * @param options This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.codestarnotifications.INotificationRule notifyOn(final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.codestarnotifications.INotificationRuleTarget target, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.codepipeline.PipelineNotifyOnOptions options) {
        return software.amazon.jsii.Kernel.call(this, "notifyOn", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.codestarnotifications.INotificationRule.class), new Object[] { java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(target, "target is required"), java.util.Objects.requireNonNull(options, "options is required") });
    }

    /**
     * Define an notification rule triggered by the set of the "Action execution" events emitted from this pipeline.
     * <p>
     * @param id This parameter is required.
     * @param target This parameter is required.
     * @param options
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.codestarnotifications.INotificationRule notifyOnAnyActionStateChange(final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.codestarnotifications.INotificationRuleTarget target, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.codestarnotifications.NotificationRuleOptions options) {
        return software.amazon.jsii.Kernel.call(this, "notifyOnAnyActionStateChange", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.codestarnotifications.INotificationRule.class), new Object[] { java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(target, "target is required"), options });
    }

    /**
     * Define an notification rule triggered by the set of the "Action execution" events emitted from this pipeline.
     * <p>
     * @param id This parameter is required.
     * @param target This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.codestarnotifications.INotificationRule notifyOnAnyActionStateChange(final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.codestarnotifications.INotificationRuleTarget target) {
        return software.amazon.jsii.Kernel.call(this, "notifyOnAnyActionStateChange", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.codestarnotifications.INotificationRule.class), new Object[] { java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(target, "target is required") });
    }

    /**
     * Define an notification rule triggered by the set of the "Manual approval" events emitted from this pipeline.
     * <p>
     * @param id This parameter is required.
     * @param target This parameter is required.
     * @param options
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.codestarnotifications.INotificationRule notifyOnAnyManualApprovalStateChange(final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.codestarnotifications.INotificationRuleTarget target, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.codestarnotifications.NotificationRuleOptions options) {
        return software.amazon.jsii.Kernel.call(this, "notifyOnAnyManualApprovalStateChange", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.codestarnotifications.INotificationRule.class), new Object[] { java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(target, "target is required"), options });
    }

    /**
     * Define an notification rule triggered by the set of the "Manual approval" events emitted from this pipeline.
     * <p>
     * @param id This parameter is required.
     * @param target This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.codestarnotifications.INotificationRule notifyOnAnyManualApprovalStateChange(final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.codestarnotifications.INotificationRuleTarget target) {
        return software.amazon.jsii.Kernel.call(this, "notifyOnAnyManualApprovalStateChange", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.codestarnotifications.INotificationRule.class), new Object[] { java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(target, "target is required") });
    }

    /**
     * Define an notification rule triggered by the set of the "Stage execution" events emitted from this pipeline.
     * <p>
     * @param id This parameter is required.
     * @param target This parameter is required.
     * @param options
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.codestarnotifications.INotificationRule notifyOnAnyStageStateChange(final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.codestarnotifications.INotificationRuleTarget target, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.codestarnotifications.NotificationRuleOptions options) {
        return software.amazon.jsii.Kernel.call(this, "notifyOnAnyStageStateChange", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.codestarnotifications.INotificationRule.class), new Object[] { java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(target, "target is required"), options });
    }

    /**
     * Define an notification rule triggered by the set of the "Stage execution" events emitted from this pipeline.
     * <p>
     * @param id This parameter is required.
     * @param target This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.codestarnotifications.INotificationRule notifyOnAnyStageStateChange(final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.codestarnotifications.INotificationRuleTarget target) {
        return software.amazon.jsii.Kernel.call(this, "notifyOnAnyStageStateChange", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.codestarnotifications.INotificationRule.class), new Object[] { java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(target, "target is required") });
    }

    /**
     * Define an notification rule triggered by the set of the "Pipeline execution" events emitted from this pipeline.
     * <p>
     * @param id This parameter is required.
     * @param target This parameter is required.
     * @param options
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.codestarnotifications.INotificationRule notifyOnExecutionStateChange(final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.codestarnotifications.INotificationRuleTarget target, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.codestarnotifications.NotificationRuleOptions options) {
        return software.amazon.jsii.Kernel.call(this, "notifyOnExecutionStateChange", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.codestarnotifications.INotificationRule.class), new Object[] { java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(target, "target is required"), options });
    }

    /**
     * Define an notification rule triggered by the set of the "Pipeline execution" events emitted from this pipeline.
     * <p>
     * @param id This parameter is required.
     * @param target This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.codestarnotifications.INotificationRule notifyOnExecutionStateChange(final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.codestarnotifications.INotificationRuleTarget target) {
        return software.amazon.jsii.Kernel.call(this, "notifyOnExecutionStateChange", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.codestarnotifications.INotificationRule.class), new Object[] { java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(target, "target is required") });
    }

    /**
     * Defines an event rule triggered by this CodePipeline.
     * <p>
     * @param id Identifier for this event handler. This parameter is required.
     * @param options Additional options to pass to the event rule.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.events.Rule onEvent(final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.events.OnEventOptions options) {
        return software.amazon.jsii.Kernel.call(this, "onEvent", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.events.Rule.class), new Object[] { java.util.Objects.requireNonNull(id, "id is required"), options });
    }

    /**
     * Defines an event rule triggered by this CodePipeline.
     * <p>
     * @param id Identifier for this event handler. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.events.Rule onEvent(final @org.jetbrains.annotations.NotNull java.lang.String id) {
        return software.amazon.jsii.Kernel.call(this, "onEvent", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.events.Rule.class), new Object[] { java.util.Objects.requireNonNull(id, "id is required") });
    }

    /**
     * Defines an event rule triggered by the "CodePipeline Pipeline Execution State Change" event emitted from this pipeline.
     * <p>
     * @param id Identifier for this event handler. This parameter is required.
     * @param options Additional options to pass to the event rule.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.events.Rule onStateChange(final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.events.OnEventOptions options) {
        return software.amazon.jsii.Kernel.call(this, "onStateChange", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.events.Rule.class), new Object[] { java.util.Objects.requireNonNull(id, "id is required"), options });
    }

    /**
     * Defines an event rule triggered by the "CodePipeline Pipeline Execution State Change" event emitted from this pipeline.
     * <p>
     * @param id Identifier for this event handler. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.events.Rule onStateChange(final @org.jetbrains.annotations.NotNull java.lang.String id) {
        return software.amazon.jsii.Kernel.call(this, "onStateChange", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.events.Rule.class), new Object[] { java.util.Objects.requireNonNull(id, "id is required") });
    }

    /**
     * Access one of the pipeline's stages by stage name.
     * <p>
     * @param stageName This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.codepipeline.IStage stage(final @org.jetbrains.annotations.NotNull java.lang.String stageName) {
        return software.amazon.jsii.Kernel.call(this, "stage", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.codepipeline.IStage.class), new Object[] { java.util.Objects.requireNonNull(stageName, "stageName is required") });
    }

    /**
     * Bucket used to store output artifacts.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.s3.IBucket getArtifactBucket() {
        return software.amazon.jsii.Kernel.get(this, "artifactBucket", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.s3.IBucket.class));
    }

    /**
     * Returns all of the <code>CrossRegionSupportStack</code>s that were generated automatically when dealing with Actions that reside in a different region than the Pipeline itself.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, software.amazon.awscdk.services.codepipeline.CrossRegionSupport> getCrossRegionSupport() {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.get(this, "crossRegionSupport", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.codepipeline.CrossRegionSupport.class))));
    }

    /**
     * ARN of this pipeline.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getPipelineArn() {
        return software.amazon.jsii.Kernel.get(this, "pipelineArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The name of the pipeline.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getPipelineName() {
        return software.amazon.jsii.Kernel.get(this, "pipelineName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The version of the pipeline.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getPipelineVersion() {
        return software.amazon.jsii.Kernel.get(this, "pipelineVersion", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The IAM role AWS CodePipeline will use to perform actions or assume roles for actions with a more specific IAM role.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.IRole getRole() {
        return software.amazon.jsii.Kernel.get(this, "role", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.iam.IRole.class));
    }

    /**
     * Get the number of Stages in this Pipeline.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.Number getStageCount() {
        return software.amazon.jsii.Kernel.get(this, "stageCount", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
    }

    /**
     * Returns the stages that comprise the pipeline.
     * <p>
     * <strong>Note</strong>: the returned array is a defensive copy,
     * so adding elements to it has no effect.
     * Instead, use the <code>addStage</code> method if you want to add more stages
     * to the pipeline.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.util.List<software.amazon.awscdk.services.codepipeline.IStage> getStages() {
        return java.util.Collections.unmodifiableList(software.amazon.jsii.Kernel.get(this, "stages", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.codepipeline.IStage.class))));
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.codepipeline.Pipeline}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.codepipeline.Pipeline> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope This parameter is required.
         * @param id This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private software.amazon.awscdk.services.codepipeline.PipelineProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
        }

        /**
         * The S3 bucket used by this Pipeline to store artifacts.
         * <p>
         * Default: - A new S3 bucket will be created.
         * <p>
         * @return {@code this}
         * @param artifactBucket The S3 bucket used by this Pipeline to store artifacts. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder artifactBucket(final software.amazon.awscdk.services.s3.IBucket artifactBucket) {
            this.props().artifactBucket(artifactBucket);
            return this;
        }

        /**
         * Create KMS keys for cross-account deployments.
         * <p>
         * This controls whether the pipeline is enabled for cross-account deployments.
         * <p>
         * By default cross-account deployments are enabled, but this feature requires
         * that KMS Customer Master Keys are created which have a cost of $1/month.
         * <p>
         * If you do not need cross-account deployments, you can set this to <code>false</code> to
         * not create those keys and save on that cost (the artifact bucket will be
         * encrypted with an AWS-managed key). However, cross-account deployments will
         * no longer be possible.
         * <p>
         * Default: false - false if the feature flag `CODEPIPELINE_CROSS_ACCOUNT_KEYS_DEFAULT_VALUE_TO_FALSE`
         * is true, true otherwise
         * <p>
         * @return {@code this}
         * @param crossAccountKeys Create KMS keys for cross-account deployments. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder crossAccountKeys(final java.lang.Boolean crossAccountKeys) {
            this.props().crossAccountKeys(crossAccountKeys);
            return this;
        }

        /**
         * A map of region to S3 bucket name used for cross-region CodePipeline.
         * <p>
         * For every Action that you specify targeting a different region than the Pipeline itself,
         * if you don't provide an explicit Bucket for that region using this property,
         * the construct will automatically create a Stack containing an S3 Bucket in that region.
         * <p>
         * Default: - None.
         * <p>
         * @return {@code this}
         * @param crossRegionReplicationBuckets A map of region to S3 bucket name used for cross-region CodePipeline. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder crossRegionReplicationBuckets(final java.util.Map<java.lang.String, ? extends software.amazon.awscdk.services.s3.IBucket> crossRegionReplicationBuckets) {
            this.props().crossRegionReplicationBuckets(crossRegionReplicationBuckets);
            return this;
        }

        /**
         * Enable KMS key rotation for the generated KMS keys.
         * <p>
         * By default KMS key rotation is disabled, but will add an additional $1/month
         * for each year the key exists when enabled.
         * <p>
         * Default: - false (key rotation is disabled)
         * <p>
         * @return {@code this}
         * @param enableKeyRotation Enable KMS key rotation for the generated KMS keys. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder enableKeyRotation(final java.lang.Boolean enableKeyRotation) {
            this.props().enableKeyRotation(enableKeyRotation);
            return this;
        }

        /**
         * The method that the pipeline will use to handle multiple executions.
         * <p>
         * Default: - ExecutionMode.SUPERSEDED
         * <p>
         * @return {@code this}
         * @param executionMode The method that the pipeline will use to handle multiple executions. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder executionMode(final software.amazon.awscdk.services.codepipeline.ExecutionMode executionMode) {
            this.props().executionMode(executionMode);
            return this;
        }

        /**
         * Name of the pipeline.
         * <p>
         * Default: - AWS CloudFormation generates an ID and uses that for the pipeline name.
         * <p>
         * @return {@code this}
         * @param pipelineName Name of the pipeline. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder pipelineName(final java.lang.String pipelineName) {
            this.props().pipelineName(pipelineName);
            return this;
        }

        /**
         * Type of the pipeline.
         * <p>
         * Default: - PipelineType.V2 if the feature flag `CODEPIPELINE_DEFAULT_PIPELINE_TYPE_TO_V2`
         * is true, PipelineType.V1 otherwise
         * <p>
         * @return {@code this}
         * @see <a href="https://docs.aws.amazon.com/codepipeline/latest/userguide/pipeline-types-planning.html">https://docs.aws.amazon.com/codepipeline/latest/userguide/pipeline-types-planning.html</a>
         * @param pipelineType Type of the pipeline. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder pipelineType(final software.amazon.awscdk.services.codepipeline.PipelineType pipelineType) {
            this.props().pipelineType(pipelineType);
            return this;
        }

        /**
         * Indicates whether to rerun the AWS CodePipeline pipeline after you update it.
         * <p>
         * Default: false
         * <p>
         * @return {@code this}
         * @param restartExecutionOnUpdate Indicates whether to rerun the AWS CodePipeline pipeline after you update it. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder restartExecutionOnUpdate(final java.lang.Boolean restartExecutionOnUpdate) {
            this.props().restartExecutionOnUpdate(restartExecutionOnUpdate);
            return this;
        }

        /**
         * Reuse the same cross region support stack for all pipelines in the App.
         * <p>
         * Default: - true (Use the same support stack for all pipelines in App)
         * <p>
         * @return {@code this}
         * @param reuseCrossRegionSupportStacks Reuse the same cross region support stack for all pipelines in the App. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder reuseCrossRegionSupportStacks(final java.lang.Boolean reuseCrossRegionSupportStacks) {
            this.props().reuseCrossRegionSupportStacks(reuseCrossRegionSupportStacks);
            return this;
        }

        /**
         * The IAM role to be assumed by this Pipeline.
         * <p>
         * Default: a new IAM role will be created.
         * <p>
         * @return {@code this}
         * @param role The IAM role to be assumed by this Pipeline. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder role(final software.amazon.awscdk.services.iam.IRole role) {
            this.props().role(role);
            return this;
        }

        /**
         * The list of Stages, in order, to create this Pipeline with.
         * <p>
         * You can always add more Stages later by calling <code>Pipeline#addStage</code>.
         * <p>
         * Default: - None.
         * <p>
         * @return {@code this}
         * @param stages The list of Stages, in order, to create this Pipeline with. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder stages(final java.util.List<? extends software.amazon.awscdk.services.codepipeline.StageProps> stages) {
            this.props().stages(stages);
            return this;
        }

        /**
         * The trigger configuration specifying a type of event, such as Git tags, that starts the pipeline.
         * <p>
         * When a trigger configuration is specified, default change detection for repository
         * and branch commits is disabled.
         * <p>
         * <code>triggers</code> can only be used when <code>pipelineType</code> is set to <code>PipelineType.V2</code>.
         * You can always add more triggers later by calling <code>Pipeline#addTrigger</code>.
         * <p>
         * Default: - No triggers
         * <p>
         * @return {@code this}
         * @param triggers The trigger configuration specifying a type of event, such as Git tags, that starts the pipeline. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder triggers(final java.util.List<? extends software.amazon.awscdk.services.codepipeline.TriggerProps> triggers) {
            this.props().triggers(triggers);
            return this;
        }

        /**
         * A list that defines the pipeline variables for a pipeline resource.
         * <p>
         * <code>variables</code> can only be used when <code>pipelineType</code> is set to <code>PipelineType.V2</code>.
         * You can always add more variables later by calling <code>Pipeline#addVariable</code>.
         * <p>
         * Default: - No variables
         * <p>
         * @return {@code this}
         * @param variables A list that defines the pipeline variables for a pipeline resource. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder variables(final java.util.List<? extends software.amazon.awscdk.services.codepipeline.Variable> variables) {
            this.props().variables(variables);
            return this;
        }

        /**
         * @return a newly built instance of {@link software.amazon.awscdk.services.codepipeline.Pipeline}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.codepipeline.Pipeline build() {
            return new software.amazon.awscdk.services.codepipeline.Pipeline(
                this.scope,
                this.id,
                this.props != null ? this.props.build() : null
            );
        }

        private software.amazon.awscdk.services.codepipeline.PipelineProps.Builder props() {
            if (this.props == null) {
                this.props = new software.amazon.awscdk.services.codepipeline.PipelineProps.Builder();
            }
            return this.props;
        }
    }
}
