package software.amazon.awscdk.services.codepipeline.actions;

/**
 * A CodePipeline source action for the CodeStar Connections source, which allows connecting to GitHub and BitBucket.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * Artifact sourceOutput = new Artifact();
 * CodeStarConnectionsSourceAction sourceAction = CodeStarConnectionsSourceAction.Builder.create()
 *         .actionName("BitBucket_Source")
 *         .owner("aws")
 *         .repo("aws-cdk")
 *         .output(sourceOutput)
 *         .connectionArn("arn:aws:codestar-connections:us-east-1:123456789012:connection/12345678-abcd-12ab-34cdef5678gh")
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.109.0 (build c221850)", date = "2025-03-14T03:24:55.481Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_codepipeline_actions.CodeStarConnectionsSourceAction")
public class CodeStarConnectionsSourceAction extends software.amazon.awscdk.services.codepipeline.actions.Action {

    protected CodeStarConnectionsSourceAction(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CodeStarConnectionsSourceAction(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public CodeStarConnectionsSourceAction(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.codepipeline.actions.CodeStarConnectionsSourceActionProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * This is a renamed version of the <code>IAction.bind</code> method.
     * <p>
     * @param _scope This parameter is required.
     * @param _stage This parameter is required.
     * @param options This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    protected @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.codepipeline.ActionConfig bound(final @org.jetbrains.annotations.NotNull software.constructs.Construct _scope, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.codepipeline.IStage _stage, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.codepipeline.ActionBindOptions options) {
        return software.amazon.jsii.Kernel.call(this, "bound", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.codepipeline.ActionConfig.class), new Object[] { java.util.Objects.requireNonNull(_scope, "_scope is required"), java.util.Objects.requireNonNull(_stage, "_stage is required"), java.util.Objects.requireNonNull(options, "options is required") });
    }

    /**
     * The variables emitted by this action.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.codepipeline.actions.CodeStarSourceVariables getVariables() {
        return software.amazon.jsii.Kernel.get(this, "variables", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.codepipeline.actions.CodeStarSourceVariables.class));
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.codepipeline.actions.CodeStarConnectionsSourceAction}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.codepipeline.actions.CodeStarConnectionsSourceAction> {
        /**
         * @return a new instance of {@link Builder}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create() {
            return new Builder();
        }

        private final software.amazon.awscdk.services.codepipeline.actions.CodeStarConnectionsSourceActionProps.Builder props;

        private Builder() {
            this.props = new software.amazon.awscdk.services.codepipeline.actions.CodeStarConnectionsSourceActionProps.Builder();
        }

        /**
         * The physical, human-readable name of the Action.
         * <p>
         * Note that Action names must be unique within a single Stage.
         * <p>
         * @return {@code this}
         * @param actionName The physical, human-readable name of the Action. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder actionName(final java.lang.String actionName) {
            this.props.actionName(actionName);
            return this;
        }

        /**
         * The runOrder property for this Action.
         * <p>
         * RunOrder determines the relative order in which multiple Actions in the same Stage execute.
         * <p>
         * Default: 1
         * <p>
         * @return {@code this}
         * @see <a href="https://docs.aws.amazon.com/codepipeline/latest/userguide/reference-pipeline-structure.html">https://docs.aws.amazon.com/codepipeline/latest/userguide/reference-pipeline-structure.html</a>
         * @param runOrder The runOrder property for this Action. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder runOrder(final java.lang.Number runOrder) {
            this.props.runOrder(runOrder);
            return this;
        }

        /**
         * The name of the namespace to use for variables emitted by this action.
         * <p>
         * Default: - a name will be generated, based on the stage and action names,
         * if any of the action's variables were referenced - otherwise,
         * no namespace will be set
         * <p>
         * @return {@code this}
         * @param variablesNamespace The name of the namespace to use for variables emitted by this action. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder variablesNamespace(final java.lang.String variablesNamespace) {
            this.props.variablesNamespace(variablesNamespace);
            return this;
        }

        /**
         * The Role in which context's this Action will be executing in.
         * <p>
         * The Pipeline's Role will assume this Role
         * (the required permissions for that will be granted automatically)
         * right before executing this Action.
         * This Action will be passed into your <code>IAction.bind</code>
         * method in the <code>ActionBindOptions.role</code> property.
         * <p>
         * Default: a new Role will be generated
         * <p>
         * @return {@code this}
         * @param role The Role in which context's this Action will be executing in. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder role(final software.amazon.awscdk.services.iam.IRole role) {
            this.props.role(role);
            return this;
        }

        /**
         * The ARN of the CodeStar Connection created in the AWS console that has permissions to access this GitHub or BitBucket repository.
         * <p>
         * Example:
         * <p>
         * <blockquote><pre>
         * "arn:aws:codestar-connections:us-east-1:123456789012:connection/12345678-abcd-12ab-34cdef5678gh";
         * </pre></blockquote>
         * <p>
         * @return {@code this}
         * @see <a href="https://docs.aws.amazon.com/codepipeline/latest/userguide/connections-create.html">https://docs.aws.amazon.com/codepipeline/latest/userguide/connections-create.html</a>
         * @param connectionArn The ARN of the CodeStar Connection created in the AWS console that has permissions to access this GitHub or BitBucket repository. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder connectionArn(final java.lang.String connectionArn) {
            this.props.connectionArn(connectionArn);
            return this;
        }

        /**
         * The output artifact that this action produces.
         * <p>
         * Can be used as input for further pipeline actions.
         * <p>
         * @return {@code this}
         * @param output The output artifact that this action produces. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder output(final software.amazon.awscdk.services.codepipeline.Artifact output) {
            this.props.output(output);
            return this;
        }

        /**
         * The owning user or organization of the repository.
         * <p>
         * Example:
         * <p>
         * <blockquote><pre>
         * "aws";
         * </pre></blockquote>
         * <p>
         * @return {@code this}
         * @param owner The owning user or organization of the repository. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder owner(final java.lang.String owner) {
            this.props.owner(owner);
            return this;
        }

        /**
         * The name of the repository.
         * <p>
         * Example:
         * <p>
         * <blockquote><pre>
         * "aws-cdk";
         * </pre></blockquote>
         * <p>
         * @return {@code this}
         * @param repo The name of the repository. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder repo(final java.lang.String repo) {
            this.props.repo(repo);
            return this;
        }

        /**
         * The branch to build.
         * <p>
         * Default: 'master'
         * <p>
         * @return {@code this}
         * @param branch The branch to build. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder branch(final java.lang.String branch) {
            this.props.branch(branch);
            return this;
        }

        /**
         * Whether the output should be the contents of the repository (which is the default), or a link that allows CodeBuild to clone the repository before building.
         * <p>
         * <strong>Note</strong>: if this option is true,
         * then only CodeBuild actions can use the resulting <code>output</code>.
         * <p>
         * Default: false
         * <p>
         * @return {@code this}
         * @see <a href="https://docs.aws.amazon.com/codepipeline/latest/userguide/action-reference-CodestarConnectionSource.html#action-reference-CodestarConnectionSource-config">https://docs.aws.amazon.com/codepipeline/latest/userguide/action-reference-CodestarConnectionSource.html#action-reference-CodestarConnectionSource-config</a>
         * @param codeBuildCloneOutput Whether the output should be the contents of the repository (which is the default), or a link that allows CodeBuild to clone the repository before building. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder codeBuildCloneOutput(final java.lang.Boolean codeBuildCloneOutput) {
            this.props.codeBuildCloneOutput(codeBuildCloneOutput);
            return this;
        }

        /**
         * Controls automatically starting your pipeline when a new commit is made on the configured repository and branch.
         * <p>
         * If unspecified,
         * the default value is true, and the field does not display by default.
         * <p>
         * Default: true
         * <p>
         * @return {@code this}
         * @see <a href="https://docs.aws.amazon.com/codepipeline/latest/userguide/action-reference-CodestarConnectionSource.html">https://docs.aws.amazon.com/codepipeline/latest/userguide/action-reference-CodestarConnectionSource.html</a>
         * @param triggerOnPush Controls automatically starting your pipeline when a new commit is made on the configured repository and branch. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder triggerOnPush(final java.lang.Boolean triggerOnPush) {
            this.props.triggerOnPush(triggerOnPush);
            return this;
        }

        /**
         * @return a newly built instance of {@link software.amazon.awscdk.services.codepipeline.actions.CodeStarConnectionsSourceAction}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.codepipeline.actions.CodeStarConnectionsSourceAction build() {
            return new software.amazon.awscdk.services.codepipeline.actions.CodeStarConnectionsSourceAction(
                this.props.build()
            );
        }
    }
}
