package software.amazon.awscdk.services.cognito;

/**
 * The user pool trigger version of the request that Amazon Cognito sends to your Lambda function.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * UserPool userpool;
 * Function preTokenGenerationFn;
 * userpool.addTrigger(UserPoolOperation.PRE_TOKEN_GENERATION_CONFIG, preTokenGenerationFn, LambdaVersion.V2_0);
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.109.0 (build c221850)", date = "2025-03-14T03:24:55.675Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_cognito.LambdaVersion")
public enum LambdaVersion {
    /**
     * V1_0 trigger.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    V1_0,
    /**
     * V2_0 trigger.
     * <p>
     * This is supported only for PRE_TOKEN_GENERATION trigger.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    V2_0,
}
