package software.amazon.awscdk.services.config;

/**
 * Properties for defining a <code>CfnOrganizationConformancePack</code>.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.config.*;
 * CfnOrganizationConformancePackProps cfnOrganizationConformancePackProps = CfnOrganizationConformancePackProps.builder()
 *         .organizationConformancePackName("organizationConformancePackName")
 *         // the properties below are optional
 *         .conformancePackInputParameters(List.of(ConformancePackInputParameterProperty.builder()
 *                 .parameterName("parameterName")
 *                 .parameterValue("parameterValue")
 *                 .build()))
 *         .deliveryS3Bucket("deliveryS3Bucket")
 *         .deliveryS3KeyPrefix("deliveryS3KeyPrefix")
 *         .excludedAccounts(List.of("excludedAccounts"))
 *         .templateBody("templateBody")
 *         .templateS3Uri("templateS3Uri")
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-config-organizationconformancepack.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-config-organizationconformancepack.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.109.0 (build c221850)", date = "2025-03-14T03:24:55.805Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_config.CfnOrganizationConformancePackProps")
@software.amazon.jsii.Jsii.Proxy(CfnOrganizationConformancePackProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnOrganizationConformancePackProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * The name you assign to an organization conformance pack.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-config-organizationconformancepack.html#cfn-config-organizationconformancepack-organizationconformancepackname">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-config-organizationconformancepack.html#cfn-config-organizationconformancepack-organizationconformancepackname</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getOrganizationConformancePackName();

    /**
     * A list of <code>ConformancePackInputParameter</code> objects.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-config-organizationconformancepack.html#cfn-config-organizationconformancepack-conformancepackinputparameters">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-config-organizationconformancepack.html#cfn-config-organizationconformancepack-conformancepackinputparameters</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getConformancePackInputParameters() {
        return null;
    }

    /**
     * The name of the Amazon S3 bucket where AWS Config stores conformance pack templates.
     * <p>
     * <blockquote>
     * <p>
     * This field is optional.
     * <p>
     * </blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-config-organizationconformancepack.html#cfn-config-organizationconformancepack-deliverys3bucket">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-config-organizationconformancepack.html#cfn-config-organizationconformancepack-deliverys3bucket</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getDeliveryS3Bucket() {
        return null;
    }

    /**
     * Any folder structure you want to add to an Amazon S3 bucket.
     * <p>
     * <blockquote>
     * <p>
     * This field is optional.
     * <p>
     * </blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-config-organizationconformancepack.html#cfn-config-organizationconformancepack-deliverys3keyprefix">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-config-organizationconformancepack.html#cfn-config-organizationconformancepack-deliverys3keyprefix</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getDeliveryS3KeyPrefix() {
        return null;
    }

    /**
     * A comma-separated list of accounts excluded from organization conformance pack.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-config-organizationconformancepack.html#cfn-config-organizationconformancepack-excludedaccounts">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-config-organizationconformancepack.html#cfn-config-organizationconformancepack-excludedaccounts</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getExcludedAccounts() {
        return null;
    }

    /**
     * A string containing full conformance pack template body.
     * <p>
     * Structure containing the template body with a minimum length of 1 byte and a maximum length of 51,200 bytes.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-config-organizationconformancepack.html#cfn-config-organizationconformancepack-templatebody">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-config-organizationconformancepack.html#cfn-config-organizationconformancepack-templatebody</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getTemplateBody() {
        return null;
    }

    /**
     * Location of file containing the template body.
     * <p>
     * The uri must point to the conformance pack template (max size: 300 KB).
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-config-organizationconformancepack.html#cfn-config-organizationconformancepack-templates3uri">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-config-organizationconformancepack.html#cfn-config-organizationconformancepack-templates3uri</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getTemplateS3Uri() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CfnOrganizationConformancePackProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnOrganizationConformancePackProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnOrganizationConformancePackProps> {
        java.lang.String organizationConformancePackName;
        java.lang.Object conformancePackInputParameters;
        java.lang.String deliveryS3Bucket;
        java.lang.String deliveryS3KeyPrefix;
        java.util.List<java.lang.String> excludedAccounts;
        java.lang.String templateBody;
        java.lang.String templateS3Uri;

        /**
         * Sets the value of {@link CfnOrganizationConformancePackProps#getOrganizationConformancePackName}
         * @param organizationConformancePackName The name you assign to an organization conformance pack. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder organizationConformancePackName(java.lang.String organizationConformancePackName) {
            this.organizationConformancePackName = organizationConformancePackName;
            return this;
        }

        /**
         * Sets the value of {@link CfnOrganizationConformancePackProps#getConformancePackInputParameters}
         * @param conformancePackInputParameters A list of <code>ConformancePackInputParameter</code> objects.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder conformancePackInputParameters(software.amazon.awscdk.IResolvable conformancePackInputParameters) {
            this.conformancePackInputParameters = conformancePackInputParameters;
            return this;
        }

        /**
         * Sets the value of {@link CfnOrganizationConformancePackProps#getConformancePackInputParameters}
         * @param conformancePackInputParameters A list of <code>ConformancePackInputParameter</code> objects.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder conformancePackInputParameters(java.util.List<? extends java.lang.Object> conformancePackInputParameters) {
            this.conformancePackInputParameters = conformancePackInputParameters;
            return this;
        }

        /**
         * Sets the value of {@link CfnOrganizationConformancePackProps#getDeliveryS3Bucket}
         * @param deliveryS3Bucket The name of the Amazon S3 bucket where AWS Config stores conformance pack templates.
         *                         <blockquote>
         *                         <p>
         *                         This field is optional.
         *                         <p>
         *                         </blockquote>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder deliveryS3Bucket(java.lang.String deliveryS3Bucket) {
            this.deliveryS3Bucket = deliveryS3Bucket;
            return this;
        }

        /**
         * Sets the value of {@link CfnOrganizationConformancePackProps#getDeliveryS3KeyPrefix}
         * @param deliveryS3KeyPrefix Any folder structure you want to add to an Amazon S3 bucket.
         *                            <blockquote>
         *                            <p>
         *                            This field is optional.
         *                            <p>
         *                            </blockquote>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder deliveryS3KeyPrefix(java.lang.String deliveryS3KeyPrefix) {
            this.deliveryS3KeyPrefix = deliveryS3KeyPrefix;
            return this;
        }

        /**
         * Sets the value of {@link CfnOrganizationConformancePackProps#getExcludedAccounts}
         * @param excludedAccounts A comma-separated list of accounts excluded from organization conformance pack.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder excludedAccounts(java.util.List<java.lang.String> excludedAccounts) {
            this.excludedAccounts = excludedAccounts;
            return this;
        }

        /**
         * Sets the value of {@link CfnOrganizationConformancePackProps#getTemplateBody}
         * @param templateBody A string containing full conformance pack template body.
         *                     Structure containing the template body with a minimum length of 1 byte and a maximum length of 51,200 bytes.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder templateBody(java.lang.String templateBody) {
            this.templateBody = templateBody;
            return this;
        }

        /**
         * Sets the value of {@link CfnOrganizationConformancePackProps#getTemplateS3Uri}
         * @param templateS3Uri Location of file containing the template body.
         *                      The uri must point to the conformance pack template (max size: 300 KB).
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder templateS3Uri(java.lang.String templateS3Uri) {
            this.templateS3Uri = templateS3Uri;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnOrganizationConformancePackProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnOrganizationConformancePackProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnOrganizationConformancePackProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnOrganizationConformancePackProps {
        private final java.lang.String organizationConformancePackName;
        private final java.lang.Object conformancePackInputParameters;
        private final java.lang.String deliveryS3Bucket;
        private final java.lang.String deliveryS3KeyPrefix;
        private final java.util.List<java.lang.String> excludedAccounts;
        private final java.lang.String templateBody;
        private final java.lang.String templateS3Uri;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.organizationConformancePackName = software.amazon.jsii.Kernel.get(this, "organizationConformancePackName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.conformancePackInputParameters = software.amazon.jsii.Kernel.get(this, "conformancePackInputParameters", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.deliveryS3Bucket = software.amazon.jsii.Kernel.get(this, "deliveryS3Bucket", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.deliveryS3KeyPrefix = software.amazon.jsii.Kernel.get(this, "deliveryS3KeyPrefix", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.excludedAccounts = software.amazon.jsii.Kernel.get(this, "excludedAccounts", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.templateBody = software.amazon.jsii.Kernel.get(this, "templateBody", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.templateS3Uri = software.amazon.jsii.Kernel.get(this, "templateS3Uri", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.organizationConformancePackName = java.util.Objects.requireNonNull(builder.organizationConformancePackName, "organizationConformancePackName is required");
            this.conformancePackInputParameters = builder.conformancePackInputParameters;
            this.deliveryS3Bucket = builder.deliveryS3Bucket;
            this.deliveryS3KeyPrefix = builder.deliveryS3KeyPrefix;
            this.excludedAccounts = builder.excludedAccounts;
            this.templateBody = builder.templateBody;
            this.templateS3Uri = builder.templateS3Uri;
        }

        @Override
        public final java.lang.String getOrganizationConformancePackName() {
            return this.organizationConformancePackName;
        }

        @Override
        public final java.lang.Object getConformancePackInputParameters() {
            return this.conformancePackInputParameters;
        }

        @Override
        public final java.lang.String getDeliveryS3Bucket() {
            return this.deliveryS3Bucket;
        }

        @Override
        public final java.lang.String getDeliveryS3KeyPrefix() {
            return this.deliveryS3KeyPrefix;
        }

        @Override
        public final java.util.List<java.lang.String> getExcludedAccounts() {
            return this.excludedAccounts;
        }

        @Override
        public final java.lang.String getTemplateBody() {
            return this.templateBody;
        }

        @Override
        public final java.lang.String getTemplateS3Uri() {
            return this.templateS3Uri;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("organizationConformancePackName", om.valueToTree(this.getOrganizationConformancePackName()));
            if (this.getConformancePackInputParameters() != null) {
                data.set("conformancePackInputParameters", om.valueToTree(this.getConformancePackInputParameters()));
            }
            if (this.getDeliveryS3Bucket() != null) {
                data.set("deliveryS3Bucket", om.valueToTree(this.getDeliveryS3Bucket()));
            }
            if (this.getDeliveryS3KeyPrefix() != null) {
                data.set("deliveryS3KeyPrefix", om.valueToTree(this.getDeliveryS3KeyPrefix()));
            }
            if (this.getExcludedAccounts() != null) {
                data.set("excludedAccounts", om.valueToTree(this.getExcludedAccounts()));
            }
            if (this.getTemplateBody() != null) {
                data.set("templateBody", om.valueToTree(this.getTemplateBody()));
            }
            if (this.getTemplateS3Uri() != null) {
                data.set("templateS3Uri", om.valueToTree(this.getTemplateS3Uri()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_config.CfnOrganizationConformancePackProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnOrganizationConformancePackProps.Jsii$Proxy that = (CfnOrganizationConformancePackProps.Jsii$Proxy) o;

            if (!organizationConformancePackName.equals(that.organizationConformancePackName)) return false;
            if (this.conformancePackInputParameters != null ? !this.conformancePackInputParameters.equals(that.conformancePackInputParameters) : that.conformancePackInputParameters != null) return false;
            if (this.deliveryS3Bucket != null ? !this.deliveryS3Bucket.equals(that.deliveryS3Bucket) : that.deliveryS3Bucket != null) return false;
            if (this.deliveryS3KeyPrefix != null ? !this.deliveryS3KeyPrefix.equals(that.deliveryS3KeyPrefix) : that.deliveryS3KeyPrefix != null) return false;
            if (this.excludedAccounts != null ? !this.excludedAccounts.equals(that.excludedAccounts) : that.excludedAccounts != null) return false;
            if (this.templateBody != null ? !this.templateBody.equals(that.templateBody) : that.templateBody != null) return false;
            return this.templateS3Uri != null ? this.templateS3Uri.equals(that.templateS3Uri) : that.templateS3Uri == null;
        }

        @Override
        public final int hashCode() {
            int result = this.organizationConformancePackName.hashCode();
            result = 31 * result + (this.conformancePackInputParameters != null ? this.conformancePackInputParameters.hashCode() : 0);
            result = 31 * result + (this.deliveryS3Bucket != null ? this.deliveryS3Bucket.hashCode() : 0);
            result = 31 * result + (this.deliveryS3KeyPrefix != null ? this.deliveryS3KeyPrefix.hashCode() : 0);
            result = 31 * result + (this.excludedAccounts != null ? this.excludedAccounts.hashCode() : 0);
            result = 31 * result + (this.templateBody != null ? this.templateBody.hashCode() : 0);
            result = 31 * result + (this.templateS3Uri != null ? this.templateS3Uri.hashCode() : 0);
            return result;
        }
    }
}
