package software.amazon.awscdk.services.config;

/**
 * Construction properties for a CloudFormationStackNotificationCheck.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // topics to which CloudFormation stacks may send event notifications
 * Topic topic1 = new Topic(this, "AllowedTopic1");
 * Topic topic2 = new Topic(this, "AllowedTopic2");
 * // non-compliant if CloudFormation stack does not send notifications to 'topic1' or 'topic2'
 * // non-compliant if CloudFormation stack does not send notifications to 'topic1' or 'topic2'
 * CloudFormationStackNotificationCheck.Builder.create(this, "NotificationCheck")
 *         .topics(List.of(topic1, topic2))
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.109.0 (build c221850)", date = "2025-03-14T03:24:55.813Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_config.CloudFormationStackNotificationCheckProps")
@software.amazon.jsii.Jsii.Proxy(CloudFormationStackNotificationCheckProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CloudFormationStackNotificationCheckProps extends software.amazon.jsii.JsiiSerializable, software.amazon.awscdk.services.config.RuleProps {

    /**
     * A list of allowed topics.
     * <p>
     * At most 5 topics.
     * <p>
     * Default: - No topics.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.services.sns.ITopic> getTopics() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CloudFormationStackNotificationCheckProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CloudFormationStackNotificationCheckProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CloudFormationStackNotificationCheckProps> {
        java.util.List<software.amazon.awscdk.services.sns.ITopic> topics;
        java.lang.String configRuleName;
        java.lang.String description;
        software.amazon.awscdk.services.config.EvaluationMode evaluationModes;
        java.util.Map<java.lang.String, java.lang.Object> inputParameters;
        software.amazon.awscdk.services.config.MaximumExecutionFrequency maximumExecutionFrequency;
        software.amazon.awscdk.services.config.RuleScope ruleScope;

        /**
         * Sets the value of {@link CloudFormationStackNotificationCheckProps#getTopics}
         * @param topics A list of allowed topics.
         *               At most 5 topics.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder topics(java.util.List<? extends software.amazon.awscdk.services.sns.ITopic> topics) {
            this.topics = (java.util.List<software.amazon.awscdk.services.sns.ITopic>)topics;
            return this;
        }

        /**
         * Sets the value of {@link CloudFormationStackNotificationCheckProps#getConfigRuleName}
         * @param configRuleName A name for the AWS Config rule.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder configRuleName(java.lang.String configRuleName) {
            this.configRuleName = configRuleName;
            return this;
        }

        /**
         * Sets the value of {@link CloudFormationStackNotificationCheckProps#getDescription}
         * @param description A description about this AWS Config rule.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder description(java.lang.String description) {
            this.description = description;
            return this;
        }

        /**
         * Sets the value of {@link CloudFormationStackNotificationCheckProps#getEvaluationModes}
         * @param evaluationModes The modes the AWS Config rule can be evaluated in.
         *                        The valid values are distinct objects.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder evaluationModes(software.amazon.awscdk.services.config.EvaluationMode evaluationModes) {
            this.evaluationModes = evaluationModes;
            return this;
        }

        /**
         * Sets the value of {@link CloudFormationStackNotificationCheckProps#getInputParameters}
         * @param inputParameters Input parameter values that are passed to the AWS Config rule.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder inputParameters(java.util.Map<java.lang.String, ? extends java.lang.Object> inputParameters) {
            this.inputParameters = (java.util.Map<java.lang.String, java.lang.Object>)inputParameters;
            return this;
        }

        /**
         * Sets the value of {@link CloudFormationStackNotificationCheckProps#getMaximumExecutionFrequency}
         * @param maximumExecutionFrequency The maximum frequency at which the AWS Config rule runs evaluations.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder maximumExecutionFrequency(software.amazon.awscdk.services.config.MaximumExecutionFrequency maximumExecutionFrequency) {
            this.maximumExecutionFrequency = maximumExecutionFrequency;
            return this;
        }

        /**
         * Sets the value of {@link CloudFormationStackNotificationCheckProps#getRuleScope}
         * @param ruleScope Defines which resources trigger an evaluation for an AWS Config rule.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder ruleScope(software.amazon.awscdk.services.config.RuleScope ruleScope) {
            this.ruleScope = ruleScope;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CloudFormationStackNotificationCheckProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CloudFormationStackNotificationCheckProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CloudFormationStackNotificationCheckProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CloudFormationStackNotificationCheckProps {
        private final java.util.List<software.amazon.awscdk.services.sns.ITopic> topics;
        private final java.lang.String configRuleName;
        private final java.lang.String description;
        private final software.amazon.awscdk.services.config.EvaluationMode evaluationModes;
        private final java.util.Map<java.lang.String, java.lang.Object> inputParameters;
        private final software.amazon.awscdk.services.config.MaximumExecutionFrequency maximumExecutionFrequency;
        private final software.amazon.awscdk.services.config.RuleScope ruleScope;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.topics = software.amazon.jsii.Kernel.get(this, "topics", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.sns.ITopic.class)));
            this.configRuleName = software.amazon.jsii.Kernel.get(this, "configRuleName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.description = software.amazon.jsii.Kernel.get(this, "description", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.evaluationModes = software.amazon.jsii.Kernel.get(this, "evaluationModes", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.config.EvaluationMode.class));
            this.inputParameters = software.amazon.jsii.Kernel.get(this, "inputParameters", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class)));
            this.maximumExecutionFrequency = software.amazon.jsii.Kernel.get(this, "maximumExecutionFrequency", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.config.MaximumExecutionFrequency.class));
            this.ruleScope = software.amazon.jsii.Kernel.get(this, "ruleScope", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.config.RuleScope.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.topics = (java.util.List<software.amazon.awscdk.services.sns.ITopic>)builder.topics;
            this.configRuleName = builder.configRuleName;
            this.description = builder.description;
            this.evaluationModes = builder.evaluationModes;
            this.inputParameters = (java.util.Map<java.lang.String, java.lang.Object>)builder.inputParameters;
            this.maximumExecutionFrequency = builder.maximumExecutionFrequency;
            this.ruleScope = builder.ruleScope;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.services.sns.ITopic> getTopics() {
            return this.topics;
        }

        @Override
        public final java.lang.String getConfigRuleName() {
            return this.configRuleName;
        }

        @Override
        public final java.lang.String getDescription() {
            return this.description;
        }

        @Override
        public final software.amazon.awscdk.services.config.EvaluationMode getEvaluationModes() {
            return this.evaluationModes;
        }

        @Override
        public final java.util.Map<java.lang.String, java.lang.Object> getInputParameters() {
            return this.inputParameters;
        }

        @Override
        public final software.amazon.awscdk.services.config.MaximumExecutionFrequency getMaximumExecutionFrequency() {
            return this.maximumExecutionFrequency;
        }

        @Override
        public final software.amazon.awscdk.services.config.RuleScope getRuleScope() {
            return this.ruleScope;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            if (this.getTopics() != null) {
                data.set("topics", om.valueToTree(this.getTopics()));
            }
            if (this.getConfigRuleName() != null) {
                data.set("configRuleName", om.valueToTree(this.getConfigRuleName()));
            }
            if (this.getDescription() != null) {
                data.set("description", om.valueToTree(this.getDescription()));
            }
            if (this.getEvaluationModes() != null) {
                data.set("evaluationModes", om.valueToTree(this.getEvaluationModes()));
            }
            if (this.getInputParameters() != null) {
                data.set("inputParameters", om.valueToTree(this.getInputParameters()));
            }
            if (this.getMaximumExecutionFrequency() != null) {
                data.set("maximumExecutionFrequency", om.valueToTree(this.getMaximumExecutionFrequency()));
            }
            if (this.getRuleScope() != null) {
                data.set("ruleScope", om.valueToTree(this.getRuleScope()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_config.CloudFormationStackNotificationCheckProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CloudFormationStackNotificationCheckProps.Jsii$Proxy that = (CloudFormationStackNotificationCheckProps.Jsii$Proxy) o;

            if (this.topics != null ? !this.topics.equals(that.topics) : that.topics != null) return false;
            if (this.configRuleName != null ? !this.configRuleName.equals(that.configRuleName) : that.configRuleName != null) return false;
            if (this.description != null ? !this.description.equals(that.description) : that.description != null) return false;
            if (this.evaluationModes != null ? !this.evaluationModes.equals(that.evaluationModes) : that.evaluationModes != null) return false;
            if (this.inputParameters != null ? !this.inputParameters.equals(that.inputParameters) : that.inputParameters != null) return false;
            if (this.maximumExecutionFrequency != null ? !this.maximumExecutionFrequency.equals(that.maximumExecutionFrequency) : that.maximumExecutionFrequency != null) return false;
            return this.ruleScope != null ? this.ruleScope.equals(that.ruleScope) : that.ruleScope == null;
        }

        @Override
        public final int hashCode() {
            int result = this.topics != null ? this.topics.hashCode() : 0;
            result = 31 * result + (this.configRuleName != null ? this.configRuleName.hashCode() : 0);
            result = 31 * result + (this.description != null ? this.description.hashCode() : 0);
            result = 31 * result + (this.evaluationModes != null ? this.evaluationModes.hashCode() : 0);
            result = 31 * result + (this.inputParameters != null ? this.inputParameters.hashCode() : 0);
            result = 31 * result + (this.maximumExecutionFrequency != null ? this.maximumExecutionFrequency.hashCode() : 0);
            result = 31 * result + (this.ruleScope != null ? this.ruleScope.hashCode() : 0);
            return result;
        }
    }
}
