package software.amazon.awscdk.services.config;

/**
 * The mode of evaluation for the rule.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * Function fn;
 * String samplePolicyText;
 * ManagedRule.Builder.create(this, "ManagedRule")
 *         .identifier(ManagedRuleIdentifiers.API_GW_XRAY_ENABLED)
 *         .evaluationModes(EvaluationMode.DETECTIVE_AND_PROACTIVE)
 *         .build();
 * CustomRule.Builder.create(this, "CustomRule")
 *         .lambdaFunction(fn)
 *         .evaluationModes(EvaluationMode.PROACTIVE)
 *         .build();
 * CustomPolicy.Builder.create(this, "CustomPolicy")
 *         .policyText(samplePolicyText)
 *         .evaluationModes(EvaluationMode.DETECTIVE)
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.109.0 (build c221850)", date = "2025-03-14T03:24:55.817Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_config.EvaluationMode")
public class EvaluationMode extends software.amazon.jsii.JsiiObject {

    protected EvaluationMode(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected EvaluationMode(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        DETECTIVE = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.EvaluationMode.class, "DETECTIVE", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.config.EvaluationMode.class));
        DETECTIVE_AND_PROACTIVE = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.EvaluationMode.class, "DETECTIVE_AND_PROACTIVE", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.config.EvaluationMode.class));
        PROACTIVE = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.EvaluationMode.class, "PROACTIVE", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.config.EvaluationMode.class));
    }

    /**
     * @param modes The modes of evaluation for the rule. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected EvaluationMode(final @org.jetbrains.annotations.NotNull java.util.List<java.lang.String> modes) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(modes, "modes is required") });
    }

    /**
     * Evaluate resources that have already been deployed.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.config.EvaluationMode DETECTIVE;

    /**
     * Evaluate resources that have already been deployed and before they have been deployed.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.config.EvaluationMode DETECTIVE_AND_PROACTIVE;

    /**
     * Evaluate resources before they have been deployed.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.config.EvaluationMode PROACTIVE;

    /**
     * The modes of evaluation for the rule.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.util.List<java.lang.String> getModes() {
        return java.util.Collections.unmodifiableList(software.amazon.jsii.Kernel.get(this, "modes", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class))));
    }
}
