package software.amazon.awscdk.services.connect;

/**
 * Properties for defining a <code>CfnEvaluationForm</code>.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.connect.*;
 * EvaluationFormSectionProperty evaluationFormSectionProperty_;
 * CfnEvaluationFormProps cfnEvaluationFormProps = CfnEvaluationFormProps.builder()
 *         .instanceArn("instanceArn")
 *         .items(List.of(EvaluationFormBaseItemProperty.builder()
 *                 .section(EvaluationFormSectionProperty.builder()
 *                         .refId("refId")
 *                         .title("title")
 *                         // the properties below are optional
 *                         .instructions("instructions")
 *                         .items(List.of(EvaluationFormItemProperty.builder()
 *                                 .question(EvaluationFormQuestionProperty.builder()
 *                                         .questionType("questionType")
 *                                         .refId("refId")
 *                                         .title("title")
 *                                         // the properties below are optional
 *                                         .instructions("instructions")
 *                                         .notApplicableEnabled(false)
 *                                         .questionTypeProperties(EvaluationFormQuestionTypePropertiesProperty.builder()
 *                                                 .numeric(EvaluationFormNumericQuestionPropertiesProperty.builder()
 *                                                         .maxValue(123)
 *                                                         .minValue(123)
 *                                                         // the properties below are optional
 *                                                         .automation(EvaluationFormNumericQuestionAutomationProperty.builder()
 *                                                                 .propertyValue(NumericQuestionPropertyValueAutomationProperty.builder()
 *                                                                         .label("label")
 *                                                                         .build())
 *                                                                 .build())
 *                                                         .options(List.of(EvaluationFormNumericQuestionOptionProperty.builder()
 *                                                                 .maxValue(123)
 *                                                                 .minValue(123)
 *                                                                 // the properties below are optional
 *                                                                 .automaticFail(false)
 *                                                                 .score(123)
 *                                                                 .build()))
 *                                                         .build())
 *                                                 .singleSelect(EvaluationFormSingleSelectQuestionPropertiesProperty.builder()
 *                                                         .options(List.of(EvaluationFormSingleSelectQuestionOptionProperty.builder()
 *                                                                 .refId("refId")
 *                                                                 .text("text")
 *                                                                 // the properties below are optional
 *                                                                 .automaticFail(false)
 *                                                                 .score(123)
 *                                                                 .build()))
 *                                                         // the properties below are optional
 *                                                         .automation(EvaluationFormSingleSelectQuestionAutomationProperty.builder()
 *                                                                 .options(List.of(EvaluationFormSingleSelectQuestionAutomationOptionProperty.builder()
 *                                                                         .ruleCategory(SingleSelectQuestionRuleCategoryAutomationProperty.builder()
 *                                                                                 .category("category")
 *                                                                                 .condition("condition")
 *                                                                                 .optionRefId("optionRefId")
 *                                                                                 .build())
 *                                                                         .build()))
 *                                                                 // the properties below are optional
 *                                                                 .defaultOptionRefId("defaultOptionRefId")
 *                                                                 .build())
 *                                                         .displayAs("displayAs")
 *                                                         .build())
 *                                                 .build())
 *                                         .weight(123)
 *                                         .build())
 *                                 .section(evaluationFormSectionProperty_)
 *                                 .build()))
 *                         .weight(123)
 *                         .build())
 *                 .build()))
 *         .status("status")
 *         .title("title")
 *         // the properties below are optional
 *         .description("description")
 *         .scoringStrategy(ScoringStrategyProperty.builder()
 *                 .mode("mode")
 *                 .status("status")
 *                 .build())
 *         .tags(List.of(CfnTag.builder()
 *                 .key("key")
 *                 .value("value")
 *                 .build()))
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-connect-evaluationform.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-connect-evaluationform.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.109.0 (build c221850)", date = "2025-03-14T03:24:55.863Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_connect.CfnEvaluationFormProps")
@software.amazon.jsii.Jsii.Proxy(CfnEvaluationFormProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnEvaluationFormProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * The identifier of the Amazon Connect instance.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-connect-evaluationform.html#cfn-connect-evaluationform-instancearn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-connect-evaluationform.html#cfn-connect-evaluationform-instancearn</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getInstanceArn();

    /**
     * Items that are part of the evaluation form.
     * <p>
     * The total number of sections and questions must not exceed 100 each. Questions must be contained in a section.
     * <p>
     * <em>Minimum size</em> : 1
     * <p>
     * <em>Maximum size</em> : 100
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-connect-evaluationform.html#cfn-connect-evaluationform-items">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-connect-evaluationform.html#cfn-connect-evaluationform-items</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.Object getItems();

    /**
     * The status of the evaluation form.
     * <p>
     * <em>Allowed values</em> : <code>DRAFT</code> | <code>ACTIVE</code>
     * <p>
     * Default: - "DRAFT"
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-connect-evaluationform.html#cfn-connect-evaluationform-status">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-connect-evaluationform.html#cfn-connect-evaluationform-status</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getStatus();

    /**
     * A title of the evaluation form.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-connect-evaluationform.html#cfn-connect-evaluationform-title">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-connect-evaluationform.html#cfn-connect-evaluationform-title</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getTitle();

    /**
     * The description of the evaluation form.
     * <p>
     * <em>Length Constraints</em> : Minimum length of 0. Maximum length of 1024.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-connect-evaluationform.html#cfn-connect-evaluationform-description">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-connect-evaluationform.html#cfn-connect-evaluationform-description</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getDescription() {
        return null;
    }

    /**
     * A scoring strategy of the evaluation form.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-connect-evaluationform.html#cfn-connect-evaluationform-scoringstrategy">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-connect-evaluationform.html#cfn-connect-evaluationform-scoringstrategy</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getScoringStrategy() {
        return null;
    }

    /**
     * The tags used to organize, track, or control access for this resource.
     * <p>
     * For example, { "tags": {"key1":"value1", "key2":"value2"} }.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-connect-evaluationform.html#cfn-connect-evaluationform-tags">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-connect-evaluationform.html#cfn-connect-evaluationform-tags</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.CfnTag> getTags() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CfnEvaluationFormProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnEvaluationFormProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnEvaluationFormProps> {
        java.lang.String instanceArn;
        java.lang.Object items;
        java.lang.String status;
        java.lang.String title;
        java.lang.String description;
        java.lang.Object scoringStrategy;
        java.util.List<software.amazon.awscdk.CfnTag> tags;

        /**
         * Sets the value of {@link CfnEvaluationFormProps#getInstanceArn}
         * @param instanceArn The identifier of the Amazon Connect instance. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder instanceArn(java.lang.String instanceArn) {
            this.instanceArn = instanceArn;
            return this;
        }

        /**
         * Sets the value of {@link CfnEvaluationFormProps#getItems}
         * @param items Items that are part of the evaluation form. This parameter is required.
         *              The total number of sections and questions must not exceed 100 each. Questions must be contained in a section.
         *              <p>
         *              <em>Minimum size</em> : 1
         *              <p>
         *              <em>Maximum size</em> : 100
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder items(software.amazon.awscdk.IResolvable items) {
            this.items = items;
            return this;
        }

        /**
         * Sets the value of {@link CfnEvaluationFormProps#getItems}
         * @param items Items that are part of the evaluation form. This parameter is required.
         *              The total number of sections and questions must not exceed 100 each. Questions must be contained in a section.
         *              <p>
         *              <em>Minimum size</em> : 1
         *              <p>
         *              <em>Maximum size</em> : 100
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder items(java.util.List<? extends java.lang.Object> items) {
            this.items = items;
            return this;
        }

        /**
         * Sets the value of {@link CfnEvaluationFormProps#getStatus}
         * @param status The status of the evaluation form. This parameter is required.
         *               <em>Allowed values</em> : <code>DRAFT</code> | <code>ACTIVE</code>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder status(java.lang.String status) {
            this.status = status;
            return this;
        }

        /**
         * Sets the value of {@link CfnEvaluationFormProps#getTitle}
         * @param title A title of the evaluation form. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder title(java.lang.String title) {
            this.title = title;
            return this;
        }

        /**
         * Sets the value of {@link CfnEvaluationFormProps#getDescription}
         * @param description The description of the evaluation form.
         *                    <em>Length Constraints</em> : Minimum length of 0. Maximum length of 1024.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder description(java.lang.String description) {
            this.description = description;
            return this;
        }

        /**
         * Sets the value of {@link CfnEvaluationFormProps#getScoringStrategy}
         * @param scoringStrategy A scoring strategy of the evaluation form.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder scoringStrategy(software.amazon.awscdk.IResolvable scoringStrategy) {
            this.scoringStrategy = scoringStrategy;
            return this;
        }

        /**
         * Sets the value of {@link CfnEvaluationFormProps#getScoringStrategy}
         * @param scoringStrategy A scoring strategy of the evaluation form.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder scoringStrategy(software.amazon.awscdk.services.connect.CfnEvaluationForm.ScoringStrategyProperty scoringStrategy) {
            this.scoringStrategy = scoringStrategy;
            return this;
        }

        /**
         * Sets the value of {@link CfnEvaluationFormProps#getTags}
         * @param tags The tags used to organize, track, or control access for this resource.
         *             For example, { "tags": {"key1":"value1", "key2":"value2"} }.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder tags(java.util.List<? extends software.amazon.awscdk.CfnTag> tags) {
            this.tags = (java.util.List<software.amazon.awscdk.CfnTag>)tags;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnEvaluationFormProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnEvaluationFormProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnEvaluationFormProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnEvaluationFormProps {
        private final java.lang.String instanceArn;
        private final java.lang.Object items;
        private final java.lang.String status;
        private final java.lang.String title;
        private final java.lang.String description;
        private final java.lang.Object scoringStrategy;
        private final java.util.List<software.amazon.awscdk.CfnTag> tags;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.instanceArn = software.amazon.jsii.Kernel.get(this, "instanceArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.items = software.amazon.jsii.Kernel.get(this, "items", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.status = software.amazon.jsii.Kernel.get(this, "status", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.title = software.amazon.jsii.Kernel.get(this, "title", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.description = software.amazon.jsii.Kernel.get(this, "description", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.scoringStrategy = software.amazon.jsii.Kernel.get(this, "scoringStrategy", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.tags = software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.CfnTag.class)));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.instanceArn = java.util.Objects.requireNonNull(builder.instanceArn, "instanceArn is required");
            this.items = java.util.Objects.requireNonNull(builder.items, "items is required");
            this.status = java.util.Objects.requireNonNull(builder.status, "status is required");
            this.title = java.util.Objects.requireNonNull(builder.title, "title is required");
            this.description = builder.description;
            this.scoringStrategy = builder.scoringStrategy;
            this.tags = (java.util.List<software.amazon.awscdk.CfnTag>)builder.tags;
        }

        @Override
        public final java.lang.String getInstanceArn() {
            return this.instanceArn;
        }

        @Override
        public final java.lang.Object getItems() {
            return this.items;
        }

        @Override
        public final java.lang.String getStatus() {
            return this.status;
        }

        @Override
        public final java.lang.String getTitle() {
            return this.title;
        }

        @Override
        public final java.lang.String getDescription() {
            return this.description;
        }

        @Override
        public final java.lang.Object getScoringStrategy() {
            return this.scoringStrategy;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.CfnTag> getTags() {
            return this.tags;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("instanceArn", om.valueToTree(this.getInstanceArn()));
            data.set("items", om.valueToTree(this.getItems()));
            data.set("status", om.valueToTree(this.getStatus()));
            data.set("title", om.valueToTree(this.getTitle()));
            if (this.getDescription() != null) {
                data.set("description", om.valueToTree(this.getDescription()));
            }
            if (this.getScoringStrategy() != null) {
                data.set("scoringStrategy", om.valueToTree(this.getScoringStrategy()));
            }
            if (this.getTags() != null) {
                data.set("tags", om.valueToTree(this.getTags()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_connect.CfnEvaluationFormProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnEvaluationFormProps.Jsii$Proxy that = (CfnEvaluationFormProps.Jsii$Proxy) o;

            if (!instanceArn.equals(that.instanceArn)) return false;
            if (!items.equals(that.items)) return false;
            if (!status.equals(that.status)) return false;
            if (!title.equals(that.title)) return false;
            if (this.description != null ? !this.description.equals(that.description) : that.description != null) return false;
            if (this.scoringStrategy != null ? !this.scoringStrategy.equals(that.scoringStrategy) : that.scoringStrategy != null) return false;
            return this.tags != null ? this.tags.equals(that.tags) : that.tags == null;
        }

        @Override
        public final int hashCode() {
            int result = this.instanceArn.hashCode();
            result = 31 * result + (this.items.hashCode());
            result = 31 * result + (this.status.hashCode());
            result = 31 * result + (this.title.hashCode());
            result = 31 * result + (this.description != null ? this.description.hashCode() : 0);
            result = 31 * result + (this.scoringStrategy != null ? this.scoringStrategy.hashCode() : 0);
            result = 31 * result + (this.tags != null ? this.tags.hashCode() : 0);
            return result;
        }
    }
}
