package software.amazon.awscdk.services.datasync;

/**
 * Properties for defining a <code>CfnStorageSystem</code>.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.datasync.*;
 * CfnStorageSystemProps cfnStorageSystemProps = CfnStorageSystemProps.builder()
 *         .agentArns(List.of("agentArns"))
 *         .serverConfiguration(ServerConfigurationProperty.builder()
 *                 .serverHostname("serverHostname")
 *                 // the properties below are optional
 *                 .serverPort(123)
 *                 .build())
 *         .systemType("systemType")
 *         // the properties below are optional
 *         .cloudWatchLogGroupArn("cloudWatchLogGroupArn")
 *         .name("name")
 *         .serverCredentials(ServerCredentialsProperty.builder()
 *                 .password("password")
 *                 .username("username")
 *                 .build())
 *         .tags(List.of(CfnTag.builder()
 *                 .key("key")
 *                 .value("value")
 *                 .build()))
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-datasync-storagesystem.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-datasync-storagesystem.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.109.0 (build c221850)", date = "2025-03-14T03:24:56.181Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_datasync.CfnStorageSystemProps")
@software.amazon.jsii.Jsii.Proxy(CfnStorageSystemProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnStorageSystemProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * Specifies the Amazon Resource Name (ARN) of the DataSync agent that connects to and reads from your on-premises storage system's management interface.
     * <p>
     * You can only specify one ARN.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-datasync-storagesystem.html#cfn-datasync-storagesystem-agentarns">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-datasync-storagesystem.html#cfn-datasync-storagesystem-agentarns</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.util.List<java.lang.String> getAgentArns();

    /**
     * Specifies the server name and network port required to connect with the management interface of your on-premises storage system.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-datasync-storagesystem.html#cfn-datasync-storagesystem-serverconfiguration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-datasync-storagesystem.html#cfn-datasync-storagesystem-serverconfiguration</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.Object getServerConfiguration();

    /**
     * Specifies the type of on-premises storage system that you want DataSync Discovery to collect information about.
     * <p>
     * <blockquote>
     * <p>
     * DataSync Discovery currently supports NetApp Fabric-Attached Storage (FAS) and All Flash FAS (AFF) systems running ONTAP 9.7 or later.
     * <p>
     * </blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-datasync-storagesystem.html#cfn-datasync-storagesystem-systemtype">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-datasync-storagesystem.html#cfn-datasync-storagesystem-systemtype</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getSystemType();

    /**
     * Specifies the ARN of the Amazon CloudWatch log group for monitoring and logging discovery job events.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-datasync-storagesystem.html#cfn-datasync-storagesystem-cloudwatchloggrouparn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-datasync-storagesystem.html#cfn-datasync-storagesystem-cloudwatchloggrouparn</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getCloudWatchLogGroupArn() {
        return null;
    }

    /**
     * Specifies a familiar name for your on-premises storage system.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-datasync-storagesystem.html#cfn-datasync-storagesystem-name">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-datasync-storagesystem.html#cfn-datasync-storagesystem-name</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getName() {
        return null;
    }

    /**
     * Specifies the user name and password for accessing your on-premises storage system's management interface.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-datasync-storagesystem.html#cfn-datasync-storagesystem-servercredentials">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-datasync-storagesystem.html#cfn-datasync-storagesystem-servercredentials</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getServerCredentials() {
        return null;
    }

    /**
     * Specifies labels that help you categorize, filter, and search for your AWS resources.
     * <p>
     * We recommend creating at least a name tag for your on-premises storage system.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-datasync-storagesystem.html#cfn-datasync-storagesystem-tags">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-datasync-storagesystem.html#cfn-datasync-storagesystem-tags</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.CfnTag> getTags() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CfnStorageSystemProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnStorageSystemProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnStorageSystemProps> {
        java.util.List<java.lang.String> agentArns;
        java.lang.Object serverConfiguration;
        java.lang.String systemType;
        java.lang.String cloudWatchLogGroupArn;
        java.lang.String name;
        java.lang.Object serverCredentials;
        java.util.List<software.amazon.awscdk.CfnTag> tags;

        /**
         * Sets the value of {@link CfnStorageSystemProps#getAgentArns}
         * @param agentArns Specifies the Amazon Resource Name (ARN) of the DataSync agent that connects to and reads from your on-premises storage system's management interface. This parameter is required.
         *                  You can only specify one ARN.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder agentArns(java.util.List<java.lang.String> agentArns) {
            this.agentArns = agentArns;
            return this;
        }

        /**
         * Sets the value of {@link CfnStorageSystemProps#getServerConfiguration}
         * @param serverConfiguration Specifies the server name and network port required to connect with the management interface of your on-premises storage system. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder serverConfiguration(software.amazon.awscdk.IResolvable serverConfiguration) {
            this.serverConfiguration = serverConfiguration;
            return this;
        }

        /**
         * Sets the value of {@link CfnStorageSystemProps#getServerConfiguration}
         * @param serverConfiguration Specifies the server name and network port required to connect with the management interface of your on-premises storage system. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder serverConfiguration(software.amazon.awscdk.services.datasync.CfnStorageSystem.ServerConfigurationProperty serverConfiguration) {
            this.serverConfiguration = serverConfiguration;
            return this;
        }

        /**
         * Sets the value of {@link CfnStorageSystemProps#getSystemType}
         * @param systemType Specifies the type of on-premises storage system that you want DataSync Discovery to collect information about. This parameter is required.
         *                   <blockquote>
         *                   <p>
         *                   DataSync Discovery currently supports NetApp Fabric-Attached Storage (FAS) and All Flash FAS (AFF) systems running ONTAP 9.7 or later.
         *                   <p>
         *                   </blockquote>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder systemType(java.lang.String systemType) {
            this.systemType = systemType;
            return this;
        }

        /**
         * Sets the value of {@link CfnStorageSystemProps#getCloudWatchLogGroupArn}
         * @param cloudWatchLogGroupArn Specifies the ARN of the Amazon CloudWatch log group for monitoring and logging discovery job events.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder cloudWatchLogGroupArn(java.lang.String cloudWatchLogGroupArn) {
            this.cloudWatchLogGroupArn = cloudWatchLogGroupArn;
            return this;
        }

        /**
         * Sets the value of {@link CfnStorageSystemProps#getName}
         * @param name Specifies a familiar name for your on-premises storage system.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder name(java.lang.String name) {
            this.name = name;
            return this;
        }

        /**
         * Sets the value of {@link CfnStorageSystemProps#getServerCredentials}
         * @param serverCredentials Specifies the user name and password for accessing your on-premises storage system's management interface.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder serverCredentials(software.amazon.awscdk.IResolvable serverCredentials) {
            this.serverCredentials = serverCredentials;
            return this;
        }

        /**
         * Sets the value of {@link CfnStorageSystemProps#getServerCredentials}
         * @param serverCredentials Specifies the user name and password for accessing your on-premises storage system's management interface.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder serverCredentials(software.amazon.awscdk.services.datasync.CfnStorageSystem.ServerCredentialsProperty serverCredentials) {
            this.serverCredentials = serverCredentials;
            return this;
        }

        /**
         * Sets the value of {@link CfnStorageSystemProps#getTags}
         * @param tags Specifies labels that help you categorize, filter, and search for your AWS resources.
         *             We recommend creating at least a name tag for your on-premises storage system.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder tags(java.util.List<? extends software.amazon.awscdk.CfnTag> tags) {
            this.tags = (java.util.List<software.amazon.awscdk.CfnTag>)tags;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnStorageSystemProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnStorageSystemProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnStorageSystemProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnStorageSystemProps {
        private final java.util.List<java.lang.String> agentArns;
        private final java.lang.Object serverConfiguration;
        private final java.lang.String systemType;
        private final java.lang.String cloudWatchLogGroupArn;
        private final java.lang.String name;
        private final java.lang.Object serverCredentials;
        private final java.util.List<software.amazon.awscdk.CfnTag> tags;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.agentArns = software.amazon.jsii.Kernel.get(this, "agentArns", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.serverConfiguration = software.amazon.jsii.Kernel.get(this, "serverConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.systemType = software.amazon.jsii.Kernel.get(this, "systemType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.cloudWatchLogGroupArn = software.amazon.jsii.Kernel.get(this, "cloudWatchLogGroupArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.name = software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.serverCredentials = software.amazon.jsii.Kernel.get(this, "serverCredentials", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.tags = software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.CfnTag.class)));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.agentArns = java.util.Objects.requireNonNull(builder.agentArns, "agentArns is required");
            this.serverConfiguration = java.util.Objects.requireNonNull(builder.serverConfiguration, "serverConfiguration is required");
            this.systemType = java.util.Objects.requireNonNull(builder.systemType, "systemType is required");
            this.cloudWatchLogGroupArn = builder.cloudWatchLogGroupArn;
            this.name = builder.name;
            this.serverCredentials = builder.serverCredentials;
            this.tags = (java.util.List<software.amazon.awscdk.CfnTag>)builder.tags;
        }

        @Override
        public final java.util.List<java.lang.String> getAgentArns() {
            return this.agentArns;
        }

        @Override
        public final java.lang.Object getServerConfiguration() {
            return this.serverConfiguration;
        }

        @Override
        public final java.lang.String getSystemType() {
            return this.systemType;
        }

        @Override
        public final java.lang.String getCloudWatchLogGroupArn() {
            return this.cloudWatchLogGroupArn;
        }

        @Override
        public final java.lang.String getName() {
            return this.name;
        }

        @Override
        public final java.lang.Object getServerCredentials() {
            return this.serverCredentials;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.CfnTag> getTags() {
            return this.tags;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("agentArns", om.valueToTree(this.getAgentArns()));
            data.set("serverConfiguration", om.valueToTree(this.getServerConfiguration()));
            data.set("systemType", om.valueToTree(this.getSystemType()));
            if (this.getCloudWatchLogGroupArn() != null) {
                data.set("cloudWatchLogGroupArn", om.valueToTree(this.getCloudWatchLogGroupArn()));
            }
            if (this.getName() != null) {
                data.set("name", om.valueToTree(this.getName()));
            }
            if (this.getServerCredentials() != null) {
                data.set("serverCredentials", om.valueToTree(this.getServerCredentials()));
            }
            if (this.getTags() != null) {
                data.set("tags", om.valueToTree(this.getTags()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_datasync.CfnStorageSystemProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnStorageSystemProps.Jsii$Proxy that = (CfnStorageSystemProps.Jsii$Proxy) o;

            if (!agentArns.equals(that.agentArns)) return false;
            if (!serverConfiguration.equals(that.serverConfiguration)) return false;
            if (!systemType.equals(that.systemType)) return false;
            if (this.cloudWatchLogGroupArn != null ? !this.cloudWatchLogGroupArn.equals(that.cloudWatchLogGroupArn) : that.cloudWatchLogGroupArn != null) return false;
            if (this.name != null ? !this.name.equals(that.name) : that.name != null) return false;
            if (this.serverCredentials != null ? !this.serverCredentials.equals(that.serverCredentials) : that.serverCredentials != null) return false;
            return this.tags != null ? this.tags.equals(that.tags) : that.tags == null;
        }

        @Override
        public final int hashCode() {
            int result = this.agentArns.hashCode();
            result = 31 * result + (this.serverConfiguration.hashCode());
            result = 31 * result + (this.systemType.hashCode());
            result = 31 * result + (this.cloudWatchLogGroupArn != null ? this.cloudWatchLogGroupArn.hashCode() : 0);
            result = 31 * result + (this.name != null ? this.name.hashCode() : 0);
            result = 31 * result + (this.serverCredentials != null ? this.serverCredentials.hashCode() : 0);
            result = 31 * result + (this.tags != null ? this.tags.hashCode() : 0);
            return result;
        }
    }
}
