package software.amazon.awscdk.services.datazone;

/**
 * Properties for defining a <code>CfnEnvironmentBlueprintConfiguration</code>.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.datazone.*;
 * CfnEnvironmentBlueprintConfigurationProps cfnEnvironmentBlueprintConfigurationProps = CfnEnvironmentBlueprintConfigurationProps.builder()
 *         .domainIdentifier("domainIdentifier")
 *         .enabledRegions(List.of("enabledRegions"))
 *         .environmentBlueprintIdentifier("environmentBlueprintIdentifier")
 *         // the properties below are optional
 *         .manageAccessRoleArn("manageAccessRoleArn")
 *         .provisioningRoleArn("provisioningRoleArn")
 *         .regionalParameters(List.of(RegionalParameterProperty.builder()
 *                 .parameters(Map.of(
 *                         "parametersKey", "parameters"))
 *                 .region("region")
 *                 .build()))
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-datazone-environmentblueprintconfiguration.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-datazone-environmentblueprintconfiguration.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.109.0 (build c221850)", date = "2025-03-14T03:24:56.221Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_datazone.CfnEnvironmentBlueprintConfigurationProps")
@software.amazon.jsii.Jsii.Proxy(CfnEnvironmentBlueprintConfigurationProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnEnvironmentBlueprintConfigurationProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * The identifier of the Amazon DataZone domain in which an environment blueprint exists.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-datazone-environmentblueprintconfiguration.html#cfn-datazone-environmentblueprintconfiguration-domainidentifier">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-datazone-environmentblueprintconfiguration.html#cfn-datazone-environmentblueprintconfiguration-domainidentifier</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getDomainIdentifier();

    /**
     * The enabled AWS Regions specified in a blueprint configuration.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-datazone-environmentblueprintconfiguration.html#cfn-datazone-environmentblueprintconfiguration-enabledregions">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-datazone-environmentblueprintconfiguration.html#cfn-datazone-environmentblueprintconfiguration-enabledregions</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.util.List<java.lang.String> getEnabledRegions();

    /**
     * The identifier of the environment blueprint.
     * <p>
     * In the current release, only the following values are supported: <code>DefaultDataLake</code> and <code>DefaultDataWarehouse</code> .
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-datazone-environmentblueprintconfiguration.html#cfn-datazone-environmentblueprintconfiguration-environmentblueprintidentifier">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-datazone-environmentblueprintconfiguration.html#cfn-datazone-environmentblueprintconfiguration-environmentblueprintidentifier</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getEnvironmentBlueprintIdentifier();

    /**
     * The ARN of the manage access role.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-datazone-environmentblueprintconfiguration.html#cfn-datazone-environmentblueprintconfiguration-manageaccessrolearn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-datazone-environmentblueprintconfiguration.html#cfn-datazone-environmentblueprintconfiguration-manageaccessrolearn</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getManageAccessRoleArn() {
        return null;
    }

    /**
     * The ARN of the provisioning role.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-datazone-environmentblueprintconfiguration.html#cfn-datazone-environmentblueprintconfiguration-provisioningrolearn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-datazone-environmentblueprintconfiguration.html#cfn-datazone-environmentblueprintconfiguration-provisioningrolearn</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getProvisioningRoleArn() {
        return null;
    }

    /**
     * The regional parameters of the environment blueprint.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-datazone-environmentblueprintconfiguration.html#cfn-datazone-environmentblueprintconfiguration-regionalparameters">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-datazone-environmentblueprintconfiguration.html#cfn-datazone-environmentblueprintconfiguration-regionalparameters</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getRegionalParameters() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CfnEnvironmentBlueprintConfigurationProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnEnvironmentBlueprintConfigurationProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnEnvironmentBlueprintConfigurationProps> {
        java.lang.String domainIdentifier;
        java.util.List<java.lang.String> enabledRegions;
        java.lang.String environmentBlueprintIdentifier;
        java.lang.String manageAccessRoleArn;
        java.lang.String provisioningRoleArn;
        java.lang.Object regionalParameters;

        /**
         * Sets the value of {@link CfnEnvironmentBlueprintConfigurationProps#getDomainIdentifier}
         * @param domainIdentifier The identifier of the Amazon DataZone domain in which an environment blueprint exists. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder domainIdentifier(java.lang.String domainIdentifier) {
            this.domainIdentifier = domainIdentifier;
            return this;
        }

        /**
         * Sets the value of {@link CfnEnvironmentBlueprintConfigurationProps#getEnabledRegions}
         * @param enabledRegions The enabled AWS Regions specified in a blueprint configuration. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder enabledRegions(java.util.List<java.lang.String> enabledRegions) {
            this.enabledRegions = enabledRegions;
            return this;
        }

        /**
         * Sets the value of {@link CfnEnvironmentBlueprintConfigurationProps#getEnvironmentBlueprintIdentifier}
         * @param environmentBlueprintIdentifier The identifier of the environment blueprint. This parameter is required.
         *                                       In the current release, only the following values are supported: <code>DefaultDataLake</code> and <code>DefaultDataWarehouse</code> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder environmentBlueprintIdentifier(java.lang.String environmentBlueprintIdentifier) {
            this.environmentBlueprintIdentifier = environmentBlueprintIdentifier;
            return this;
        }

        /**
         * Sets the value of {@link CfnEnvironmentBlueprintConfigurationProps#getManageAccessRoleArn}
         * @param manageAccessRoleArn The ARN of the manage access role.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder manageAccessRoleArn(java.lang.String manageAccessRoleArn) {
            this.manageAccessRoleArn = manageAccessRoleArn;
            return this;
        }

        /**
         * Sets the value of {@link CfnEnvironmentBlueprintConfigurationProps#getProvisioningRoleArn}
         * @param provisioningRoleArn The ARN of the provisioning role.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder provisioningRoleArn(java.lang.String provisioningRoleArn) {
            this.provisioningRoleArn = provisioningRoleArn;
            return this;
        }

        /**
         * Sets the value of {@link CfnEnvironmentBlueprintConfigurationProps#getRegionalParameters}
         * @param regionalParameters The regional parameters of the environment blueprint.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder regionalParameters(software.amazon.awscdk.IResolvable regionalParameters) {
            this.regionalParameters = regionalParameters;
            return this;
        }

        /**
         * Sets the value of {@link CfnEnvironmentBlueprintConfigurationProps#getRegionalParameters}
         * @param regionalParameters The regional parameters of the environment blueprint.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder regionalParameters(java.util.List<? extends java.lang.Object> regionalParameters) {
            this.regionalParameters = regionalParameters;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnEnvironmentBlueprintConfigurationProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnEnvironmentBlueprintConfigurationProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnEnvironmentBlueprintConfigurationProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnEnvironmentBlueprintConfigurationProps {
        private final java.lang.String domainIdentifier;
        private final java.util.List<java.lang.String> enabledRegions;
        private final java.lang.String environmentBlueprintIdentifier;
        private final java.lang.String manageAccessRoleArn;
        private final java.lang.String provisioningRoleArn;
        private final java.lang.Object regionalParameters;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.domainIdentifier = software.amazon.jsii.Kernel.get(this, "domainIdentifier", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.enabledRegions = software.amazon.jsii.Kernel.get(this, "enabledRegions", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.environmentBlueprintIdentifier = software.amazon.jsii.Kernel.get(this, "environmentBlueprintIdentifier", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.manageAccessRoleArn = software.amazon.jsii.Kernel.get(this, "manageAccessRoleArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.provisioningRoleArn = software.amazon.jsii.Kernel.get(this, "provisioningRoleArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.regionalParameters = software.amazon.jsii.Kernel.get(this, "regionalParameters", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.domainIdentifier = java.util.Objects.requireNonNull(builder.domainIdentifier, "domainIdentifier is required");
            this.enabledRegions = java.util.Objects.requireNonNull(builder.enabledRegions, "enabledRegions is required");
            this.environmentBlueprintIdentifier = java.util.Objects.requireNonNull(builder.environmentBlueprintIdentifier, "environmentBlueprintIdentifier is required");
            this.manageAccessRoleArn = builder.manageAccessRoleArn;
            this.provisioningRoleArn = builder.provisioningRoleArn;
            this.regionalParameters = builder.regionalParameters;
        }

        @Override
        public final java.lang.String getDomainIdentifier() {
            return this.domainIdentifier;
        }

        @Override
        public final java.util.List<java.lang.String> getEnabledRegions() {
            return this.enabledRegions;
        }

        @Override
        public final java.lang.String getEnvironmentBlueprintIdentifier() {
            return this.environmentBlueprintIdentifier;
        }

        @Override
        public final java.lang.String getManageAccessRoleArn() {
            return this.manageAccessRoleArn;
        }

        @Override
        public final java.lang.String getProvisioningRoleArn() {
            return this.provisioningRoleArn;
        }

        @Override
        public final java.lang.Object getRegionalParameters() {
            return this.regionalParameters;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("domainIdentifier", om.valueToTree(this.getDomainIdentifier()));
            data.set("enabledRegions", om.valueToTree(this.getEnabledRegions()));
            data.set("environmentBlueprintIdentifier", om.valueToTree(this.getEnvironmentBlueprintIdentifier()));
            if (this.getManageAccessRoleArn() != null) {
                data.set("manageAccessRoleArn", om.valueToTree(this.getManageAccessRoleArn()));
            }
            if (this.getProvisioningRoleArn() != null) {
                data.set("provisioningRoleArn", om.valueToTree(this.getProvisioningRoleArn()));
            }
            if (this.getRegionalParameters() != null) {
                data.set("regionalParameters", om.valueToTree(this.getRegionalParameters()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_datazone.CfnEnvironmentBlueprintConfigurationProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnEnvironmentBlueprintConfigurationProps.Jsii$Proxy that = (CfnEnvironmentBlueprintConfigurationProps.Jsii$Proxy) o;

            if (!domainIdentifier.equals(that.domainIdentifier)) return false;
            if (!enabledRegions.equals(that.enabledRegions)) return false;
            if (!environmentBlueprintIdentifier.equals(that.environmentBlueprintIdentifier)) return false;
            if (this.manageAccessRoleArn != null ? !this.manageAccessRoleArn.equals(that.manageAccessRoleArn) : that.manageAccessRoleArn != null) return false;
            if (this.provisioningRoleArn != null ? !this.provisioningRoleArn.equals(that.provisioningRoleArn) : that.provisioningRoleArn != null) return false;
            return this.regionalParameters != null ? this.regionalParameters.equals(that.regionalParameters) : that.regionalParameters == null;
        }

        @Override
        public final int hashCode() {
            int result = this.domainIdentifier.hashCode();
            result = 31 * result + (this.enabledRegions.hashCode());
            result = 31 * result + (this.environmentBlueprintIdentifier.hashCode());
            result = 31 * result + (this.manageAccessRoleArn != null ? this.manageAccessRoleArn.hashCode() : 0);
            result = 31 * result + (this.provisioningRoleArn != null ? this.provisioningRoleArn.hashCode() : 0);
            result = 31 * result + (this.regionalParameters != null ? this.regionalParameters.hashCode() : 0);
            return result;
        }
    }
}
