package software.amazon.awscdk.services.deadline;

/**
 * Properties for defining a <code>CfnMonitor</code>.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.deadline.*;
 * CfnMonitorProps cfnMonitorProps = CfnMonitorProps.builder()
 *         .displayName("displayName")
 *         .identityCenterInstanceArn("identityCenterInstanceArn")
 *         .roleArn("roleArn")
 *         .subdomain("subdomain")
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-deadline-monitor.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-deadline-monitor.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.109.0 (build c221850)", date = "2025-03-14T03:24:56.269Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_deadline.CfnMonitorProps")
@software.amazon.jsii.Jsii.Proxy(CfnMonitorProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnMonitorProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * The name of the monitor that displays on the Deadline Cloud console.
     * <p>
     * <blockquote>
     * <p>
     * This field can store any content. Escape or encode this content before displaying it on a webpage or any other system that might interpret the content of this field.
     * <p>
     * </blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-deadline-monitor.html#cfn-deadline-monitor-displayname">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-deadline-monitor.html#cfn-deadline-monitor-displayname</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getDisplayName();

    /**
     * The Amazon Resource Name (ARN) of the IAM Identity Center instance responsible for authenticating monitor users.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-deadline-monitor.html#cfn-deadline-monitor-identitycenterinstancearn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-deadline-monitor.html#cfn-deadline-monitor-identitycenterinstancearn</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getIdentityCenterInstanceArn();

    /**
     * The Amazon Resource Name (ARN) of the IAM role for the monitor.
     * <p>
     * Users of the monitor use this role to access Deadline Cloud resources.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-deadline-monitor.html#cfn-deadline-monitor-rolearn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-deadline-monitor.html#cfn-deadline-monitor-rolearn</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getRoleArn();

    /**
     * The subdomain used for the monitor URL.
     * <p>
     * The full URL of the monitor is subdomain.Region.deadlinecloud.amazonaws.com.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-deadline-monitor.html#cfn-deadline-monitor-subdomain">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-deadline-monitor.html#cfn-deadline-monitor-subdomain</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getSubdomain();

    /**
     * @return a {@link Builder} of {@link CfnMonitorProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnMonitorProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnMonitorProps> {
        java.lang.String displayName;
        java.lang.String identityCenterInstanceArn;
        java.lang.String roleArn;
        java.lang.String subdomain;

        /**
         * Sets the value of {@link CfnMonitorProps#getDisplayName}
         * @param displayName The name of the monitor that displays on the Deadline Cloud console. This parameter is required.
         *                    <blockquote>
         *                    <p>
         *                    This field can store any content. Escape or encode this content before displaying it on a webpage or any other system that might interpret the content of this field.
         *                    <p>
         *                    </blockquote>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder displayName(java.lang.String displayName) {
            this.displayName = displayName;
            return this;
        }

        /**
         * Sets the value of {@link CfnMonitorProps#getIdentityCenterInstanceArn}
         * @param identityCenterInstanceArn The Amazon Resource Name (ARN) of the IAM Identity Center instance responsible for authenticating monitor users. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder identityCenterInstanceArn(java.lang.String identityCenterInstanceArn) {
            this.identityCenterInstanceArn = identityCenterInstanceArn;
            return this;
        }

        /**
         * Sets the value of {@link CfnMonitorProps#getRoleArn}
         * @param roleArn The Amazon Resource Name (ARN) of the IAM role for the monitor. This parameter is required.
         *                Users of the monitor use this role to access Deadline Cloud resources.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder roleArn(java.lang.String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        /**
         * Sets the value of {@link CfnMonitorProps#getSubdomain}
         * @param subdomain The subdomain used for the monitor URL. This parameter is required.
         *                  The full URL of the monitor is subdomain.Region.deadlinecloud.amazonaws.com.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder subdomain(java.lang.String subdomain) {
            this.subdomain = subdomain;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnMonitorProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnMonitorProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnMonitorProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnMonitorProps {
        private final java.lang.String displayName;
        private final java.lang.String identityCenterInstanceArn;
        private final java.lang.String roleArn;
        private final java.lang.String subdomain;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.displayName = software.amazon.jsii.Kernel.get(this, "displayName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.identityCenterInstanceArn = software.amazon.jsii.Kernel.get(this, "identityCenterInstanceArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.roleArn = software.amazon.jsii.Kernel.get(this, "roleArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.subdomain = software.amazon.jsii.Kernel.get(this, "subdomain", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.displayName = java.util.Objects.requireNonNull(builder.displayName, "displayName is required");
            this.identityCenterInstanceArn = java.util.Objects.requireNonNull(builder.identityCenterInstanceArn, "identityCenterInstanceArn is required");
            this.roleArn = java.util.Objects.requireNonNull(builder.roleArn, "roleArn is required");
            this.subdomain = java.util.Objects.requireNonNull(builder.subdomain, "subdomain is required");
        }

        @Override
        public final java.lang.String getDisplayName() {
            return this.displayName;
        }

        @Override
        public final java.lang.String getIdentityCenterInstanceArn() {
            return this.identityCenterInstanceArn;
        }

        @Override
        public final java.lang.String getRoleArn() {
            return this.roleArn;
        }

        @Override
        public final java.lang.String getSubdomain() {
            return this.subdomain;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("displayName", om.valueToTree(this.getDisplayName()));
            data.set("identityCenterInstanceArn", om.valueToTree(this.getIdentityCenterInstanceArn()));
            data.set("roleArn", om.valueToTree(this.getRoleArn()));
            data.set("subdomain", om.valueToTree(this.getSubdomain()));

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_deadline.CfnMonitorProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnMonitorProps.Jsii$Proxy that = (CfnMonitorProps.Jsii$Proxy) o;

            if (!displayName.equals(that.displayName)) return false;
            if (!identityCenterInstanceArn.equals(that.identityCenterInstanceArn)) return false;
            if (!roleArn.equals(that.roleArn)) return false;
            return this.subdomain.equals(that.subdomain);
        }

        @Override
        public final int hashCode() {
            int result = this.displayName.hashCode();
            result = 31 * result + (this.identityCenterInstanceArn.hashCode());
            result = 31 * result + (this.roleArn.hashCode());
            result = 31 * result + (this.subdomain.hashCode());
            return result;
        }
    }
}
