package software.amazon.awscdk.services.dms;

/**
 * http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dms-replicationconfig.html.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.dms.*;
 * Object replicationSettings;
 * Object supplementalSettings;
 * Object tableMappings;
 * CfnReplicationConfig cfnReplicationConfig = CfnReplicationConfig.Builder.create(this, "MyCfnReplicationConfig")
 *         .computeConfig(ComputeConfigProperty.builder()
 *                 .maxCapacityUnits(123)
 *                 // the properties below are optional
 *                 .availabilityZone("availabilityZone")
 *                 .dnsNameServers("dnsNameServers")
 *                 .kmsKeyId("kmsKeyId")
 *                 .minCapacityUnits(123)
 *                 .multiAz(false)
 *                 .preferredMaintenanceWindow("preferredMaintenanceWindow")
 *                 .replicationSubnetGroupId("replicationSubnetGroupId")
 *                 .vpcSecurityGroupIds(List.of("vpcSecurityGroupIds"))
 *                 .build())
 *         .replicationConfigIdentifier("replicationConfigIdentifier")
 *         .replicationType("replicationType")
 *         .sourceEndpointArn("sourceEndpointArn")
 *         .tableMappings(tableMappings)
 *         .targetEndpointArn("targetEndpointArn")
 *         // the properties below are optional
 *         .replicationSettings(replicationSettings)
 *         .resourceIdentifier("resourceIdentifier")
 *         .supplementalSettings(supplementalSettings)
 *         .tags(List.of(CfnTag.builder()
 *                 .key("key")
 *                 .value("value")
 *                 .build()))
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dms-replicationconfig.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dms-replicationconfig.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.109.0 (build c221850)", date = "2025-03-14T03:24:56.459Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_dms.CfnReplicationConfig")
public class CfnReplicationConfig extends software.amazon.awscdk.CfnResource implements software.amazon.awscdk.IInspectable, software.amazon.awscdk.ITaggableV2 {

    protected CfnReplicationConfig(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnReplicationConfig(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        CFN_RESOURCE_TYPE_NAME = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.dms.CfnReplicationConfig.class, "CFN_RESOURCE_TYPE_NAME", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * @param scope Scope in which this resource is defined. This parameter is required.
     * @param id Construct identifier for this resource (unique in its scope). This parameter is required.
     * @param props Resource properties. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public CfnReplicationConfig(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.dms.CfnReplicationConfigProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Examines the CloudFormation resource and discloses attributes.
     * <p>
     * @param inspector tree inspector to collect and process attributes. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public void inspect(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.TreeInspector inspector) {
        software.amazon.jsii.Kernel.call(this, "inspect", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(inspector, "inspector is required") });
    }

    /**
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> renderProperties(final @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> props) {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.call(this, "renderProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class)), new Object[] { java.util.Objects.requireNonNull(props, "props is required") }));
    }

    /**
     * The CloudFormation resource type name for this resource class.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String CFN_RESOURCE_TYPE_NAME;

    /**
     * The Amazon Resource Name (ARN) of this AWS DMS Serverless replication configuration.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrReplicationConfigArn() {
        return software.amazon.jsii.Kernel.get(this, "attrReplicationConfigArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Tag Manager which manages the tags for this resource.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.TagManager getCdkTagManager() {
        return software.amazon.jsii.Kernel.get(this, "cdkTagManager", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.TagManager.class));
    }

    /**
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> getCfnProperties() {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.get(this, "cfnProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class))));
    }

    /**
     * Configuration parameters for provisioning an AWS DMS Serverless replication.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.Object getComputeConfig() {
        return software.amazon.jsii.Kernel.get(this, "computeConfig", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * Configuration parameters for provisioning an AWS DMS Serverless replication.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setComputeConfig(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "computeConfig", java.util.Objects.requireNonNull(value, "computeConfig is required"));
    }

    /**
     * Configuration parameters for provisioning an AWS DMS Serverless replication.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setComputeConfig(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.dms.CfnReplicationConfig.ComputeConfigProperty value) {
        software.amazon.jsii.Kernel.set(this, "computeConfig", java.util.Objects.requireNonNull(value, "computeConfig is required"));
    }

    /**
     * A unique identifier that you want to use to create a <code>ReplicationConfigArn</code> that is returned as part of the output from this action.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getReplicationConfigIdentifier() {
        return software.amazon.jsii.Kernel.get(this, "replicationConfigIdentifier", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * A unique identifier that you want to use to create a <code>ReplicationConfigArn</code> that is returned as part of the output from this action.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setReplicationConfigIdentifier(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "replicationConfigIdentifier", java.util.Objects.requireNonNull(value, "replicationConfigIdentifier is required"));
    }

    /**
     * The type of AWS DMS Serverless replication to provision using this replication configuration.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getReplicationType() {
        return software.amazon.jsii.Kernel.get(this, "replicationType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The type of AWS DMS Serverless replication to provision using this replication configuration.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setReplicationType(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "replicationType", java.util.Objects.requireNonNull(value, "replicationType is required"));
    }

    /**
     * The Amazon Resource Name (ARN) of the source endpoint for this AWS DMS Serverless replication configuration.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getSourceEndpointArn() {
        return software.amazon.jsii.Kernel.get(this, "sourceEndpointArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The Amazon Resource Name (ARN) of the source endpoint for this AWS DMS Serverless replication configuration.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setSourceEndpointArn(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "sourceEndpointArn", java.util.Objects.requireNonNull(value, "sourceEndpointArn is required"));
    }

    /**
     * JSON table mappings for AWS DMS Serverless replications that are provisioned using this replication configuration.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.Object getTableMappings() {
        return software.amazon.jsii.Kernel.get(this, "tableMappings", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * JSON table mappings for AWS DMS Serverless replications that are provisioned using this replication configuration.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setTableMappings(final @org.jetbrains.annotations.NotNull java.lang.Object value) {
        software.amazon.jsii.Kernel.set(this, "tableMappings", java.util.Objects.requireNonNull(value, "tableMappings is required"));
    }

    /**
     * The Amazon Resource Name (ARN) of the target endpoint for this AWS DMS serverless replication configuration.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getTargetEndpointArn() {
        return software.amazon.jsii.Kernel.get(this, "targetEndpointArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The Amazon Resource Name (ARN) of the target endpoint for this AWS DMS serverless replication configuration.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setTargetEndpointArn(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "targetEndpointArn", java.util.Objects.requireNonNull(value, "targetEndpointArn is required"));
    }

    /**
     * Optional JSON settings for AWS DMS Serverless replications that are provisioned using this replication configuration.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getReplicationSettings() {
        return software.amazon.jsii.Kernel.get(this, "replicationSettings", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * Optional JSON settings for AWS DMS Serverless replications that are provisioned using this replication configuration.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setReplicationSettings(final @org.jetbrains.annotations.Nullable java.lang.Object value) {
        software.amazon.jsii.Kernel.set(this, "replicationSettings", value);
    }

    /**
     * Optional unique value or name that you set for a given resource that can be used to construct an Amazon Resource Name (ARN) for that resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getResourceIdentifier() {
        return software.amazon.jsii.Kernel.get(this, "resourceIdentifier", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Optional unique value or name that you set for a given resource that can be used to construct an Amazon Resource Name (ARN) for that resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setResourceIdentifier(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "resourceIdentifier", value);
    }

    /**
     * Optional JSON settings for specifying supplemental data.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getSupplementalSettings() {
        return software.amazon.jsii.Kernel.get(this, "supplementalSettings", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * Optional JSON settings for specifying supplemental data.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setSupplementalSettings(final @org.jetbrains.annotations.Nullable java.lang.Object value) {
        software.amazon.jsii.Kernel.set(this, "supplementalSettings", value);
    }

    /**
     * One or more optional tags associated with resources used by the AWS DMS Serverless replication.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.CfnTag> getTags() {
        return java.util.Optional.ofNullable((java.util.List<software.amazon.awscdk.CfnTag>)(software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.CfnTag.class))))).map(java.util.Collections::unmodifiableList).orElse(null);
    }

    /**
     * One or more optional tags associated with resources used by the AWS DMS Serverless replication.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setTags(final @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.CfnTag> value) {
        software.amazon.jsii.Kernel.set(this, "tags", value);
    }
    /**
     * Configuration parameters for provisioning an AWS DMS Serverless replication.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.dms.*;
     * ComputeConfigProperty computeConfigProperty = ComputeConfigProperty.builder()
     *         .maxCapacityUnits(123)
     *         // the properties below are optional
     *         .availabilityZone("availabilityZone")
     *         .dnsNameServers("dnsNameServers")
     *         .kmsKeyId("kmsKeyId")
     *         .minCapacityUnits(123)
     *         .multiAz(false)
     *         .preferredMaintenanceWindow("preferredMaintenanceWindow")
     *         .replicationSubnetGroupId("replicationSubnetGroupId")
     *         .vpcSecurityGroupIds(List.of("vpcSecurityGroupIds"))
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dms-replicationconfig-computeconfig.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dms-replicationconfig-computeconfig.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_dms.CfnReplicationConfig.ComputeConfigProperty")
    @software.amazon.jsii.Jsii.Proxy(ComputeConfigProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ComputeConfigProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Specifies the maximum value of the AWS DMS capacity units (DCUs) for which a given AWS DMS Serverless replication can be provisioned.
         * <p>
         * A single DCU is 2GB of RAM, with 1 DCU as the minimum value allowed. The list of valid DCU values includes 1, 2, 4, 8, 16, 32, 64, 128, 192, 256, and 384. So, the maximum value that you can specify for AWS DMS Serverless is 384. The <code>MaxCapacityUnits</code> parameter is the only DCU parameter you are required to specify.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dms-replicationconfig-computeconfig.html#cfn-dms-replicationconfig-computeconfig-maxcapacityunits">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dms-replicationconfig-computeconfig.html#cfn-dms-replicationconfig-computeconfig-maxcapacityunits</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Number getMaxCapacityUnits();

        /**
         * The Availability Zone where the AWS DMS Serverless replication using this configuration will run.
         * <p>
         * The default value is a random, system-chosen Availability Zone in the configuration's AWS Region , for example, <code>"us-west-2"</code> . You can't set this parameter if the <code>MultiAZ</code> parameter is set to <code>true</code> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dms-replicationconfig-computeconfig.html#cfn-dms-replicationconfig-computeconfig-availabilityzone">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dms-replicationconfig-computeconfig.html#cfn-dms-replicationconfig-computeconfig-availabilityzone</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getAvailabilityZone() {
            return null;
        }

        /**
         * A list of custom DNS name servers supported for the AWS DMS Serverless replication to access your source or target database.
         * <p>
         * This list overrides the default name servers supported by the AWS DMS Serverless replication. You can specify a comma-separated list of internet addresses for up to four DNS name servers. For example: <code>"1.1.1.1,2.2.2.2,3.3.3.3,4.4.4.4"</code>
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dms-replicationconfig-computeconfig.html#cfn-dms-replicationconfig-computeconfig-dnsnameservers">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dms-replicationconfig-computeconfig.html#cfn-dms-replicationconfig-computeconfig-dnsnameservers</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getDnsNameServers() {
            return null;
        }

        /**
         * An AWS Key Management Service ( AWS KMS ) key Amazon Resource Name (ARN) that is used to encrypt the data during AWS DMS Serverless replication.
         * <p>
         * If you don't specify a value for the <code>KmsKeyId</code> parameter, AWS DMS uses your default encryption key.
         * <p>
         * AWS KMS creates the default encryption key for your Amazon Web Services account. Your AWS account has a different default encryption key for each AWS Region .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dms-replicationconfig-computeconfig.html#cfn-dms-replicationconfig-computeconfig-kmskeyid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dms-replicationconfig-computeconfig.html#cfn-dms-replicationconfig-computeconfig-kmskeyid</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getKmsKeyId() {
            return null;
        }

        /**
         * Specifies the minimum value of the AWS DMS capacity units (DCUs) for which a given AWS DMS Serverless replication can be provisioned.
         * <p>
         * A single DCU is 2GB of RAM, with 1 DCU as the minimum value allowed. The list of valid DCU values includes 1, 2, 4, 8, 16, 32, 64, 128, 192, 256, and 384. So, the minimum DCU value that you can specify for AWS DMS Serverless is 1. If you don't set this value, AWS DMS sets this parameter to the minimum DCU value allowed, 1. If there is no current source activity, AWS DMS scales down your replication until it reaches the value specified in <code>MinCapacityUnits</code> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dms-replicationconfig-computeconfig.html#cfn-dms-replicationconfig-computeconfig-mincapacityunits">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dms-replicationconfig-computeconfig.html#cfn-dms-replicationconfig-computeconfig-mincapacityunits</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getMinCapacityUnits() {
            return null;
        }

        /**
         * Specifies whether the AWS DMS Serverless replication is a Multi-AZ deployment.
         * <p>
         * You can't set the <code>AvailabilityZone</code> parameter if the <code>MultiAZ</code> parameter is set to <code>true</code> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dms-replicationconfig-computeconfig.html#cfn-dms-replicationconfig-computeconfig-multiaz">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dms-replicationconfig-computeconfig.html#cfn-dms-replicationconfig-computeconfig-multiaz</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getMultiAz() {
            return null;
        }

        /**
         * The weekly time range during which system maintenance can occur for the AWS DMS Serverless replication, in Universal Coordinated Time (UTC).
         * <p>
         * The format is <code>ddd:hh24:mi-ddd:hh24:mi</code> .
         * <p>
         * The default is a 30-minute window selected at random from an 8-hour block of time per AWS Region . This maintenance occurs on a random day of the week. Valid values for days of the week include <code>Mon</code> , <code>Tue</code> , <code>Wed</code> , <code>Thu</code> , <code>Fri</code> , <code>Sat</code> , and <code>Sun</code> .
         * <p>
         * Constraints include a minimum 30-minute window.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dms-replicationconfig-computeconfig.html#cfn-dms-replicationconfig-computeconfig-preferredmaintenancewindow">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dms-replicationconfig-computeconfig.html#cfn-dms-replicationconfig-computeconfig-preferredmaintenancewindow</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getPreferredMaintenanceWindow() {
            return null;
        }

        /**
         * Specifies a subnet group identifier to associate with the AWS DMS Serverless replication.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dms-replicationconfig-computeconfig.html#cfn-dms-replicationconfig-computeconfig-replicationsubnetgroupid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dms-replicationconfig-computeconfig.html#cfn-dms-replicationconfig-computeconfig-replicationsubnetgroupid</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getReplicationSubnetGroupId() {
            return null;
        }

        /**
         * Specifies the virtual private cloud (VPC) security group to use with the AWS DMS Serverless replication.
         * <p>
         * The VPC security group must work with the VPC containing the replication.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dms-replicationconfig-computeconfig.html#cfn-dms-replicationconfig-computeconfig-vpcsecuritygroupids">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dms-replicationconfig-computeconfig.html#cfn-dms-replicationconfig-computeconfig-vpcsecuritygroupids</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getVpcSecurityGroupIds() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link ComputeConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ComputeConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ComputeConfigProperty> {
            java.lang.Number maxCapacityUnits;
            java.lang.String availabilityZone;
            java.lang.String dnsNameServers;
            java.lang.String kmsKeyId;
            java.lang.Number minCapacityUnits;
            java.lang.Object multiAz;
            java.lang.String preferredMaintenanceWindow;
            java.lang.String replicationSubnetGroupId;
            java.util.List<java.lang.String> vpcSecurityGroupIds;

            /**
             * Sets the value of {@link ComputeConfigProperty#getMaxCapacityUnits}
             * @param maxCapacityUnits Specifies the maximum value of the AWS DMS capacity units (DCUs) for which a given AWS DMS Serverless replication can be provisioned. This parameter is required.
             *                         A single DCU is 2GB of RAM, with 1 DCU as the minimum value allowed. The list of valid DCU values includes 1, 2, 4, 8, 16, 32, 64, 128, 192, 256, and 384. So, the maximum value that you can specify for AWS DMS Serverless is 384. The <code>MaxCapacityUnits</code> parameter is the only DCU parameter you are required to specify.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder maxCapacityUnits(java.lang.Number maxCapacityUnits) {
                this.maxCapacityUnits = maxCapacityUnits;
                return this;
            }

            /**
             * Sets the value of {@link ComputeConfigProperty#getAvailabilityZone}
             * @param availabilityZone The Availability Zone where the AWS DMS Serverless replication using this configuration will run.
             *                         The default value is a random, system-chosen Availability Zone in the configuration's AWS Region , for example, <code>"us-west-2"</code> . You can't set this parameter if the <code>MultiAZ</code> parameter is set to <code>true</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder availabilityZone(java.lang.String availabilityZone) {
                this.availabilityZone = availabilityZone;
                return this;
            }

            /**
             * Sets the value of {@link ComputeConfigProperty#getDnsNameServers}
             * @param dnsNameServers A list of custom DNS name servers supported for the AWS DMS Serverless replication to access your source or target database.
             *                       This list overrides the default name servers supported by the AWS DMS Serverless replication. You can specify a comma-separated list of internet addresses for up to four DNS name servers. For example: <code>"1.1.1.1,2.2.2.2,3.3.3.3,4.4.4.4"</code>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder dnsNameServers(java.lang.String dnsNameServers) {
                this.dnsNameServers = dnsNameServers;
                return this;
            }

            /**
             * Sets the value of {@link ComputeConfigProperty#getKmsKeyId}
             * @param kmsKeyId An AWS Key Management Service ( AWS KMS ) key Amazon Resource Name (ARN) that is used to encrypt the data during AWS DMS Serverless replication.
             *                 If you don't specify a value for the <code>KmsKeyId</code> parameter, AWS DMS uses your default encryption key.
             *                 <p>
             *                 AWS KMS creates the default encryption key for your Amazon Web Services account. Your AWS account has a different default encryption key for each AWS Region .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder kmsKeyId(java.lang.String kmsKeyId) {
                this.kmsKeyId = kmsKeyId;
                return this;
            }

            /**
             * Sets the value of {@link ComputeConfigProperty#getMinCapacityUnits}
             * @param minCapacityUnits Specifies the minimum value of the AWS DMS capacity units (DCUs) for which a given AWS DMS Serverless replication can be provisioned.
             *                         A single DCU is 2GB of RAM, with 1 DCU as the minimum value allowed. The list of valid DCU values includes 1, 2, 4, 8, 16, 32, 64, 128, 192, 256, and 384. So, the minimum DCU value that you can specify for AWS DMS Serverless is 1. If you don't set this value, AWS DMS sets this parameter to the minimum DCU value allowed, 1. If there is no current source activity, AWS DMS scales down your replication until it reaches the value specified in <code>MinCapacityUnits</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder minCapacityUnits(java.lang.Number minCapacityUnits) {
                this.minCapacityUnits = minCapacityUnits;
                return this;
            }

            /**
             * Sets the value of {@link ComputeConfigProperty#getMultiAz}
             * @param multiAz Specifies whether the AWS DMS Serverless replication is a Multi-AZ deployment.
             *                You can't set the <code>AvailabilityZone</code> parameter if the <code>MultiAZ</code> parameter is set to <code>true</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder multiAz(java.lang.Boolean multiAz) {
                this.multiAz = multiAz;
                return this;
            }

            /**
             * Sets the value of {@link ComputeConfigProperty#getMultiAz}
             * @param multiAz Specifies whether the AWS DMS Serverless replication is a Multi-AZ deployment.
             *                You can't set the <code>AvailabilityZone</code> parameter if the <code>MultiAZ</code> parameter is set to <code>true</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder multiAz(software.amazon.awscdk.IResolvable multiAz) {
                this.multiAz = multiAz;
                return this;
            }

            /**
             * Sets the value of {@link ComputeConfigProperty#getPreferredMaintenanceWindow}
             * @param preferredMaintenanceWindow The weekly time range during which system maintenance can occur for the AWS DMS Serverless replication, in Universal Coordinated Time (UTC).
             *                                   The format is <code>ddd:hh24:mi-ddd:hh24:mi</code> .
             *                                   <p>
             *                                   The default is a 30-minute window selected at random from an 8-hour block of time per AWS Region . This maintenance occurs on a random day of the week. Valid values for days of the week include <code>Mon</code> , <code>Tue</code> , <code>Wed</code> , <code>Thu</code> , <code>Fri</code> , <code>Sat</code> , and <code>Sun</code> .
             *                                   <p>
             *                                   Constraints include a minimum 30-minute window.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder preferredMaintenanceWindow(java.lang.String preferredMaintenanceWindow) {
                this.preferredMaintenanceWindow = preferredMaintenanceWindow;
                return this;
            }

            /**
             * Sets the value of {@link ComputeConfigProperty#getReplicationSubnetGroupId}
             * @param replicationSubnetGroupId Specifies a subnet group identifier to associate with the AWS DMS Serverless replication.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder replicationSubnetGroupId(java.lang.String replicationSubnetGroupId) {
                this.replicationSubnetGroupId = replicationSubnetGroupId;
                return this;
            }

            /**
             * Sets the value of {@link ComputeConfigProperty#getVpcSecurityGroupIds}
             * @param vpcSecurityGroupIds Specifies the virtual private cloud (VPC) security group to use with the AWS DMS Serverless replication.
             *                            The VPC security group must work with the VPC containing the replication.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder vpcSecurityGroupIds(java.util.List<java.lang.String> vpcSecurityGroupIds) {
                this.vpcSecurityGroupIds = vpcSecurityGroupIds;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ComputeConfigProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ComputeConfigProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link ComputeConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ComputeConfigProperty {
            private final java.lang.Number maxCapacityUnits;
            private final java.lang.String availabilityZone;
            private final java.lang.String dnsNameServers;
            private final java.lang.String kmsKeyId;
            private final java.lang.Number minCapacityUnits;
            private final java.lang.Object multiAz;
            private final java.lang.String preferredMaintenanceWindow;
            private final java.lang.String replicationSubnetGroupId;
            private final java.util.List<java.lang.String> vpcSecurityGroupIds;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.maxCapacityUnits = software.amazon.jsii.Kernel.get(this, "maxCapacityUnits", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.availabilityZone = software.amazon.jsii.Kernel.get(this, "availabilityZone", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.dnsNameServers = software.amazon.jsii.Kernel.get(this, "dnsNameServers", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.kmsKeyId = software.amazon.jsii.Kernel.get(this, "kmsKeyId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.minCapacityUnits = software.amazon.jsii.Kernel.get(this, "minCapacityUnits", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.multiAz = software.amazon.jsii.Kernel.get(this, "multiAz", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.preferredMaintenanceWindow = software.amazon.jsii.Kernel.get(this, "preferredMaintenanceWindow", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.replicationSubnetGroupId = software.amazon.jsii.Kernel.get(this, "replicationSubnetGroupId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.vpcSecurityGroupIds = software.amazon.jsii.Kernel.get(this, "vpcSecurityGroupIds", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.maxCapacityUnits = java.util.Objects.requireNonNull(builder.maxCapacityUnits, "maxCapacityUnits is required");
                this.availabilityZone = builder.availabilityZone;
                this.dnsNameServers = builder.dnsNameServers;
                this.kmsKeyId = builder.kmsKeyId;
                this.minCapacityUnits = builder.minCapacityUnits;
                this.multiAz = builder.multiAz;
                this.preferredMaintenanceWindow = builder.preferredMaintenanceWindow;
                this.replicationSubnetGroupId = builder.replicationSubnetGroupId;
                this.vpcSecurityGroupIds = builder.vpcSecurityGroupIds;
            }

            @Override
            public final java.lang.Number getMaxCapacityUnits() {
                return this.maxCapacityUnits;
            }

            @Override
            public final java.lang.String getAvailabilityZone() {
                return this.availabilityZone;
            }

            @Override
            public final java.lang.String getDnsNameServers() {
                return this.dnsNameServers;
            }

            @Override
            public final java.lang.String getKmsKeyId() {
                return this.kmsKeyId;
            }

            @Override
            public final java.lang.Number getMinCapacityUnits() {
                return this.minCapacityUnits;
            }

            @Override
            public final java.lang.Object getMultiAz() {
                return this.multiAz;
            }

            @Override
            public final java.lang.String getPreferredMaintenanceWindow() {
                return this.preferredMaintenanceWindow;
            }

            @Override
            public final java.lang.String getReplicationSubnetGroupId() {
                return this.replicationSubnetGroupId;
            }

            @Override
            public final java.util.List<java.lang.String> getVpcSecurityGroupIds() {
                return this.vpcSecurityGroupIds;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("maxCapacityUnits", om.valueToTree(this.getMaxCapacityUnits()));
                if (this.getAvailabilityZone() != null) {
                    data.set("availabilityZone", om.valueToTree(this.getAvailabilityZone()));
                }
                if (this.getDnsNameServers() != null) {
                    data.set("dnsNameServers", om.valueToTree(this.getDnsNameServers()));
                }
                if (this.getKmsKeyId() != null) {
                    data.set("kmsKeyId", om.valueToTree(this.getKmsKeyId()));
                }
                if (this.getMinCapacityUnits() != null) {
                    data.set("minCapacityUnits", om.valueToTree(this.getMinCapacityUnits()));
                }
                if (this.getMultiAz() != null) {
                    data.set("multiAz", om.valueToTree(this.getMultiAz()));
                }
                if (this.getPreferredMaintenanceWindow() != null) {
                    data.set("preferredMaintenanceWindow", om.valueToTree(this.getPreferredMaintenanceWindow()));
                }
                if (this.getReplicationSubnetGroupId() != null) {
                    data.set("replicationSubnetGroupId", om.valueToTree(this.getReplicationSubnetGroupId()));
                }
                if (this.getVpcSecurityGroupIds() != null) {
                    data.set("vpcSecurityGroupIds", om.valueToTree(this.getVpcSecurityGroupIds()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_dms.CfnReplicationConfig.ComputeConfigProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ComputeConfigProperty.Jsii$Proxy that = (ComputeConfigProperty.Jsii$Proxy) o;

                if (!maxCapacityUnits.equals(that.maxCapacityUnits)) return false;
                if (this.availabilityZone != null ? !this.availabilityZone.equals(that.availabilityZone) : that.availabilityZone != null) return false;
                if (this.dnsNameServers != null ? !this.dnsNameServers.equals(that.dnsNameServers) : that.dnsNameServers != null) return false;
                if (this.kmsKeyId != null ? !this.kmsKeyId.equals(that.kmsKeyId) : that.kmsKeyId != null) return false;
                if (this.minCapacityUnits != null ? !this.minCapacityUnits.equals(that.minCapacityUnits) : that.minCapacityUnits != null) return false;
                if (this.multiAz != null ? !this.multiAz.equals(that.multiAz) : that.multiAz != null) return false;
                if (this.preferredMaintenanceWindow != null ? !this.preferredMaintenanceWindow.equals(that.preferredMaintenanceWindow) : that.preferredMaintenanceWindow != null) return false;
                if (this.replicationSubnetGroupId != null ? !this.replicationSubnetGroupId.equals(that.replicationSubnetGroupId) : that.replicationSubnetGroupId != null) return false;
                return this.vpcSecurityGroupIds != null ? this.vpcSecurityGroupIds.equals(that.vpcSecurityGroupIds) : that.vpcSecurityGroupIds == null;
            }

            @Override
            public final int hashCode() {
                int result = this.maxCapacityUnits.hashCode();
                result = 31 * result + (this.availabilityZone != null ? this.availabilityZone.hashCode() : 0);
                result = 31 * result + (this.dnsNameServers != null ? this.dnsNameServers.hashCode() : 0);
                result = 31 * result + (this.kmsKeyId != null ? this.kmsKeyId.hashCode() : 0);
                result = 31 * result + (this.minCapacityUnits != null ? this.minCapacityUnits.hashCode() : 0);
                result = 31 * result + (this.multiAz != null ? this.multiAz.hashCode() : 0);
                result = 31 * result + (this.preferredMaintenanceWindow != null ? this.preferredMaintenanceWindow.hashCode() : 0);
                result = 31 * result + (this.replicationSubnetGroupId != null ? this.replicationSubnetGroupId.hashCode() : 0);
                result = 31 * result + (this.vpcSecurityGroupIds != null ? this.vpcSecurityGroupIds.hashCode() : 0);
                return result;
            }
        }
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.dms.CfnReplicationConfig}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.dms.CfnReplicationConfig> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope Scope in which this resource is defined. This parameter is required.
         * @param id Construct identifier for this resource (unique in its scope). This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.dms.CfnReplicationConfigProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.services.dms.CfnReplicationConfigProps.Builder();
        }

        /**
         * Configuration parameters for provisioning an AWS DMS Serverless replication.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dms-replicationconfig.html#cfn-dms-replicationconfig-computeconfig">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dms-replicationconfig.html#cfn-dms-replicationconfig-computeconfig</a>
         * @param computeConfig Configuration parameters for provisioning an AWS DMS Serverless replication. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder computeConfig(final software.amazon.awscdk.IResolvable computeConfig) {
            this.props.computeConfig(computeConfig);
            return this;
        }
        /**
         * Configuration parameters for provisioning an AWS DMS Serverless replication.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dms-replicationconfig.html#cfn-dms-replicationconfig-computeconfig">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dms-replicationconfig.html#cfn-dms-replicationconfig-computeconfig</a>
         * @param computeConfig Configuration parameters for provisioning an AWS DMS Serverless replication. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder computeConfig(final software.amazon.awscdk.services.dms.CfnReplicationConfig.ComputeConfigProperty computeConfig) {
            this.props.computeConfig(computeConfig);
            return this;
        }

        /**
         * A unique identifier that you want to use to create a <code>ReplicationConfigArn</code> that is returned as part of the output from this action.
         * <p>
         * You can then pass this output <code>ReplicationConfigArn</code> as the value of the <code>ReplicationConfigArn</code> option for other actions to identify both AWS DMS Serverless replications and replication configurations that you want those actions to operate on. For some actions, you can also use either this unique identifier or a corresponding ARN in action filters to identify the specific replication and replication configuration to operate on.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dms-replicationconfig.html#cfn-dms-replicationconfig-replicationconfigidentifier">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dms-replicationconfig.html#cfn-dms-replicationconfig-replicationconfigidentifier</a>
         * @param replicationConfigIdentifier A unique identifier that you want to use to create a <code>ReplicationConfigArn</code> that is returned as part of the output from this action. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder replicationConfigIdentifier(final java.lang.String replicationConfigIdentifier) {
            this.props.replicationConfigIdentifier(replicationConfigIdentifier);
            return this;
        }

        /**
         * The type of AWS DMS Serverless replication to provision using this replication configuration.
         * <p>
         * Possible values:
         * <p>
         * <ul>
         * <li><code>"full-load"</code></li>
         * <li><code>"cdc"</code></li>
         * <li><code>"full-load-and-cdc"</code></li>
         * </ul>
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dms-replicationconfig.html#cfn-dms-replicationconfig-replicationtype">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dms-replicationconfig.html#cfn-dms-replicationconfig-replicationtype</a>
         * @param replicationType The type of AWS DMS Serverless replication to provision using this replication configuration. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder replicationType(final java.lang.String replicationType) {
            this.props.replicationType(replicationType);
            return this;
        }

        /**
         * The Amazon Resource Name (ARN) of the source endpoint for this AWS DMS Serverless replication configuration.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dms-replicationconfig.html#cfn-dms-replicationconfig-sourceendpointarn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dms-replicationconfig.html#cfn-dms-replicationconfig-sourceendpointarn</a>
         * @param sourceEndpointArn The Amazon Resource Name (ARN) of the source endpoint for this AWS DMS Serverless replication configuration. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder sourceEndpointArn(final java.lang.String sourceEndpointArn) {
            this.props.sourceEndpointArn(sourceEndpointArn);
            return this;
        }

        /**
         * JSON table mappings for AWS DMS Serverless replications that are provisioned using this replication configuration.
         * <p>
         * For more information, see <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Tasks.CustomizingTasks.TableMapping.SelectionTransformation.html">Specifying table selection and transformations rules using JSON</a> .
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dms-replicationconfig.html#cfn-dms-replicationconfig-tablemappings">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dms-replicationconfig.html#cfn-dms-replicationconfig-tablemappings</a>
         * @param tableMappings JSON table mappings for AWS DMS Serverless replications that are provisioned using this replication configuration. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder tableMappings(final java.lang.Object tableMappings) {
            this.props.tableMappings(tableMappings);
            return this;
        }

        /**
         * The Amazon Resource Name (ARN) of the target endpoint for this AWS DMS serverless replication configuration.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dms-replicationconfig.html#cfn-dms-replicationconfig-targetendpointarn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dms-replicationconfig.html#cfn-dms-replicationconfig-targetendpointarn</a>
         * @param targetEndpointArn The Amazon Resource Name (ARN) of the target endpoint for this AWS DMS serverless replication configuration. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder targetEndpointArn(final java.lang.String targetEndpointArn) {
            this.props.targetEndpointArn(targetEndpointArn);
            return this;
        }

        /**
         * Optional JSON settings for AWS DMS Serverless replications that are provisioned using this replication configuration.
         * <p>
         * For example, see <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Tasks.CustomizingTasks.TaskSettings.ChangeProcessingTuning.html">Change processing tuning settings</a> .
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dms-replicationconfig.html#cfn-dms-replicationconfig-replicationsettings">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dms-replicationconfig.html#cfn-dms-replicationconfig-replicationsettings</a>
         * @param replicationSettings Optional JSON settings for AWS DMS Serverless replications that are provisioned using this replication configuration. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder replicationSettings(final java.lang.Object replicationSettings) {
            this.props.replicationSettings(replicationSettings);
            return this;
        }

        /**
         * Optional unique value or name that you set for a given resource that can be used to construct an Amazon Resource Name (ARN) for that resource.
         * <p>
         * For more information, see <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Security.html#CHAP_Security.FineGrainedAccess">Fine-grained access control using resource names and tags</a> .
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dms-replicationconfig.html#cfn-dms-replicationconfig-resourceidentifier">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dms-replicationconfig.html#cfn-dms-replicationconfig-resourceidentifier</a>
         * @param resourceIdentifier Optional unique value or name that you set for a given resource that can be used to construct an Amazon Resource Name (ARN) for that resource. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder resourceIdentifier(final java.lang.String resourceIdentifier) {
            this.props.resourceIdentifier(resourceIdentifier);
            return this;
        }

        /**
         * Optional JSON settings for specifying supplemental data.
         * <p>
         * For more information, see <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Tasks.TaskData.html">Specifying supplemental data for task settings</a> .
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dms-replicationconfig.html#cfn-dms-replicationconfig-supplementalsettings">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dms-replicationconfig.html#cfn-dms-replicationconfig-supplementalsettings</a>
         * @param supplementalSettings Optional JSON settings for specifying supplemental data. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder supplementalSettings(final java.lang.Object supplementalSettings) {
            this.props.supplementalSettings(supplementalSettings);
            return this;
        }

        /**
         * One or more optional tags associated with resources used by the AWS DMS Serverless replication.
         * <p>
         * For more information, see <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Tagging.html">Tagging resources in AWS Database Migration Service</a> .
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dms-replicationconfig.html#cfn-dms-replicationconfig-tags">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dms-replicationconfig.html#cfn-dms-replicationconfig-tags</a>
         * @param tags One or more optional tags associated with resources used by the AWS DMS Serverless replication. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder tags(final java.util.List<? extends software.amazon.awscdk.CfnTag> tags) {
            this.props.tags(tags);
            return this;
        }

        /**
         * @return a newly built instance of {@link software.amazon.awscdk.services.dms.CfnReplicationConfig}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.dms.CfnReplicationConfig build() {
            return new software.amazon.awscdk.services.dms.CfnReplicationConfig(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
