package software.amazon.awscdk.services.dynamodb;

/**
 * Reference to PointInTimeRecovey Specification for continuous backups.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * TableV2 table = TableV2.Builder.create(this, "Table")
 *         .partitionKey(Attribute.builder().name("pk").type(AttributeType.STRING).build())
 *         .contributorInsights(true)
 *         .tableClass(TableClass.STANDARD_INFREQUENT_ACCESS)
 *         .pointInTimeRecoverySpecification(PointInTimeRecoverySpecification.builder()
 *                 .pointInTimeRecoveryEnabled(true)
 *                 .build())
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.109.0 (build c221850)", date = "2025-03-14T03:24:56.611Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_dynamodb.PointInTimeRecoverySpecification")
@software.amazon.jsii.Jsii.Proxy(PointInTimeRecoverySpecification.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface PointInTimeRecoverySpecification extends software.amazon.jsii.JsiiSerializable {

    /**
     * Indicates whether point in time recovery is enabled (true) or disabled (false) on the table.
     * <p>
     * Default: false
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.Boolean getPointInTimeRecoveryEnabled();

    /**
     * The number of preceding days for which continuous backups are taken and maintained.
     * <p>
     * Your table data is only recoverable to any point-in-time from within the configured recovery period.
     * If no value is provided, the value will default to 35.
     * <p>
     * Default: 35
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Number getRecoveryPeriodInDays() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link PointInTimeRecoverySpecification}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link PointInTimeRecoverySpecification}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<PointInTimeRecoverySpecification> {
        java.lang.Boolean pointInTimeRecoveryEnabled;
        java.lang.Number recoveryPeriodInDays;

        /**
         * Sets the value of {@link PointInTimeRecoverySpecification#getPointInTimeRecoveryEnabled}
         * @param pointInTimeRecoveryEnabled Indicates whether point in time recovery is enabled (true) or disabled (false) on the table. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder pointInTimeRecoveryEnabled(java.lang.Boolean pointInTimeRecoveryEnabled) {
            this.pointInTimeRecoveryEnabled = pointInTimeRecoveryEnabled;
            return this;
        }

        /**
         * Sets the value of {@link PointInTimeRecoverySpecification#getRecoveryPeriodInDays}
         * @param recoveryPeriodInDays The number of preceding days for which continuous backups are taken and maintained.
         *                             Your table data is only recoverable to any point-in-time from within the configured recovery period.
         *                             If no value is provided, the value will default to 35.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder recoveryPeriodInDays(java.lang.Number recoveryPeriodInDays) {
            this.recoveryPeriodInDays = recoveryPeriodInDays;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link PointInTimeRecoverySpecification}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public PointInTimeRecoverySpecification build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link PointInTimeRecoverySpecification}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements PointInTimeRecoverySpecification {
        private final java.lang.Boolean pointInTimeRecoveryEnabled;
        private final java.lang.Number recoveryPeriodInDays;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.pointInTimeRecoveryEnabled = software.amazon.jsii.Kernel.get(this, "pointInTimeRecoveryEnabled", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.recoveryPeriodInDays = software.amazon.jsii.Kernel.get(this, "recoveryPeriodInDays", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.pointInTimeRecoveryEnabled = java.util.Objects.requireNonNull(builder.pointInTimeRecoveryEnabled, "pointInTimeRecoveryEnabled is required");
            this.recoveryPeriodInDays = builder.recoveryPeriodInDays;
        }

        @Override
        public final java.lang.Boolean getPointInTimeRecoveryEnabled() {
            return this.pointInTimeRecoveryEnabled;
        }

        @Override
        public final java.lang.Number getRecoveryPeriodInDays() {
            return this.recoveryPeriodInDays;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("pointInTimeRecoveryEnabled", om.valueToTree(this.getPointInTimeRecoveryEnabled()));
            if (this.getRecoveryPeriodInDays() != null) {
                data.set("recoveryPeriodInDays", om.valueToTree(this.getRecoveryPeriodInDays()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_dynamodb.PointInTimeRecoverySpecification"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            PointInTimeRecoverySpecification.Jsii$Proxy that = (PointInTimeRecoverySpecification.Jsii$Proxy) o;

            if (!pointInTimeRecoveryEnabled.equals(that.pointInTimeRecoveryEnabled)) return false;
            return this.recoveryPeriodInDays != null ? this.recoveryPeriodInDays.equals(that.recoveryPeriodInDays) : that.recoveryPeriodInDays == null;
        }

        @Override
        public final int hashCode() {
            int result = this.pointInTimeRecoveryEnabled.hashCode();
            result = 31 * result + (this.recoveryPeriodInDays != null ? this.recoveryPeriodInDays.hashCode() : 0);
            return result;
        }
    }
}
